/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.core.validation.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.dltk.mod.compiler.problem.DefaultProblem;
import org.eclipse.vjet.af.common.error.ErrorList;
import org.eclipse.vjet.af.common.error.ErrorObject;
import org.eclipse.vjet.dsf.jst.IScriptProblem;
import org.eclipse.vjet.dsf.jst.ProblemSeverity;

public class ProblemUtility {
    public static List<DefaultProblem> reportErrors(String location, ErrorList errorList) {
        ArrayList<DefaultProblem> probs = new ArrayList<DefaultProblem>();
        if (errorList == null) {
            return probs;
        }
        ListIterator i = errorList.listIterator();
        while (i.hasNext()) {
            ErrorObject eo = (ErrorObject)i.next();
            probs.add(ProblemUtility.reportProblem(location, eo, 1));
        }
        return probs;
    }

    public static List<DefaultProblem> reportWarnings(String location, ErrorList warnings) {
        ArrayList<DefaultProblem> probs = new ArrayList<DefaultProblem>();
        if (warnings == null) {
            return probs;
        }
        ListIterator i = warnings.listIterator();
        while (i.hasNext()) {
            ErrorObject eo = (ErrorObject)i.next();
            probs.add(ProblemUtility.reportProblem(location, eo, 0));
        }
        return probs;
    }

    private static DefaultProblem reportProblem(String location, ErrorObject errorObject, int problemServerity) {
        int begin = ProblemUtility.getIntValue(errorObject, "begin");
        int end = ProblemUtility.getIntValue(errorObject, "end");
        int line = ProblemUtility.getIntValue(errorObject, "line");
        int column = ProblemUtility.getIntValue(errorObject, "column");
        String message = errorObject.getParameters().getValueByName("message");
        return ProblemUtility.reportProblem(location, begin, end, line, column, message, problemServerity);
    }

    public static DefaultProblem reportProblem(IScriptProblem problem, int problemServerity) {
        String message = problem.getMessage();
        if (message == null) {
            message = problem.getID().toString();
        }
        return ProblemUtility.reportProblem("", problem.getSourceStart(), problem.getSourceEnd() + 1, problem.getSourceLineNumber(), problem.getColumn(), message, problemServerity);
    }

    public static List<DefaultProblem> reportProblems(List<IScriptProblem> problems) {
        ArrayList<DefaultProblem> probs = new ArrayList<DefaultProblem>();
        for (IScriptProblem problem : problems) {
            if (problem.type().equals((Object)ProblemSeverity.ignore)) continue;
            probs.add(ProblemUtility.reportProblem(problem, ProblemUtility.getProblemServerity(problem.type())));
        }
        return probs;
    }

    private static int getProblemServerity(ProblemSeverity serverity) {
        switch (serverity) {
            case error: {
                return 1;
            }
            case warning: {
                return 0;
            }
            case ignore: {
                return -1;
            }
        }
        return 1;
    }

    private static int getIntValue(ErrorObject errorObject, String name) {
        String value = errorObject.getParameters().getValueByName(name);
        return value == null ? 0 : Integer.parseInt(value);
    }

    private static DefaultProblem reportProblem(String location, int start, int end, int line, int col, String msg, int problemSeverity) {
        return new DefaultProblem(location, msg, 0, null, problemSeverity, start, end, line, col);
    }
}

