/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.internal.core.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.dltk.mod.core.DLTKCore;
import org.eclipse.dltk.mod.core.IType;
import org.eclipse.dltk.mod.core.environment.EnvironmentPathUtils;
import org.eclipse.dltk.mod.internal.core.NativeVjoSourceModule;
import org.eclipse.dltk.mod.internal.core.ScriptProject;
import org.eclipse.vjet.dsf.jsgen.shared.generate.CodeStyle;
import org.eclipse.vjet.dsf.jsgen.shared.vjo.GeneratorCtx;
import org.eclipse.vjet.dsf.jsgen.shared.vjo.VjoGenerator;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.declaration.JstModifiers;
import org.eclipse.vjet.dsf.jst.declaration.JstPackage;
import org.eclipse.vjet.dsf.ts.group.IGroup;
import org.eclipse.vjet.eclipse.codeassist.CodeassistUtils;
import org.eclipse.vjet.vjo.tool.codecompletion.StringUtils;
import org.eclipse.vjet.vjo.tool.typespace.SourceTypeName;
import org.eclipse.vjet.vjo.tool.typespace.TypeSpaceMgr;

public class Util {
    private static final String METAFILE_NAME = "manifest.mf";

    private Util() {
    }

    public static int getModifiers(JstModifiers jstModifiers) {
        int modifiers = 0;
        modifiers = jstModifiers.isPublic() ? (modifiers |= 0x80) : (jstModifiers.isProtected() ? (modifiers |= 0x40) : (jstModifiers.isPrivate() ? (modifiers |= 0x20) : (modifiers |= 0)));
        if (jstModifiers.isAbstract()) {
            modifiers |= 1;
        }
        if (jstModifiers.isFinal()) {
            modifiers |= 8;
        }
        if (jstModifiers.isStatic()) {
            modifiers |= 0x100;
        }
        return modifiers;
    }

    public static IJstType toJstType(IType type) {
        if (type.getParent() instanceof NativeVjoSourceModule) {
            return ((NativeVjoSourceModule)type.getParent()).getJstType();
        }
        IFile file = (IFile)type.getResource();
        String name = type.getElementName();
        String groupName = type.getScriptProject().getElementName();
        if (file != null) {
            name = CodeassistUtils.getClassName(file);
        } else {
            groupName = "JsNativeLib";
        }
        return TypeSpaceMgr.findType((String)groupName, (String)name);
    }

    public static IType toIType(IJstType type) {
        ScriptProject project = CodeassistUtils.getScriptProject(type.getPackage().getGroupName());
        if (project == null) {
            return null;
        }
        return CodeassistUtils.findType(project, type.getName());
    }

    private static void createJsNativeFile(SourceTypeName tname) {
        GeneratorCtx m_generatorCtx = new GeneratorCtx(CodeStyle.PRETTY);
        IJstType type = CodeassistUtils.findNativeJstType(tname.typeName());
        if (type == null) {
            return;
        }
        VjoGenerator writer = m_generatorCtx.getProvider().getTypeGenerator();
        try {
            Util.cacheText(tname, writer.writeVjo(type).getGeneratedText());
        }
        catch (Exception e) {
            DLTKCore.error((String)e.toString(), (Throwable)e);
        }
    }

    public static File getCacheDir() {
        IPath path = DLTKCore.getDefault().getStateLocation();
        File file = path.toFile();
        if (!file.exists()) {
            file.mkdir();
        }
        return file;
    }

    public static File getNativeTypeCacheDir(String groupName) {
        File file = Util.getCacheDir();
        File nDirectory = new File(file, groupName);
        if (!nDirectory.exists()) {
            nDirectory.mkdir();
        }
        Util.initDirStructure(nDirectory, groupName);
        return nDirectory;
    }

    public static boolean isNativeCacheDir(IPath fPath) {
        if (fPath == null) {
            return false;
        }
        IPath path = EnvironmentPathUtils.getLocalPath((IPath)fPath);
        if (path == null) {
            return false;
        }
        File file = path.toFile();
        if (file.exists()) {
            return file.getParentFile().equals(Util.getCacheDir());
        }
        return false;
    }

    private static void initDirStructure(File dir, String groupName) {
        Util.getMetaInfo(dir);
        boolean updateJsFile = true;
        TypeSpaceMgr tsm = TypeSpaceMgr.getInstance();
        IGroup group = (IGroup)tsm.getController().getJstTypeSpaceMgr().getTypeSpace().getGroups().get(groupName);
        if (group == null) {
            return;
        }
        for (IJstType jstType : group.getEntities().values()) {
            File file;
            if (!Util.isOuterType(jstType)) break;
            JstPackage packag = jstType.getPackage();
            String packageName = "";
            if (packag != null && !StringUtils.isBlankOrEmpty((String)packag.getName())) {
                packageName = packag.getName();
            }
            if ((file = Util.getPackDir(dir, packageName)).exists() && !updateJsFile) continue;
            Util.createJsNativeFile(file, jstType);
        }
    }

    private static void createJsNativeFile(File file, IJstType jstType) {
        GeneratorCtx m_generatorCtx = new GeneratorCtx(CodeStyle.PRETTY);
        VjoGenerator writer = m_generatorCtx.getProvider().getTypeGenerator();
        try {
            File jsFile = new File(file, String.valueOf(jstType.getSimpleName()) + ".js");
            if (jsFile.exists()) {
                return;
            }
            Util.writeText(jsFile, writer.writeVjo(jstType).getGeneratedText());
        }
        catch (Exception e) {
            DLTKCore.error((String)e.toString(), (Throwable)e);
        }
    }

    private static void writeText(File jsFile, String generatedText) {
        FileOutputStream fo = null;
        try {
            try {
                fo = new FileOutputStream(jsFile);
                fo.write(generatedText.getBytes());
            }
            catch (FileNotFoundException e) {
                DLTKCore.error((String)e.toString(), (Throwable)e);
                try {
                    fo.close();
                }
                catch (IOException e2) {
                    DLTKCore.error((String)e2.toString(), (Throwable)e2);
                }
            }
            catch (IOException e) {
                DLTKCore.error((String)e.toString(), (Throwable)e);
                try {
                    fo.close();
                }
                catch (IOException e3) {
                    DLTKCore.error((String)e3.toString(), (Throwable)e3);
                }
            }
        }
        finally {
            try {
                fo.close();
            }
            catch (IOException e) {
                DLTKCore.error((String)e.toString(), (Throwable)e);
            }
        }
    }

    private static File getPackDir(File dir, String packageName) {
        String path = packageName.replace(".", File.separator);
        File file = new File(dir, path);
        if (file.exists()) {
            return file;
        }
        file.mkdirs();
        return file;
    }

    public static boolean isOuterType(IJstType jstType) {
        return jstType.getParentNode() == null;
    }

    private static List<String> getMetaInfo(File dir) {
        File metaFile = new File(dir, METAFILE_NAME);
        if (!metaFile.exists()) {
            try {
                metaFile.createNewFile();
                return new ArrayList<String>();
            }
            catch (IOException iOException) {
                return new ArrayList<String>();
            }
        }
        List<String> metaInfo = Util.loadMetaFile(metaFile);
        return metaInfo;
    }

    private static List<String> loadMetaFile(File metaFile) {
        ArrayList<String> list = new ArrayList<String>();
        try {
            FileReader fr = new FileReader(metaFile);
            BufferedReader reader = new BufferedReader(fr);
            String s = reader.readLine();
            while (s != null) {
                list.add(s);
                s = reader.readLine();
            }
            return list;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return new ArrayList<String>();
    }

    private static void cacheText(SourceTypeName tname, String generatedText) {
        File file = Util.getNativeTypeCacheDir(tname.groupName());
        if (!file.exists()) {
            return;
        }
        File jsFile = new File(file, String.valueOf(tname.typeName()) + ".js");
        FileOutputStream fo = null;
        try {
            try {
                fo = new FileOutputStream(jsFile);
                fo.write(generatedText.getBytes());
            }
            catch (FileNotFoundException e) {
                DLTKCore.error((String)e.toString(), (Throwable)e);
                try {
                    fo.close();
                }
                catch (IOException e2) {
                    DLTKCore.error((String)e2.toString(), (Throwable)e2);
                }
            }
            catch (IOException e) {
                DLTKCore.error((String)e.toString(), (Throwable)e);
                try {
                    fo.close();
                }
                catch (IOException e3) {
                    DLTKCore.error((String)e3.toString(), (Throwable)e3);
                }
            }
        }
        finally {
            try {
                fo.close();
            }
            catch (IOException e) {
                DLTKCore.error((String)e.toString(), (Throwable)e);
            }
        }
    }

    public static File getNativeTypeCacheFile(SourceTypeName tname) {
        File file = Util.getNativeTypeCacheDir(tname.groupName());
        if (!file.exists()) {
            return null;
        }
        File jsFile = new File(file, String.valueOf(tname.typeName()) + ".js");
        if (!jsFile.exists()) {
            Util.createJsNativeFile(tname);
        }
        return jsFile;
    }

    public static void setReadOnly(IResource resource, boolean readOnly) {
        if (Util.isReadOnlySupported()) {
            ResourceAttributes resourceAttributes = resource.getResourceAttributes();
            if (resourceAttributes == null) {
                return;
            }
            resourceAttributes.setReadOnly(readOnly);
            try {
                resource.setResourceAttributes(resourceAttributes);
            }
            catch (CoreException coreException) {}
        }
    }

    protected static boolean isAttributeSupported(int attribute) {
        return (EFS.getLocalFileSystem().attributes() & attribute) != 0;
    }

    public static boolean isReadOnly(IResource resource) {
        if (Util.isReadOnlySupported()) {
            ResourceAttributes resourceAttributes = resource.getResourceAttributes();
            if (resourceAttributes == null) {
                return false;
            }
            return resourceAttributes.isReadOnly();
        }
        return false;
    }

    public static boolean isReadOnlySupported() {
        return Util.isAttributeSupported(2);
    }
}

