/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.internal.parser;

import java.io.File;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.dltk.mod.ast.ASTNode;
import org.eclipse.dltk.mod.ast.declarations.Argument;
import org.eclipse.dltk.mod.ast.declarations.MethodDeclaration;
import org.eclipse.dltk.mod.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.mod.ast.declarations.TypeDeclaration;
import org.eclipse.dltk.mod.ast.parser.AbstractSourceParser;
import org.eclipse.dltk.mod.ast.references.SimpleReference;
import org.eclipse.dltk.mod.ast.references.TypeReference;
import org.eclipse.dltk.mod.ast.references.VariableKind;
import org.eclipse.dltk.mod.ast.references.VariableReference;
import org.eclipse.dltk.mod.ast.references.VjoTypeReference;
import org.eclipse.dltk.mod.ast.statements.Statement;
import org.eclipse.dltk.mod.compiler.problem.DefaultProblem;
import org.eclipse.dltk.mod.compiler.problem.IProblem;
import org.eclipse.dltk.mod.compiler.problem.IProblemReporter;
import org.eclipse.dltk.mod.core.DLTKCore;
import org.eclipse.vjet.dsf.jsgen.shared.ids.VjoSyntaxProbIds;
import org.eclipse.vjet.dsf.jsgen.shared.jstvalidator.DefaultJstProblem;
import org.eclipse.vjet.dsf.jst.IJstMethod;
import org.eclipse.vjet.dsf.jst.IJstProperty;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.IScriptProblem;
import org.eclipse.vjet.dsf.jst.JstSource;
import org.eclipse.vjet.dsf.jst.ProblemSeverity;
import org.eclipse.vjet.dsf.jst.declaration.JstArg;
import org.eclipse.vjet.dsf.jst.declaration.JstBlock;
import org.eclipse.vjet.dsf.jst.declaration.JstVar;
import org.eclipse.vjet.dsf.jst.declaration.JstVars;
import org.eclipse.vjet.dsf.jst.expr.ArrayAccessExpr;
import org.eclipse.vjet.dsf.jst.expr.AssignExpr;
import org.eclipse.vjet.dsf.jst.expr.BoolExpr;
import org.eclipse.vjet.dsf.jst.expr.FieldAccessExpr;
import org.eclipse.vjet.dsf.jst.expr.InfixExpr;
import org.eclipse.vjet.dsf.jst.expr.MtdInvocationExpr;
import org.eclipse.vjet.dsf.jst.expr.ParenthesizedExpr;
import org.eclipse.vjet.dsf.jst.expr.PostfixExpr;
import org.eclipse.vjet.dsf.jst.expr.PrefixExpr;
import org.eclipse.vjet.dsf.jst.stmt.CatchStmt;
import org.eclipse.vjet.dsf.jst.stmt.ForStmt;
import org.eclipse.vjet.dsf.jst.stmt.RtnStmt;
import org.eclipse.vjet.dsf.jst.stmt.SwitchStmt;
import org.eclipse.vjet.dsf.jst.stmt.ThrowStmt;
import org.eclipse.vjet.dsf.jst.stmt.WhileStmt;
import org.eclipse.vjet.dsf.jst.term.JstIdentifier;
import org.eclipse.vjet.dsf.jst.token.IExpr;
import org.eclipse.vjet.dsf.jst.token.IIfStmt;
import org.eclipse.vjet.dsf.jst.token.IInitializer;
import org.eclipse.vjet.dsf.jst.token.ILHS;
import org.eclipse.vjet.dsf.jst.token.IStmt;
import org.eclipse.vjet.dsf.jst.token.ITryStmt;
import org.eclipse.vjet.dsf.ts.event.ISourceEvent;
import org.eclipse.vjet.dsf.ts.event.ISourceEventCallback;
import org.eclipse.vjet.dsf.ts.event.type.AddTypeEvent;
import org.eclipse.vjet.dsf.ts.event.type.ModifyTypeEvent;
import org.eclipse.vjet.dsf.ts.event.type.RemoveTypeEvent;
import org.eclipse.vjet.dsf.ts.type.TypeName;
import org.eclipse.vjet.eclipse.ast.declarations.VjoArgument;
import org.eclipse.vjet.eclipse.ast.declarations.VjoFieldDeclaration;
import org.eclipse.vjet.eclipse.ast.declarations.VjoMethodDeclaration;
import org.eclipse.vjet.eclipse.ast.declarations.VjoTypeDeclaration;
import org.eclipse.vjet.eclipse.ast.references.VjoQualifiedNameReference;
import org.eclipse.vjet.eclipse.codeassist.CodeassistUtils;
import org.eclipse.vjet.eclipse.core.VjetPlugin;
import org.eclipse.vjet.eclipse.core.builder.VjetSourceModuleBuildCtx;
import org.eclipse.vjet.eclipse.core.parser.VjoParserToJstAndIType;
import org.eclipse.vjet.eclipse.core.validation.ValidationEntry;
import org.eclipse.vjet.eclipse.core.validation.utils.ProblemUtility;
import org.eclipse.vjet.eclipse.internal.core.util.Util;
import org.eclipse.vjet.vjo.tool.codecompletion.CodeCompletionUtils;
import org.eclipse.vjet.vjo.tool.typespace.SourceTypeName;
import org.eclipse.vjet.vjo.tool.typespace.TypeSpaceMgr;

public class VjoSourceParser
extends AbstractSourceParser {
    TypeSpaceMgr tsm = TypeSpaceMgr.getInstance();
    String typeName;

    public ModuleDeclaration parse(char[] fileName, char[] source, IProblemReporter reporter, VjetSourceModuleBuildCtx context) {
        ModuleDeclaration moduleDeclaration = new ModuleDeclaration(source.length);
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        String strPath = new String(fileName).replace(File.separatorChar, '/');
        IPath path = workspaceRoot.getFullPath().append(strPath);
        IFile file = workspaceRoot.getFile(path);
        URI locationURI = file.getLocationURI();
        if (locationURI.getScheme().equals("typespace")) {
            SourceTypeName srctypeName = CodeassistUtils.getTypeName((IResource)file);
            IJstType jsttype = TypeSpaceMgr.QE().findType((TypeName)srctypeName);
            this.processType(jsttype, moduleDeclaration);
            return moduleDeclaration;
        }
        String groupName = file.getProject().getName();
        String substring = strPath.substring(strPath.indexOf(groupName) + groupName.length(), strPath.lastIndexOf(47));
        if (substring.contains(".")) {
            String[] str = new String[]{};
            reporter.reportProblem((IProblem)ProblemUtility.reportProblem((IScriptProblem)new DefaultJstProblem(str, VjoSyntaxProbIds.TypeHasIllegalToken, "file path contains unsupported character \".\" dot : " + substring, fileName, 0, 0, 0, 0, ProblemSeverity.error), 1));
            return moduleDeclaration;
        }
        String typeName = CodeassistUtils.getClassName(file);
        VjoParserToJstAndIType parser = new VjoParserToJstAndIType(reporter);
        try {
            if (VjetPlugin.TRACE_PARSER) {
                System.out.println("parsing for " + ((Object)((Object)this)).getClass().getName());
            }
            IJstType scriptUnit = parser.parse(groupName, typeName, new String(source));
            typeName = scriptUnit.getName();
            if (context == null && ValidationEntry.isEnableVjetValidation()) {
                List<DefaultProblem> dproblems = null;
                List problems = scriptUnit.getProblems();
                dproblems = problems != null && !problems.isEmpty() ? ProblemUtility.reportProblems(problems) : ValidationEntry.validator(scriptUnit);
                if (dproblems != null && !dproblems.isEmpty()) {
                    parser.reportProblems(dproblems, reporter);
                }
            }
            if (scriptUnit != null && !scriptUnit.getName().equals(typeName)) {
                typeName = scriptUnit.getName();
            }
            if (scriptUnit != null) {
                this.reRegestierType(source, file, groupName, typeName, scriptUnit);
                this.processType(scriptUnit, moduleDeclaration);
            }
            if (context != null) {
                context.setUnit(scriptUnit);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            DLTKCore.error((String)e.getMessage(), (Throwable)e);
        }
        return moduleDeclaration;
    }

    public ModuleDeclaration parse(char[] fileName, char[] source, IProblemReporter reporter) {
        return this.parse(fileName, source, reporter, null);
    }

    private void reRegestierType(char[] source, IFile file, String groupName, String typeName, IJstType unit) {
        SourceTypeName name = new SourceTypeName(groupName, typeName, new String(source));
        if (!TypeSpaceMgr.existType((TypeName)name)) {
            IJstType actualType = unit;
            String actualName = null;
            if (actualType != null && (actualName = actualType.getName()) != null) {
                if (file == null || file.getLocation() == null) {
                    return;
                }
                String filePath = file.getLocation().toOSString();
                if (!filePath.endsWith(".js")) {
                    return;
                }
                if (typeName.equals(actualName)) {
                    this.doProcessType(name, null, actualType);
                }
            }
        }
    }

    private void reRegestierType2(char[] source, IFile file, String groupName, String typeName, IJstType unit) {
        SourceTypeName name = new SourceTypeName(groupName, typeName, new String(source));
        if (TypeSpaceMgr.existType((TypeName)name)) {
            name.setAction(4);
        } else {
            name.setAction(1);
        }
        IJstType actualType = unit;
        this.doProcessType(name, null, actualType);
    }

    private boolean isChangedTypeNotExist(SourceTypeName name) {
        return name.getAction() == 4 && !TypeSpaceMgr.existType((TypeName)name);
    }

    private void doProcessType(SourceTypeName name, ISourceEventCallback<IJstType> callback, IJstType jstType) {
        TypeName typeName = new TypeName(name.groupName(), name.typeName());
        int action = name.getAction();
        if (this.isChangedTypeNotExist(name)) {
            action = 1;
        }
        switch (action) {
            case 1: {
                AddTypeEvent addEvent = new AddTypeEvent((TypeName)name, jstType);
                TypeSpaceMgr.processEvent((ISourceEvent)addEvent, callback);
                break;
            }
            case 4: {
                ModifyTypeEvent event = new ModifyTypeEvent(name.groupName(), name.typeName(), name.source());
                TypeSpaceMgr.processEvent((ISourceEvent)event, callback);
                break;
            }
            case 2: {
                RemoveTypeEvent removeEvent = new RemoveTypeEvent(typeName);
                TypeSpaceMgr.processEvent((ISourceEvent)removeEvent, callback);
                break;
            }
        }
    }

    public void processType(IJstType type, ModuleDeclaration moduleDeclaration) {
        String typeName = type.getSimpleName();
        JstSource typeSource = type.getSource();
        VjoTypeDeclaration typeDeclaration = typeSource != null ? new VjoTypeDeclaration(typeName, typeSource.getStartOffSet(), typeSource.getEndOffSet() + 1, typeSource.getStartOffSet(), moduleDeclaration.sourceEnd()) : new VjoTypeDeclaration(typeName, 0, 0, 0, 0);
        moduleDeclaration.addStatement((Statement)typeDeclaration);
        this.processInheritsAndImplements(type, typeDeclaration);
        this.processFields(type, (TypeDeclaration)typeDeclaration);
        this.processConstructor(type, typeDeclaration);
        this.processMethods(type, (TypeDeclaration)typeDeclaration);
    }

    private void processConstructor(IJstType type, TypeDeclaration typeDeclaration) {
        IJstMethod constructor = type.getConstructor();
        if (constructor != null && !CodeCompletionUtils.isSynthesizedElement((Object)constructor)) {
            JstSource nameSource = constructor.getName().getSource();
            this.processMethod(constructor, typeDeclaration, nameSource);
        }
    }

    private void processInheritsAndImplements(IJstType type, TypeDeclaration typeDeclaration) {
        List types = type.getExtends();
        this.processTypes(types, typeDeclaration, type);
        types = type.getSatisfies();
        this.processTypes(types, typeDeclaration, type);
    }

    private void processTypes(List<? extends IJstType> types, TypeDeclaration typeDeclaration, IJstType focusType) {
        for (IJstType iJstType : types) {
            typeDeclaration.addSuperClass((ASTNode)VjoSourceParser.createTypeReference(iJstType));
        }
    }

    private void processFields(IJstType type, TypeDeclaration typeDeclaration) {
        List fields = type.getStaticProperties();
        this.processFields(fields, typeDeclaration);
        fields = type.getInstanceProperties();
        this.processFields(fields, typeDeclaration);
    }

    private void processFields(Collection<IJstProperty> fields, TypeDeclaration typeDeclaration) {
        for (IJstProperty field : fields) {
            if (CodeCompletionUtils.isSynthesizedElement((Object)field)) continue;
            String name = field.getName().getName();
            JstSource nameSource = field.getName().getSource();
            int startOffSet = 0;
            int endOffset = 0;
            if (nameSource != null) {
                startOffSet = nameSource.getStartOffSet();
                endOffset = nameSource.getEndOffSet() + 1;
            }
            VjoFieldDeclaration fieldDeclaration = new VjoFieldDeclaration(name, startOffSet, endOffset, startOffSet, endOffset, null);
            int modifiers = Util.getModifiers(field.getModifiers());
            fieldDeclaration.setModifiers(modifiers);
            typeDeclaration.getFieldList().add(fieldDeclaration);
            IJstType fieldType = field.getType();
            if (fieldType == null) continue;
            fieldDeclaration.type = VjoSourceParser.createTypeReference(fieldType);
        }
    }

    private static TypeReference createTypeReference(IJstType type) {
        VjoTypeReference typeRef = null;
        if (type != null) {
            String typeName = type.getSimpleName();
            JstSource typeSource = type.getSource();
            if (typeSource != null) {
                typeRef = new VjoTypeReference(typeSource.getStartOffSet(), typeSource.getEndOffSet() + 1, typeName);
                if (type.getPackage() != null) {
                    typeRef.setPackageName(type.getPackage().getName());
                }
            }
        }
        return typeRef;
    }

    private void processMethods(IJstType type, TypeDeclaration typeDeclaration) {
        List methods = type.getStaticMethods();
        this.processMethods(methods, typeDeclaration);
        methods = type.getInstanceMethods();
        this.processMethods(methods, typeDeclaration);
    }

    private void processMethods(Collection<? extends IJstMethod> methods, TypeDeclaration typeDeclaration) {
        for (IJstMethod iJstMethod : methods) {
            if (iJstMethod.getName().getSource() == null) continue;
            JstSource nameSource = iJstMethod.getName().getSource();
            this.processMethod(iJstMethod, typeDeclaration, nameSource);
            List overloadedMethods = iJstMethod.getOverloaded();
            if (overloadedMethods.size() <= 0) continue;
            for (IJstMethod m : overloadedMethods) {
                this.processMethod(m, typeDeclaration, nameSource);
            }
        }
    }

    private void processMethod(IJstMethod method, TypeDeclaration typeDeclaration, JstSource nameSource) {
        if (nameSource == null) {
            nameSource = new JstSource(0, 0, 0, 0, 0, 0);
        }
        VjoMethodDeclaration methodDeclaration = new VjoMethodDeclaration(method.getName().getName(), nameSource.getStartOffSet(), nameSource.getEndOffSet() + 1, nameSource.getStartOffSet(), nameSource.getEndOffSet() + 1);
        methodDeclaration.setDeclaringTypeName(typeDeclaration.getName());
        methodDeclaration.setModifiers(Util.getModifiers(method.getModifiers()));
        typeDeclaration.getMethodList().add(methodDeclaration);
        IJstType retType = method.getRtnType();
        if (retType != null) {
            methodDeclaration.type = VjoSourceParser.createTypeReference(retType);
        }
        List args = method.getArgs();
        for (JstArg arg : args) {
            JstSource argSource = arg.getSource();
            if (argSource == null || arg.getName() == null) continue;
            VjoArgument argDecl = new VjoArgument(new SimpleReference(argSource.getStartOffSet(), argSource.getEndOffSet() + 1, arg.getName()), argSource.getStartOffSet(), null, 0);
            IJstType argType = arg.getType();
            if (argType != null) {
                argDecl.type = VjoSourceParser.createTypeReference(argType);
            }
            methodDeclaration.addArgument(argDecl);
        }
        this.processStatements(method.getBlock(), methodDeclaration);
    }

    private void processStatements(JstBlock block, MethodDeclaration methodDelcaration) {
        if (block != null) {
            List statements = block.getStmts();
            for (IStmt statement : statements) {
                this.processStatement(statement, methodDelcaration);
            }
        }
    }

    private void processStatement(IStmt statement, MethodDeclaration methodDelcaration) {
        if (statement instanceof AssignExpr) {
            this.processAssignExpr((AssignExpr)statement, methodDelcaration);
        } else if (statement instanceof ForStmt) {
            ForStmt forStatement = (ForStmt)statement;
            IInitializer initializer = forStatement.getInitializers();
            if (initializer != null) {
                List initializers = initializer.getAssignments();
                for (AssignExpr assignExpr : initializers) {
                    this.processAssignExpr(assignExpr, methodDelcaration);
                }
            }
            this.processExpression((IExpr)forStatement.getCondition(), methodDelcaration);
            List updaters = forStatement.getUpdaters();
            for (IExpr updater : updaters) {
                this.processExpression(updater, methodDelcaration);
            }
            this.processStatements(forStatement.getBody(), methodDelcaration);
        } else if (statement instanceof WhileStmt) {
            WhileStmt whileStmt = (WhileStmt)statement;
            this.processExpression((IExpr)whileStmt.getCondition(), methodDelcaration);
            this.processStatements(whileStmt.getBody(), methodDelcaration);
        } else if (statement instanceof ITryStmt) {
            ITryStmt tryStmt = (ITryStmt)statement;
            this.processStatements(tryStmt.getBody(), methodDelcaration);
            if (tryStmt.getCatchBlock() != null) {
                List catchStmts = tryStmt.getCatchBlock().getStmts();
                for (IStmt catchStmt : catchStmts) {
                    this.processStatement(catchStmt, methodDelcaration);
                }
                this.processStatements(tryStmt.getFinallyBlock(), methodDelcaration);
            }
        } else if (statement instanceof CatchStmt) {
            CatchStmt catchStmt = (CatchStmt)statement;
            this.processJstVar(catchStmt.getException(), methodDelcaration);
            this.processStatements(catchStmt.getBody(), methodDelcaration);
        } else if (statement instanceof SwitchStmt) {
            SwitchStmt switchStmt = (SwitchStmt)statement;
            this.processExpression(switchStmt.getExpr(), methodDelcaration);
            List statements = switchStmt.getBody().getStmts();
            if (statements != null) {
                for (IStmt stmt : statements) {
                    this.processStatement(stmt, methodDelcaration);
                }
            }
        } else if (statement instanceof SwitchStmt.CaseStmt) {
            this.processExpression(((SwitchStmt.CaseStmt)statement).getExpr(), methodDelcaration);
        } else if (statement instanceof IIfStmt) {
            List elseIfStmts;
            IIfStmt ifStmt = (IIfStmt)statement;
            this.processExpression((IExpr)ifStmt.getCondition(), methodDelcaration);
            this.processStatements(ifStmt.getBody(), methodDelcaration);
            if (ifStmt.getElseIfBlock() != null && (elseIfStmts = ifStmt.getElseIfBlock().getStmts()) != null) {
                for (IStmt elseIfStmt : elseIfStmts) {
                    this.processStatement(elseIfStmt, methodDelcaration);
                }
            }
            this.processStatements(ifStmt.getElseBlock(), methodDelcaration);
        } else if (statement instanceof ThrowStmt) {
            ThrowStmt throwStmt = (ThrowStmt)statement;
            this.processExpression(throwStmt.getExpression(), methodDelcaration);
        } else if (statement instanceof RtnStmt) {
            RtnStmt returnStmt = (RtnStmt)statement;
            this.processExpression(returnStmt.getExpression(), methodDelcaration);
        } else if (statement instanceof MtdInvocationExpr) {
            this.processExpression((IExpr)statement, methodDelcaration);
        } else if (statement instanceof JstVars) {
            this.processJstVars((JstVars)statement, methodDelcaration);
        }
    }

    private void processJstVars(JstVars vars, MethodDeclaration methodDelcaration) {
        JstIdentifier localVar = (JstIdentifier)((AssignExpr)vars.getAssignments().get(0)).getLHS();
        JstSource source = localVar.getSource();
        IJstType type = vars.getType();
        String typeName = "Object";
        if (type != null) {
            typeName = type.getName();
        }
        VjoFieldDeclaration var = new VjoFieldDeclaration(localVar.getName(), source.getStartOffSet(), source.getEndOffSet() + 1, source.getStartOffSet(), source.getEndOffSet() + 1, new TypeReference(0, 0, typeName));
        var.setModifiers(var.getModifiers());
        methodDelcaration.getBody().addStatement((ASTNode)var);
    }

    private void processJstVar(JstVar jstVar, MethodDeclaration methodDelcaration) {
        JstSource source = jstVar.getSource();
        IJstType type = jstVar.getType();
        String typeName = "Object";
        if (type != null) {
            typeName = type.getName();
        }
        VjoFieldDeclaration var = new VjoFieldDeclaration(jstVar.getName(), source.getStartOffSet(), source.getEndOffSet() + 1, source.getStartOffSet(), source.getEndOffSet() + 1, new TypeReference(0, 0, typeName));
        var.setModifiers(var.getModifiers());
        methodDelcaration.getBody().addStatement((ASTNode)var);
    }

    private void processAssignExpr(AssignExpr assignExpr, MethodDeclaration methodDelcaration) {
        ILHS lhs = assignExpr.getLHS();
        if (lhs instanceof IExpr) {
            this.processExpression((IExpr)lhs, methodDelcaration);
        } else if (lhs instanceof JstVar) {
            this.processJstVar((JstVar)lhs, methodDelcaration);
        }
        this.processExpression(assignExpr.getExpr(), methodDelcaration);
    }

    private void processExpression(IExpr expression, MethodDeclaration methodDelcaration) {
        if (expression == null) {
            return;
        }
        if (expression instanceof JstIdentifier) {
            JstIdentifier identifier = (JstIdentifier)expression;
            if ("this".equals(identifier.getName()) || "self".equals(identifier.getName())) {
                return;
            }
            VariableKind kind = VariableKind.UNKNOWN;
            List localVars = methodDelcaration.getBody().getStatements();
            for (Object statement : localVars) {
                if (!(statement instanceof VjoFieldDeclaration) || !((VjoFieldDeclaration)((Object)statement)).getName().equals(identifier.getName())) continue;
                kind = VariableKind.LOCAL;
                break;
            }
            if (kind.equals(VariableKind.UNKNOWN)) {
                List args = methodDelcaration.getArguments();
                for (Argument argument : args) {
                    if (!argument.getName().equals(identifier.getName())) continue;
                    kind = VariableKind.ARGUMENT;
                    break;
                }
            }
            JstSource source = identifier.getSource();
            VariableReference varRef = new VariableReference(source.getStartOffSet(), source.getEndOffSet() + 1, identifier.getName(), kind);
            methodDelcaration.getBody().addStatement((ASTNode)varRef);
        } else if (expression instanceof MtdInvocationExpr || expression instanceof FieldAccessExpr) {
            VjoQualifiedNameReference qref = new VjoQualifiedNameReference(-1, -1, expression.toExprText(), this.typeName, expression);
            methodDelcaration.getBody().addStatement((ASTNode)qref);
        } else if (expression instanceof BoolExpr) {
            BoolExpr boolExpr = (BoolExpr)expression;
            this.processExpression(boolExpr.getLeft(), methodDelcaration);
            this.processExpression(boolExpr.getRight(), methodDelcaration);
        } else if (expression instanceof PostfixExpr) {
            this.processExpression(((PostfixExpr)expression).getIdentifier(), methodDelcaration);
        } else if (expression instanceof InfixExpr) {
            InfixExpr infixExpr = (InfixExpr)expression;
            this.processExpression(infixExpr.getLeft(), methodDelcaration);
            this.processExpression(infixExpr.getRight(), methodDelcaration);
        } else if (expression instanceof ParenthesizedExpr) {
            this.processExpression(((ParenthesizedExpr)expression).getExpression(), methodDelcaration);
        } else if (expression instanceof PrefixExpr) {
            this.processExpression(((PrefixExpr)expression).getIdentifier(), methodDelcaration);
        } else if (expression instanceof ArrayAccessExpr) {
            this.processExpression(((ArrayAccessExpr)expression).getExpr(), methodDelcaration);
            this.processExpression(((ArrayAccessExpr)expression).getIndex(), methodDelcaration);
        }
    }
}

