/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.javatojs.ui.commands;

import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.ui.console.MessageConsoleStream;
import org.eclipse.vjet.core.codegen.bootstrap.IJs2JavaCodeGenInput;
import org.eclipse.vjet.core.codegen.bootstrap.IJs2JavaCodeGenOutput;
import org.eclipse.vjet.core.codegen.bootstrap.IJs2JavaCodeGenTool;
import org.eclipse.vjet.core.codegen.bootstrap.IToolMonitor;
import org.eclipse.vjet.eclipse.javatojs.ui.Java2JsPlugin;
import org.eclipse.vjet.eclipse.javatojs.ui.adapters.Js2JavaInput;
import org.eclipse.vjet.eclipse.javatojs.ui.adapters.ToolMonitor;
import org.eclipse.vjet.eclipse.javatojs.ui.commands.ClassloaderUtils;

public class Js2JavaGenerateJob
extends WorkspaceJob {
    private List<IJs2JavaCodeGenInput> input;
    private List<IJs2JavaCodeGenOutput> output;

    public Js2JavaGenerateJob(List<IJs2JavaCodeGenInput> input) {
        super("Java2Js Generate Job");
        this.input = input;
    }

    public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                if (monitor == null) {
                    monitor = new NullProgressMonitor();
                }
                try {
                    try {
                        monitor.beginTask("Generate ", 50);
                        MessageConsoleStream stream = Java2JsPlugin.getDefault().getConsole().newMessageStream();
                        IJs2JavaCodeGenTool generator = this.getGenerator();
                        Js2JavaGenerateJob.this.output = generator.generate(Js2JavaGenerateJob.this.input, (IToolMonitor)new ToolMonitor((IProgressMonitor)new SubProgressMonitor(monitor, 30), (OutputStream)stream));
                        stream.println("Generator output:");
                        for (IJs2JavaCodeGenOutput item : Js2JavaGenerateJob.this.output) {
                            stream.println(item.getUrl().toString());
                        }
                        Js2JavaGenerateJob.this.mark((IProgressMonitor)new SubProgressMonitor(monitor, 10));
                        Js2JavaGenerateJob.this.refresh((IProgressMonitor)new SubProgressMonitor(monitor, 10));
                        stream.println("Generator complete.");
                    }
                    catch (Exception e) {
                        Java2JsPlugin.logException(e);
                        monitor.done();
                    }
                }
                finally {
                    monitor.done();
                }
            }

            private IJs2JavaCodeGenTool getGenerator() {
                Object obj = ClassloaderUtils.getWorkspaceObject("org.eclipse.vjet.eclipse.javatojs.core.JsCodeGenTool", ClassloaderUtils.ClassLoaderKey.WORKSPACECODEGEN);
                if (obj instanceof IJs2JavaCodeGenTool) {
                    return (IJs2JavaCodeGenTool)obj;
                }
                return null;
            }
        };
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        workspace.run(runnable, monitor);
        return Status.OK_STATUS;
    }

    protected void mark(IProgressMonitor monitor) {
    }

    protected void refresh(IProgressMonitor monitor) {
        try {
            ArrayList<IProject> projects = new ArrayList<IProject>();
            for (IJs2JavaCodeGenInput item : this.input) {
                IResource resource;
                if (!(item instanceof Js2JavaInput) || (resource = ((Js2JavaInput)item).getResource()) == null) continue;
                projects.add(resource.getProject());
            }
            monitor.beginTask("Refresh workspace", projects.size());
            for (IProject project : projects) {
                try {
                    project.refreshLocal(2, monitor);
                }
                catch (CoreException e) {
                    Java2JsPlugin.logException((Exception)((Object)e));
                }
                monitor.worked(1);
            }
        }
        finally {
            monitor.done();
        }
    }
}

