/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.internal.launching;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.dltk.mod.core.IModelElement;
import org.eclipse.dltk.mod.core.IProjectFragment;
import org.eclipse.dltk.mod.core.IScriptProject;
import org.eclipse.dltk.mod.core.ModelException;
import org.eclipse.dltk.mod.launching.AbstractInterpreterRunner;
import org.eclipse.dltk.mod.launching.AbstractScriptLaunchConfigurationDelegate;
import org.eclipse.dltk.mod.launching.IInterpreterInstall;
import org.eclipse.dltk.mod.launching.InterpreterConfig;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.launching.JavaSourceLookupDirector;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMRunner;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.VMRunnerConfiguration;
import org.eclipse.vjet.dsf.jst.IJstMethod;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.eclipse.internal.launching.BrowserService;
import org.eclipse.vjet.eclipse.internal.launching.LauncherUtil;
import org.eclipse.vjet.eclipse.internal.launching.SourceLocatorProxy;
import org.eclipse.vjet.eclipse.internal.launching.VjoRunnerInfo;
import org.eclipse.vjet.eclipse.launching.VjetLaunchingPlugin;
import org.eclipse.vjet.vjo.tool.codecompletion.StringUtils;
import org.eclipse.vjet.vjo.tool.typespace.TypeSpaceMgr;

public class VjetInterpreterRunner
extends AbstractInterpreterRunner {
    private static final boolean DEBUG_LAUNCH = "true".equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.vjet.eclipse.launching/debug/launch"));
    private final String m_mode;
    private static final String PathSeparator = System.getProperty("path.separator");

    public VjetInterpreterRunner(IInterpreterInstall install, String mode) {
        super(install);
        this.m_mode = mode;
    }

    public void run(InterpreterConfig config, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        this.doRunImpl(config, launch);
    }

    public void doRunImpl(InterpreterConfig config, ILaunch launch) throws CoreException {
        IVMInstall vmInstall;
        IScriptProject proj = AbstractScriptLaunchConfigurationDelegate.getScriptProject((ILaunchConfiguration)launch.getLaunchConfiguration());
        IJavaProject myJavaProject = JavaCore.create((IProject)proj.getProject());
        IVMInstall iVMInstall = vmInstall = myJavaProject.exists() ? JavaRuntime.getVMInstall((IJavaProject)myJavaProject) : JavaRuntime.getDefaultVMInstall();
        if (vmInstall == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.vjet.eclipse.core", 4, "No VMInstall", null));
        }
        IVMRunner vmRunner = vmInstall.getVMRunner(this.m_mode);
        if (vmRunner == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.vjet.eclipse.core", 4, "No VMRunner", null));
        }
        IWorkspaceRoot workspaceRoot = proj.getProject().getWorkspace().getRoot();
        String sourceSearchPath = null;
        String[] clzPath = VjoRunnerInfo.getClassPath();
        if (DEBUG_LAUNCH) {
            String[] stringArray = clzPath;
            int n = clzPath.length;
            int n2 = 0;
            while (n2 < n) {
                String path = stringArray[n2];
                System.out.println(path);
                ++n2;
            }
        }
        String[] jarPaths = null;
        jarPaths = myJavaProject.exists() ? VjetInterpreterRunner.getJarPaths(myJavaProject) : this.getJarPaths(proj);
        if (jarPaths.length > 0) {
            String[] newClzPath = new String[clzPath.length + jarPaths.length];
            System.arraycopy(clzPath, 0, newClzPath, 0, clzPath.length);
            System.arraycopy(jarPaths, 0, newClzPath, clzPath.length, jarPaths.length);
            clzPath = newClzPath;
        }
        VMRunnerConfiguration vmConfig = new VMRunnerConfiguration(VjoRunnerInfo.getClassName(), clzPath);
        IPath scriptFilePath = config.getScriptFilePath();
        if (scriptFilePath == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.vjet.eclipse.core", 4, "Script File name is not specified...", null));
        }
        if (!proj.exists() && !myJavaProject.exists()) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.vjet.eclipse.core", 4, "Must run js from a VJET or JAVA project!", null));
        }
        String jsFile = scriptFilePath.toFile().getAbsolutePath();
        String vjoClz = "";
        if (jsFile.endsWith(".js")) {
            int n;
            int n3;
            IModelElement[] iModelElementArray;
            Object sourceRoot = null;
            if (proj.exists()) {
                IModelElement[] children;
                iModelElementArray = children = proj.getChildren();
                n3 = children.length;
                n = 0;
                while (n < n3) {
                    IProjectFragment melem;
                    IModelElement elem = iModelElementArray[n];
                    if (elem instanceof IProjectFragment && !(melem = (IProjectFragment)elem).isReadOnly()) {
                        String absolutePath = proj.getProject().getLocation().toFile().getAbsolutePath();
                        absolutePath = absolutePath.replace("//", "/");
                        absolutePath = absolutePath.replace("\\", "/");
                        String srcDir = String.valueOf(absolutePath.substring(0, absolutePath.indexOf(proj.getProject().getName()))) + melem.getPath();
                        srcDir = srcDir.replace("//", "/");
                        if (jsFile.startsWith(srcDir = srcDir.replace("\\\\", "/"))) {
                            sourceRoot = srcDir;
                            break;
                        }
                    }
                    ++n;
                }
            }
            if (StringUtils.isBlankOrEmpty(sourceRoot) && myJavaProject.exists()) {
                IClasspathEntry[] classpathEntries = myJavaProject.getRawClasspath();
                iModelElementArray = classpathEntries;
                n3 = classpathEntries.length;
                n = 0;
                while (n < n3) {
                    Object path;
                    IModelElement entry = iModelElementArray[n];
                    if (entry.getEntryKind() == 3 && jsFile.startsWith((String)(path = VjetInterpreterRunner.getSourceFile((IClasspathEntry)entry, workspaceRoot).getAbsolutePath()))) {
                        sourceRoot = path;
                        break;
                    }
                    ++n;
                }
            }
            if (sourceRoot != null) {
                String vjoFile = jsFile.substring(((String)sourceRoot).length() + 1);
                int suffixIndex = vjoFile.indexOf(".");
                if (suffixIndex > 0) {
                    vjoFile = vjoFile.substring(0, suffixIndex);
                }
                vjoClz = vjoFile.replace("/", ".");
                vjoClz = vjoClz.replace("\\", ".");
            }
        }
        ILaunchConfiguration launchConf = launch.getLaunchConfiguration();
        String args = launchConf.getAttribute("scriptArguments", "").trim();
        Map env = launchConf.getAttribute(ILaunchManager.ATTR_ENVIRONMENT_VARIABLES, new HashMap());
        List loadJSList = launchConf.getAttribute("includepath", new ArrayList());
        if (loadJSList.size() > 0) {
            StringBuilder loadJSStr = new StringBuilder();
            for (String js : loadJSList) {
                String path = js.substring(1);
                loadJSStr.append(path).append(";");
            }
            env.put("loadJs", loadJSStr.toString());
        }
        ArrayList<String> pArgs = new ArrayList<String>();
        if (vjoClz == "" && jsFile.indexOf("htm") != -1) {
            env.put("type", "html");
        }
        this.addEnvOptions(env, pArgs);
        pArgs.add(scriptFilePath.toFile().getAbsolutePath());
        pArgs.add(vjoClz);
        pArgs.add(this.findMainFunc(vjoClz, proj.getProject().getName()));
        pArgs.add(new ArgsNormalizer(args).normalize());
        vmConfig.setProgramArguments(pArgs.toArray(new String[0]));
        ArrayList<String> vmArgs = new ArrayList<String>(4);
        if (sourceSearchPath != null) {
            vmArgs.add("-Djava.source.path=" + sourceSearchPath);
        }
        IFileStore s = EFS.getStore((URI)proj.getProject().getProject().getLocationURI());
        File f = s.toLocalFile(0, null);
        if (this.m_mode.equals("debug")) {
            vmArgs.add("-DVJETDebugHost=" + config.getProperty("host"));
            vmArgs.add("-DVJETDebugPort=" + config.getProperty("port"));
            vmArgs.add("-DVJETDebugSessionID=" + config.getProperty("sessionId"));
            vmArgs.add("-DVJETProjectPath=" + f.getAbsolutePath());
        }
        String javaprojectprop = "org.eclipse.jdt.launching.PROJECT_ATTR";
        String projectName = myJavaProject.getProject().getName();
        ILaunchConfigurationWorkingCopy copy = launch.getLaunchConfiguration().getWorkingCopy();
        copy.setAttribute(javaprojectprop, projectName);
        copy.doSave();
        this.setupProxySrcLocator(launch, (ILaunchConfiguration)copy);
        vmConfig.setVMArguments(vmArgs.toArray(new String[vmArgs.size()]));
        vmRunner.run(vmConfig, launch, null);
        IDebugTarget[] debugTargets = launch.getDebugTargets();
        if (debugTargets.length > 0) {
            VjetLaunchingPlugin.getDefault().getLog().log((IStatus)new Status(1, "org.eclipse.vjet.eclipse.core", 1, "!USAGE_TRACKING: NAME=org.eclipse.vjet.eclipse.core.debug; ACCESS_TIME=" + new Date().toString() + ";", null));
        } else {
            VjetLaunchingPlugin.getDefault().getLog().log((IStatus)new Status(1, "org.eclipse.vjet.eclipse.core", 1, "!USAGE_TRACKING: NAME=org.eclipse.vjet.eclipse.core.run; ACCESS_TIME=" + new Date().toString() + ";", null));
        }
    }

    private String findMainFunc(String vjoClz, String projectName) {
        IJstMethod main;
        IJstType t = TypeSpaceMgr.findType((String)projectName, (String)vjoClz);
        if (t != null && (main = t.getMethod("main", true)) != null) {
            return String.valueOf(t.getName()) + ".main";
        }
        return "";
    }

    private String[] getJarPaths(IScriptProject scriptProject) {
        return LauncherUtil.getOptimizedBuildpath(scriptProject);
    }

    private void setupProxySrcLocator(ILaunch launch, ILaunchConfiguration config) {
        JavaSourceLookupDirector sourceLocator = new JavaSourceLookupDirector();
        sourceLocator.setSourcePathComputer(DebugPlugin.getDefault().getLaunchManager().getSourcePathComputer("org.eclipse.jdt.launching.sourceLookup.javaSourcePathComputer"));
        try {
            sourceLocator.initializeDefaults(config);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        launch.setSourceLocator((ISourceLocator)new SourceLocatorProxy((ISourceLocator)sourceLocator, launch.getSourceLocator()));
    }

    private String prepareSourceSearchPath(IScriptProject proj, IJavaProject myJavaProject, IWorkspaceRoot workspaceRoot, String sourceSearchPath) throws ModelException, JavaModelException {
        sourceSearchPath = !myJavaProject.exists() ? VjetInterpreterRunner.getSourceSearchPath(proj) : VjetInterpreterRunner.getSourceSearchPath(myJavaProject, workspaceRoot);
        return sourceSearchPath;
    }

    private void addEnvOptions(Map<?, ?> options, List<String> pArgs) {
        if (options != null) {
            for (Object optionKey : options.keySet()) {
                String key = (String)optionKey;
                String value = (String)options.get(optionKey);
                pArgs.add("-V" + key + "=" + value);
                if ((!key.equals("browserDisplay") || !"true".equalsIgnoreCase(value)) && (!key.equals("dapMode") || !"W".equalsIgnoreCase(value))) continue;
                BrowserService s = BrowserService.getInstance();
                pArgs.add("-VbrowserServiceUrl=http://localhost:" + s.getPort());
            }
        }
    }

    private static String getSourceSearchPath(IScriptProject proj) throws ModelException {
        IModelElement[] children = proj.getChildren();
        StringBuilder sb = new StringBuilder();
        IModelElement[] iModelElementArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IProjectFragment melem;
            IModelElement elem = iModelElementArray[n2];
            if (elem instanceof IProjectFragment && !(melem = (IProjectFragment)elem).isReadOnly()) {
                String absolutePath = proj.getProject().getLocation().toFile().getAbsolutePath();
                String srcDir = String.valueOf(absolutePath.substring(0, absolutePath.indexOf(proj.getProject().getName()))) + melem.getPath();
                srcDir = srcDir.replace("/", "\\");
                srcDir = srcDir.replace("\\\\", "\\");
                sb.append(srcDir);
                sb.append(PathSeparator);
            }
            ++n2;
        }
        return sb.toString();
    }

    private static String getSourceSearchPath(IJavaProject javaProject, IWorkspaceRoot workspaceRoot) throws JavaModelException {
        LinkedHashMap<String, IJavaProject> transitiveClosureProjectList = new LinkedHashMap<String, IJavaProject>();
        LauncherUtil.getTransitiveClosureProjectDependnecyList(javaProject, transitiveClosureProjectList);
        ArrayList<File> sourcePaths = new ArrayList<File>();
        VjetInterpreterRunner.getProjectSourcePaths(sourcePaths, workspaceRoot, javaProject.getResolvedClasspath(true));
        for (IJavaProject project : transitiveClosureProjectList.values()) {
            VjetInterpreterRunner.getProjectSourcePaths(sourcePaths, workspaceRoot, project.getResolvedClasspath(true));
        }
        StringBuilder sb = new StringBuilder();
        sb.append(javaProject.getPath().toFile().getAbsolutePath());
        for (File file : sourcePaths) {
            sb.append(PathSeparator).append(file.getAbsolutePath());
        }
        return sb.toString();
    }

    private static void getProjectSourcePaths(List<File> sourcePaths, IWorkspaceRoot workspaceRoot, IClasspathEntry[] classPathEntries) {
        if (classPathEntries != null) {
            IClasspathEntry[] iClasspathEntryArray = classPathEntries;
            int n = classPathEntries.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathEntry classPathEntry = iClasspathEntryArray[n2];
                if (classPathEntry.getEntryKind() == 3) {
                    sourcePaths.add(VjetInterpreterRunner.getSourceFile(classPathEntry, workspaceRoot));
                }
                ++n2;
            }
        }
    }

    private static File getSourceFile(IClasspathEntry classPathEntry, IWorkspaceRoot workspaceRoot) {
        if (classPathEntry.getPath().segmentCount() == 1) {
            IProject project = workspaceRoot.getProject(classPathEntry.getPath().lastSegment());
            return project.getLocation().toFile();
        }
        IFile sourceIFile = workspaceRoot.getFile(classPathEntry.getPath());
        return sourceIFile.getLocation().toFile();
    }

    private static String[] getJarPaths(IJavaProject javaProject) throws JavaModelException {
        return LauncherUtil.getOptimizedClasspath(javaProject);
    }

    private static class ArgsNormalizer {
        private static Pattern quotedPattern = Pattern.compile("^('|\")[\\w\\p{Punct}\\s]+('|\")");
        private static Pattern numberPattern = Pattern.compile("^[-+]?[0-9]*\\.?[0-9]+(\\s|$)");
        private static Pattern wordPattern = Pattern.compile("^[\\w\\p{Punct}]+(\\s|$)");
        private String rawArgs;
        private boolean first = true;

        private ArgsNormalizer(String rawArgs) {
            this.rawArgs = rawArgs;
        }

        String normalize() {
            StringBuffer buf = new StringBuffer();
            String arg = this.rawArgs.trim();
            while (arg.length() > 0) {
                Matcher quotedArgMatcher = quotedPattern.matcher(arg);
                Matcher numberMatcher = numberPattern.matcher(arg);
                Matcher wordMatcher = wordPattern.matcher(arg);
                if (quotedArgMatcher.find()) {
                    arg = this.match(arg, quotedArgMatcher.group(), buf, false);
                    continue;
                }
                if (numberMatcher.find()) {
                    arg = this.match(arg, numberMatcher.group().trim(), buf, false);
                    continue;
                }
                if (wordMatcher.find()) {
                    arg = this.match(arg, wordMatcher.group().trim(), buf, true);
                    continue;
                }
                return "";
            }
            return buf.toString();
        }

        private String match(String arg, String group, StringBuffer buf, boolean needToQuoted) {
            if (!this.first) {
                buf.append(" ");
            }
            this.first = false;
            if (needToQuoted) {
                buf.append("\"");
            }
            buf.append(group);
            if (needToQuoted) {
                buf.append("\"");
            }
            return arg.substring(group.length()).trim();
        }
    }
}

