/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.typespace.efs;

import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipException;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.provider.FileSystem;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.vjet.eclipse.typespace.efs.TypeSpaceFileStore;
import org.eclipse.vjet.eclipse.typespace.efs.internal.Activator;
import org.eclipse.vjet.eclipse.typespace.efs.internal.GroupItem;
import org.eclipse.vjet.eclipse.typespace.efs.internal.GroupRootItem;
import org.eclipse.vjet.vjo.tool.typespace.TypeSpaceMgr;

public class TypeSpaceFileSystem
extends FileSystem {
    public static final String SCEME_TYPESPACE = "typespace";
    private static Map<URI, GroupItem> tsItemCache = new HashMap<URI, GroupItem>();
    private static Map<URI, TypeSpaceFileStore> tstypeURICache = new HashMap<URI, TypeSpaceFileStore>();

    public int attributes() {
        return 2;
    }

    public static GroupItem getItem(URI uri) throws ZipException, IOException, CoreException {
        if (tsItemCache.containsKey(uri)) {
            return tsItemCache.get(uri);
        }
        String groupName = uri.getHost();
        GroupRootItem item = new GroupRootItem(groupName);
        tsItemCache.put(uri, item);
        return item;
    }

    public static void initialize(URI uri, IFile zipFile) throws ZipException, IOException, CoreException {
        if (tstypeURICache.containsKey(uri)) {
            return;
        }
        String groupName = uri.getHost();
        GroupRootItem item = new GroupRootItem(groupName, zipFile);
        tstypeURICache.put(uri, new TypeSpaceFileStore("root", null, item, uri));
    }

    public IFileStore getStore(URI uri) {
        try {
            if (tstypeURICache.containsKey(uri)) {
                return tstypeURICache.get(uri);
            }
            if (TypeSpaceFileSystem.canInitialize(uri.getHost())) {
                TypeSpaceFileStore store = new TypeSpaceFileStore("root", null, uri);
                tstypeURICache.put(uri, store);
                return store;
            }
        }
        catch (Exception e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.vjet.eclipse.typespace.efs", "could not create store for " + uri.toString(), (Throwable)e));
        }
        return EFS.getNullFileSystem().getStore(uri);
    }

    static void cache(URI uri, TypeSpaceFileStore store) {
        tstypeURICache.put(uri, store);
    }

    private static boolean canInitialize(String groupName) {
        if (TypeSpaceMgr.getInstance().getController() == null) {
            return false;
        }
        return TypeSpaceMgr.getInstance().getTypeSpace().getGroup(groupName) != null;
    }
}

