/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.typespace.efs.internal;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.declaration.JstObjectLiteralType;
import org.eclipse.vjet.dsf.jstojava.parser.VjoParser;
import org.eclipse.vjet.dsf.ts.group.IGroup;
import org.eclipse.vjet.eclipse.typespace.efs.internal.GroupFileItem;
import org.eclipse.vjet.eclipse.typespace.efs.internal.GroupItem;
import org.eclipse.vjet.eclipse.typespace.efs.internal.GroupPkgDirectoryItem;
import org.eclipse.vjet.vjo.tool.typespace.TypeSpaceMgr;

public class GroupRootItem
extends GroupPkgDirectoryItem {
    private String m_group;
    private boolean m_initialized;

    public GroupRootItem(String group) {
        super(group, null);
        this.m_group = group;
        this.createEntries(group);
    }

    public GroupRootItem(String group, IFile zip) {
        super(group, null);
        this.m_group = group;
        this.createEntries(zip);
    }

    public String getFullName() {
        return this.m_group;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void createEntries(IFile zip) {
        if (this.m_initialized) {
            return;
        }
        ZipInputStream in = null;
        try {
            try {
                ZipEntry current;
                IFileStore store = EFS.getStore((URI)zip.getLocationURI());
                in = new ZipInputStream(store.openInputStream(0, null));
                while ((current = in.getNextEntry()) != null) {
                    if (current.isDirectory() || !current.getName().equals("types.txt")) continue;
                    InputStream stream = new ZipFile(store.toLocalFile(0, null)).getInputStream(current);
                    String typesStr = VjoParser.load((InputStream)stream, (String)"types.txt");
                    String[] types = typesStr.split("\n");
                    GroupRootItem root = this;
                    String[] stringArray = types;
                    int n = types.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String t = stringArray[n2];
                        GroupRootItem parent = root;
                        this.addEntries(parent, t);
                        ++n2;
                    }
                    stream.close();
                }
                this.m_initialized = true;
                return;
            }
            catch (CoreException e) {
                e.printStackTrace();
                if (in == null) return;
                try {
                    in.close();
                    return;
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
                return;
            }
            catch (IOException e) {
                e.printStackTrace();
                if (in == null) return;
                try {
                    in.close();
                    return;
                }
                catch (IOException e3) {
                    e3.printStackTrace();
                }
                return;
            }
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private final synchronized void createEntries(String group) {
        if (this.m_initialized) {
            return;
        }
        IGroup groupSpace = null;
        groupSpace = TypeSpaceMgr.getInstance().getTypeSpace().getGroup(group);
        if (groupSpace == null) {
            return;
        }
        GroupRootItem root = this;
        for (IJstType type : groupSpace.getEntities().values()) {
            GroupRootItem parent = root;
            String fullName = type.getName();
            if (type instanceof JstObjectLiteralType) {
                System.out.println(type);
                fullName = type.getPackage().getName();
            }
            this.addEntries(parent, fullName);
        }
        this.m_initialized = true;
    }

    private void addEntries(GroupPkgDirectoryItem parent, String fullName) {
        fullName = fullName.replace(".", "/");
        Path path = new Path(fullName);
        int i = 0;
        while (i < path.segmentCount() - 1) {
            String dirName = path.segment(i);
            GroupItem item = parent.getItem(dirName);
            GroupPkgDirectoryItem newParent = (GroupPkgDirectoryItem)item;
            if (newParent == null) {
                newParent = new GroupPkgDirectoryItem(dirName, parent);
            }
            parent = newParent;
            ++i;
        }
        String name = path.lastSegment();
        new GroupFileItem(String.valueOf(name) + ".js", parent);
    }
}

