/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.internal.ui.text;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.dltk.mod.core.IScriptProject;
import org.eclipse.dltk.mod.ui.DLTKUIPlugin;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultIndentLineAutoEditStrategy;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.DocumentRewriteSession;
import org.eclipse.jface.text.DocumentRewriteSessionType;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.rules.FastPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.texteditor.ITextEditorExtension3;
import org.eclipse.vjet.eclipse.core.VjetPlugin;
import org.eclipse.vjet.eclipse.internal.ui.scriptdoc.IScanner;
import org.eclipse.vjet.eclipse.internal.ui.scriptdoc.JavaHeuristicScanner;
import org.eclipse.vjet.eclipse.internal.ui.scriptdoc.JavaIndenter;
import org.eclipse.vjet.eclipse.internal.ui.scriptdoc.PublicScanner;
import org.eclipse.vjet.eclipse.internal.ui.text.JavascriptPartitionScanner;
import org.eclipse.vjet.eclipse.internal.ui.text.JsPreferenceInterpreter;
import org.eclipse.vjet.eclipse.internal.ui.text.VjoIndenter;
import org.eclipse.vjet.eclipse.ui.VjetUIPlugin;

public class VjoAutoEditStrategy
extends DefaultIndentLineAutoEditStrategy {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final String LINE_COMMENT = "//";
    private static final char FORWARD_SLASH = '/';
    private static final char CONTINUE_MULTILINE_COMMENT = '*';
    private boolean fCloseBrace;
    private boolean fIsSmartMode;
    private String fPartitioning;
    final IScriptProject fProject;
    private static IScanner fgScanner = new PublicScanner(false, false, false, 3L, null, null, false);
    JsPreferenceInterpreter prefs;

    public VjoAutoEditStrategy(String partitioning, IScriptProject project) {
        this.fPartitioning = partitioning;
        this.fProject = project;
        this.prefs = new JsPreferenceInterpreter(VjetUIPlugin.getDefault().getPreferenceStore());
    }

    private int getBracketCount(IDocument d, int startOffset, int endOffset, boolean ignoreCloseBrackets) throws BadLocationException {
        int bracketCount = 0;
        block7: while (startOffset < endOffset) {
            char curr = d.getChar(startOffset);
            ++startOffset;
            switch (curr) {
                case '/': {
                    if (startOffset >= endOffset) break;
                    char next = d.getChar(startOffset);
                    if (next == '*') {
                        startOffset = this.getMultiLineCommentEnd(d, startOffset + 1, endOffset);
                        break;
                    }
                    if (next != '/') break;
                    startOffset = this.getLineCommentEnd(d, startOffset + 1, endOffset);
                    break;
                }
                case '*': {
                    char next;
                    if (startOffset >= endOffset || (next = d.getChar(startOffset)) != '/') continue block7;
                    bracketCount = 0;
                    ++startOffset;
                    break;
                }
                case '{': {
                    ++bracketCount;
                    ignoreCloseBrackets = false;
                    break;
                }
                case '}': {
                    if (ignoreCloseBrackets) break;
                    --bracketCount;
                    break;
                }
                case '\"': 
                case '\'': {
                    startOffset = this.getStringEnd(d, startOffset, endOffset, curr);
                }
            }
        }
        return bracketCount;
    }

    private int getMultiLineCommentEnd(IDocument d, int offset, int endOffset) throws BadLocationException {
        while (offset < endOffset) {
            char curr = d.getChar(offset);
            if (curr != '*' || ++offset >= endOffset || d.getChar(offset) != '/') continue;
            return offset + 1;
        }
        return endOffset;
    }

    private int getLineCommentEnd(IDocument d, int offset, int endOffset) throws BadLocationException {
        while (offset < endOffset) {
            char curr = d.getChar(offset);
            ++offset;
            if (curr != '\n') continue;
            return offset;
        }
        return endOffset;
    }

    private String getIndentOfLine(IDocument d, int line) throws BadLocationException {
        if (line > -1) {
            int start = d.getLineOffset(line);
            int end = start + d.getLineLength(line) - 1;
            int whiteEnd = this.findEndOfWhiteSpace(d, start, end);
            return d.get(start, whiteEnd - start);
        }
        return "";
    }

    private int getStringEnd(IDocument d, int offset, int endOffset, char ch) throws BadLocationException {
        while (offset < endOffset) {
            char curr = d.getChar(offset);
            ++offset;
            if (curr == '\\') {
                ++offset;
                continue;
            }
            if (curr != ch) continue;
            return offset;
        }
        return endOffset;
    }

    private void smartIndentAfterClosingBracket(IDocument d, DocumentCommand c) {
        if (c.offset == -1 || d.getLength() == 0) {
            return;
        }
        try {
            int p = c.offset == d.getLength() ? c.offset - 1 : c.offset;
            int line = d.getLineOfOffset(p);
            int start = d.getLineOffset(line);
            int whiteend = this.findEndOfWhiteSpace(d, start, c.offset);
            JavaHeuristicScanner scanner = new JavaHeuristicScanner(d);
            VjoIndenter indenter = new VjoIndenter(d, scanner, this.fProject);
            if (whiteend == c.offset) {
                int indLine;
                int reference = indenter.findReferencePosition(c.offset, false, true, false, false);
                String beforeCursor = d.get(0, c.offset).trim();
                int lastMatch = beforeCursor.lastIndexOf("{");
                if (lastMatch > reference) {
                    reference = lastMatch;
                }
                if ((indLine = d.getLineOfOffset(reference)) != -1 && indLine != line) {
                    StringBuffer replaceText = new StringBuffer(this.getIndentOfLine(d, indLine));
                    replaceText.append(d.get(whiteend, c.offset - whiteend));
                    replaceText.append(c.text);
                    c.length += c.offset - start;
                    c.offset = start;
                    c.text = replaceText.toString();
                }
            }
        }
        catch (BadLocationException e) {
            DLTKUIPlugin.log((Throwable)e);
        }
    }

    private void smartIndentAfterOpeningBracket(IDocument d, DocumentCommand c) {
        if (c.offset < 1 || d.getLength() == 0) {
            return;
        }
        JavaHeuristicScanner scanner = new JavaHeuristicScanner(d);
        int p = c.offset == d.getLength() ? c.offset - 1 : c.offset;
        try {
            int line = d.getLineOfOffset(p);
            int lineOffset = d.getLineOffset(line);
            if (d.get(lineOffset, p - lineOffset).trim().length() != 0) {
                return;
            }
            int pos = scanner.findNonWhitespaceBackward(p, -2);
            if (pos == -1) {
                return;
            }
            int lastLine = d.getLineOfOffset(pos);
            if (lastLine < line) {
                VjoIndenter indenter = new VjoIndenter(d, scanner, this.fProject);
                StringBuffer indent = indenter.computeIndentation(p, true);
                String toDelete = d.get(lineOffset, c.offset - lineOffset);
                if (indent != null && !indent.toString().equals(toDelete)) {
                    c.text = indent.append(c.text).toString();
                    c.length += c.offset - lineOffset;
                    c.offset = lineOffset;
                }
            }
        }
        catch (BadLocationException e) {
            DLTKUIPlugin.log((Throwable)e);
        }
    }

    private void smartIndentAfterNewLine(IDocument d, DocumentCommand c) {
        JavaHeuristicScanner scanner;
        VjoIndenter indenter;
        StringBuffer indent;
        int indexOf = c.text.indexOf(9);
        if (indexOf != -1) {
            c.text = c.text.substring(0, indexOf);
        }
        if ((indexOf = c.text.indexOf(32)) != -1) {
            c.text = c.text.substring(0, indexOf);
        }
        if ((indent = (indenter = new VjoIndenter(d, scanner = new JavaHeuristicScanner(d), this.fProject)).computeIndentation(c.offset)) == null) {
            indent = new StringBuffer();
        }
        int docLength = d.getLength();
        if (c.offset == -1 || docLength == 0) {
            return;
        }
        try {
            int firstCharPos;
            int p = c.offset == docLength ? c.offset - 1 : c.offset;
            int line = d.getLineOfOffset(p);
            StringBuffer buf = new StringBuffer(String.valueOf(c.text) + indent);
            IRegion reg = d.getLineInformation(line);
            int lineEnd = reg.getOffset() + reg.getLength();
            int contentStart = this.findEndOfWhiteSpace(d, c.offset, lineEnd);
            c.length = Math.max(contentStart - c.offset, 0);
            int start = reg.getOffset();
            ITypedRegion region = TextUtilities.getPartition((IDocument)d, (String)this.fPartitioning, (int)start, (boolean)true);
            if ("__javascript_doc".equals(region.getType())) {
                start = d.getLineInformationOfOffset(region.getOffset()).getOffset();
            }
            if (this.closeBrace() && !VjoAutoEditStrategy.isBlockBalanced(d) && (this.isAfterOpenBrace(d, c.offset) || !this.isClosedBrace(d, c.offset))) {
                c.caretOffset = c.offset + buf.length();
                c.shiftsCaret = false;
                buf.append('}');
                this.copyContent(d, c, buf, lineEnd, contentStart);
                this.appendReference(d, c, indenter, buf, lineEnd, start);
            } else if (c.offset > start && contentStart < lineEnd && d.getChar(contentStart) == '}' && (firstCharPos = scanner.findNonWhitespaceBackward(c.offset - 1, start)) != -1 && d.getChar(firstCharPos) == '{') {
                c.caretOffset = c.offset + buf.length();
                c.shiftsCaret = false;
                this.appendReference(d, c, indenter, buf, lineEnd, start);
            }
            c.text = buf.toString();
        }
        catch (BadLocationException e) {
            DLTKUIPlugin.log((Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isAfterOpenBrace(IDocument d, int offset) {
        try {
            while (true) {
                char ch;
                if ((ch = d.getChar(offset)) == '{') {
                    return true;
                }
                if (!Character.isWhitespace(ch)) {
                    return false;
                }
                --offset;
            }
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }

    private void copyContent(IDocument d, DocumentCommand c, StringBuffer buf, int lineEnd, int contentStart) throws BadLocationException {
        if ((c.offset == 0 || VjoAutoEditStrategy.computeAnonymousPosition(d, c.offset - 1, this.fPartitioning, lineEnd) == -1 && !this.isBraceInParenthis(d, c.offset)) && lineEnd - contentStart > 0) {
            c.length = lineEnd - c.offset;
            buf.append(d.get(contentStart, lineEnd - contentStart).toCharArray());
        }
    }

    private boolean isBraceInParenthis(IDocument d, int offset) {
        String sm = d.get();
        String lsm = sm.substring(offset, sm.length());
        if (lsm.length() == 0) {
            return false;
        }
        char c = lsm.charAt(0);
        return c == ')' || c == '}';
    }

    private void appendReference(IDocument d, DocumentCommand c, VjoIndenter indenter, StringBuffer buf, int lineEnd, int start) throws BadLocationException {
        StringBuffer reference = null;
        int nonWS = this.findEndOfWhiteSpace(d, start, lineEnd);
        reference = nonWS < c.offset && d.getChar(nonWS) == '{' ? new StringBuffer(d.get(start, nonWS - start)) : indenter.getReferenceIndentation(c.offset);
        buf.append(TextUtilities.getDefaultLineDelimiter((IDocument)d));
        if (reference != null) {
            buf.append(reference);
        }
    }

    private boolean isClosedBrace(IDocument d, int offset) {
        String sm = d.get();
        String lsm = sm.substring(offset, sm.length());
        String tsm = sm.substring(0, offset).trim();
        if (tsm.endsWith("({") && ((tsm = tsm.substring(0, tsm.length() - 2).trim()).endsWith("props") || tsm.endsWith("protos"))) {
            return true;
        }
        try {
            String afterOffset;
            d.getLineInformationOfOffset(offset);
            int position = lsm.indexOf(LINE_SEPARATOR);
            String string = afterOffset = position != -1 ? sm.substring(offset, offset + position) : lsm;
            if (afterOffset.trim().startsWith("})")) {
                return true;
            }
        }
        catch (BadLocationException e1) {
            VjetUIPlugin.log((Exception)((Object)e1));
        }
        int start = sm.substring(0, offset).lastIndexOf("({");
        sm.substring(0, offset).lastIndexOf("})");
        int endBraceCurly = sm.indexOf("({", offset);
        int end = this.getLegalEnd(sm, offset);
        if (endBraceCurly != -1 && endBraceCurly > start) {
            end = Math.min(endBraceCurly, end);
        }
        if (start < 0 || end < 0) {
            end = lsm.indexOf("}");
            if (end < 0) {
                return false;
            }
            return lsm.substring(0, end).trim().length() <= 0;
        }
        try {
            int count = this.getBracketCount(d, start + "({".length(), end, false);
            if (count <= 0) {
                return true;
            }
        }
        catch (BadLocationException e) {
            VjetPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.vjet.eclipse.core", 4, "Error during counting of braces", (Throwable)e));
        }
        return false;
    }

    public int getLegalEnd(String sm, int offset) {
        int end = sm.indexOf("})", offset);
        if (end != -1 && end < sm.length()) {
            if (sm.substring(end).startsWith("});")) {
                end = this.getLegalEnd(sm, end + "});".length());
            } else {
                return end;
            }
        }
        return end;
    }

    private static int computeAnonymousPosition(IDocument document, int offset, String partitioning, int max) {
        int openingParen;
        int startScan;
        JavaHeuristicScanner scanner = new JavaHeuristicScanner(document);
        int pos = offset;
        int length = max;
        int scanTo = scanner.scanForward(pos, length, '}');
        if (scanTo == -1) {
            scanTo = length;
        }
        int closingParen = VjoAutoEditStrategy.findClosingParenToLeft(scanner, pos) - 1;
        while ((closingParen = scanner.scanForward(startScan = closingParen + 1, scanTo, ')')) != -1 && (openingParen = scanner.findOpeningPeer(closingParen - 1, '(', ')')) >= 1) {
            if (openingParen > pos || !VjoAutoEditStrategy.looksLikeAnonymousClassDef(document, partitioning, scanner, openingParen - 1)) continue;
            return closingParen + 1;
        }
        return -1;
    }

    private static int findClosingParenToLeft(JavaHeuristicScanner scanner, int position) {
        if (position < 1) {
            return position;
        }
        if (scanner.previousToken(position - 1, -2) == 6) {
            return scanner.getPosition() + 1;
        }
        return position;
    }

    private static boolean isNewMatch(IDocument document, int offset, int length, String partitioning) {
        int pos;
        String text;
        block6: {
            block5: {
                Assert.isTrue((length >= 0 ? 1 : 0) != 0);
                Assert.isTrue((offset >= 0 ? 1 : 0) != 0);
                Assert.isTrue((offset + length < document.getLength() + 1 ? 1 : 0) != 0);
                try {
                    text = document.get(offset, length);
                    pos = text.indexOf("new");
                    while (pos != -1 && !VjoAutoEditStrategy.isDefaultPartition(document, pos + offset, partitioning)) {
                        pos = text.indexOf("new", pos + 2);
                    }
                    if (pos >= 0) break block5;
                    return false;
                }
                catch (BadLocationException badLocationException) {
                    return false;
                }
            }
            if (pos == 0 || !Character.isJavaIdentifierPart(text.charAt(pos - 1))) break block6;
            return false;
        }
        return pos + 3 >= length || !Character.isJavaIdentifierPart(text.charAt(pos + 3));
    }

    private static boolean looksLikeAnonymousClassDef(IDocument document, String partitioning, JavaHeuristicScanner scanner, int position) {
        int previousCommaParenEqual = scanner.scanBackward(position - 1, -2, new char[]{',', '(', '='});
        if (previousCommaParenEqual == -1 || position < previousCommaParenEqual + 5) {
            return false;
        }
        return VjoAutoEditStrategy.isNewMatch(document, previousCommaParenEqual + 1, position - previousCommaParenEqual - 2, partitioning);
    }

    private static boolean isDefaultPartition(IDocument document, int position, String partitioning) {
        Assert.isTrue((position >= 0 ? 1 : 0) != 0);
        Assert.isTrue((position <= document.getLength() ? 1 : 0) != 0);
        try {
            ITypedRegion region = TextUtilities.getPartition((IDocument)document, (String)partitioning, (int)position, (boolean)false);
            return region.getType().equals("__dftl_partition_content_type");
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }

    private static void installJavaStuff(Document document) {
        String[] types = new String[]{"__javascript_doc", "__javascript_single_comment", "__javascript_multi_comment", "__javascript_partitioning", "__javascript_string", "__dftl_partition_content_type"};
        FastPartitioner partitioner = new FastPartitioner((IPartitionTokenScanner)new JavascriptPartitionScanner(), types);
        partitioner.connect((IDocument)document);
        document.setDocumentPartitioner("__javascript_partitioning", (IDocumentPartitioner)partitioner);
    }

    private static void removeJavaStuff(Document document) {
        document.setDocumentPartitioner("__javascript_partitioning", null);
    }

    private void smartPaste(IDocument document, DocumentCommand command) {
        int newOffset = command.offset;
        int newLength = command.length;
        String newText = command.text;
        try {
            IRegion refLine;
            String prefix;
            JavaHeuristicScanner scanner = new JavaHeuristicScanner(document);
            VjoIndenter indenter = new VjoIndenter(document, scanner, this.fProject);
            int offset = newOffset;
            int refOffset = indenter.findReferencePosition(offset);
            if (refOffset == -1) {
                return;
            }
            int peerOffset = this.getPeerPosition(document, command);
            peerOffset = indenter.findReferencePosition(peerOffset);
            refOffset = Math.min(refOffset, peerOffset);
            int firstLine = 1;
            IRegion line = document.getLineInformationOfOffset(offset);
            String notSelected = document.get(line.getOffset(), offset - line.getOffset());
            if (notSelected.trim().length() == 0) {
                newLength += notSelected.length();
                newOffset = line.getOffset();
                firstLine = 0;
            }
            if ((prefix = document.get((refLine = document.getLineInformationOfOffset(refOffset)).getOffset(), newOffset - refLine.getOffset())).endsWith(LINE_SEPARATOR) && !prefix.endsWith("{" + LINE_SEPARATOR) && !prefix.endsWith(";" + LINE_SEPARATOR) && !prefix.trim().endsWith(",")) {
                offset = document.get(0, offset).trim().length();
                refLine = document.getLineInformationOfOffset(offset);
                prefix = document.get(refLine.getOffset(), offset - refLine.getOffset());
            }
            Document temp = new Document(String.valueOf(prefix) + newText);
            DocumentRewriteSession session = temp.startRewriteSession(DocumentRewriteSessionType.STRICTLY_SEQUENTIAL);
            scanner = new JavaHeuristicScanner((IDocument)temp);
            indenter = new VjoIndenter((IDocument)temp, scanner, this.fProject);
            VjoAutoEditStrategy.installJavaStuff(temp);
            boolean isIndentDetected = false;
            StringBuffer addition = new StringBuffer();
            int insertLength = 0;
            int first = document.computeNumberOfLines(prefix) + firstLine;
            int lines = temp.getNumberOfLines();
            int tabLength = this.getVisualTabLengthPreference();
            boolean changed = false;
            int l = first;
            while (l < lines) {
                IRegion r = temp.getLineInformation(l);
                int lineOffset = r.getOffset();
                int lineLength = r.getLength();
                if (lineLength != 0) {
                    if (!isIndentDetected) {
                        String current = VjoAutoEditStrategy.getCurrentIndent(temp, l);
                        StringBuffer correct = indenter.computeIndentation(lineOffset);
                        if (correct == null) {
                            return;
                        }
                        insertLength = this.subtractIndent(correct, current, addition, tabLength);
                        if (l != first && temp.get(lineOffset, lineLength).trim().length() != 0) {
                            isIndentDetected = true;
                            if (insertLength == 0) {
                                if (firstLine == 0) {
                                    command.offset = newOffset;
                                    command.length = newLength;
                                    if (changed) break;
                                }
                                return;
                            }
                            VjoAutoEditStrategy.removeJavaStuff(temp);
                        } else {
                            boolean bl = changed = insertLength != 0;
                        }
                    }
                    if (insertLength > 0) {
                        this.addIndent(temp, l, addition, tabLength);
                    } else if (insertLength < 0) {
                        this.cutIndent(temp, l, -insertLength, tabLength);
                    }
                }
                ++l;
            }
            temp.stopRewriteSession(session);
            newText = temp.get(prefix.length(), temp.getLength() - prefix.length());
            command.offset = newOffset;
            command.length = newLength;
            command.text = newText;
        }
        catch (BadLocationException e) {
            DLTKUIPlugin.log((Throwable)e);
        }
    }

    private static String getCurrentIndent(Document document, int line) throws BadLocationException {
        String type;
        IRegion region = document.getLineInformation(line);
        int from = region.getOffset();
        int endOffset = region.getOffset() + region.getLength();
        int to = from;
        while (to < endOffset - 2 && document.get(to, 2).equals(LINE_COMMENT)) {
            to += 2;
        }
        while (to < endOffset) {
            char ch = document.getChar(to);
            if (!Character.isWhitespace(ch)) break;
            ++to;
        }
        if (to > from && to < endOffset - 1 && document.get(to - 1, 2).equals(" *") && ((type = TextUtilities.getContentType((IDocument)document, (String)"__javascript_partitioning", (int)to, (boolean)true)).equals("__javascript_doc") || type.equals("__javascript_single_comment") || type.equals("__javascript_multi_comment"))) {
            --to;
        }
        return document.get(from, to - from);
    }

    private int subtractIndent(CharSequence correct, CharSequence current, StringBuffer difference, int tabLength) {
        int c2;
        int c1 = this.computeVisualLength(correct, tabLength);
        int diff = c1 - (c2 = this.computeVisualLength(current, tabLength));
        if (diff <= 0) {
            return diff;
        }
        difference.setLength(0);
        int len = 0;
        int i = 0;
        while (len < diff) {
            char c = correct.charAt(i++);
            difference.append(c);
            len += this.computeVisualLength(c, tabLength);
        }
        return diff;
    }

    private void addIndent(Document document, int line, CharSequence indent, int tabLength) throws BadLocationException {
        IRegion region = document.getLineInformation(line);
        int insert = region.getOffset();
        int endOffset = region.getOffset() + region.getLength();
        int newInsert = insert;
        while (newInsert < endOffset - 2 && document.get(newInsert, 2).equals(LINE_COMMENT)) {
            newInsert += 2;
        }
        if (newInsert > insert) {
            int whitespaceCount = 0;
            int i = newInsert;
            while (i < endOffset - 1) {
                char ch = document.get(i, 1).charAt(0);
                if (!Character.isWhitespace(ch)) break;
                whitespaceCount += this.computeVisualLength(ch, tabLength);
                ++i;
            }
            if (whitespaceCount != 0 && whitespaceCount >= 4) {
                insert = newInsert;
            }
        }
        document.replace(insert, 0, indent.toString());
    }

    private void cutIndent(Document document, int line, int toDelete, int tabLength) throws BadLocationException {
        IRegion region = document.getLineInformation(line);
        int from = region.getOffset();
        int endOffset = region.getOffset() + region.getLength();
        while (from < endOffset - 2 && document.get(from, 2).equals(LINE_COMMENT)) {
            from += 2;
        }
        int to = from;
        while (toDelete > 0 && to < endOffset) {
            char ch = document.getChar(to);
            if (!Character.isWhitespace(ch) || (toDelete -= this.computeVisualLength(ch, tabLength)) < 0) break;
            ++to;
        }
        document.replace(from, to - from, "");
    }

    private int computeVisualLength(CharSequence seq, int tabLength) {
        int size = 0;
        int i = 0;
        while (i < seq.length()) {
            char ch = seq.charAt(i);
            if (ch == '\t') {
                if (tabLength != 0) {
                    size += tabLength - size % tabLength;
                }
            } else {
                ++size;
            }
            ++i;
        }
        return size;
    }

    private int computeVisualLength(char ch, int tabLength) {
        if (ch == '\t') {
            return tabLength;
        }
        return 1;
    }

    private int getVisualTabLengthPreference() {
        return 4;
    }

    private int getPeerPosition(IDocument document, DocumentCommand command) {
        if (document.getLength() == 0) {
            return 0;
        }
        Document pasted = new Document(command.text);
        VjoAutoEditStrategy.installJavaStuff(pasted);
        int firstPeer = command.offset;
        JavaHeuristicScanner pScanner = new JavaHeuristicScanner((IDocument)pasted);
        JavaHeuristicScanner dScanner = new JavaHeuristicScanner(document);
        int afterToken = dScanner.nextToken(command.offset + command.length, -2);
        try {
            switch (afterToken) {
                case 2: {
                    pasted.replace(pasted.getLength(), 0, "}");
                    break;
                }
                case 6: {
                    pasted.replace(pasted.getLength(), 0, ")");
                    break;
                }
                case 4: {
                    pasted.replace(pasted.getLength(), 0, "]");
                }
            }
        }
        catch (BadLocationException badLocationException) {
            Assert.isTrue((boolean)false);
        }
        int pPos = 0;
        int dPos = Math.max(0, command.offset - 1);
        block15: while (true) {
            int token = pScanner.nextToken(pPos, -2);
            pPos = pScanner.getPosition();
            switch (token) {
                case 1: 
                case 3: 
                case 5: {
                    if ((pPos = VjoAutoEditStrategy.skipScope(pScanner, pPos, token)) != -1) continue block15;
                    return firstPeer;
                }
                case 2: {
                    int peer = dScanner.findOpeningPeer(dPos, '{', '}');
                    dPos = peer - 1;
                    if (peer == -1) {
                        return firstPeer;
                    }
                    firstPeer = peer;
                    continue block15;
                }
                case 4: {
                    int peer = dScanner.findOpeningPeer(dPos, '[', ']');
                    dPos = peer - 1;
                    if (peer == -1) {
                        return firstPeer;
                    }
                    firstPeer = peer;
                    continue block15;
                }
                case 6: {
                    int peer = dScanner.findOpeningPeer(dPos, '(', ')');
                    dPos = peer - 1;
                    if (peer == -1) {
                        return firstPeer;
                    }
                    firstPeer = peer;
                    continue block15;
                }
                case 1013: 
                case 1024: {
                    VjoIndenter indenter = new VjoIndenter(document, dScanner, this.fProject);
                    int peer = indenter.findReferencePosition(dPos, false, false, false, true);
                    if (peer == -1) {
                        return firstPeer;
                    }
                    firstPeer = peer;
                    continue block15;
                }
                case -1: {
                    return firstPeer;
                }
            }
        }
    }

    private static int skipScope(JavaHeuristicScanner scanner, int pos, int token) {
        int closeToken;
        int openToken = token;
        switch (token) {
            case 5: {
                closeToken = 6;
                break;
            }
            case 3: {
                closeToken = 4;
                break;
            }
            case 1: {
                closeToken = 2;
                break;
            }
            default: {
                Assert.isTrue((boolean)false);
                return -1;
            }
        }
        int depth = 1;
        int p = pos;
        while (true) {
            int tok = scanner.nextToken(p, -2);
            p = scanner.getPosition();
            if (tok == openToken) {
                ++depth;
                continue;
            }
            if (tok == closeToken) {
                if (--depth != 0) continue;
                return p + 1;
            }
            if (tok == -1) break;
        }
        return -1;
    }

    private boolean isLineDelimiter(IDocument document, String text) {
        String[] delimiters = document.getLegalLineDelimiters();
        if (delimiters != null) {
            return TextUtilities.startsWith((String[])delimiters, (String)text) > -1 && text.trim().length() == 0;
        }
        return false;
    }

    /*
     * Exception decompiling
     */
    private void autoClose(IDocument d, DocumentCommand c) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 6[CASE]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void smartIndentOnKeypress(IDocument document, DocumentCommand command) {
        switch (command.text.charAt(0)) {
            case '}': {
                this.smartIndentAfterClosingBracket(document, command);
                break;
            }
            case '{': {
                this.smartIndentAfterOpeningBracket(document, command);
                break;
            }
            case '\"': 
            case '\'': 
            case '(': 
            case '[': {
                this.autoClose(document, command);
                break;
            }
            case 'e': {
                this.smartIndentUponE(document, command);
            }
        }
    }

    private void smartIndentUponE(IDocument d, DocumentCommand c) {
        if (c.offset < 4 || d.getLength() == 0) {
            return;
        }
        try {
            String content = d.get(c.offset - 3, 3);
            if (content.equals("els")) {
                JavaHeuristicScanner scanner = new JavaHeuristicScanner(d);
                int p = c.offset - 3;
                int line = d.getLineOfOffset(p);
                int lineOffset = d.getLineOffset(line);
                if (d.get(lineOffset, p - lineOffset).trim().length() != 0) {
                    return;
                }
                int pos = scanner.findNonWhitespaceBackward(p - 1, -2);
                if (pos == -1) {
                    return;
                }
                int lastLine = d.getLineOfOffset(pos);
                if (lastLine < line) {
                    VjoIndenter indenter = new VjoIndenter(d, scanner, this.fProject);
                    int ref = indenter.findReferencePosition(p, true, false, false, false);
                    if (ref == -1) {
                        return;
                    }
                    int refLine = d.getLineOfOffset(ref);
                    String indent = this.getIndentOfLine(d, refLine);
                    if (indent != null) {
                        c.text = String.valueOf(indent.toString()) + "else";
                        c.length += c.offset - lineOffset;
                        c.offset = lineOffset;
                    }
                }
                return;
            }
            if (content.equals("cas")) {
                JavaHeuristicScanner scanner = new JavaHeuristicScanner(d);
                int p = c.offset - 3;
                int line = d.getLineOfOffset(p);
                int lineOffset = d.getLineOffset(line);
                if (d.get(lineOffset, p - lineOffset).trim().length() != 0) {
                    return;
                }
                int pos = scanner.findNonWhitespaceBackward(p - 1, -2);
                if (pos == -1) {
                    return;
                }
                int lastLine = d.getLineOfOffset(pos);
                if (lastLine < line) {
                    JavaIndenter indenter = new JavaIndenter(d, scanner, this.fProject);
                    int ref = indenter.findReferencePosition(p, false, false, false, true);
                    if (ref == -1) {
                        return;
                    }
                    int refLine = d.getLineOfOffset(ref);
                    int nextToken = scanner.nextToken(ref, -2);
                    String indent = nextToken == 1013 || nextToken == 1024 ? this.getIndentOfLine(d, refLine) : indenter.computeIndentation(p).toString();
                    if (indent != null) {
                        c.text = String.valueOf(indent.toString()) + "case";
                        c.length += c.offset - lineOffset;
                        c.offset = lineOffset;
                    }
                }
                return;
            }
        }
        catch (BadLocationException e) {
            DLTKUIPlugin.log((Throwable)e);
        }
    }

    public void customizeDocumentCommand(IDocument d, DocumentCommand c) {
        if (!c.doit) {
            return;
        }
        this.clearCachedValues();
        if (!this.isSmartMode()) {
            super.customizeDocumentCommand(d, c);
            return;
        }
        if (c.length == 0 && c.text != null && this.isLineDelimiter(d, c.text)) {
            this.smartIndentAfterNewLine(d, c);
        } else if (c.text.length() == 1) {
            this.smartIndentOnKeypress(d, c);
        } else if (c.text.length() > 1 && VjoAutoEditStrategy.getPreferenceStore().getBoolean("smartPaste")) {
            this.smartPaste(d, c);
        }
    }

    private static IPreferenceStore getPreferenceStore() {
        return VjetUIPlugin.getDefault().getPreferenceStore();
    }

    private boolean closeBrace() {
        return this.fCloseBrace;
    }

    private boolean isSmartMode() {
        return this.fIsSmartMode;
    }

    private void clearCachedValues() {
        IPreferenceStore preferenceStore = VjoAutoEditStrategy.getPreferenceStore();
        this.fCloseBrace = preferenceStore.getBoolean("closeBraces");
        this.fIsSmartMode = this.computeSmartMode();
    }

    private boolean computeSmartMode() {
        IEditorPart part;
        IWorkbenchPage page = DLTKUIPlugin.getActivePage();
        if (page != null && (part = page.getActiveEditor()) instanceof ITextEditorExtension3) {
            ITextEditorExtension3 extension = (ITextEditorExtension3)part;
            return extension.getInsertMode() == ITextEditorExtension3.SMART_INSERT;
        }
        return false;
    }

    private static boolean isBlockBalanced(IDocument document) {
        int token;
        JavaHeuristicScanner scanner = new JavaHeuristicScanner(document);
        int start = 0;
        int end = document.getLength();
        int numOfBlocks = 0;
        while ((token = scanner.nextToken(start, end)) != -1) {
            switch (token) {
                case 1: {
                    ++numOfBlocks;
                    break;
                }
                case 2: {
                    --numOfBlocks;
                }
            }
            start = scanner.getPosition();
        }
        return numOfBlocks == 0;
    }
}

