/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.javatojs.cli;

import java.io.File;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.vjet.dsf.javatojs.control.BuildController;
import org.eclipse.vjet.dsf.javatojs.control.ICodeGenPathResolver;
import org.eclipse.vjet.dsf.javatojs.util.JavaToJsHelper;
import org.eclipse.vjet.dsf.jst.declaration.JstType;

public class Java2Vjo {
    private static String s_help = "Java2Vjo [options]\nOptions:\n\t[file-path] is the path to a single java file or a directory that contains\n\tjava source files. You MUST provide at least one valid path.  You can provide\n\t more than one.\n\n\t-verbose print debugging information. Default: Off.\n\t-ot OnDemand translation. Default: On\n\t-tt Targetted translation. Default: Off [Either runs in OnDemand or Targeted not Both]\n\t-trace Enable tracing. Default: Off.\n\t-nojsr Do not create Jsr files. Default: Off [will create jsr files].\n\t-help Display this help menu.\n\nExample: Java2Vjo c:/sample c:/sample2 -ot -nojsr";
    private boolean m_traceEnabled = false;
    private boolean m_genJsr = true;
    private boolean m_includeChildPkgs = true;
    private boolean m_verbose = false;
    private boolean m_onDemand = true;
    private boolean m_help = false;

    public void generate(List<URL> files) {
        BuildController controller = new BuildController();
        controller.enableTrace(this.m_traceEnabled);
        controller.setGenJsr(this.m_genJsr);
        controller.setVerbose(this.m_verbose);
        if (this.m_onDemand) {
            controller.setUseOnDemand(true);
        } else {
            controller.setUseOnDemand(false);
        }
        this.setUpCodeGenPathResolver(controller, files);
        for (URL file : files) {
            if (file.getPath().endsWith(".java")) {
                ArrayList<URL> list = new ArrayList<URL>(1);
                list.add(file);
                controller.buildFiles(list);
                continue;
            }
            controller.setIncludeChildPkgs(this.m_includeChildPkgs);
            controller.buildPackage(file);
        }
        controller.reset();
    }

    private void setUpCodeGenPathResolver(BuildController controller, List<URL> files) {
        try {
            ArrayList<File> javaFiles = new ArrayList<File>();
            for (URL url : files) {
                if (!url.getProtocol().equalsIgnoreCase("file")) continue;
                File currentFile = new File(url.toURI());
                this.listJavaFiles(currentFile, javaFiles);
            }
            if (!javaFiles.isEmpty()) {
                File currentFile = (File)javaFiles.get(0);
                String packagePath = JavaToJsHelper.getPkgNameFromSrc((String)JavaToJsHelper.readFromInputReader((InputStreamReader)new InputStreamReader(currentFile.toURI().toURL().openStream())));
                final File genDir = new File(currentFile.getCanonicalPath().substring(0, currentFile.getCanonicalPath().indexOf(packagePath.replace('.', File.separatorChar))));
                controller.setCodeGenPathResolver(new ICodeGenPathResolver(){

                    public URL getJavaFilePath(JstType type) throws MalformedURLException {
                        URL url = ICodeGenPathResolver.DEFAULT.getJavaFilePath(type);
                        System.out.println("Java : " + url);
                        return url;
                    }

                    public URL getJsrFilePath(JstType type) throws MalformedURLException {
                        URL url = ICodeGenPathResolver.DEFAULT.getJsrFilePath(type);
                        System.out.println("JSR  : " + url);
                        if (url.getProtocol().equalsIgnoreCase("file")) {
                            return url;
                        }
                        return new File(genDir, String.valueOf(type.getName().replace('.', '/')) + "Jsr.java").toURI().toURL();
                    }

                    public URL getVjoFilePath(JstType type) throws MalformedURLException {
                        URL url = ICodeGenPathResolver.DEFAULT.getVjoFilePath(type);
                        System.out.println("JS   : " + url);
                        if (url.getProtocol().equalsIgnoreCase("file")) {
                            return url;
                        }
                        return new File(genDir, String.valueOf(type.getName().replace('.', '/')) + ".js").toURI().toURL();
                    }
                });
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void listJavaFiles(File dir, List<File> files) {
        if (dir.isDirectory()) {
            File[] children;
            File[] fileArray = children = dir.listFiles();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                File child = fileArray[n2];
                if (child.isFile()) {
                    if (child.getName().endsWith(".java")) {
                        files.add(child);
                    }
                } else {
                    this.listJavaFiles(child, files);
                }
                ++n2;
            }
        } else if (dir.getName().endsWith(".java")) {
            files.add(dir);
        }
    }

    public static void main(String[] args) {
        if (args == null || args.length < 1) {
            Java2Vjo.showHelp();
            return;
        }
        Java2Vjo java2Vjo = new Java2Vjo();
        ArrayList<URL> files = new ArrayList<URL>();
        Java2Vjo.processOptions(java2Vjo, args, files);
        if (java2Vjo.isHelp()) {
            Java2Vjo.showHelp();
            return;
        }
        if (files.size() == 0) {
            System.out.println("ERROR: No Valid File Paths Found!");
            return;
        }
        System.out.print("Options: [");
        System.out.print("GenJsr " + (java2Vjo.m_genJsr ? "enabled" : "disabled"));
        System.out.print(", OnDemand " + (java2Vjo.m_onDemand ? "enabled" : "disabled"));
        System.out.print(", Trace " + (java2Vjo.m_traceEnabled ? "enabled" : "disabled"));
        System.out.print(", Verbose " + (java2Vjo.m_verbose ? "enabled" : "disabled"));
        System.out.println("]");
        java2Vjo.generate(files);
        System.out.println("Java2Vjo completed successfully");
    }

    public boolean isTraceEnabled() {
        return this.m_traceEnabled;
    }

    public void setTraceEnabled(boolean enabled) {
        this.m_traceEnabled = enabled;
    }

    public boolean shouldGenJsr() {
        return this.m_genJsr;
    }

    public void setGenJsr(boolean value) {
        this.m_genJsr = value;
    }

    public boolean shouldIncludeChildPkgs() {
        return this.m_includeChildPkgs;
    }

    public void setIncludeChildPkgs(boolean value) {
        this.m_includeChildPkgs = value;
    }

    public boolean isVerbose() {
        return this.m_verbose;
    }

    public void setVerbose(boolean verbose) {
        this.m_verbose = verbose;
    }

    public boolean isOnDemand() {
        return this.m_onDemand;
    }

    public void setOnDemand(boolean value) {
        this.m_onDemand = value;
    }

    public boolean isHelp() {
        return this.m_help;
    }

    public void setHelp(boolean value) {
        this.m_help = value;
    }

    private static void processOptions(Java2Vjo java2Vjo, String[] args, List<URL> files) {
        File file = null;
        int i = 0;
        while (i < args.length) {
            String opt = args[i].trim();
            if (opt.equalsIgnoreCase(Options.NOJSR.toString())) {
                java2Vjo.setGenJsr(false);
            } else if (opt.equalsIgnoreCase(Options.OT.toString())) {
                java2Vjo.setOnDemand(true);
            } else if (opt.equalsIgnoreCase(Options.TT.toString())) {
                java2Vjo.setOnDemand(false);
            } else if (opt.equalsIgnoreCase(Options.TRACE.toString())) {
                java2Vjo.setTraceEnabled(true);
            } else if (opt.equalsIgnoreCase(Options.VERBOSE.toString())) {
                java2Vjo.setVerbose(true);
            } else {
                if (opt.equalsIgnoreCase(Options.HELP.toString())) {
                    java2Vjo.setHelp(true);
                    return;
                }
                if (!opt.startsWith("-")) {
                    file = new File(opt);
                    if (file.exists()) {
                        try {
                            files.add(file.toURI().toURL());
                        }
                        catch (MalformedURLException malformedURLException) {
                            System.out.println("File/Path Does Not Exist: " + opt);
                        }
                    } else {
                        System.out.println("File/Path Does Not Exist: " + opt);
                    }
                } else {
                    System.out.println("Ignoring unknown option: " + opt);
                }
            }
            ++i;
        }
    }

    private static void showHelp() {
        System.out.println(s_help);
    }

    static enum Options {
        OT("-ot"),
        TT("-tt"),
        TRACE("-trace"),
        NOJSR("-nojsr"),
        VERBOSE("-verbose"),
        HELP("-help");

        private String m_value;

        private Options(String value) {
            this.m_value = value;
        }

        public String toString() {
            return this.m_value;
        }
    }
}

