/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.dap.rt;

import java.text.MessageFormat;
import org.eclipse.vjet.dsf.dap.rt.DapCtx;
import org.eclipse.vjet.dsf.html.events.ISimpleJsEventHandler;
import org.eclipse.vjet.dsf.html.js.IJsFunc;
import org.eclipse.vjet.dsf.html.js.IScopeableJsHandler;

public final class DapEventHandlerAdapter
implements ISimpleJsEventHandler,
IScopeableJsHandler {
    private IJsFunc m_func;
    private String m_scope;

    DapEventHandlerAdapter(String elemId, int index) {
        this.m_scope = MessageFormat.format("dapHost.getEvtHandlers(\"{0}\")[{1}]", elemId, new Integer(index));
    }

    DapEventHandlerAdapter(IJsFunc func) {
        this.m_func = func;
    }

    public String asJsDefinition() {
        return null;
    }

    public String asJsHandler() {
        return this.asJsHandler(null);
    }

    public String asJsHandler(String scope) {
        StringBuffer buf = new StringBuffer();
        if (DapCtx.ctx().isActiveMode()) {
            buf.append("function(event) { return this.process(event.src, event.eventType, event.nativeEvent);}");
        } else {
            buf.append("function(event) { ").append(this.m_func.generate(scope)).append(" }");
        }
        return buf.toString();
    }

    public String getScope() {
        if (DapCtx.ctx().isActiveMode()) {
            return this.m_scope;
        }
        if (this.m_func != null) {
            return this.m_func.getScope();
        }
        return null;
    }

    public IJsFunc getJsFunc() {
        return this.m_func;
    }
}

