/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.dap.rt.jsonp;

import org.eclipse.vjet.dsf.active.client.AWindow;
import org.eclipse.vjet.dsf.active.util.AsyncTask;
import org.eclipse.vjet.dsf.dap.rt.DapCtx;
import org.eclipse.vjet.dsf.dap.rt.DapHttpRequest;
import org.eclipse.vjet.dsf.dap.rt.DapHttpResponse;
import org.eclipse.vjet.dsf.dap.rt.IDapHttpClient;
import org.eclipse.vjet.dsf.services.ConnectionProtocolEnum;

public class JsonpProxy {
    public static void evaluate(String src, AWindow window) {
        if (src != null && src.trim().length() > 0) {
            DapHttpRequest dapReq = JsonpProxy.buildDapRequest(src);
            AsyncTask asyncTask = new AsyncTask();
            window.addTask(asyncTask);
            JsonpCallback callback = new JsonpCallback(asyncTask);
            DapCtx.ctx().getDapConfig().getHttpClient().send(dapReq, callback);
        }
    }

    private static DapHttpRequest buildDapRequest(String src) {
        DapHttpRequest dapReq = new DapHttpRequest(ConnectionProtocolEnum.GET.getName(), src, true);
        dapReq.setTimeout(100000L);
        return dapReq;
    }

    private static class JsonpCallback
    implements IDapHttpClient.IDapCallback {
        private AsyncTask m_task;

        public JsonpCallback(AsyncTask task) {
            this.m_task = task;
        }

        @Override
        public void onComplete(DapHttpResponse resp) {
            String jsCode = resp.getResponseText();
            if (jsCode != null && jsCode.trim().length() > 0) {
                this.m_task.setJsCode(jsCode);
            } else {
                this.m_task.cancel();
            }
        }

        @Override
        public void onTimedOut() {
        }
    }
}

