/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.json.serializer;

import java.lang.reflect.Type;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.vjet.dsf.json.JsonArray;
import org.eclipse.vjet.dsf.json.JsonObject;
import org.eclipse.vjet.dsf.json.JsonTokener;
import org.eclipse.vjet.dsf.json.serializer.ArraySerializer;
import org.eclipse.vjet.dsf.json.serializer.BeanSerializer;
import org.eclipse.vjet.dsf.json.serializer.BooleanSerializer;
import org.eclipse.vjet.dsf.json.serializer.DateSerializer;
import org.eclipse.vjet.dsf.json.serializer.DictionarySerializer;
import org.eclipse.vjet.dsf.json.serializer.ISerializer;
import org.eclipse.vjet.dsf.json.serializer.ListSerializer;
import org.eclipse.vjet.dsf.json.serializer.MapSerializer;
import org.eclipse.vjet.dsf.json.serializer.NumberSerializer;
import org.eclipse.vjet.dsf.json.serializer.ObjectMatch;
import org.eclipse.vjet.dsf.json.serializer.PrimitiveSerializer;
import org.eclipse.vjet.dsf.json.serializer.SerializationException;
import org.eclipse.vjet.dsf.json.serializer.SerializerState;
import org.eclipse.vjet.dsf.json.serializer.SetSerializer;
import org.eclipse.vjet.dsf.json.serializer.StringSerializer;
import org.eclipse.vjet.dsf.services.IRequestValidator;

public class JsonRpcSerializer {
    private volatile Registry m_registry = new Registry();
    private boolean m_marshallNullAttributes = true;

    public void registerDefaultSerializers() throws SerializationException {
        this.registerSerializer(new BeanSerializer());
        this.registerSerializer(new ArraySerializer());
        this.registerSerializer(new DictionarySerializer());
        this.registerSerializer(new MapSerializer());
        this.registerSerializer(new SetSerializer());
        this.registerSerializer(new ListSerializer());
        this.registerSerializer(new DateSerializer());
        this.registerSerializer(new StringSerializer());
        this.registerSerializer(new NumberSerializer());
        this.registerSerializer(new BooleanSerializer());
        this.registerSerializer(new PrimitiveSerializer());
    }

    public void registerSerializer(ISerializer s) throws SerializationException {
        Registry.registerSerializer(s, this);
    }

    public ISerializer getSerializer(Class clazz, Class jsoClazz) {
        return this.m_registry.getSerializer(clazz, jsoClazz);
    }

    private Class getClassFromHint(Object o) throws SerializationException {
        if (o == null) {
            return null;
        }
        if (o instanceof JsonObject) {
            try {
                String class_name = ((JsonObject)o).getString("javaClass");
                Class<?> clazz = Class.forName(class_name);
                return clazz;
            }
            catch (Exception exception) {
                throw new SerializationException("class in hint not found");
            }
        }
        if (o instanceof JsonArray) {
            JsonArray arr = (JsonArray)o;
            if (arr.length() == 0) {
                throw new SerializationException("no type for empty array");
            }
            Class compClazz = this.getClassFromHint(arr.get(0));
            try {
                if (compClazz.isArray()) {
                    return Class.forName("[" + compClazz.getName());
                }
                return Class.forName("[L" + compClazz.getName() + ";");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new SerializationException("problem getting array type");
            }
        }
        return o.getClass();
    }

    public ObjectMatch tryUnmarshall(SerializerState state, Class clazz, Object json) throws SerializationException {
        Class cls = clazz;
        if (cls != null && json instanceof JsonObject && ((JsonObject)json).has("javaClass") && cls.isAssignableFrom(this.getClassFromHint(json))) {
            cls = this.getClassFromHint(json);
        }
        if (cls == null) {
            cls = this.getClassFromHint(json);
        }
        if (cls == null) {
            throw new SerializationException("no class hint");
        }
        if (json == null || json == JsonObject.NULL) {
            if (!cls.isPrimitive()) {
                return ObjectMatch.NULL;
            }
            throw new SerializationException("can't assign null primitive");
        }
        ISerializer s = this.getSerializer(cls, json.getClass());
        if (s != null) {
            return s.tryUnmarshall(state, cls, json);
        }
        throw new SerializationException("no match");
    }

    public Object unmarshall(SerializerState state, Class clazz, Object json, IRequestValidator validator) throws SerializationException {
        Class cls = clazz;
        if (cls != null && json instanceof JsonObject && ((JsonObject)json).has("javaClass") && cls.isAssignableFrom(this.getClassFromHint(json))) {
            cls = this.getClassFromHint(json);
        }
        if (cls == null) {
            cls = this.getClassFromHint(json);
        }
        if (cls == null) {
            throw new SerializationException("no class hint");
        }
        if (json == null || json == JsonObject.NULL) {
            if (!cls.isPrimitive()) {
                return null;
            }
            throw new SerializationException("can't assign null primitive");
        }
        ISerializer s = this.getSerializer(cls, json.getClass());
        if (s != null) {
            return s.unmarshall(state, cls, json);
        }
        throw new SerializationException("can't unmarshall");
    }

    public Object unmarshall(SerializerState state, Class clazz, Object json) throws SerializationException {
        return this.unmarshall(state, clazz, json, null);
    }

    public Object unmarshall(SerializerState state, Class clazz, Type type, Object json, IRequestValidator validator) throws SerializationException {
        if (type != null && json instanceof JsonObject && ((JsonObject)json).has("javaClass") && clazz.isAssignableFrom(this.getClassFromHint(json))) {
            type = this.getClassFromHint(json);
        }
        if (type == null) {
            type = this.getClassFromHint(json);
        }
        if (type == null) {
            throw new SerializationException("no class hint");
        }
        if (json == null || json == JsonObject.NULL) {
            if (!type.getClass().isPrimitive()) {
                return null;
            }
            throw new SerializationException("can't assign null primitive");
        }
        ISerializer s = this.getSerializer(clazz, json.getClass());
        if (s != null) {
            if (s instanceof ListSerializer) {
                return ((ListSerializer)s).unmarshall(state, clazz, type, json);
            }
            return s.unmarshall(state, clazz, json);
        }
        throw new SerializationException("can't unmarshall");
    }

    public Object unmarshall(SerializerState state, Class clazz, Type type, Object json) throws SerializationException {
        return this.unmarshall(state, clazz, type, json, null);
    }

    public Object marshall(SerializerState state, Object o) throws SerializationException {
        if (o == null) {
            return JsonObject.NULL;
        }
        ISerializer s = this.getSerializer(o.getClass(), null);
        if (s != null) {
            return s.marshall(state, o);
        }
        throw new SerializationException("can't marshall " + o.getClass().getName());
    }

    public String toJSON(Object o) throws SerializationException {
        SerializerState state = new SerializerState();
        Object json = this.marshall(state, o);
        return json.toString();
    }

    public Object fromJSON(String s, Class aClass, IRequestValidator validator) throws SerializationException {
        Object json;
        JsonTokener tok = new JsonTokener(s);
        try {
            json = tok.nextValue();
        }
        catch (ParseException parseException) {
            throw new SerializationException("couldn't parse JSON");
        }
        SerializerState state = new SerializerState();
        state.setValidator(validator);
        return this.unmarshall(state, aClass, json, validator);
    }

    public Object fromJSON(String s, Class aClass) throws SerializationException {
        return this.fromJSON(s, aClass, null);
    }

    public Object fromJSON(String s) throws SerializationException {
        return this.fromJSON(s, null);
    }

    public boolean getMarshallNullAttributes() {
        return this.m_marshallNullAttributes;
    }

    public void setMarshallNullAttributes(boolean marshallNullAttributes) {
        this.m_marshallNullAttributes = marshallNullAttributes;
    }

    private static class Registry {
        private final Set<ISerializer> m_serializerSet;
        private final Map<Class, ISerializer> m_serializableMap;
        private final List<ISerializer> m_serializerList;

        Registry() {
            this.m_serializerSet = new HashSet<ISerializer>();
            this.m_serializableMap = new HashMap<Class, ISerializer>();
            this.m_serializerList = new ArrayList<ISerializer>();
        }

        Registry(Registry prev) {
            this.m_serializerSet = new HashSet<ISerializer>(prev.m_serializerSet);
            this.m_serializableMap = new HashMap<Class, ISerializer>(prev.m_serializableMap);
            this.m_serializerList = new ArrayList<ISerializer>(prev.m_serializerList);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static void registerSerializer(ISerializer s, JsonRpcSerializer jrs) throws SerializationException {
            Class<?>[] classes = s.getSerializableClasses();
            JsonRpcSerializer jsonRpcSerializer = jrs;
            synchronized (jsonRpcSerializer) {
                Registry registry = jrs.m_registry;
                int i = 0;
                while (i < classes.length) {
                    ISerializer exists = registry.m_serializableMap.get(classes[i]);
                    if (exists != null && exists.getClass() != s.getClass()) {
                        throw new SerializationException("different serializer already registered for " + classes[i].getName());
                    }
                    ++i;
                }
                if (!registry.m_serializerSet.contains(s)) {
                    Registry copy = new Registry(registry);
                    int i2 = 0;
                    while (i2 < classes.length) {
                        copy.m_serializableMap.put(classes[i2], s);
                        ++i2;
                    }
                    s.setOwner(jrs);
                    copy.m_serializerSet.add(s);
                    copy.m_serializerList.add(0, s);
                    jrs.m_registry = copy;
                }
            }
        }

        ISerializer getSerializer(Class clazz, Class jsoClazz) {
            ISerializer s = this.m_serializableMap.get(clazz);
            if (s == null && Map.class.isAssignableFrom(clazz)) {
                s = this.m_serializableMap.get(Map.class);
            }
            if (s == null && List.class.isAssignableFrom(clazz)) {
                s = this.m_serializableMap.get(List.class);
            }
            if (s != null && s.canSerialize(clazz, jsoClazz)) {
                return s;
            }
            for (ISerializer is : this.m_serializerList) {
                if (!is.canSerialize(clazz, jsoClazz)) continue;
                return is;
            }
            return null;
        }
    }
}

