/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.vjo.loader;

import java.io.IOException;
import java.net.URL;
import org.eclipse.vjet.dsf.common.resource.ResourceUtil;
import org.eclipse.vjet.vjo.loader.VjUrl;

public class VjResolver {
    private static final String SCHEME_TYPE = "type";
    private static final String SCHEME_FILE = "file";
    private static final String SCHEME_HTTP = "http";
    private static boolean s_verbose = false;

    public VjUrl resolve(String identifier, VjUrl parentUrl) {
        VjUrl vjUrl;
        if (identifier == null) {
            throw new RuntimeException("identifier cannot be null");
        }
        if (s_verbose) {
            System.out.println("Resolving: " + identifier);
        }
        if ((vjUrl = this.toVjUrl(identifier, parentUrl)) == null) {
            return null;
        }
        if (SCHEME_TYPE.equals(vjUrl.getScheme())) {
            this.resolveType(vjUrl);
        } else if (SCHEME_FILE.equals(vjUrl.getScheme())) {
            this.resolveFile(vjUrl);
        }
        if (s_verbose) {
            System.out.println("... url = " + vjUrl.getExternalForm());
        }
        return vjUrl;
    }

    protected void resolveType(VjUrl vjUrl) {
        String path = vjUrl.getPath();
        if (path.endsWith(".js")) {
            path = path.substring(0, path.length() - 3);
        }
        path = String.valueOf(path.replace(".", "/")) + ".js";
        if (s_verbose) {
            System.out.println("... path = " + path);
        }
        vjUrl.setPath(path);
        URL sourceUrl = null;
        do {
            int index = path.lastIndexOf("/");
            String resourceName = path;
            String relDir = "";
            if (index > 0) {
                relDir = path.substring(0, index);
                resourceName = path.substring(index + 1);
            }
            try {
                if (s_verbose) {
                    System.out.println("... relDir = " + relDir);
                    System.out.println("... resourceName = " + resourceName);
                }
                if ((sourceUrl = ResourceUtil.getResource((String)relDir, (String)resourceName)) == null) continue;
                vjUrl.setScheme(SCHEME_FILE).setRelativePath(relDir).setResourceName(resourceName);
            }
            catch (IOException iOException) {}
        } while (sourceUrl == null && (path = VjResolver.getContainer(path)) != null);
        if (sourceUrl != null) {
            if (vjUrl.getScheme() != null) {
                vjUrl.setScheme(SCHEME_TYPE);
            }
            vjUrl.setExternalForm(sourceUrl.toExternalForm());
        }
    }

    protected void resolveFile(VjUrl vjUrl) {
        String path = vjUrl.getPath();
        if (path == null) {
            return;
        }
        if (!path.endsWith(".js")) {
            path = String.valueOf(path) + ".js";
            vjUrl.setPath(path);
        }
        int index = path.lastIndexOf("/");
        String resourceName = path;
        String relDir = "";
        if (index > 0) {
            relDir = path.substring(0, index);
            resourceName = path.substring(index + 1);
        }
        if (s_verbose) {
            System.out.println("... relDir = " + relDir);
            System.out.println("... resourceName = " + resourceName);
        }
        try {
            URL resourceUrl = ResourceUtil.getResource((String)relDir, (String)resourceName);
            if (resourceUrl != null) {
                vjUrl.setRelativePath(relDir).setResourceName(resourceName).setExternalForm(resourceUrl.toExternalForm());
            }
        }
        catch (IOException iOException) {}
    }

    private VjUrl toVjUrl(String identifier, VjUrl parentUrl) {
        String remaining;
        VjUrl vjUrl = new VjUrl();
        String scheme = this.extractScheme(identifier);
        if (s_verbose) {
            System.out.println("... scheme = " + scheme);
        }
        vjUrl.setScheme(scheme);
        int index = identifier.indexOf(":");
        String string = remaining = index < 0 ? identifier : identifier.substring(index + 1);
        if (s_verbose) {
            System.out.println("... remaining = " + remaining);
        }
        if (SCHEME_TYPE.equals(scheme)) {
            vjUrl.setPath(remaining);
        } else if (SCHEME_FILE.equals(scheme)) {
            String path = remaining;
            if (path.startsWith("///")) {
                path = identifier.substring(3);
            } else if (path.startsWith("/")) {
                path = identifier.substring(1);
            } else if (path.startsWith("./")) {
                String parentPath = this.getParentPath(parentUrl);
                if (parentPath == null) {
                    return null;
                }
                path = String.valueOf(parentPath) + path.substring(1);
            } else if (path.startsWith("../")) {
                String parentPath = this.getParentPath(parentUrl);
                if (parentPath == null) {
                    return null;
                }
                index = parentPath.lastIndexOf("/");
                path = index > 0 ? String.valueOf(parentPath.substring(0, index)) + path.substring(2) : path.substring(3);
            }
            vjUrl.setPath(path);
        }
        if (s_verbose) {
            System.out.println("... path = " + vjUrl.getPath());
        }
        return vjUrl;
    }

    private String extractScheme(String identifier) {
        if (identifier.startsWith(SCHEME_FILE)) {
            return SCHEME_FILE;
        }
        if (identifier.startsWith(SCHEME_HTTP)) {
            return SCHEME_HTTP;
        }
        if (identifier.startsWith(SCHEME_TYPE)) {
            return SCHEME_TYPE;
        }
        if (!identifier.contains(":")) {
            if (identifier.startsWith("./") || identifier.startsWith("..")) {
                return SCHEME_FILE;
            }
            return SCHEME_TYPE;
        }
        throw new RuntimeException("Non-supported scheme: " + identifier);
    }

    private String getParentPath(VjUrl parentUrl) {
        if (s_verbose) {
            System.out.println("... parentUrl = " + (parentUrl == null ? null : parentUrl.getExternalForm()));
        }
        if (parentUrl == null || parentUrl.getPath() == null) {
            return null;
        }
        String parentPath = parentUrl.getPath();
        int index = parentPath.lastIndexOf("/");
        if (index > 0) {
            parentPath = parentPath.substring(0, index);
        }
        return parentPath;
    }

    private static String getContainer(String identifier) {
        String[] parts = identifier.split("\\.");
        int len = parts.length;
        if (len <= 1 || parts[len - 2].toLowerCase().equals(parts[len - 2])) {
            return null;
        }
        String clz = parts[0];
        int i = 1;
        while (i < len - 1) {
            clz = String.valueOf(clz) + "." + parts[i];
            ++i;
        }
        return clz;
    }
}

