/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.vjo.runner;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import org.eclipse.vjet.dsf.active.client.AWindow;
import org.eclipse.vjet.dsf.dap.rt.BodyOnloadAdapter;
import org.eclipse.vjet.dsf.dap.rt.DapCtx;
import org.eclipse.vjet.dsf.jsrunner.BrowserRemoteLauncher;
import org.eclipse.vjet.dsf.jsrunner.IBrowserLauncher;
import org.eclipse.vjet.dsf.jsrunner.JsRunner;
import org.eclipse.vjet.dsf.util.JavaSourceLocator;
import org.eclipse.vjet.vjo.VjBootstrapJsr;
import org.eclipse.vjet.vjo.jsunit.JsUnitFailure;
import org.eclipse.vjet.vjo.jsunit.VjoJsUnit;
import org.eclipse.vjet.vjo.loader.VjoConsole;
import org.eclipse.vjet.vjo.loader.VjoLoader;
import org.mozilla.mod.javascript.Scriptable;
import org.mozilla.mod.javascript.ScriptableObject;

public class VjoRunner
extends JsRunner {
    public static void main(String[] args) {
        try {
            JsRunner.ProgramInfo info = VjoRunner.getProgramInfo((String[])args);
            if ("A".equals(info.getOption("dapMode"))) {
                DapCtx.ctx().setExeMode(DapCtx.ExeMode.ACTIVE);
            }
            BrowserRemoteLauncher browserLauncher = null;
            String browserServiceUrl = info.getBrowserServiceUrl();
            if (browserServiceUrl != null) {
                browserLauncher = new BrowserRemoteLauncher(browserServiceUrl);
            }
            VjoRunner runner = new VjoRunner(info, VjoRunner.needDebug(), (IBrowserLauncher)browserLauncher);
            if (runner.m_activeWeb != null) {
                runner.m_activeWeb.waitForWindowLoaded();
                runner.m_activeWeb.waitForExit();
                runner.m_activeWeb.destroy();
                return;
            }
            VjoJsUnit jsUnit = new VjoJsUnit();
            runner.enableJsUnit(jsUnit);
            runner.complete();
            List<JsUnitFailure> failures = jsUnit.getFailures();
            for (JsUnitFailure failure : failures) {
                System.err.println(failure.toString());
            }
        }
        catch (MalformedURLException malformedURLException) {
            System.err.println("Provided  JS File path is not correct : " + args[0]);
        }
    }

    public VjoRunner(JsRunner.ProgramInfo info, boolean debug) {
        this(info, debug, null);
    }

    public VjoRunner(JsRunner.ProgramInfo info, boolean debug, IBrowserLauncher launcher) {
        super(info, debug, launcher);
        if (this.m_activeWeb != null) {
            return;
        }
        this.enableVjo();
        if (debug) {
            this.loadDescriptForDebug();
        }
    }

    private void loadDescriptForDebug() {
        Scriptable vjo = (Scriptable)ScriptableObject.getProperty((Scriptable)this.m_scope, (String)"vjo");
        Scriptable loader = (Scriptable)ScriptableObject.getProperty((Scriptable)vjo, (String)"loader");
        if (loader instanceof VjoLoader) {
            ((VjoLoader)loader).load("org.eclipse.vjet.vjo.runner.DescriptUtils");
        }
    }

    public void enableJsUnit(VjoJsUnit jsUnit) {
        jsUnit.attach(this.m_cx, this.m_scope);
    }

    public void loadHtml(String htmlFile) {
        super.loadHtml(htmlFile);
        BodyOnloadAdapter.fireOnload((AWindow)this.m_window);
    }

    public void loadHtml(URL url) {
        super.loadHtml(url);
        BodyOnloadAdapter.fireOnload((AWindow)this.m_window);
    }

    private void enableVjo() {
        URL sourceUrl = null;
        try {
            sourceUrl = JavaSourceLocator.getInstance().getSourceUrl(VjBootstrapJsr.getSourceUri(), ".js");
        }
        catch (Throwable throwable) {}
        if (sourceUrl == null) {
            sourceUrl = VjBootstrapJsr.getJsAsUrl();
        }
        this.runScript(sourceUrl);
        VjoLoader.enable(this.m_cx, this.m_scope);
        VjoConsole.enable(this.m_cx, this.m_scope);
    }

    protected JsRunner.ActiveWebListener createWebListener(boolean debugEnabled) {
        return new VjoActiveWebListener(debugEnabled);
    }

    protected class VjoActiveWebListener
    extends JsRunner.ActiveWebListener {
        public VjoActiveWebListener(boolean debugEnabled) {
            super((JsRunner)VjoRunner.this, debugEnabled);
        }

        public void windowOnload() {
            this.init();
            VjoRunner.this.enableVjo();
            if (this.m_debugEnabled) {
                VjoRunner.this.loadDescriptForDebug();
            }
            VjoJsUnit jsUnit = new VjoJsUnit();
            VjoRunner.this.enableJsUnit(jsUnit);
            this.execJs();
            List<JsUnitFailure> failures = jsUnit.getFailures();
            for (JsUnitFailure failure : failures) {
                System.err.println(failure.toString());
            }
        }
    }
}

