/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.vsf.aggregator.js;

import org.eclipse.vjet.dsf.dom.DDocument;
import org.eclipse.vjet.dsf.html.dom.DHtmlDocument;
import org.eclipse.vjet.dsf.resource.slot.JsResourceSlotAssignment;
import org.eclipse.vjet.dsf.resource.slot.JsResourceSlotter;
import org.eclipse.vjet.dsf.resource.slot.simple.SimpleJsResourceSlotter;
import org.eclipse.vjet.dsf.spec.view.IViewSpec;
import org.eclipse.vjet.vjo.bootstrap.VjBootstrap;
import org.eclipse.vjet.vsf.EventDispatcherJsr;
import org.eclipse.vjet.vsf.FirePageLoadJsr;
import org.eclipse.vjet.vsf.ServiceEngineJsr;
import org.eclipse.vjet.vsf.aggregator.cache.JsSystemLibCache;
import org.eclipse.vjet.vsf.aggregator.event.export.EventDispatcherAssembler;
import org.eclipse.vjet.vsf.aggregator.event.export.IEventDispatcherAssembler;
import org.eclipse.vjet.vsf.aggregator.js.BaseJsProcessor;
import org.eclipse.vjet.vsf.aggregator.js.JsResourceApplier;
import org.eclipse.vjet.vsf.assembly.VjClientAssemblerJsr;
import org.eclipse.vjet.vsf.docprocessing.IJsResourceApplier;
import org.eclipse.vjet.vsf.error.DefaultErrorHandlerJsr;
import org.eclipse.vjet.vsf.error.ErrorHandlerManagerJsr;
import vjo.RegistryJsr;

public class JsProcessor
extends BaseJsProcessor {
    private IEventDispatcherAssembler m_evtDispatcherAssembler = EventDispatcherAssembler.getInstance();
    private boolean m_processEventsAndServices = true;

    public JsProcessor() {
    }

    public JsProcessor(JsResourceSlotter slotter, IJsResourceApplier applier, JsSystemLibCache libCache) {
        this(slotter, applier, libCache, true);
    }

    public JsProcessor(JsResourceSlotter slotter, IJsResourceApplier applier, JsSystemLibCache libCache, boolean processEventsAndServices) {
        super(slotter, applier, libCache, processEventsAndServices);
        this.m_processEventsAndServices = processEventsAndServices;
    }

    public IEventDispatcherAssembler getEvtDispatcherAssembler() {
        return this.m_evtDispatcherAssembler;
    }

    public void setEvtDispatcherAssembler(IEventDispatcherAssembler dispatcherAssembler) {
        this.m_evtDispatcherAssembler = dispatcherAssembler;
    }

    @Override
    public JsResourceSlotAssignment createAssignment() {
        return JsProcessor.createDefaultAssignment();
    }

    public static JsResourceSlotAssignment createDefaultAssignment() {
        JsResourceSlotAssignment assignment = new JsResourceSlotAssignment();
        JsProcessor.assignJsSlot(assignment, VjBootstrap.ResourceSpec.getInstance(), "BEFORE_ANY_HTML_RENDER");
        JsProcessor.assignJsSlot(assignment, DefaultErrorHandlerJsr.ResourceSpec.getInstance(), "BEFORE_ANY_HTML_RENDER");
        JsProcessor.assignJsSlot(assignment, ErrorHandlerManagerJsr.ResourceSpec.getInstance(), "BEFORE_ANY_HTML_RENDER");
        JsProcessor.assignJsSlot(assignment, "_ERROR_", "BEFORE_ANY_HTML_RENDER");
        JsProcessor.assignJsSlot(assignment, EventDispatcherJsr.ResourceSpec.getInstance(), "BEFORE_ANY_HTML_RENDER");
        JsProcessor.assignJsSlot(assignment, RegistryJsr.ResourceSpec.getInstance(), "BEFORE_ANY_HTML_RENDER");
        JsProcessor.assignJsSlot(assignment, ServiceEngineJsr.ResourceSpec.getInstance(), "BEFORE_ANY_HTML_RENDER");
        JsProcessor.assignJsSlot(assignment, VjClientAssemblerJsr.ResourceSpec.getInstance(), "BEFORE_ANY_HTML_RENDER");
        JsProcessor.assignJsSlot(assignment, FirePageLoadJsr.ResourceSpec.getInstance(), "AFTER_ANY_HTML_RENDER");
        return assignment;
    }

    public static JsResourceSlotter createDefaultSlotter() {
        SimpleJsResourceSlotter slotter = new SimpleJsResourceSlotter(false);
        slotter.addSlotAssignment(JsProcessor.createDefaultAssignment());
        return slotter;
    }

    public static IJsResourceApplier createDefaultApplier() {
        return new JsResourceApplier();
    }

    @Override
    protected void aggragateJs(DDocument doc, IViewSpec viewSpec) {
        super.aggragateJs(doc, viewSpec);
        if (this.m_processEventsAndServices) {
            this.processEvents((DHtmlDocument)doc);
        }
    }

    private void processEvents(DHtmlDocument doc) {
        this.m_evtDispatcherAssembler.processEventHandling(doc.getBody(), this.m_slotter);
    }
}

