/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.vsf.aggregator.view;

import java.util.Map;
import java.util.Set;
import org.eclipse.vjet.dsf.common.context.DsfCtx;
import org.eclipse.vjet.dsf.common.context.IdGenerator;
import org.eclipse.vjet.dsf.common.trace.DataModelCtx;
import org.eclipse.vjet.dsf.common.trace.TraceCtx;
import org.eclipse.vjet.dsf.common.utils.DataModelHelper;
import org.eclipse.vjet.dsf.dom.DDocument;
import org.eclipse.vjet.dsf.dom.DElement;
import org.eclipse.vjet.dsf.dom.DNode;
import org.eclipse.vjet.dsf.html.ctx.HtmlCtx;
import org.eclipse.vjet.dsf.html.dom.DDiv;
import org.eclipse.vjet.dsf.html.dom.DForm;
import org.eclipse.vjet.dsf.html.dom.DH3;
import org.eclipse.vjet.dsf.html.dom.DHead;
import org.eclipse.vjet.dsf.html.dom.DHtmlDocument;
import org.eclipse.vjet.dsf.html.dom.DMeta;
import org.eclipse.vjet.dsf.html.dom.DScript;
import org.eclipse.vjet.dsf.html.dom.DSpan;
import org.eclipse.vjet.dsf.html.dom.DTable;
import org.eclipse.vjet.dsf.html.dom.DTd;
import org.eclipse.vjet.dsf.html.dom.DTextArea;
import org.eclipse.vjet.dsf.html.dom.DTr;
import org.eclipse.vjet.dsf.resource.slot.JsResourceSlotter;
import org.eclipse.vjet.dsf.resource.trace.ContentUsageTracer;
import org.eclipse.vjet.dsf.resource.trace.HtmlResourceUsageTracer;
import org.eclipse.vjet.dsf.resource.trace.IResourceUsageTracer;
import org.eclipse.vjet.dsf.resource.trace.ResourceUsageCtx;
import org.eclipse.vjet.dsf.spec.app.IDocAnnotationData;
import org.eclipse.vjet.vsf.FirePageLoadJsr;
import org.eclipse.vjet.vsf.aggregator.js.JsProcessor;
import org.eclipse.vjet.vsf.aggregator.js.JsProcessorUtils;
import org.eclipse.vjet.vsf.aggregator.js.error.DefaultErrorHandler;
import org.eclipse.vjet.vsf.docprocessing.BaseDocProcessor;
import org.eclipse.vjet.vsf.docprocessing.IJsProcessor;
import org.eclipse.vjet.vsf.docprocessing.IProductionPlan;
import org.eclipse.vjet.vsf.jsref.ctx.ResourceCtx;
import org.eclipse.vjet.vsf.jsruntime.context.JsRuntimeCtx;
import org.eclipse.vjet.vsf.jsruntime.error.IErrorHandler;
import org.eclipse.vjet.vsf.resource.js.trace.SimpleResourceUsageTracer;
import org.eclipse.vjet.vsf.resource.pattern.js.JsResource;
import org.w3c.dom.Node;

public class DocProcessor
extends BaseDocProcessor {
    public DocProcessor(IProductionPlan plan) {
        super(plan);
        int size;
        if (this.m_plan.getJsSlotter() == null) {
            this.m_plan.setJsSlotter(JsProcessor.createDefaultSlotter());
        }
        JsResourceSlotter jsSlotter = this.m_plan.getJsSlotter();
        if (JsRuntimeCtx.ctx().addErrorHandling()) {
            JsRuntimeCtx.ctx().addErrorHandler((IErrorHandler)new DefaultErrorHandler(), 0);
            JsProcessorUtils.addJsErrorHandling(jsSlotter);
            JsProcessorUtils.enableWindowOnError(jsSlotter, JsRuntimeCtx.ctx().hideJsErrors(), JsRuntimeCtx.ctx().isCaptureJsErrorStackTrace());
        }
        if ((size = HtmlCtx.ctx().getEventHandlerContainer().size()) > 0) {
            ResourceCtx.ctx().register(FirePageLoadJsr.ResourceSpec.getInstance());
        }
    }

    protected IJsProcessor createJsProcessor() {
        return new JsProcessor(this.m_plan.getJsSlotter(), this.m_plan.getJsApplier(), this.m_plan.getJsSystemLibCache(), this.m_plan.isProcessEventsAndServices());
    }

    public void process(DHtmlDocument doc) {
        super.process((DDocument)doc);
        IResourceUsageTracer usageTracer = ResourceUsageCtx.ctx().getTracer();
        if (usageTracer instanceof SimpleResourceUsageTracer) {
            DocProcessor.addUsageInfoToHtml(doc, (SimpleResourceUsageTracer)usageTracer);
        }
        if (TraceCtx.ctx().haveInstrumenter()) {
            DocProcessor.addDataModelToDOM(doc);
        }
    }

    protected static void addUsageInfoToHtml(DHtmlDocument doc, SimpleResourceUsageTracer tracer) {
        Node finalNode = doc.getBody().getLastChild().getParentNode();
        DH3 h3 = new DH3("Resources Used by Page");
        finalNode.appendChild((Node)h3);
        DDiv lastNode = new DDiv("tabber");
        finalNode.appendChild((Node)lastNode);
        if (tracer.getJsList().size() > 0) {
            DDiv js = DocProcessor.createResourceTab("Javascript");
            lastNode.add((DNode)js);
            DocProcessor.generateJsUsed(tracer, js);
        }
    }

    protected static void addHtmlUsageInfoToDOM(DHtmlDocument doc, HtmlResourceUsageTracer tracer) {
        Node finalNode = doc.getBody().getLastChild().getParentNode();
        if (tracer.getHtmlTraceMap().size() > 0) {
            String[] localList = new String[tracer.getHtmlTraceMap().size()];
            for (Object key : tracer.getHtmlTraceMap().keySet()) {
                localList[((Integer)tracer.getHtmlTraceMap().get(key)).intValue()] = (String)key;
            }
            StringBuffer sbuf = new StringBuffer("var spyglassTracebackTbl = [ ");
            String[] stringArray = localList;
            int n = localList.length;
            int n2 = 0;
            while (n2 < n) {
                String trace = stringArray[n2];
                sbuf.append("\"").append(trace).append("\",\n");
                ++n2;
            }
            sbuf.append("\"\" ]");
            DScript jsonDs = new DScript();
            jsonDs.add(sbuf.toString());
            finalNode.appendChild((Node)jsonDs);
        }
    }

    protected static void addDataModelToDOM(DHtmlDocument doc) {
        Node finalNode = doc.getBody().getLastChild().getParentNode();
        DSpan span = new DSpan();
        finalNode.appendChild((Node)span);
        span.setHtmlStyleAsString("display:none");
        span.setHtmlId("spydatamodelspan");
        DataModelCtx ctx = DataModelCtx.getCtx();
        Map map = ctx.getComponentModelMap();
        for (DNode node : map.keySet()) {
            DataModelHelper helper;
            String xmlDataModel;
            Object model;
            if (!(node instanceof DElement) || (model = map.get(node)) == null || (xmlDataModel = (helper = DataModelHelper.getInstance()).getDataModelAsXml(node, true)) == null) continue;
            DsfCtx dsfCtx = DsfCtx.ctx();
            IdGenerator idGenerator = dsfCtx.ids();
            String id = idGenerator.nextHtmlId();
            ((DElement)node).setAttribute("spydatamodelid", id);
            DForm form = new DForm();
            span.add((DNode)form);
            form.setHtmlId(id);
            form.setAttribute("target", "_blank");
            form.setAttribute("method", "POST");
            form.setAttribute("action", "http://localhost:9090/v4plugin/getxml");
            DTextArea ta = new DTextArea();
            form.add((DNode)ta);
            ta.setHtmlName("datamodelxmlstr");
            ta.setTextContent(xmlDataModel);
        }
    }

    protected void addContentUsageInfoToDOM(DHtmlDocument doc, ContentUsageTracer tracer) {
        Node finalNode = doc.getBody().getLastChild().getParentNode();
        if (tracer.getContentTraceMap().size() <= 0) {
            return;
        }
        DScript jsonDs = new DScript();
        jsonDs.setAttribute("id", "SpyglassTracebackTbl");
        finalNode.appendChild((Node)jsonDs);
    }

    private static void generateJsUsed(SimpleResourceUsageTracer tracer, DDiv outer) {
        DTable table = new DTable();
        table.setHtmlBorder("1");
        outer.add((DNode)table);
        for (JsResource resource : tracer.getJsList()) {
            if (resource.getUrn().indexOf("VjSpyglass") > 0) continue;
            DTr rows = new DTr();
            table.add((DNode)rows);
            DTd td1s = new DTd();
            rows.add((DNode)td1s);
            td1s.add(resource.getUrn());
            Set dispensers = tracer.getDispensers(resource);
            if (dispensers == null) continue;
            DTd td2s = new DTd();
            rows.add((DNode)td2s);
            for (Class clz : dispensers) {
                td2s.add(clz.getName());
                td2s.addBr();
            }
        }
    }

    private static DDiv createResourceTab(String title) {
        DDiv tabDiv = new DDiv("tabbertab");
        tabDiv.setHtmlTitle(title);
        DTable table = new DTable();
        table.setHtmlStyleAsString("border: solid 1px black");
        tabDiv.add((DNode)table);
        return tabDiv;
    }

    protected void processDocAnnotation(DDocument ddoc) {
        IDocAnnotationData annotation = this.m_plan.getDocAnnotation();
        DHtmlDocument doc = (DHtmlDocument)ddoc;
        if (annotation == null) {
            return;
        }
        if (doc.getDoctype() == null) {
            doc.setDocType(annotation.getDocType());
        }
        if (annotation.getContentType() == null || annotation.getContentType().length() <= 0) {
            return;
        }
        DHead head = doc.getHead();
        DMeta content = new DMeta();
        String charset = annotation.getCharset() == null ? "ISO-8859-1" : annotation.getCharset();
        content.setHtmlHttpEquiv("Content-Type");
        content.setHtmlContent(String.valueOf(annotation.getContentType()) + "; charset=" + charset);
        head.insertBefore((Node)content, head.getFirstChild());
    }
}

