/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.vsf.resource.pattern.js.resolution;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.eclipse.vjet.dsf.common.exceptions.DsfRuntimeException;
import org.eclipse.vjet.dsf.html.js.ActiveJsExecutionControlCtx;
import org.eclipse.vjet.dsf.resource.exception.ResourceNotFoundRuntimeException;
import org.eclipse.vjet.dsf.resource.trace.ResourceUsageCtx;
import org.eclipse.vjet.dsf.resource.utils.ResourceHelper;
import org.eclipse.vjet.vsf.resource.pattern.js.IJsResourceHandle;
import org.eclipse.vjet.vsf.resource.pattern.js.JsResRtCfg;
import org.eclipse.vjet.vsf.resource.pattern.js.resolution.IJsResourceKey;
import org.eclipse.vjet.vsf.resource.pattern.js.resolution.IJsResourceResolver;

public class DefaultJsResourceHandle
implements IJsResourceHandle {
    public static final String CLEAR_JAVA_JS_TEXT_CACHE = "CLEAR_JAVA_JS_TEXT_CACHE";
    private final IJsResourceKey m_key;

    public DefaultJsResourceHandle(IJsResourceKey key) {
        this.assertNotNull(key, "Resource key must not be null");
        this.m_key = key;
    }

    @Override
    public URL getExternalUrl() {
        return this.getResolver().getUrl(this.m_key);
    }

    private IJsResourceResolver getResolver() {
        String resourceGroupId = this.m_key.getResourceGroupId();
        IJsResourceResolver resolver = JsResRtCfg.getInstance().getJsResourceResolver(resourceGroupId);
        this.assertNotNull(resolver, "Resolver must not be null");
        return resolver;
    }

    @Override
    public boolean isExternalized() {
        return false;
    }

    @Override
    public String getScriptText() {
        URL url = this.getResolver().getUrl(this.m_key);
        String text = null;
        if (url == null) {
            throw new ResourceNotFoundRuntimeException("unable to get URL for '" + this.toString() + "'");
        }
        ActiveJsExecutionControlCtx jsControlCtx = ActiveJsExecutionControlCtx.ctx();
        if (jsControlCtx.needExecuteJavaScript() && jsControlCtx.needDebug()) {
            return "//ACTIVE_JS_SRC:[" + url.toExternalForm() + "]";
        }
        try {
            text = JsTextCache.getText(url);
        }
        catch (URISyntaxException uRISyntaxException) {}
        return text;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("AnchorClass:" + this.m_key.getAnchorClass()).append(" | ").append("Resource Name:" + this.m_key.getResourceName()).append(" | ").append("Permutation:" + this.m_key.getPermutation()).append(" | ").append("External URL:" + this.getExternalUrl()).append(" | ").append("Class name:" + this.getResolver().getClass().getName());
        return sb.toString();
    }

    public static void clearCache() {
        JsTextCache.clear();
    }

    private void assertNotNull(Object o, String msg) {
        if (o == null) {
            throw new DsfRuntimeException(msg);
        }
    }

    private static class CacheEntry {
        private final String m_rawText;
        private String m_obfuscatedText;
        private int m_minVersion;

        CacheEntry(String rawText) {
            this.m_rawText = rawText.intern();
        }

        public String getRawText() {
            return this.m_rawText;
        }

        public String getObfuscatedText(URL url) {
            return this.m_rawText;
        }
    }

    private static class JsTextCache {
        private static volatile ConcurrentMap<URI, CacheEntry> s_cache = new ConcurrentHashMap<URI, CacheEntry>(100);

        private JsTextCache() {
        }

        static String getText(URL url) throws URISyntaxException {
            String rawText;
            CacheEntry old;
            CacheEntry entry;
            URI toURI = url.toURI();
            ResourceUsageCtx ctx = ResourceUsageCtx.ctx();
            if (ctx.isFragmentExtractionMode()) {
                ctx.registerObfuscationEvent();
                ctx.registerMinificationEvent();
            }
            if ((entry = (CacheEntry)s_cache.get(toURI)) == null && (old = s_cache.putIfAbsent(toURI, entry = new CacheEntry(rawText = ResourceHelper.getStringContent((URL)url)))) != null) {
                entry = old;
            }
            if (!ctx.isNeedVerboseInfo() && (ctx.isNeedObfuscation() || ctx.isNeedMinification())) {
                return entry.getObfuscatedText(url);
            }
            return entry.getRawText();
        }

        static void clear() {
            s_cache = new ConcurrentHashMap<URI, CacheEntry>(100);
        }

        private static class ClearCacheListener
        implements PropertyChangeListener {
            private ClearCacheListener() {
            }

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                JsTextCache.clear();
            }
        }
    }
}

