/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.serializer;

import java.util.Map;
import org.eclipse.vjet.dsf.common.context.DsfCtx;
import org.eclipse.vjet.dsf.json.serializer.SerializationException;
import org.eclipse.vjet.dsf.serializer.VjoMapSerializedResult;
import org.eclipse.vjet.dsf.serializer.VjoSerializableSerializer;
import org.eclipse.vjet.dsf.serializer.VjoSerializationCtx;

public class VjoMapSerializer
extends VjoSerializableSerializer {
    private String m_vjoMapUtil = "$mU";

    public String getVjoMapUtil() {
        return this.m_vjoMapUtil;
    }

    public VjoMapSerializer setVjoMapUtil(String util) {
        this.m_vjoMapUtil = util;
        return this;
    }

    @Override
    public boolean canSerialize(Object obj) {
        Class<?> type = obj.getClass();
        return Map.class.isAssignableFrom(type);
    }

    @Override
    protected void preSerialize(Object toSerialize) {
        super.preSerialize(toSerialize);
        VjoSerializationCtx.ctx().setHasVjoMap(true);
    }

    @Override
    public Object doSerialize(Object obj) throws SerializationException {
        VjoMapSerializedResult vjoMap = new VjoMapSerializedResult();
        vjoMap.setVjoId(DsfCtx.ctx().ids().nextJsCompId());
        vjoMap.setVjoMapUtil(this.getVjoMapUtil());
        Class<?> type = obj.getClass();
        if (Map.class.isAssignableFrom(type)) {
            Map map = (Map)obj;
            for (Map.Entry elem : map.entrySet()) {
                vjoMap.putVjoObject(this.getOwner().serialize(elem.getKey()), this.getOwner().serialize(elem.getValue()));
            }
        }
        return vjoMap;
    }
}

