/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.css.dom.impl;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import org.eclipse.vjet.dsf.css.dom.impl.DCssException;
import org.eclipse.vjet.dsf.css.parser.DCssBuilder;
import org.w3c.css.sac.InputSource;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSCharsetRule;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSStyleSheet;

public class DCssCharsetRule
implements CSSCharsetRule,
Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private CSSStyleSheet m_parentStyleSheet = null;
    private CSSRule m_parentRule = null;
    private String m_encoding = null;

    public DCssCharsetRule(CSSStyleSheet parentStyleSheet, CSSRule parentRule, String encoding) {
        this.m_parentStyleSheet = parentStyleSheet;
        this.m_parentRule = parentRule;
        this.m_encoding = encoding;
    }

    @Override
    public short getType() {
        return 2;
    }

    @Override
    public String getCssText() {
        return "@charset \"" + this.getEncoding() + "\";";
    }

    @Override
    public void setCssText(String cssText) throws DOMException {
        if (this.m_parentStyleSheet != null) {
            throw new DCssException(7, 2);
        }
        try {
            InputSource is = new InputSource((Reader)new StringReader(cssText));
            DCssBuilder parser = new DCssBuilder();
            CSSRule r = parser.parseRule(is);
            if (r.getType() != 2) {
                throw new DCssException(13, 5);
            }
            this.m_encoding = ((DCssCharsetRule)r).m_encoding;
        }
        catch (DCssException e) {
            throw new DCssException(12, 0, e.getMessage());
        }
        catch (IOException e) {
            throw new DCssException(12, 0, e.getMessage());
        }
    }

    @Override
    public CSSStyleSheet getParentStyleSheet() {
        return this.m_parentStyleSheet;
    }

    @Override
    public CSSRule getParentRule() {
        return this.m_parentRule;
    }

    @Override
    public String getEncoding() {
        return this.m_encoding;
    }

    @Override
    public void setEncoding(String encoding) throws DOMException {
        this.m_encoding = encoding;
    }

    public String toString() {
        return this.getCssText();
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

