/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.css.dom.impl;

import java.io.Serializable;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.dom.css.Counter;

public class DCssCounter
implements Counter,
Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private String m_identifier;
    private String m_listStyle;
    private String m_separator;

    public DCssCounter(boolean separatorSpecified, LexicalUnit lu) {
        LexicalUnit next = lu;
        this.m_identifier = next.getStringValue();
        next = next.getNextLexicalUnit();
        if (separatorSpecified && next != null) {
            next = next.getNextLexicalUnit();
            this.m_separator = next.getStringValue();
            next = next.getNextLexicalUnit();
        }
        if (next != null) {
            this.m_listStyle = next.getStringValue();
            next = next.getNextLexicalUnit();
        }
    }

    @Override
    public String getIdentifier() {
        return this.m_identifier;
    }

    @Override
    public String getListStyle() {
        return this.m_listStyle;
    }

    @Override
    public String getSeparator() {
        return this.m_separator;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.m_separator == null) {
            sb.append("counter(");
        } else {
            sb.append("counters(");
        }
        sb.append(this.m_identifier);
        if (this.m_separator != null) {
            sb.append(", \"").append(this.m_separator).append("\"");
        }
        if (this.m_listStyle != null) {
            sb.append(", ").append(this.m_listStyle);
        }
        sb.append(")");
        return sb.toString();
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

