/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.html.dom;

import org.eclipse.vjet.dsf.common.xml.IXmlStreamWriter;
import org.eclipse.vjet.dsf.dom.DElement;
import org.eclipse.vjet.dsf.html.IConditionalUsage;
import org.eclipse.vjet.dsf.html.dom.util.INodeEmitter;
import org.eclipse.vjet.dsf.html.dom.util.IRawSaxHandler;
import org.eclipse.vjet.dsf.html.dom.util.ISelfRender;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ConditionalElement
extends DElement
implements ISelfRender {
    private static final long serialVersionUID = 1L;
    private final IConditionalUsage.Condition m_condition;
    private final DElement m_rootElement;

    public ConditionalElement(IConditionalUsage.Condition condition, DElement rootElement) {
        super(null, "dummy");
        this.m_condition = condition;
        this.m_rootElement = rootElement;
    }

    public IConditionalUsage.Condition getCondition() {
        return this.m_condition;
    }

    public static StartConditionalComment startCondition(IConditionalUsage.Condition condition) {
        return new StartConditionalComment(condition);
    }

    public static EndConditionalComment endCondition(IConditionalUsage.Condition condition) {
        return new EndConditionalComment(condition);
    }

    public boolean render(IRawSaxHandler rawSaxHandler, IXmlStreamWriter xmlStreamWriter, INodeEmitter nodeEmitter) {
        boolean hasUnconditionalChild = this.hasChildNodes();
        xmlStreamWriter.writeRaw("<!--");
        xmlStreamWriter.writeRaw(this.m_condition.getBegin());
        if (!hasUnconditionalChild) {
            nodeEmitter.genEvents((Node)this.m_rootElement, xmlStreamWriter);
        } else {
            rawSaxHandler.startElement(this.m_rootElement);
            ConditionalElement.renderChildren(rawSaxHandler, xmlStreamWriter, nodeEmitter, this.m_rootElement);
            xmlStreamWriter.writeRaw(this.m_condition.getEnd());
            xmlStreamWriter.writeRaw("-->");
            ConditionalElement.renderChildren(rawSaxHandler, xmlStreamWriter, nodeEmitter, this);
            xmlStreamWriter.writeRaw("<!--");
            xmlStreamWriter.writeRaw(this.m_condition.getBegin());
            rawSaxHandler.endElement(this.m_rootElement);
        }
        xmlStreamWriter.writeRaw(this.m_condition.getEnd());
        xmlStreamWriter.writeRaw("-->");
        return true;
    }

    private static void renderChildren(IRawSaxHandler rawSaxHandler, IXmlStreamWriter xmlStreamWriter, INodeEmitter nodeEmitter, DElement element) {
        if (!element.hasChildNodes()) {
            return;
        }
        NodeList kids = element.getChildNodes();
        int len = kids.getLength();
        int i = 0;
        while (i < len) {
            Node childNode = kids.item(i);
            nodeEmitter.genEvents(childNode, xmlStreamWriter);
            ++i;
        }
    }

    public static class EndConditionalComment
    extends DElement
    implements ISelfRender {
        private static final long serialVersionUID = 1L;
        private final IConditionalUsage.Condition m_condition;

        public EndConditionalComment(IConditionalUsage.Condition condition) {
            super(null, "dummy");
            this.m_condition = condition;
        }

        public boolean render(IRawSaxHandler rawSaxHandler, IXmlStreamWriter xmlStreamWriter, INodeEmitter nodeEmitter) {
            xmlStreamWriter.writeRaw(this.m_condition.getEnd());
            xmlStreamWriter.writeRaw("-->");
            return true;
        }
    }

    public static class StartConditionalComment
    extends DElement
    implements ISelfRender {
        private static final long serialVersionUID = 1L;
        private final IConditionalUsage.Condition m_condition;

        public StartConditionalComment(IConditionalUsage.Condition condition) {
            super(null, "dummy");
            this.m_condition = condition;
        }

        public boolean render(IRawSaxHandler rawSaxHandler, IXmlStreamWriter xmlStreamWriter, INodeEmitter nodeEmitter) {
            xmlStreamWriter.writeRaw("<!--");
            xmlStreamWriter.writeRaw(this.m_condition.getBegin());
            return true;
        }
    }
}

