/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.html.dom;

import java.util.Iterator;
import org.eclipse.vjet.dsf.common.Z;
import org.eclipse.vjet.dsf.common.event.AbortDsfEventProcessingException;
import org.eclipse.vjet.dsf.common.event.DsfEvent;
import org.eclipse.vjet.dsf.common.node.IAttributeMap;
import org.eclipse.vjet.dsf.common.node.IDNodeRelationshipVerifier;
import org.eclipse.vjet.dsf.common.node.visitor.IDNodeVisitor;
import org.eclipse.vjet.dsf.common.xml.IXmlStreamWriter;
import org.eclipse.vjet.dsf.css.CssClassConstant;
import org.eclipse.vjet.dsf.css.CssIdConstant;
import org.eclipse.vjet.dsf.dom.DDocument;
import org.eclipse.vjet.dsf.dom.DDocumentType;
import org.eclipse.vjet.dsf.dom.DElement;
import org.eclipse.vjet.dsf.dom.DNode;
import org.eclipse.vjet.dsf.dom.DText;
import org.eclipse.vjet.dsf.dom.support.DNamespace;
import org.eclipse.vjet.dsf.html.dom.BaseOrigNonAttrs;
import org.eclipse.vjet.dsf.html.dom.DHtmlDocument;
import org.eclipse.vjet.dsf.html.dom.EHtmlAttr;
import org.eclipse.vjet.dsf.html.dom.HtmlTypeEnum;
import org.eclipse.vjet.dsf.html.dom.util.INodeEmitter;
import org.eclipse.vjet.dsf.html.dom.util.IRawSaxHandler;
import org.eclipse.vjet.dsf.html.dom.util.ISelfRender;
import org.eclipse.vjet.dsf.html.events.EventType;
import org.eclipse.vjet.dsf.html.events.ISimpleJsEventHandler;
import org.eclipse.vjet.dsf.html.js.IJsFunc;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.css.CSSStyleDeclaration;

public class DScript
extends BaseOrigNonAttrs
implements ISelfRender {
    private static final long serialVersionUID = 3832626162072498224L;
    private static final DScript s_script = new DScript();
    public static final String TYPE_TEXT_CSS = "text/css";
    public static final String TYPE_TEXT_JAVASCRIPT = "text/javascript";
    public static final String TYPE_TEXT_VBSCRIPT = "text/vbscript";
    public static final int DOCUMENT_LOCATION_HEAD = 0;
    public static final int DOCUMENT_LOCATION_BODY = 1;
    @Deprecated
    private int m_documentLocation;

    public DScript() {
        super(null, HtmlTypeEnum.SCRIPT);
        this.m_documentLocation = 0;
    }

    public DScript(DHtmlDocument doc) {
        super(doc, HtmlTypeEnum.SCRIPT);
    }

    public DScript(String text) {
        this();
        this.setHtmlText(text);
    }

    public DScript(String text, String type) {
        this();
        this.setHtmlText(text);
        this.setHtmlType(type);
    }

    public DScript(Class anchorClass, String resourceName) {
        this();
        this.setHtmlType(TYPE_TEXT_JAVASCRIPT);
        this.setHtmlSrc(anchorClass.getResource(resourceName).toExternalForm());
    }

    @Override
    public HtmlTypeEnum htmlType() {
        return HtmlTypeEnum.SCRIPT;
    }

    public boolean render(IRawSaxHandler rawSaxHandler, IXmlStreamWriter xmlStreamWriter, INodeEmitter nodeEmitter) {
        DDocument doc = this.getDsfOwnerDocument();
        if (doc == null || doc.getDoctype() == null) {
            rawSaxHandler.startElement((DElement)this);
            this.writeKids(xmlStreamWriter, nodeEmitter);
            rawSaxHandler.endElement((DElement)this);
            return true;
        }
        DDocumentType doctype = doc.getDoctype();
        boolean addCDATA = this.scriptRequiresCDATA(doctype);
        boolean isJavaScript = this.javascript();
        rawSaxHandler.startElement((DElement)this);
        if (addCDATA) {
            if (isJavaScript) {
                xmlStreamWriter.writeRaw("//");
            }
            xmlStreamWriter.writeRaw("<![CDATA[");
        }
        this.writeKids(xmlStreamWriter, nodeEmitter);
        if (addCDATA) {
            if (isJavaScript) {
                xmlStreamWriter.writeRaw("//");
            }
            xmlStreamWriter.writeRaw("]]>");
        }
        rawSaxHandler.endElement((DElement)this);
        return true;
    }

    private void writeKids(IXmlStreamWriter xmlStreamWriter, INodeEmitter nodeEmitter) {
        if (this.hasChildNodes()) {
            NodeList kids = this.getChildNodes();
            int len = kids.getLength();
            int i = 0;
            while (i < len) {
                Node kid = kids.item(i);
                nodeEmitter.genEvents(kid, xmlStreamWriter);
                ++i;
            }
        }
    }

    private void writeMyself(IRawSaxHandler rawSaxHandler, IXmlStreamWriter xmlStreamWriter) {
        rawSaxHandler.startElement((DElement)this);
    }

    private void writeAttributes(IXmlStreamWriter xmlStreamWriter) {
        if (!this.hasAttributes()) {
            return;
        }
        IAttributeMap attrs = this.getDsfAttributes();
        Iterator itr = attrs.keySet().iterator();
        while (itr.hasNext()) {
            String key;
            Object value = attrs.get((Object)(key = (String)itr.next()));
            xmlStreamWriter.writeAttribute(key, value == null ? "" : value.toString());
        }
    }

    private boolean scriptRequiresCDATA(DDocumentType doctype) {
        if (doctype == null) {
            return false;
        }
        String pubId = doctype.getPublicId();
        if (pubId.contains("-//W3C//DTD XHTML")) {
            return true;
        }
        if (pubId.contains("-//W3C//DTD XML")) {
            return true;
        }
        if (pubId.contains("-//W3C//DTD SVG")) {
            return true;
        }
        return pubId.contains("-//W3C//DTD MathML");
    }

    private boolean javascript() {
        return false;
    }

    @Deprecated
    public int getDocumentLocation() {
        return this.m_documentLocation;
    }

    @Deprecated
    public void setDocumentLocation(int location) {
        this.m_documentLocation = location;
    }

    public String getHtmlText() {
        StringBuilder text = new StringBuilder();
        Node child = this.getFirstChild();
        while (child != null) {
            if (child instanceof DText) {
                text.append(((DText)child).getData());
            }
            child = child.getNextSibling();
        }
        return text.toString();
    }

    public final DScript setHtmlText(String text) {
        Node child = this.getFirstChild();
        while (child != null) {
            Node next = child.getNextSibling();
            this.removeChild(child);
            child = next;
        }
        this.add(text);
        return this;
    }

    public String getHtmlCharset() {
        return this.getHtmlAttribute(EHtmlAttr.charset);
    }

    public DScript setHtmlCharset(String charset) {
        this.setHtmlAttribute(EHtmlAttr.charset, charset);
        return this;
    }

    public final boolean getHtmlDefer() {
        return this.getHtmlAttributeExists(EHtmlAttr.defer);
    }

    public DScript setHtmlDefer(String defer) {
        return this.setHtmlDefer(this.toBoolean("defer", defer));
    }

    public DScript setHtmlDefer(boolean defer) {
        this.setHtmlAttribute(EHtmlAttr.defer, defer);
        return this;
    }

    public String getHtmlSrc() {
        return this.getHtmlAttribute(EHtmlAttr.src);
    }

    public DScript setHtmlSrc(String src) {
        this.setHtmlAttribute(EHtmlAttr.src, src);
        return this;
    }

    public String getHtmlType() {
        return this.getHtmlAttribute(EHtmlAttr.type);
    }

    public final DScript setHtmlType(String type) {
        this.setHtmlAttribute(EHtmlAttr.type, type);
        return this;
    }

    public final boolean getHtmlAsync() {
        return this.getHtmlAttributeExists(EHtmlAttr.async);
    }

    public DScript setHtmlAsync(String async) {
        return this.setHtmlAsync(this.toBoolean("async", async));
    }

    public DScript setHtmlAsync(boolean async) {
        this.setHtmlAttribute(EHtmlAttr.async, async);
        return this;
    }

    public String getHtmlLanguage() {
        return this.getHtmlAttribute(EHtmlAttr.language);
    }

    public DScript setHtmlLanguage(String language) {
        this.setHtmlAttribute(EHtmlAttr.language, language);
        return this;
    }

    @Override
    public String toString() {
        return String.valueOf(super.toString()) + Z.fmt((String)"charset", (Object)this.getHtmlCharset()) + Z.fmt((String)"defer", (Object)("" + this.getHtmlDefer())) + Z.fmt((String)"language", (Object)this.getHtmlLanguage()) + Z.fmt((String)"src", (Object)this.getHtmlSrc()) + Z.fmt((String)"text", (Object)this.getHtmlText()) + Z.fmt((String)"type", (Object)this.getHtmlType()) + Z.fmt((String)"async", (boolean)this.getHtmlAsync());
    }

    public DScript add(DNode newChild) throws DOMException {
        super.add(newChild);
        return this;
    }

    public DScript add(String value) throws DOMException {
        super.add(value);
        return this;
    }

    public DScript addRaw(String value) throws DOMException {
        super.addRaw(value);
        return this;
    }

    public DScript dsfAccept(IDNodeVisitor visitor) {
        super.dsfAccept(visitor);
        return this;
    }

    public DScript dsfBroadcast(DsfEvent event) throws AbortDsfEventProcessingException {
        super.dsfBroadcast(event);
        return this;
    }

    public DScript setDsfRelationshipVerifier(IDNodeRelationshipVerifier relationshipVerifier) {
        super.setDsfRelationshipVerifier(relationshipVerifier);
        return this;
    }

    public DScript cloned() {
        return (DScript)((Object)super.cloned());
    }

    public DScript setDsfNamespace(DNamespace namespace) {
        super.setDsfNamespace(namespace);
        return this;
    }

    @Override
    public DScript setHtmlAccessKey(String accessKey) {
        super.setHtmlAccessKey(accessKey);
        return this;
    }

    @Override
    public DScript setHtmlClassName(String className) {
        super.setHtmlClassName(className);
        return this;
    }

    @Override
    public DScript setHtmlClassName(CssClassConstant ccc) {
        super.setHtmlClassName(ccc);
        return this;
    }

    @Override
    public DScript setHtmlContentEditable(String editable) {
        super.setHtmlContentEditable(editable);
        return this;
    }

    @Override
    public DScript setHtmlContextMenu(String contextMenu) {
        super.setHtmlContextMenu(contextMenu);
        return this;
    }

    @Override
    public DScript setHtmlDir(String dir) {
        super.setHtmlDir(dir);
        return this;
    }

    @Override
    public DScript setHtmlDraggable(String draggable) {
        super.setHtmlDraggable(draggable);
        return this;
    }

    @Override
    public DScript setHtmlDraggable(boolean draggable) {
        super.setHtmlDraggable(draggable);
        return this;
    }

    @Override
    public DScript setHtmlHidden(String hidden) {
        super.setHtmlHidden(hidden);
        return this;
    }

    @Override
    public DScript setHtmlHidden(boolean hidden) {
        super.setHtmlHidden(hidden);
        return this;
    }

    @Override
    public DScript setHtmlId(String id) {
        super.setHtmlId(id);
        return this;
    }

    @Override
    public DScript setHtmlId(CssIdConstant id) {
        super.setHtmlId(id);
        return this;
    }

    @Override
    public DScript setHtmlItem(String item) {
        super.setHtmlItem(item);
        return this;
    }

    @Override
    public DScript setHtmlItemProp(String itemProp) {
        super.setHtmlItemProp(itemProp);
        return this;
    }

    @Override
    public DScript setHtmlLang(String lang) {
        super.setHtmlLang(lang);
        return this;
    }

    @Override
    public DScript setHtmlSpellCheck(String spellCheck) {
        super.setHtmlSpellCheck(spellCheck);
        return this;
    }

    @Override
    public DScript setHtmlSpellCheck(boolean spellCheck) {
        super.setHtmlSpellCheck(spellCheck);
        return this;
    }

    @Override
    public DScript setHtmlStyleAsString(String styleString) {
        super.setHtmlStyleAsString(styleString);
        return this;
    }

    @Override
    public DScript setHtmlStyle(CSSStyleDeclaration style) {
        super.setHtmlStyle(style);
        return this;
    }

    @Override
    public DScript setHtmlSubject(String subject) {
        super.setHtmlSubject(subject);
        return this;
    }

    @Override
    public DScript setHtmlTabIndex(String tabIndex) {
        super.setHtmlTabIndex(tabIndex);
        return this;
    }

    @Override
    public DScript setHtmlTabIndex(int tabIndex) {
        super.setHtmlTabIndex(tabIndex);
        return this;
    }

    @Override
    public DScript setHtmlTitle(String title) {
        super.setHtmlTitle(title);
        return this;
    }

    @Override
    public DScript setHtmlOnAbort(String script) {
        super.setHtmlOnAbort(script);
        return this;
    }

    @Override
    public DScript setHtmlOnBlur(String onBlur) {
        super.setHtmlOnBlur(onBlur);
        return this;
    }

    @Override
    public DScript setHtmlOnCanPlay(String script) {
        super.setHtmlOnCanPlay(script);
        return this;
    }

    @Override
    public DScript setHtmlOnCanPlayThrough(String script) {
        super.setHtmlOnCanPlayThrough(script);
        return this;
    }

    @Override
    public DScript setHtmlOnChange(String script) {
        super.setHtmlOnChange(script);
        return this;
    }

    @Override
    public DScript setHtmlOnClick(String script) {
        super.setHtmlOnClick(script);
        return this;
    }

    @Override
    public DScript setHtmlOnContextMenu(String script) {
        super.setHtmlOnContextMenu(script);
        return this;
    }

    @Override
    public DScript setHtmlOnDblClick(String script) {
        super.setHtmlOnDblClick(script);
        return this;
    }

    @Override
    public DScript setHtmlOnDrag(String script) {
        super.setHtmlOnDrag(script);
        return this;
    }

    @Override
    public DScript setHtmlOnDragEnd(String script) {
        super.setHtmlOnDragEnd(script);
        return this;
    }

    @Override
    public DScript setHtmlOnDragEnter(String script) {
        super.setHtmlOnDragEnter(script);
        return this;
    }

    @Override
    public DScript setHtmlOnDragLeave(String script) {
        super.setHtmlOnDragLeave(script);
        return this;
    }

    @Override
    public DScript setHtmlOnDragOver(String script) {
        super.setHtmlOnDragOver(script);
        return this;
    }

    @Override
    public DScript setHtmlOnDragStart(String script) {
        super.setHtmlOnDragStart(script);
        return this;
    }

    @Override
    public DScript setHtmlOnDrop(String script) {
        super.setHtmlOnDrop(script);
        return this;
    }

    @Override
    public DScript setHtmlOnDurationChange(String script) {
        super.setHtmlOnDurationChange(script);
        return this;
    }

    @Override
    public DScript setHtmlOnEmptied(String script) {
        super.setHtmlOnEmptied(script);
        return this;
    }

    @Override
    public DScript setHtmlOnEnded(String script) {
        super.setHtmlOnEnded(script);
        return this;
    }

    @Override
    public DScript setHtmlOnError(String script) {
        super.setHtmlOnError(script);
        return this;
    }

    @Override
    public DScript setHtmlOnFocus(String script) {
        super.setHtmlOnFocus(script);
        return this;
    }

    @Override
    public DScript setHtmlOnFormChange(String script) {
        super.setHtmlOnFormChange(script);
        return this;
    }

    @Override
    public DScript setHtmlOnFormInput(String script) {
        super.setHtmlOnFormInput(script);
        return this;
    }

    @Override
    public DScript setHtmlOnInput(String script) {
        super.setHtmlOnInput(script);
        return this;
    }

    @Override
    public DScript setHtmlOnInvalid(String script) {
        super.setHtmlOnInvalid(script);
        return this;
    }

    @Override
    public DScript setHtmlOnKeyDown(String script) {
        super.setHtmlOnKeyDown(script);
        return this;
    }

    @Override
    public DScript setHtmlOnKeyPress(String script) {
        super.setHtmlOnKeyPress(script);
        return this;
    }

    @Override
    public DScript setHtmlOnKeyUp(String script) {
        super.setHtmlOnKeyUp(script);
        return this;
    }

    @Override
    public DScript setHtmlOnLoad(String script) {
        super.setHtmlOnLoad(script);
        return this;
    }

    @Override
    public DScript setHtmlOnLoadedData(String script) {
        super.setHtmlOnLoadedData(script);
        return this;
    }

    @Override
    public DScript setHtmlOnLoadedMetadata(String script) {
        super.setHtmlOnLoadedMetadata(script);
        return this;
    }

    @Override
    public DScript setHtmlOnLoadStart(String script) {
        super.setHtmlOnLoadStart(script);
        return this;
    }

    @Override
    public DScript setHtmlOnMouseDown(String script) {
        super.setHtmlOnMouseDown(script);
        return this;
    }

    @Override
    public DScript setHtmlOnMouseMove(String script) {
        super.setHtmlOnMouseMove(script);
        return this;
    }

    @Override
    public DScript setHtmlOnMouseOut(String script) {
        super.setHtmlOnMouseOut(script);
        return this;
    }

    @Override
    public DScript setHtmlOnMouseOver(String script) {
        super.setHtmlOnMouseOver(script);
        return this;
    }

    @Override
    public DScript setHtmlOnMouseUp(String script) {
        super.setHtmlOnMouseUp(script);
        return this;
    }

    @Override
    public DScript setHtmlOnMouseWheel(String script) {
        super.setHtmlOnMouseWheel(script);
        return this;
    }

    @Override
    public DScript setHtmlOnPause(String script) {
        super.setHtmlOnPause(script);
        return this;
    }

    @Override
    public DScript setHtmlOnPlay(String script) {
        super.setHtmlOnPlay(script);
        return this;
    }

    @Override
    public DScript setHtmlOnPlaying(String script) {
        super.setHtmlOnPlaying(script);
        return this;
    }

    @Override
    public DScript setHtmlOnProgress(String script) {
        super.setHtmlOnProgress(script);
        return this;
    }

    @Override
    public DScript setHtmlOnRateChange(String script) {
        super.setHtmlOnRateChange(script);
        return this;
    }

    @Override
    public DScript setHtmlOnReadyStateChange(String script) {
        super.setHtmlOnReadyStateChange(script);
        return this;
    }

    @Override
    public DScript setHtmlOnScroll(String script) {
        super.setHtmlOnScroll(script);
        return this;
    }

    @Override
    public DScript setHtmlOnSeeked(String script) {
        super.setHtmlOnSeeked(script);
        return this;
    }

    @Override
    public DScript setHtmlOnSeeking(String script) {
        super.setHtmlOnSeeking(script);
        return this;
    }

    @Override
    public DScript setHtmlOnSelect(String script) {
        super.setHtmlOnSelect(script);
        return this;
    }

    @Override
    public DScript setHtmlOnShow(String script) {
        super.setHtmlOnShow(script);
        return this;
    }

    @Override
    public DScript setHtmlOnStalled(String script) {
        super.setHtmlOnStalled(script);
        return this;
    }

    @Override
    public DScript setHtmlOnSubmit(String script) {
        super.setHtmlOnSubmit(script);
        return this;
    }

    @Override
    public DScript setHtmlOnSuspend(String script) {
        super.setHtmlOnSuspend(script);
        return this;
    }

    @Override
    public DScript setHtmlOnTimeUpdate(String script) {
        super.setHtmlOnTimeUpdate(script);
        return this;
    }

    @Override
    public DScript setHtmlOnVolumeChange(String script) {
        super.setHtmlOnVolumeChange(script);
        return this;
    }

    @Override
    public DScript setHtmlOnWaiting(String script) {
        super.setHtmlOnWaiting(script);
        return this;
    }

    @Override
    public DScript add(EventType eventType, ISimpleJsEventHandler handler) {
        super.add(eventType, handler);
        return this;
    }

    @Override
    public DScript add(EventType eventType, IJsFunc func) {
        super.add(eventType, func);
        return this;
    }

    @Override
    public DScript add(EventType eventType, String jsText) {
        super.add(eventType, jsText);
        return this;
    }

    @Override
    public DScript addBr() {
        super.addBr();
        return this;
    }

    @Override
    public DScript addBr(int howMany) {
        super.addBr(howMany);
        return this;
    }

    @Override
    public DScript addHtmlClassName(String className) {
        super.addHtmlClassName(className);
        return this;
    }

    @Override
    public DScript addHtmlClassName(CssClassConstant ccc) {
        super.addHtmlClassName(ccc);
        return this;
    }

    @Override
    public DScript jif(String jif) {
        super.jif(jif);
        return this;
    }
}

