/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.html.dom;

import org.eclipse.vjet.dsf.common.Z;
import org.eclipse.vjet.dsf.common.event.AbortDsfEventProcessingException;
import org.eclipse.vjet.dsf.common.event.DsfEvent;
import org.eclipse.vjet.dsf.common.exceptions.DsfRuntimeException;
import org.eclipse.vjet.dsf.common.node.IDNodeRelationshipVerifier;
import org.eclipse.vjet.dsf.common.node.visitor.IDNodeVisitor;
import org.eclipse.vjet.dsf.css.CssClassConstant;
import org.eclipse.vjet.dsf.css.CssIdConstant;
import org.eclipse.vjet.dsf.dom.DNode;
import org.eclipse.vjet.dsf.dom.support.DNamespace;
import org.eclipse.vjet.dsf.html.dom.BaseAttrsHtmlElement;
import org.eclipse.vjet.dsf.html.dom.BaseHtmlElement;
import org.eclipse.vjet.dsf.html.dom.DHtmlCollection;
import org.eclipse.vjet.dsf.html.dom.DHtmlDocument;
import org.eclipse.vjet.dsf.html.dom.DOptGroup;
import org.eclipse.vjet.dsf.html.dom.DOption;
import org.eclipse.vjet.dsf.html.dom.EHtmlAttr;
import org.eclipse.vjet.dsf.html.dom.HtmlTypeEnum;
import org.eclipse.vjet.dsf.html.dom.IDFormControl;
import org.eclipse.vjet.dsf.html.events.EventType;
import org.eclipse.vjet.dsf.html.events.ISimpleJsEventHandler;
import org.eclipse.vjet.dsf.html.js.IJsFunc;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.css.CSSStyleDeclaration;

public class DSelect
extends BaseAttrsHtmlElement
implements IDFormControl {
    private static final long serialVersionUID = 3256722883588665912L;
    private DHtmlCollection m_options;

    public DSelect() {
        super(HtmlTypeEnum.SELECT);
    }

    public DSelect(DHtmlDocument doc) {
        super(doc, HtmlTypeEnum.SELECT);
    }

    public DSelect(String jif) {
        this();
        this.jif(jif);
    }

    public DSelect(BaseHtmlElement ... elems) {
        this();
        this.add(elems);
    }

    @Override
    public HtmlTypeEnum htmlType() {
        return HtmlTypeEnum.SELECT;
    }

    public String getHtmlType() {
        return this.getHtmlAttribute(EHtmlAttr.type);
    }

    public String getHtmlValue() {
        if (this.getHtmlMultiple()) {
            throw new DsfRuntimeException("unsupported method for multi-select element");
        }
        NodeList options = this.getElementsByTagName(HtmlTypeEnum.OPTION);
        int i = 0;
        while (i < options.getLength()) {
            DOption opt = (DOption)((Object)options.item(i));
            if (opt.getHtmlSelected()) {
                return opt.getHtmlValue();
            }
            ++i;
        }
        return null;
    }

    public DSelect setHtmlValue(String value) {
        if (this.getHtmlMultiple()) {
            throw new DsfRuntimeException("unsupported method for multi-select element");
        }
        NodeList options = this.getElementsByTagName(HtmlTypeEnum.OPTION);
        int i = 0;
        while (i < options.getLength()) {
            DOption opt = (DOption)((Object)options.item(i));
            if (value.equals(opt.getHtmlValue())) {
                opt.setHtmlSelected(true);
            } else {
                opt.setHtmlSelected(false);
            }
            ++i;
        }
        return this;
    }

    public int getHtmlSelectedIndex() {
        if (this.getHtmlMultiple()) {
            throw new DsfRuntimeException("unsupported method for multi-select element");
        }
        NodeList options = this.getElementsByTagName(HtmlTypeEnum.OPTION);
        int i = 0;
        while (i < options.getLength()) {
            if (((DOption)((Object)options.item(i))).getHtmlSelected()) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public DSelect setHtmlSelectedIndex(String selectedIndex) {
        return this.setHtmlSelectedIndex(this.toInt("DSelect:selectedindex", selectedIndex));
    }

    public DSelect setHtmlSelectedIndex(int selectedIndex) {
        if (this.getHtmlMultiple()) {
            throw new DsfRuntimeException("unsupported method for multi-select element");
        }
        NodeList options = this.getElementsByTagName(HtmlTypeEnum.OPTION);
        int i = 0;
        while (i < options.getLength()) {
            ((DOption)((Object)options.item(i))).setHtmlSelected(i == selectedIndex);
            ++i;
        }
        return this;
    }

    public DHtmlCollection getHtmlOptions() {
        if (this.m_options == null) {
            this.m_options = new DHtmlCollection(this, 6);
        }
        return this.m_options;
    }

    public int getHtmlLength() {
        return this.getHtmlOptions().getLength();
    }

    public boolean getHtmlDisabled() {
        return this.getHtmlAttributeExists(EHtmlAttr.disabled);
    }

    public DSelect setHtmlDisabled(String disabled) {
        return this.setHtmlDisabled(this.toBoolean("disabled", disabled));
    }

    public DSelect setHtmlDisabled(boolean disabled) {
        this.setHtmlAttribute(EHtmlAttr.disabled, disabled);
        return this;
    }

    public boolean getHtmlMultiple() {
        return this.getHtmlAttributeExists(EHtmlAttr.multiple);
    }

    public DSelect setHtmlMultiple(String multiple) {
        return this.setHtmlMultiple(this.toBoolean("multiple", multiple));
    }

    public DSelect setHtmlMultiple(boolean multiple) {
        this.setHtmlAttribute(EHtmlAttr.multiple, multiple);
        return this;
    }

    public String getHtmlName() {
        return this.getHtmlAttribute(EHtmlAttr.name);
    }

    public DSelect setHtmlName(String name) {
        this.setHtmlAttribute(EHtmlAttr.name, name);
        return this;
    }

    public int getHtmlSize() {
        return this.getHtmlAttributeInteger(EHtmlAttr.size);
    }

    public DSelect setHtmlSize(String size) {
        return this.setHtmlSize(this.toInt("DSelect:size", size));
    }

    public DSelect setHtmlSize(int size) {
        this.setHtmlAttribute(EHtmlAttr.size, size);
        return this;
    }

    public DSelect htmlAdd(BaseHtmlElement element, BaseHtmlElement before) {
        this.insertBefore((Node)((Object)element), (Node)((Object)before));
        return this;
    }

    public DSelect htmlRemove(int index) {
        NodeList options = this.getElementsByTagName(HtmlTypeEnum.OPTION);
        Node removed = options.item(index);
        if (removed != null) {
            removed.getParentNode().removeChild(removed);
        }
        return this;
    }

    public boolean getHtmlAutoFocus() {
        return this.getHtmlAttributeExists(EHtmlAttr.autofocus);
    }

    public DSelect setHtmlAutoFocus(String autofocus) {
        return this.setHtmlAutoFocus(this.toBoolean("autofocus", autofocus));
    }

    public DSelect setHtmlAutoFocus(boolean autofocus) {
        this.setHtmlAttribute(EHtmlAttr.autofocus, autofocus);
        return this;
    }

    public Object cloneNode() throws CloneNotSupportedException {
        DSelect clonedNode = (DSelect)super.clone();
        clonedNode.m_options = null;
        return clonedNode;
    }

    @Override
    public String toString() {
        return String.valueOf(super.toString()) + Z.fmt((String)"disabled", (Object)("" + this.getHtmlDisabled())) + Z.fmt((String)"length", (int)this.getHtmlLength()) + Z.fmt((String)"multiple", (boolean)this.getHtmlMultiple()) + Z.fmt((String)"name", (Object)this.getHtmlName()) + Z.fmt((String)"seletedindex", (Object)("" + this.getHtmlSelectedIndex())) + Z.fmt((String)"size", (Object)("" + this.getHtmlSize())) + Z.fmt((String)"type", (Object)this.getHtmlType()) + Z.fmt((String)"value", (Object)this.getHtmlValue()) + Z.fmt((String)"autofocus", (boolean)this.getHtmlAutoFocus());
    }

    public DSelect add(DNode newChild) throws DOMException {
        super.add(newChild);
        return this;
    }

    @Override
    public DSelect add(BaseHtmlElement ... elems) throws DOMException {
        super.add(elems);
        return this;
    }

    public DSelect add(String value) throws DOMException {
        super.add(value);
        return this;
    }

    public DSelect addRaw(String value) throws DOMException {
        super.addRaw(value);
        return this;
    }

    public DSelect dsfAccept(IDNodeVisitor visitor) {
        super.dsfAccept(visitor);
        return this;
    }

    public DSelect dsfBroadcast(DsfEvent event) throws AbortDsfEventProcessingException {
        super.dsfBroadcast(event);
        return this;
    }

    public DSelect setDsfRelationshipVerifier(IDNodeRelationshipVerifier relationshipVerifier) {
        super.setDsfRelationshipVerifier(relationshipVerifier);
        return this;
    }

    public DSelect cloned() {
        return (DSelect)super.cloned();
    }

    public DSelect setDsfNamespace(DNamespace namespace) {
        super.setDsfNamespace(namespace);
        return this;
    }

    @Override
    public DSelect setHtmlAccessKey(String accessKey) {
        super.setHtmlAccessKey(accessKey);
        return this;
    }

    @Override
    public DSelect setHtmlClassName(String className) {
        super.setHtmlClassName(className);
        return this;
    }

    @Override
    public DSelect setHtmlClassName(CssClassConstant ccc) {
        super.setHtmlClassName(ccc);
        return this;
    }

    @Override
    public DSelect setHtmlContentEditable(String editable) {
        super.setHtmlContentEditable(editable);
        return this;
    }

    @Override
    public DSelect setHtmlContextMenu(String contextMenu) {
        super.setHtmlContextMenu(contextMenu);
        return this;
    }

    @Override
    public DSelect setHtmlDir(String dir) {
        super.setHtmlDir(dir);
        return this;
    }

    @Override
    public DSelect setHtmlDraggable(String draggable) {
        super.setHtmlDraggable(draggable);
        return this;
    }

    @Override
    public DSelect setHtmlDraggable(boolean draggable) {
        super.setHtmlDraggable(draggable);
        return this;
    }

    @Override
    public DSelect setHtmlHidden(String hidden) {
        super.setHtmlHidden(hidden);
        return this;
    }

    @Override
    public DSelect setHtmlHidden(boolean hidden) {
        super.setHtmlHidden(hidden);
        return this;
    }

    @Override
    public DSelect setHtmlId(String id) {
        super.setHtmlId(id);
        return this;
    }

    @Override
    public DSelect setHtmlId(CssIdConstant id) {
        super.setHtmlId(id);
        return this;
    }

    @Override
    public DSelect setHtmlItem(String item) {
        super.setHtmlItem(item);
        return this;
    }

    @Override
    public DSelect setHtmlItemProp(String itemProp) {
        super.setHtmlItemProp(itemProp);
        return this;
    }

    @Override
    public DSelect setHtmlLang(String lang) {
        super.setHtmlLang(lang);
        return this;
    }

    @Override
    public DSelect setHtmlSpellCheck(String spellCheck) {
        super.setHtmlSpellCheck(spellCheck);
        return this;
    }

    @Override
    public DSelect setHtmlSpellCheck(boolean spellCheck) {
        super.setHtmlSpellCheck(spellCheck);
        return this;
    }

    @Override
    public DSelect setHtmlStyleAsString(String styleString) {
        super.setHtmlStyleAsString(styleString);
        return this;
    }

    @Override
    public DSelect setHtmlStyle(CSSStyleDeclaration style) {
        super.setHtmlStyle(style);
        return this;
    }

    @Override
    public DSelect setHtmlSubject(String subject) {
        super.setHtmlSubject(subject);
        return this;
    }

    @Override
    public DSelect setHtmlTabIndex(String tabIndex) {
        super.setHtmlTabIndex(tabIndex);
        return this;
    }

    @Override
    public DSelect setHtmlTabIndex(int tabIndex) {
        super.setHtmlTabIndex(tabIndex);
        return this;
    }

    @Override
    public DSelect setHtmlTitle(String title) {
        super.setHtmlTitle(title);
        return this;
    }

    @Override
    public DSelect setHtmlOnAbort(String script) {
        super.setHtmlOnAbort(script);
        return this;
    }

    @Override
    public DSelect setHtmlOnBlur(String onBlur) {
        super.setHtmlOnBlur(onBlur);
        return this;
    }

    @Override
    public DSelect setHtmlOnCanPlay(String script) {
        super.setHtmlOnCanPlay(script);
        return this;
    }

    @Override
    public DSelect setHtmlOnCanPlayThrough(String script) {
        super.setHtmlOnCanPlayThrough(script);
        return this;
    }

    @Override
    public DSelect setHtmlOnChange(String script) {
        super.setHtmlOnChange(script);
        return this;
    }

    @Override
    public DSelect setHtmlOnClick(String script) {
        super.setHtmlOnClick(script);
        return this;
    }

    @Override
    public DSelect setHtmlOnContextMenu(String script) {
        super.setHtmlOnContextMenu(script);
        return this;
    }

    @Override
    public DSelect setHtmlOnDblClick(String script) {
        super.setHtmlOnDblClick(script);
        return this;
    }

    @Override
    public DSelect setHtmlOnDrag(String script) {
        super.setHtmlOnDrag(script);
        return this;
    }

    @Override
    public DSelect setHtmlOnDragEnd(String script) {
        super.setHtmlOnDragEnd(script);
        return this;
    }

    @Override
    public DSelect setHtmlOnDragEnter(String script) {
        super.setHtmlOnDragEnter(script);
        return this;
    }

    @Override
    public DSelect setHtmlOnDragLeave(String script) {
        super.setHtmlOnDragLeave(script);
        return this;
    }

    @Override
    public DSelect setHtmlOnDragOver(String script) {
        super.setHtmlOnDragOver(script);
        return this;
    }

    @Override
    public DSelect setHtmlOnDragStart(String script) {
        super.setHtmlOnDragStart(script);
        return this;
    }

    @Override
    public DSelect setHtmlOnDrop(String script) {
        super.setHtmlOnDrop(script);
        return this;
    }

    @Override
    public DSelect setHtmlOnDurationChange(String script) {
        super.setHtmlOnDurationChange(script);
        return this;
    }

    @Override
    public DSelect setHtmlOnEmptied(String script) {
        super.setHtmlOnEmptied(script);
        return this;
    }

    @Override
    public DSelect setHtmlOnEnded(String script) {
        super.setHtmlOnEnded(script);
        return this;
    }

    @Override
    public DSelect setHtmlOnError(String script) {
        super.setHtmlOnError(script);
        return this;
    }

    @Override
    public DSelect setHtmlOnFocus(String script) {
        super.setHtmlOnFocus(script);
        return this;
    }

    @Override
    public DSelect setHtmlOnFormChange(String script) {
        super.setHtmlOnFormChange(script);
        return this;
    }

    @Override
    public DSelect setHtmlOnFormInput(String script) {
        super.setHtmlOnFormInput(script);
        return this;
    }

    @Override
    public DSelect setHtmlOnInput(String script) {
        super.setHtmlOnInput(script);
        return this;
    }

    @Override
    public DSelect setHtmlOnInvalid(String script) {
        super.setHtmlOnInvalid(script);
        return this;
    }

    @Override
    public DSelect setHtmlOnKeyDown(String script) {
        super.setHtmlOnKeyDown(script);
        return this;
    }

    @Override
    public DSelect setHtmlOnKeyPress(String script) {
        super.setHtmlOnKeyPress(script);
        return this;
    }

    @Override
    public DSelect setHtmlOnKeyUp(String script) {
        super.setHtmlOnKeyUp(script);
        return this;
    }

    @Override
    public DSelect setHtmlOnLoad(String script) {
        super.setHtmlOnLoad(script);
        return this;
    }

    @Override
    public DSelect setHtmlOnLoadedData(String script) {
        super.setHtmlOnLoadedData(script);
        return this;
    }

    @Override
    public DSelect setHtmlOnLoadedMetadata(String script) {
        super.setHtmlOnLoadedMetadata(script);
        return this;
    }

    @Override
    public DSelect setHtmlOnLoadStart(String script) {
        super.setHtmlOnLoadStart(script);
        return this;
    }

    @Override
    public DSelect setHtmlOnMouseDown(String script) {
        super.setHtmlOnMouseDown(script);
        return this;
    }

    @Override
    public DSelect setHtmlOnMouseMove(String script) {
        super.setHtmlOnMouseMove(script);
        return this;
    }

    @Override
    public DSelect setHtmlOnMouseOut(String script) {
        super.setHtmlOnMouseOut(script);
        return this;
    }

    @Override
    public DSelect setHtmlOnMouseOver(String script) {
        super.setHtmlOnMouseOver(script);
        return this;
    }

    @Override
    public DSelect setHtmlOnMouseUp(String script) {
        super.setHtmlOnMouseUp(script);
        return this;
    }

    @Override
    public DSelect setHtmlOnMouseWheel(String script) {
        super.setHtmlOnMouseWheel(script);
        return this;
    }

    @Override
    public DSelect setHtmlOnPause(String script) {
        super.setHtmlOnPause(script);
        return this;
    }

    @Override
    public DSelect setHtmlOnPlay(String script) {
        super.setHtmlOnPlay(script);
        return this;
    }

    @Override
    public DSelect setHtmlOnPlaying(String script) {
        super.setHtmlOnPlaying(script);
        return this;
    }

    @Override
    public DSelect setHtmlOnProgress(String script) {
        super.setHtmlOnProgress(script);
        return this;
    }

    @Override
    public DSelect setHtmlOnRateChange(String script) {
        super.setHtmlOnRateChange(script);
        return this;
    }

    @Override
    public DSelect setHtmlOnReadyStateChange(String script) {
        super.setHtmlOnReadyStateChange(script);
        return this;
    }

    @Override
    public DSelect setHtmlOnScroll(String script) {
        super.setHtmlOnScroll(script);
        return this;
    }

    @Override
    public DSelect setHtmlOnSeeked(String script) {
        super.setHtmlOnSeeked(script);
        return this;
    }

    @Override
    public DSelect setHtmlOnSeeking(String script) {
        super.setHtmlOnSeeking(script);
        return this;
    }

    @Override
    public DSelect setHtmlOnSelect(String script) {
        super.setHtmlOnSelect(script);
        return this;
    }

    @Override
    public DSelect setHtmlOnShow(String script) {
        super.setHtmlOnShow(script);
        return this;
    }

    @Override
    public DSelect setHtmlOnStalled(String script) {
        super.setHtmlOnStalled(script);
        return this;
    }

    @Override
    public DSelect setHtmlOnSubmit(String script) {
        super.setHtmlOnSubmit(script);
        return this;
    }

    @Override
    public DSelect setHtmlOnSuspend(String script) {
        super.setHtmlOnSuspend(script);
        return this;
    }

    @Override
    public DSelect setHtmlOnTimeUpdate(String script) {
        super.setHtmlOnTimeUpdate(script);
        return this;
    }

    @Override
    public DSelect setHtmlOnVolumeChange(String script) {
        super.setHtmlOnVolumeChange(script);
        return this;
    }

    @Override
    public DSelect setHtmlOnWaiting(String script) {
        super.setHtmlOnWaiting(script);
        return this;
    }

    @Override
    public DSelect add(EventType eventType, ISimpleJsEventHandler handler) {
        super.add(eventType, handler);
        return this;
    }

    @Override
    public DSelect add(EventType eventType, IJsFunc func) {
        super.add(eventType, func);
        return this;
    }

    @Override
    public DSelect add(EventType eventType, String jsText) {
        super.add(eventType, jsText);
        return this;
    }

    @Override
    public DSelect addBr() {
        super.addBr();
        return this;
    }

    @Override
    public DSelect addBr(int howMany) {
        super.addBr(howMany);
        return this;
    }

    @Override
    public DSelect addHtmlClassName(String className) {
        super.addHtmlClassName(className);
        return this;
    }

    @Override
    public DSelect addHtmlClassName(CssClassConstant ccc) {
        super.addHtmlClassName(ccc);
        return this;
    }

    @Override
    public DSelect jif(String jif) {
        super.jif(jif);
        return this;
    }

    public DOptGroup _optgroup() {
        return this._optgroup(-1);
    }

    public DOptGroup _optgroup(int count) {
        return (DOptGroup)((Object)this.getOrCreate(DOptGroup.class, count));
    }

    public DOption _option() {
        return this._option(-1);
    }

    public DOption _option(int count) {
        return (DOption)((Object)this.getOrCreate(DOption.class, count));
    }
}

