/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.html.dom;

import org.eclipse.vjet.dsf.common.Z;
import org.eclipse.vjet.dsf.common.event.AbortDsfEventProcessingException;
import org.eclipse.vjet.dsf.common.event.DsfEvent;
import org.eclipse.vjet.dsf.common.node.IDNodeRelationshipVerifier;
import org.eclipse.vjet.dsf.common.node.visitor.IDNodeVisitor;
import org.eclipse.vjet.dsf.css.CssClassConstant;
import org.eclipse.vjet.dsf.css.CssIdConstant;
import org.eclipse.vjet.dsf.dom.DElement;
import org.eclipse.vjet.dsf.dom.DNode;
import org.eclipse.vjet.dsf.dom.support.DNamespace;
import org.eclipse.vjet.dsf.html.dom.BaseAttrsHtmlElement;
import org.eclipse.vjet.dsf.html.dom.BaseTableCell;
import org.eclipse.vjet.dsf.html.dom.BaseTableSection;
import org.eclipse.vjet.dsf.html.dom.DHtmlCollection;
import org.eclipse.vjet.dsf.html.dom.DHtmlDocument;
import org.eclipse.vjet.dsf.html.dom.DTable;
import org.eclipse.vjet.dsf.html.dom.DTd;
import org.eclipse.vjet.dsf.html.dom.DTh;
import org.eclipse.vjet.dsf.html.dom.EHtmlAttr;
import org.eclipse.vjet.dsf.html.dom.HtmlTypeEnum;
import org.eclipse.vjet.dsf.html.dom.Util;
import org.eclipse.vjet.dsf.html.events.EventType;
import org.eclipse.vjet.dsf.html.events.ISimpleJsEventHandler;
import org.eclipse.vjet.dsf.html.js.IJsFunc;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.css.CSSStyleDeclaration;

public class DTr
extends BaseAttrsHtmlElement {
    private static final long serialVersionUID = 3545231444772468278L;
    public static final String ALIGN_LEFT = "left";
    public static final String ALIGN_CENTER = "center";
    public static final String ALIGN_RIGHT = "right";
    public static final String ALIGN_JUSTIFY = "justify";
    public static final String ALIGN_CHAR = "char";
    public static final String VALIGN_TOP = "top";
    public static final String VALIGN_MIDDLE = "middle";
    public static final String VALIGN_BOTTOM = "bottom";
    public static final String VALIGN_BASELINE = "baseline";
    DHtmlCollection m_cells;

    public DTr() {
        super(HtmlTypeEnum.TR);
    }

    public DTr(DHtmlDocument doc) {
        super(doc, HtmlTypeEnum.TR);
    }

    public DTr(String jif) {
        this();
        this.jif(jif);
    }

    public DTr(DTd ... cells) {
        this();
        this.add(cells);
    }

    @Override
    public HtmlTypeEnum htmlType() {
        return HtmlTypeEnum.TR;
    }

    public int getHtmlRowIndex() {
        Node parent = this.getParentNode();
        if (parent instanceof BaseTableSection) {
            parent = parent.getParentNode();
        }
        if (parent instanceof DTable) {
            return this.getRowIndex(parent);
        }
        return -1;
    }

    public DTr setHtmlRowIndex(String rowIndex) {
        return this.setHtmlRowIndex(this.toInt("DTr:rowindex", rowIndex));
    }

    public DTr setHtmlRowIndex(int rowIndex) {
        Node parent = this.getParentNode();
        if (parent instanceof BaseTableSection) {
            parent = parent.getParentNode();
        }
        if (parent instanceof DTable) {
            ((DTable)((Object)parent)).insertRowX(rowIndex, this);
        }
        return this;
    }

    public int getHtmlSectionRowIndex() {
        Node parent = this.getParentNode();
        if (parent instanceof BaseTableSection) {
            return this.getRowIndex(parent);
        }
        return -1;
    }

    public DTr setHtmlSectionRowIndex(String sectionRowIndex) {
        return this.setHtmlSectionRowIndex(this.toInt("DTr:sectionrowindex", sectionRowIndex));
    }

    public DTr setHtmlSectionRowIndex(int sectionRowIndex) {
        Node parent = this.getParentNode();
        if (parent instanceof BaseTableSection) {
            ((BaseTableSection)((Object)parent)).insertRowX(sectionRowIndex, this);
        }
        return this;
    }

    int getRowIndex(Node parent) {
        NodeList rows = ((DElement)parent).getElementsByTagName(HtmlTypeEnum.TR.getName());
        int i = 0;
        while (i < rows.getLength()) {
            if (rows.item(i) == this) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public DHtmlCollection getHtmlCells() {
        if (this.m_cells == null) {
            this.m_cells = new DHtmlCollection(this, -3);
        }
        return this.m_cells;
    }

    public DTr setHtmlCells(DHtmlCollection cells) {
        Node child = this.getFirstChild();
        while (child != null) {
            this.removeChild(child);
            child = child.getNextSibling();
        }
        int i = 0;
        child = cells.item(i);
        while (child != null) {
            this.appendChild(child);
            child = cells.item(++i);
        }
        return this;
    }

    public DTd htmlInsertCell(int index) {
        DTd newCell = new DTd();
        Node child = this.getFirstChild();
        while (child != null) {
            if (child instanceof BaseTableCell) {
                if (index == 0) {
                    this.insertBefore((Node)((Object)newCell), child);
                    return newCell;
                }
                --index;
            }
            child = child.getNextSibling();
        }
        this.add((DNode)newCell);
        return newCell;
    }

    public DTr htmlDeleteCell(int index) {
        Node child = this.getFirstChild();
        while (child != null) {
            if (child instanceof BaseTableCell) {
                if (index == 0) {
                    this.removeChild(child);
                    return this;
                }
                --index;
            }
            child = child.getNextSibling();
        }
        return this;
    }

    public String getHtmlAlign() {
        return this.capitalize(this.getHtmlAttribute(EHtmlAttr.align));
    }

    public DTr setHtmlAlign(String align) {
        this.setHtmlAttribute(EHtmlAttr.align, align);
        return this;
    }

    public String getHtmlBgColor() {
        return this.getHtmlAttribute(EHtmlAttr.bgcolor);
    }

    public DTr setHtmlBgColor(String bgColor) {
        this.setHtmlAttribute(EHtmlAttr.bgcolor, bgColor);
        return this;
    }

    public String getHtmlCh() {
        return Util.getHtmlCh(this);
    }

    public DTr setHtmlCh(String _char) {
        Util.setHtmlCh(this, _char);
        return this;
    }

    public String getHtmlChOff() {
        return this.getHtmlAttribute(EHtmlAttr.charoff);
    }

    public DTr setHtmlChOff(String charoff) {
        this.setHtmlAttribute(EHtmlAttr.charoff, charoff);
        return this;
    }

    public String getHtmlValign() {
        return this.capitalize(this.getHtmlAttribute(EHtmlAttr.valign));
    }

    public DTr setHtmlValign(String valign) {
        this.setHtmlAttribute(EHtmlAttr.valign, valign);
        return this;
    }

    @Override
    public String toString() {
        return String.valueOf(super.toString()) + Z.fmt((String)"align", (Object)this.getHtmlAlign()) + Z.fmt((String)"bgcolor", (Object)this.getHtmlBgColor()) + Z.fmt((String)ALIGN_CHAR, (Object)this.getHtmlCh()) + Z.fmt((String)"charoff", (Object)this.getHtmlChOff()) + Z.fmt((String)"rowindex", (Object)("" + this.getHtmlRowIndex())) + Z.fmt((String)"sectionrowindex", (Object)("" + this.getHtmlSectionRowIndex())) + Z.fmt((String)"valign", (Object)this.getHtmlValign());
    }

    public Object clone() throws CloneNotSupportedException {
        DTr clonedNode = (DTr)((Object)super.clone());
        clonedNode.m_cells = null;
        return clonedNode;
    }

    public DTr add(DNode newChild) throws DOMException {
        super.add(newChild);
        return this;
    }

    public DTr add(DTd ... elems) throws DOMException {
        super.add(elems);
        return this;
    }

    public DTr add(String value) throws DOMException {
        super.add(value);
        return this;
    }

    public DTr addRaw(String value) throws DOMException {
        super.addRaw(value);
        return this;
    }

    public DTr dsfAccept(IDNodeVisitor visitor) {
        super.dsfAccept(visitor);
        return this;
    }

    public DTr dsfBroadcast(DsfEvent event) throws AbortDsfEventProcessingException {
        super.dsfBroadcast(event);
        return this;
    }

    public DTr setDsfRelationshipVerifier(IDNodeRelationshipVerifier relationshipVerifier) {
        super.setDsfRelationshipVerifier(relationshipVerifier);
        return this;
    }

    public DTr cloned() {
        return (DTr)((Object)super.cloned());
    }

    public DTr setDsfNamespace(DNamespace namespace) {
        super.setDsfNamespace(namespace);
        return this;
    }

    @Override
    public DTr setHtmlAccessKey(String accessKey) {
        super.setHtmlAccessKey(accessKey);
        return this;
    }

    @Override
    public DTr setHtmlClassName(String className) {
        super.setHtmlClassName(className);
        return this;
    }

    @Override
    public DTr setHtmlClassName(CssClassConstant ccc) {
        super.setHtmlClassName(ccc);
        return this;
    }

    @Override
    public DTr setHtmlContentEditable(String editable) {
        super.setHtmlContentEditable(editable);
        return this;
    }

    @Override
    public DTr setHtmlContextMenu(String contextMenu) {
        super.setHtmlContextMenu(contextMenu);
        return this;
    }

    @Override
    public DTr setHtmlDir(String dir) {
        super.setHtmlDir(dir);
        return this;
    }

    @Override
    public DTr setHtmlDraggable(String draggable) {
        super.setHtmlDraggable(draggable);
        return this;
    }

    @Override
    public DTr setHtmlDraggable(boolean draggable) {
        super.setHtmlDraggable(draggable);
        return this;
    }

    @Override
    public DTr setHtmlHidden(String hidden) {
        super.setHtmlHidden(hidden);
        return this;
    }

    @Override
    public DTr setHtmlHidden(boolean hidden) {
        super.setHtmlHidden(hidden);
        return this;
    }

    @Override
    public DTr setHtmlId(String id) {
        super.setHtmlId(id);
        return this;
    }

    @Override
    public DTr setHtmlId(CssIdConstant id) {
        super.setHtmlId(id);
        return this;
    }

    @Override
    public DTr setHtmlItem(String item) {
        super.setHtmlItem(item);
        return this;
    }

    @Override
    public DTr setHtmlItemProp(String itemProp) {
        super.setHtmlItemProp(itemProp);
        return this;
    }

    @Override
    public DTr setHtmlLang(String lang) {
        super.setHtmlLang(lang);
        return this;
    }

    @Override
    public DTr setHtmlSpellCheck(String spellCheck) {
        super.setHtmlSpellCheck(spellCheck);
        return this;
    }

    @Override
    public DTr setHtmlSpellCheck(boolean spellCheck) {
        super.setHtmlSpellCheck(spellCheck);
        return this;
    }

    @Override
    public DTr setHtmlStyleAsString(String styleString) {
        super.setHtmlStyleAsString(styleString);
        return this;
    }

    @Override
    public DTr setHtmlStyle(CSSStyleDeclaration style) {
        super.setHtmlStyle(style);
        return this;
    }

    @Override
    public DTr setHtmlSubject(String subject) {
        super.setHtmlSubject(subject);
        return this;
    }

    @Override
    public DTr setHtmlTabIndex(String tabIndex) {
        super.setHtmlTabIndex(tabIndex);
        return this;
    }

    @Override
    public DTr setHtmlTabIndex(int tabIndex) {
        super.setHtmlTabIndex(tabIndex);
        return this;
    }

    @Override
    public DTr setHtmlTitle(String title) {
        super.setHtmlTitle(title);
        return this;
    }

    @Override
    public DTr setHtmlOnAbort(String script) {
        super.setHtmlOnAbort(script);
        return this;
    }

    @Override
    public DTr setHtmlOnBlur(String onBlur) {
        super.setHtmlOnBlur(onBlur);
        return this;
    }

    @Override
    public DTr setHtmlOnCanPlay(String script) {
        super.setHtmlOnCanPlay(script);
        return this;
    }

    @Override
    public DTr setHtmlOnCanPlayThrough(String script) {
        super.setHtmlOnCanPlayThrough(script);
        return this;
    }

    @Override
    public DTr setHtmlOnChange(String script) {
        super.setHtmlOnChange(script);
        return this;
    }

    @Override
    public DTr setHtmlOnClick(String script) {
        super.setHtmlOnClick(script);
        return this;
    }

    @Override
    public DTr setHtmlOnContextMenu(String script) {
        super.setHtmlOnContextMenu(script);
        return this;
    }

    @Override
    public DTr setHtmlOnDblClick(String script) {
        super.setHtmlOnDblClick(script);
        return this;
    }

    @Override
    public DTr setHtmlOnDrag(String script) {
        super.setHtmlOnDrag(script);
        return this;
    }

    @Override
    public DTr setHtmlOnDragEnd(String script) {
        super.setHtmlOnDragEnd(script);
        return this;
    }

    @Override
    public DTr setHtmlOnDragEnter(String script) {
        super.setHtmlOnDragEnter(script);
        return this;
    }

    @Override
    public DTr setHtmlOnDragLeave(String script) {
        super.setHtmlOnDragLeave(script);
        return this;
    }

    @Override
    public DTr setHtmlOnDragOver(String script) {
        super.setHtmlOnDragOver(script);
        return this;
    }

    @Override
    public DTr setHtmlOnDragStart(String script) {
        super.setHtmlOnDragStart(script);
        return this;
    }

    @Override
    public DTr setHtmlOnDrop(String script) {
        super.setHtmlOnDrop(script);
        return this;
    }

    @Override
    public DTr setHtmlOnDurationChange(String script) {
        super.setHtmlOnDurationChange(script);
        return this;
    }

    @Override
    public DTr setHtmlOnEmptied(String script) {
        super.setHtmlOnEmptied(script);
        return this;
    }

    @Override
    public DTr setHtmlOnEnded(String script) {
        super.setHtmlOnEnded(script);
        return this;
    }

    @Override
    public DTr setHtmlOnError(String script) {
        super.setHtmlOnError(script);
        return this;
    }

    @Override
    public DTr setHtmlOnFocus(String script) {
        super.setHtmlOnFocus(script);
        return this;
    }

    @Override
    public DTr setHtmlOnFormChange(String script) {
        super.setHtmlOnFormChange(script);
        return this;
    }

    @Override
    public DTr setHtmlOnFormInput(String script) {
        super.setHtmlOnFormInput(script);
        return this;
    }

    @Override
    public DTr setHtmlOnInput(String script) {
        super.setHtmlOnInput(script);
        return this;
    }

    @Override
    public DTr setHtmlOnInvalid(String script) {
        super.setHtmlOnInvalid(script);
        return this;
    }

    @Override
    public DTr setHtmlOnKeyDown(String script) {
        super.setHtmlOnKeyDown(script);
        return this;
    }

    @Override
    public DTr setHtmlOnKeyPress(String script) {
        super.setHtmlOnKeyPress(script);
        return this;
    }

    @Override
    public DTr setHtmlOnKeyUp(String script) {
        super.setHtmlOnKeyUp(script);
        return this;
    }

    @Override
    public DTr setHtmlOnLoad(String script) {
        super.setHtmlOnLoad(script);
        return this;
    }

    @Override
    public DTr setHtmlOnLoadedData(String script) {
        super.setHtmlOnLoadedData(script);
        return this;
    }

    @Override
    public DTr setHtmlOnLoadedMetadata(String script) {
        super.setHtmlOnLoadedMetadata(script);
        return this;
    }

    @Override
    public DTr setHtmlOnLoadStart(String script) {
        super.setHtmlOnLoadStart(script);
        return this;
    }

    @Override
    public DTr setHtmlOnMouseDown(String script) {
        super.setHtmlOnMouseDown(script);
        return this;
    }

    @Override
    public DTr setHtmlOnMouseMove(String script) {
        super.setHtmlOnMouseMove(script);
        return this;
    }

    @Override
    public DTr setHtmlOnMouseOut(String script) {
        super.setHtmlOnMouseOut(script);
        return this;
    }

    @Override
    public DTr setHtmlOnMouseOver(String script) {
        super.setHtmlOnMouseOver(script);
        return this;
    }

    @Override
    public DTr setHtmlOnMouseUp(String script) {
        super.setHtmlOnMouseUp(script);
        return this;
    }

    @Override
    public DTr setHtmlOnMouseWheel(String script) {
        super.setHtmlOnMouseWheel(script);
        return this;
    }

    @Override
    public DTr setHtmlOnPause(String script) {
        super.setHtmlOnPause(script);
        return this;
    }

    @Override
    public DTr setHtmlOnPlay(String script) {
        super.setHtmlOnPlay(script);
        return this;
    }

    @Override
    public DTr setHtmlOnPlaying(String script) {
        super.setHtmlOnPlaying(script);
        return this;
    }

    @Override
    public DTr setHtmlOnProgress(String script) {
        super.setHtmlOnProgress(script);
        return this;
    }

    @Override
    public DTr setHtmlOnRateChange(String script) {
        super.setHtmlOnRateChange(script);
        return this;
    }

    @Override
    public DTr setHtmlOnReadyStateChange(String script) {
        super.setHtmlOnReadyStateChange(script);
        return this;
    }

    @Override
    public DTr setHtmlOnScroll(String script) {
        super.setHtmlOnScroll(script);
        return this;
    }

    @Override
    public DTr setHtmlOnSeeked(String script) {
        super.setHtmlOnSeeked(script);
        return this;
    }

    @Override
    public DTr setHtmlOnSeeking(String script) {
        super.setHtmlOnSeeking(script);
        return this;
    }

    @Override
    public DTr setHtmlOnSelect(String script) {
        super.setHtmlOnSelect(script);
        return this;
    }

    @Override
    public DTr setHtmlOnShow(String script) {
        super.setHtmlOnShow(script);
        return this;
    }

    @Override
    public DTr setHtmlOnStalled(String script) {
        super.setHtmlOnStalled(script);
        return this;
    }

    @Override
    public DTr setHtmlOnSubmit(String script) {
        super.setHtmlOnSubmit(script);
        return this;
    }

    @Override
    public DTr setHtmlOnSuspend(String script) {
        super.setHtmlOnSuspend(script);
        return this;
    }

    @Override
    public DTr setHtmlOnTimeUpdate(String script) {
        super.setHtmlOnTimeUpdate(script);
        return this;
    }

    @Override
    public DTr setHtmlOnVolumeChange(String script) {
        super.setHtmlOnVolumeChange(script);
        return this;
    }

    @Override
    public DTr setHtmlOnWaiting(String script) {
        super.setHtmlOnWaiting(script);
        return this;
    }

    @Override
    public DTr add(EventType eventType, ISimpleJsEventHandler handler) {
        super.add(eventType, handler);
        return this;
    }

    @Override
    public DTr add(EventType eventType, IJsFunc func) {
        super.add(eventType, func);
        return this;
    }

    @Override
    public DTr add(EventType eventType, String jsText) {
        super.add(eventType, jsText);
        return this;
    }

    @Override
    public DTr addBr() {
        super.addBr();
        return this;
    }

    @Override
    public DTr addBr(int howMany) {
        super.addBr(howMany);
        return this;
    }

    @Override
    public DTr addHtmlClassName(String className) {
        super.addHtmlClassName(className);
        return this;
    }

    @Override
    public DTr addHtmlClassName(CssClassConstant ccc) {
        super.addHtmlClassName(ccc);
        return this;
    }

    @Override
    public DTr jif(String jif) {
        super.jif(jif);
        return this;
    }

    public DTd _td() {
        return this._td(-1);
    }

    public DTd _td(int count) {
        return (DTd)((Object)this.getOrCreate(DTd.class, count));
    }

    public DTh _th() {
        return this._th(-1);
    }

    public DTh _th(int count) {
        return (DTh)((Object)this.getOrCreate(DTh.class, count));
    }

    public DTh _th(String textValue) {
        return this._th().setHtmlExtTextValue(textValue);
    }
}

