/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.html.events;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.vjet.dsf.dom.DElement;
import org.eclipse.vjet.dsf.html.dom.DBody;
import org.eclipse.vjet.dsf.html.dom.HtmlTypeEnum;
import org.eclipse.vjet.dsf.html.events.DsfEventTarget;
import org.eclipse.vjet.dsf.html.events.IDomEventType;
import org.eclipse.vjet.dsf.html.events.IDomType;
import org.eclipse.vjet.dsf.html.events.ISimpleJsEventHandler;

public class EventHandlerContainer {
    private Map<DsfEventTarget, List<EventsToHandlerPair>> m_targets;
    private Map<DsfEventTarget, List<EventsToHandlerPair>> m_elementsAttached;

    private EventsToHandlerPair getPair(DsfEventTarget elem, ISimpleJsEventHandler handler) {
        List<EventsToHandlerPair> list = this.getElements().get(elem);
        for (EventsToHandlerPair pair : list) {
            if (pair.getHandler() != handler) continue;
            return pair;
        }
        return null;
    }

    public void add(String elementId, IDomEventType event, ISimpleJsEventHandler handler) {
        DsfEventTarget target = this.getTarget(elementId);
        if (target == null) {
            target = new DsfEventTarget();
            target.setId(elementId);
        }
        this.add(target, event, handler);
    }

    public void add(DElement elem, IDomEventType event, ISimpleJsEventHandler handler) {
        if (elem instanceof DBody) {
            this.add(HtmlTypeEnum.BODY.getName(), event, handler);
            return;
        }
        DsfEventTarget target = this.getTarget(elem);
        if (target == null) {
            target = new DsfEventTarget();
            target.setElem(elem);
        }
        this.add(target, event, handler);
    }

    public void add(IDomType elem, IDomEventType event, ISimpleJsEventHandler handler) {
        if (HtmlTypeEnum.BODY.equals(elem)) {
            this.add(HtmlTypeEnum.BODY.getName(), event, handler);
            return;
        }
        DsfEventTarget target = this.getTarget(elem);
        if (target == null) {
            target = new DsfEventTarget();
            target.setType(elem);
        }
        this.add(target, event, handler);
    }

    private void add(DsfEventTarget elem, IDomEventType eventType, ISimpleJsEventHandler handler) {
        EventsToHandlerPair newPair = new EventsToHandlerPair(eventType, handler);
        if (this.getElements().containsKey(elem)) {
            if (this.getPair(elem, handler) == null) {
                this.getElements().get(elem).add(newPair);
            }
        } else {
            ArrayList<EventsToHandlerPair> pairs = new ArrayList<EventsToHandlerPair>(3);
            pairs.add(newPair);
            this.getElements().put(elem, pairs);
        }
    }

    public void addForAttached(String elementId, IDomEventType event, ISimpleJsEventHandler handler) {
        DsfEventTarget target = new DsfEventTarget();
        target.setId(elementId);
        this.addForAttached(target, event, handler);
    }

    public void addForAttached(DElement elem, IDomEventType event, ISimpleJsEventHandler handler) {
        DsfEventTarget target = new DsfEventTarget();
        target.setElem(elem);
        this.addForAttached(target, event, handler);
    }

    public void addForAttached(IDomType elem, IDomEventType event, ISimpleJsEventHandler handler) {
        DsfEventTarget target = new DsfEventTarget();
        target.setType(elem);
        this.addForAttached(target, event, handler);
    }

    private void addForAttached(DsfEventTarget elem, IDomEventType event, ISimpleJsEventHandler handler) {
        if (this.getElementsAttached().containsKey(elem)) {
            if (this.getPair(elem, handler) == null) {
                this.getElementsAttached().get(elem).add(new EventsToHandlerPair(event, handler));
            }
        } else {
            ArrayList<EventsToHandlerPair> pairs = new ArrayList<EventsToHandlerPair>(3);
            pairs.add(new EventsToHandlerPair(event, handler));
            this.getElementsAttached().put(elem, pairs);
        }
    }

    public int size() {
        if (this.m_targets == null) {
            return 0;
        }
        return this.m_targets.size();
    }

    public boolean removeHandler(DElement elem, ISimpleJsEventHandler handler) {
        return this.removeHandler(this.getTarget(elem), handler);
    }

    public boolean removeHandler(String elem, ISimpleJsEventHandler handler) {
        return this.removeHandler(this.getTarget(elem), handler);
    }

    public boolean removeHandler(IDomType elem, ISimpleJsEventHandler handler) {
        return this.removeHandler(this.getTarget(elem), handler);
    }

    private boolean removeHandler(DsfEventTarget elem, ISimpleJsEventHandler handler) {
        if (!this.getElements().containsKey(elem)) {
            return false;
        }
        EventsToHandlerPair pair = this.getPair(elem, handler);
        if (pair == null) {
            return false;
        }
        return this.getElements().get(elem).remove(pair);
    }

    public void reset() {
        this.m_elementsAttached = null;
        this.m_targets = null;
    }

    public void removeHandlers(String elem, IDomEventType event) {
        this.removeHandlers(this.getTarget(elem), event);
    }

    public void removeHandlers(DElement elem, IDomEventType event) {
        this.removeHandlers(this.getTarget(elem), event);
    }

    public void removeHandlers(IDomType elem, IDomEventType event) {
        this.removeHandlers(this.getTarget(elem), event);
    }

    public void removeHandlers(DsfEventTarget elem, IDomEventType event) {
        if (elem == null) {
            return;
        }
        if (!this.getElements().containsKey(elem)) {
            return;
        }
        List<EventsToHandlerPair> list = this.getElements().get(elem);
        int len = list.size();
        int i = 0;
        while (i < len) {
            EventsToHandlerPair pair = list.get(i);
            if (pair.getEventType().equals(event)) {
                this.getElements().get(elem).remove(i);
                --i;
                --len;
            }
            ++i;
        }
    }

    public Iterable<EventsToHandlerPair> iterable(DElement elem) {
        return this.getElements().get(this.getTarget(elem));
    }

    public Map<DsfEventTarget, List<EventsToHandlerPair>> getElements() {
        if (this.m_targets == null) {
            this.m_targets = new LinkedHashMap<DsfEventTarget, List<EventsToHandlerPair>>(0);
        }
        return this.m_targets;
    }

    public Map<DsfEventTarget, List<EventsToHandlerPair>> getElementsAttached() {
        if (this.m_elementsAttached == null) {
            this.m_elementsAttached = new LinkedHashMap<DsfEventTarget, List<EventsToHandlerPair>>(0);
        }
        return this.m_elementsAttached;
    }

    public String toString() {
        if (this.getElements().isEmpty()) {
            return "No event handlers for this element";
        }
        StringBuilder buffer = new StringBuilder();
        return buffer.toString();
    }

    public int getNumOfHandlers(DElement elem) {
        return this.getNumOfHandlers(this.getTarget(elem));
    }

    public int getNumOfHandlers(String elem) {
        return this.getNumOfHandlers(this.getTarget(elem));
    }

    public int getNumOfHandlers(DsfEventTarget elem) {
        int num = 0;
        if (this.getElements().get(elem) != null) {
            num += this.getElements().get(elem).size();
        }
        if (this.getElementsAttached().get(elem) != null) {
            num += this.getElementsAttached().get(elem).size();
        }
        return num;
    }

    private DsfEventTarget getTarget(DElement elem) {
        DsfEventTarget target = null;
        for (DsfEventTarget tmp : this.getElements().keySet()) {
            if (tmp.getElem() == null || !tmp.getElem().equals(elem)) continue;
            target = tmp;
            break;
        }
        return target;
    }

    private DsfEventTarget getTarget(String elem) {
        DsfEventTarget target = null;
        for (DsfEventTarget tmp : this.getElements().keySet()) {
            if (tmp.getId() == null || !tmp.getId().equals(elem)) continue;
            target = tmp;
            break;
        }
        return target;
    }

    private DsfEventTarget getTarget(IDomType elem) {
        DsfEventTarget target = null;
        for (DsfEventTarget tmp : this.getElements().keySet()) {
            if (tmp.getType() == null || !tmp.getType().equals(elem)) continue;
            target = tmp;
            break;
        }
        return target;
    }

    public static class EventsToHandlerPair {
        private final IDomEventType m_eventType;
        private final ISimpleJsEventHandler m_handler;

        public EventsToHandlerPair(IDomEventType event, ISimpleJsEventHandler handler) {
            this.m_eventType = event;
            this.m_handler = handler;
        }

        public IDomEventType getEventType() {
            return this.m_eventType;
        }

        public ISimpleJsEventHandler getHandler() {
            return this.m_handler;
        }

        public String toString() {
            return String.valueOf(this.getEventType().toString()) + " -> " + this.getHandler().asJsHandler();
        }
    }
}

