/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.common.binding;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.WeakHashMap;
import org.eclipse.vjet.dsf.common.exceptions.DsfRuntimeException;

public final class PropertyHelper {
    private static final WeakHashMap<Object, Object> s_descriptors = new WeakHashMap();
    private static final Object[] empty = new Object[0];

    public static Object get(Object target, String name) {
        if (name == null) {
            throw new NullPointerException();
        }
        PropertyDescriptor pd = PropertyHelper.getPropertyDescriptor(target.getClass(), name);
        if (pd == null) {
            return null;
        }
        try {
            Method readMethod = pd.getReadMethod();
            if (readMethod != null) {
                return readMethod.invoke(target, empty);
            }
            throw new IllegalArgumentException(name);
        }
        catch (IllegalAccessException e) {
            PropertyHelper.chuck(e.getMessage());
        }
        catch (InvocationTargetException e) {
            PropertyHelper.chuck(e.getTargetException().getMessage());
        }
        return null;
    }

    public static Object put(Object target, String name, Object value) {
        if (name == null) {
            throw new NullPointerException();
        }
        PropertyDescriptor pd = PropertyHelper.getPropertyDescriptor(target.getClass(), name);
        if (pd == null) {
            return null;
        }
        try {
            Method writeMethod;
            Object result = null;
            Method readMethod = pd.getReadMethod();
            if (readMethod != null) {
                result = readMethod.invoke(target, empty);
            }
            if ((writeMethod = pd.getWriteMethod()) == null) {
                throw new IllegalArgumentException();
            }
            writeMethod.invoke(target, value);
            return result;
        }
        catch (IllegalAccessException e) {
            PropertyHelper.chuck(e.getMessage());
        }
        catch (InvocationTargetException e) {
            PropertyHelper.chuck(e.getTargetException().getMessage());
        }
        return null;
    }

    private static void chuck(String message) {
        throw new DsfRuntimeException(message);
    }

    private static PropertyDescriptor getPropertyDescriptor(Class clz, String name) {
        PropertyDescriptor[] pd = PropertyHelper.getPropertyDescriptors(clz);
        int i = 0;
        while (i < pd.length) {
            if (name.equals(pd[i].getName())) {
                return pd[i];
            }
            ++i;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static PropertyDescriptor[] getPropertyDescriptors(Class clz) {
        WeakHashMap<Object, Object> weakHashMap = s_descriptors;
        synchronized (weakHashMap) {
            PropertyDescriptor[] pd = (PropertyDescriptor[])s_descriptors.get(clz);
            if (pd == null) {
                try {
                    pd = Introspector.getBeanInfo(clz).getPropertyDescriptors();
                }
                catch (IntrospectionException e) {
                    PropertyHelper.chuck(e.getMessage());
                }
                s_descriptors.put(clz, pd);
            }
            return pd;
        }
    }
}

