/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.common.naming;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.vjet.dsf.common.DsfVerifierConfig;
import org.eclipse.vjet.dsf.common.naming.DsfInvalidNameException;
import org.eclipse.vjet.dsf.common.naming.IDsfId;

public final class DElementId
implements IDsfId {
    private static final long serialVersionUID = 1L;
    private static final Pattern s_pattern = Pattern.compile("[^\\w]*");
    private String m_shortName = "";
    private String m_longName = "";
    private IDsfId.Mode m_idMode = SINGLE;
    private int m_counter;

    public DElementId(String name) {
        this.assertStandardId(name);
        this.setShortName(name);
        this.setLongName(name);
    }

    public DElementId(String longName, String shortName, IDsfId.Mode mode) {
        this.assertStandardId(longName);
        this.assertStandardId(shortName);
        this.setShortName(shortName);
        this.setLongName(longName);
        this.m_idMode = mode;
        if (this.m_idMode.equals(MULTIPLE)) {
            this.m_counter = 0;
        }
    }

    public DElementId(String name, IDsfId.Mode mode) {
        this.assertStandardId(name);
        this.m_shortName = name;
        this.m_longName = name;
        this.m_idMode = mode;
        if (this.m_idMode.equals(MULTIPLE)) {
            this.m_counter = 0;
        }
    }

    @Override
    public void assertStandardId(String s) {
        Matcher m;
        boolean b;
        if (!DsfVerifierConfig.getInstance().isVerifyNaming()) {
            return;
        }
        if (s.indexOf("\\") != -1) {
            this.chuckInvalidNameException("Not a valid id - " + s + "\n dom id attributes can not contain backslashes. ");
        }
        if (s.indexOf("_") != -1) {
            this.chuckInvalidNameException("Not a valid id - " + s + " dom id attributes can not have underscore values. ");
        }
        if (s.indexOf("-") != -1) {
            this.chuckInvalidNameException("Not a valid id - " + s + " dom id attributes can not have hyphen in the id. ");
        }
        if (s.indexOf("#") != -1) {
            this.chuckInvalidNameException("Not a valid id - " + s + " dom id attributes can not contain hash symbols (#) values. " + "Conflicts with CSS and anchors ");
        }
        if (s.indexOf(":") != -1) {
            this.chuckInvalidNameException("Not a valid id - " + s + " dom id attributes can not contain colons (:). " + "Conflicts with CSS 1 id selectors ");
        }
        if (b = (m = s_pattern.matcher(s)).matches()) {
            throw new DsfInvalidNameException("Not a valid id - " + s + " dom  - special characters are not allowed.");
        }
    }

    @Override
    public String getLongName() {
        String longName = this.m_longName;
        if (this.m_idMode.equals(MULTIPLE)) {
            longName = String.valueOf(longName) + this.m_counter;
        }
        return longName;
    }

    @Override
    public String getShortName() {
        String shortName = this.m_shortName;
        if (this.m_idMode.equals(MULTIPLE)) {
            shortName = String.valueOf(shortName) + this.m_counter;
        }
        return shortName;
    }

    public DElementId next() {
        ++this.m_counter;
        return this;
    }

    @Override
    public String toString() {
        return this.m_shortName;
    }

    @Override
    public IDsfId.Mode getIdMode() {
        return this.m_idMode;
    }

    @Override
    public void setIdMode(IDsfId.Mode string) {
        this.m_idMode = string;
    }

    @Override
    public void setLongName(String string) {
        this.m_longName = string;
    }

    @Override
    public void setShortName(String string) {
        this.m_shortName = string;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (DElementId.class.isInstance(obj)) {
            DElementId id = (DElementId)obj;
            return this.getLongName().equals(id.getLongName()) && this.getShortName().equals(id.getShortName());
        }
        if (String.class.isInstance(obj)) {
            return this.getLongName().equals((String)obj) || this.getShortName().equals((String)obj);
        }
        return false;
    }

    private void chuckInvalidNameException(String msg) {
        throw new DsfInvalidNameException(msg);
    }

    public DElementId clone() throws CloneNotSupportedException {
        DElementId cloned = (DElementId)super.clone();
        return cloned;
    }
}

