/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.dom.util;

import java.io.IOException;
import java.io.StringWriter;
import java.util.Set;
import org.eclipse.vjet.dsf.common.Z;
import org.eclipse.vjet.dsf.common.exceptions.DsfRuntimeException;
import org.eclipse.vjet.dsf.common.node.IAttributeMap;
import org.eclipse.vjet.dsf.common.trace.TraceCtx;
import org.eclipse.vjet.dsf.common.xml.IIndenter;
import org.eclipse.vjet.dsf.common.xml.IXmlStreamWriter;
import org.eclipse.vjet.dsf.common.xml.XmlStreamException;
import org.eclipse.vjet.dsf.dom.DAttr;
import org.eclipse.vjet.dsf.dom.DCDATASection;
import org.eclipse.vjet.dsf.dom.DComment;
import org.eclipse.vjet.dsf.dom.DDocument;
import org.eclipse.vjet.dsf.dom.DDocumentType;
import org.eclipse.vjet.dsf.dom.DElement;
import org.eclipse.vjet.dsf.dom.DEntity;
import org.eclipse.vjet.dsf.dom.DEntityReference;
import org.eclipse.vjet.dsf.dom.DNode;
import org.eclipse.vjet.dsf.dom.DNotation;
import org.eclipse.vjet.dsf.dom.DProcessingInstruction;
import org.eclipse.vjet.dsf.dom.DRawString;
import org.eclipse.vjet.dsf.dom.DText;
import org.eclipse.vjet.dsf.dom.support.DNamespace;
import org.eclipse.vjet.dsf.dom.util.DomWriterCtx;
import org.eclipse.vjet.dsf.dom.util.ILineLocateIndenter;
import org.eclipse.vjet.dsf.dom.util.XmlWriterHelper;
import org.eclipse.vjet.dsf.html.dom.util.HtmlNSHelper;
import org.eclipse.vjet.dsf.html.dom.util.IChildIntercepter;
import org.eclipse.vjet.dsf.html.dom.util.INodeEmitter;
import org.eclipse.vjet.dsf.html.dom.util.IRawSaxHandler;
import org.eclipse.vjet.dsf.html.dom.util.ISelfRender;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class BaseDomWriter
implements IRawSaxHandler,
IChildIntercepter {
    public static final String START_LINE = "dsfSL";
    public static final String END_LINE = "dsfEL";
    protected static char[][] s_attribute_names_as_chars;
    protected DDocument localtmpDoc;
    protected ILineLocateIndenter m_lineLocator;
    protected String m_elementStartLineNum;
    private IXmlStreamWriter m_writer;
    private DomWriterCtx m_writerCtx;

    protected BaseDomWriter(IXmlStreamWriter writer) {
        this.m_writer = writer;
    }

    protected BaseDomWriter(IXmlStreamWriter writer, DomWriterCtx ctx) {
        this(writer);
        this.m_writerCtx = ctx;
    }

    @Override
    public void endElement(DElement element) {
        this.addLine(element, false, true);
        try {
            this.m_writer.writeEndElement();
        }
        catch (Exception e) {
            throw new DsfRuntimeException("error writing end tag for '" + element.getTagName() + "'", (Throwable)e);
        }
    }

    @Override
    public boolean genEvents(DElement node, INodeEmitter nodeEmitter, IXmlStreamWriter writer) {
        if (node instanceof ISelfRender) {
            ISelfRender selfRender = (ISelfRender)((Object)node);
            boolean retcode = false;
            retcode = selfRender.render(this, this.m_writer, nodeEmitter);
            if (!retcode) {
                NodeList kids = node.getChildNodes();
                int len = kids.getLength();
                int i = 0;
                while (i < len) {
                    Node childNode = kids.item(i);
                    nodeEmitter.genEvents(childNode, writer);
                    ++i;
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean genDebugEvents(DElement node, INodeEmitter nodeEmitter, IXmlStreamWriter writer) {
        if (node instanceof ISelfRender) {
            TraceCtx.ctx().getInstrumenter().runStartSelfRenderInstrumenters(node, this.m_writer);
            boolean result = this.genEvents(node, nodeEmitter, writer);
            TraceCtx.ctx().getInstrumenter().runEndSelfRenderInstrumenters(node, this.m_writer);
            return result;
        }
        return false;
    }

    @Override
    public void startDocument(DDocument document) {
        if (!this.m_writerCtx.isRenderXmlDoc()) {
            return;
        }
        this.m_writer.writeStartDocument(document.getXmlEncoding(), document.getXmlVersion());
    }

    @Override
    public void endDocument(DDocument document) {
        this.m_writer.writeEndDocument();
    }

    @Override
    public void handleDocType(DDocumentType doctype) {
        Node obj;
        String publicId = doctype.getPublicId();
        String systemId = doctype.getSystemId();
        String internalSubset = doctype.getInternalSubset();
        IIndenter indenter = this.m_writerCtx.getIndenter();
        boolean hasPublic = false;
        this.m_writer.writeRaw("<!DOCTYPE ");
        this.m_writer.writeRaw(doctype.getNodeName());
        if (publicId != null) {
            this.m_writer.writeRaw(" PUBLIC \"");
            this.m_writer.writeRaw(publicId);
            this.m_writer.writeRaw("\"");
            hasPublic = true;
        }
        if (systemId != null) {
            if (!hasPublic) {
                this.m_writer.writeRaw(" SYSTEM");
            }
            this.m_writer.writeRaw(" \"");
            this.m_writer.writeRaw(systemId);
            this.m_writer.writeRaw("\"");
        }
        boolean extraOutput = false;
        if (internalSubset != null && !internalSubset.equals("") || doctype.getEntities().getLength() > 0 || doctype.getNotations().getLength() > 0) {
            extraOutput = true;
        }
        if (!extraOutput) {
            this.m_writer.writeRaw(">");
            return;
        }
        this.m_writer.writeRaw(" [");
        if (internalSubset != null && !internalSubset.equals("")) {
            this.m_writer.writeRaw(Z.NL);
            this.m_writer.writeRaw(doctype.getInternalSubset());
        }
        int len = doctype.getNotations().getLength();
        int i = 0;
        while (i < len) {
            obj = doctype.getNotations().item(i);
            this.handleNotation((DNotation)obj);
            ++i;
        }
        len = doctype.getEntities().getLength();
        i = 0;
        while (i < len) {
            obj = doctype.getEntities().item(i);
            this.handleEntity((DEntity)obj);
            ++i;
        }
        this.m_writer.writeRaw("]");
        this.m_writer.writeRaw(">");
        if (indenter != IIndenter.COMPACT) {
            this.m_writer.writeRaw("\n");
        }
    }

    @Override
    public void startElement(DElement element) {
        this.addLine(element, true, false);
        String tagName = element.getTagName();
        this.m_writer.writeStartElement(tagName);
        if (element.getOwnerDocument() != null && element.getOwnerDocument().getDocumentElement() == element) {
            if (element.getOwnerDocument().getBaseURI() != null) {
                this.m_writer.writeAttribute("xmlns:base", element.getOwnerDocument().getBaseURI());
            }
            Set<DNamespace> nsDecls = ((DDocument)element.getOwnerDocument()).getDsfNamespaceDeclarations();
            for (DNamespace nsObj : nsDecls) {
                this.writeNSAttr(nsObj.getPrefix(), nsObj.getNamespaceKey());
            }
        }
        this.writeAttributes(element);
    }

    @Override
    public void handleNotation(DNotation notation) {
        String entityNodeName = notation.getNodeName();
        String entityPublicId = notation.getPublicId();
        String entitySystemId = notation.getSystemId();
        boolean entityHasPublic = false;
        IIndenter indenter = this.m_writerCtx.getIndenter();
        if (indenter != IIndenter.COMPACT) {
            this.m_writer.writeRaw("\n");
        }
        this.m_writer.writeRaw("<!NOTATION ");
        if (entityNodeName != null) {
            this.m_writer.writeRaw(entityNodeName);
        }
        if (entityPublicId != null) {
            this.m_writer.writeRaw(" PUBLIC \"");
            this.m_writer.writeRaw(entityPublicId);
            this.m_writer.writeRaw("\"");
            entityHasPublic = true;
        }
        if (entitySystemId != null) {
            if (!entityHasPublic) {
                this.m_writer.writeRaw(" SYSTEM");
            }
            this.m_writer.writeRaw(" \"");
            this.m_writer.writeRaw(entitySystemId);
            this.m_writer.writeRaw("\"");
        }
        this.m_writer.writeRaw(">");
    }

    @Override
    public void handleProcessingInstruction(DProcessingInstruction pi) {
        pi.render(null, this.m_writer, null);
    }

    @Override
    public void handleEntity(DEntity entity) {
        String entityNodeName = entity.getNodeName();
        String entityPublicId = entity.getPublicId();
        String entitySystemId = entity.getSystemId();
        String entityNotationName = entity.getNotationName();
        boolean entityHasPublic = false;
        IIndenter indenter = this.m_writerCtx.getIndenter();
        if (indenter != IIndenter.COMPACT) {
            this.m_writer.writeRaw("\n");
        }
        this.m_writer.writeRaw("<!ENTITY ");
        if (entity.isParameterEntity()) {
            this.m_writer.writeRaw("% ");
        }
        if (entityNodeName != null) {
            this.m_writer.writeRaw(entityNodeName);
        }
        if (entityPublicId != null) {
            this.m_writer.writeRaw(" PUBLIC \"");
            this.m_writer.writeRaw(entityPublicId);
            this.m_writer.writeRaw("\"");
            entityHasPublic = true;
        }
        if (entitySystemId != null) {
            if (!entityHasPublic) {
                this.m_writer.writeRaw(" SYSTEM");
            }
            this.m_writer.writeRaw(" \"");
            this.m_writer.writeRaw(entitySystemId);
            this.m_writer.writeRaw("\"");
        }
        if (entity.hasChildNodes()) {
            this.m_writer.writeRaw(" '");
            NodeList children = entity.getChildNodes();
            int len = children.getLength();
            StringWriter tempWriter = new StringWriter(200);
            int i = 0;
            while (i < len) {
                Node child = children.item(i);
                XmlWriterHelper.write(child, tempWriter, indenter);
                ++i;
            }
            this.m_writer.writeRaw(((Object)tempWriter).toString());
            this.m_writer.writeRaw("'");
        }
        if (entityNotationName != null) {
            this.m_writer.writeRaw(" ");
            this.m_writer.writeRaw(entityNotationName);
        }
        this.m_writer.writeRaw(">");
    }

    @Override
    public void handleEntityReference(DEntityReference reference) {
        this.m_writer.writeRaw("&");
        String data = reference.getNodeName();
        this.m_writer.writeRaw(data);
        this.m_writer.writeRaw(";");
    }

    @Override
    public void handleCData(DCDATASection cdata) {
        this.m_writer.writeCData(cdata.getData());
    }

    @Override
    public void handleComment(DComment comment) {
        this.m_writer.writeComment(comment.getData());
        try {
            this.m_writerCtx.getIndenter().indent(this.m_writerCtx.getWriter(), 0);
        }
        catch (IOException e) {
            throw new DsfRuntimeException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void handleRawString(DRawString rawString) {
        if (this.m_writerCtx.isAddLineNumber()) {
            this.m_writer.writeRaw(this.m_lineLocator.lineNumberText(this.m_writerCtx.isTrimDText() ? rawString.getRawString().getString().trim() : rawString.getRawString().getString()));
        } else {
            this.m_writer.writeRaw(this.m_writerCtx.isTrimDText() ? rawString.getRawString().getString().trim() : rawString.getRawString().getString());
        }
    }

    @Override
    public void handleText(DText text) {
        if (this.m_writerCtx.isAddLineNumber()) {
            this.m_writer.writeCharacters(this.m_lineLocator.lineNumberText(this.m_writerCtx.isTrimDText() ? text.getData().trim() : text.getData()));
        } else {
            this.m_writer.writeCharacters(this.m_writerCtx.isTrimDText() ? text.getData().trim() : text.getData());
        }
    }

    public void flush() throws XmlStreamException {
        this.m_writer.flush();
    }

    protected void addLine(DNode n, boolean bStart, boolean bHasEndTag) {
        if (!this.m_writerCtx.isAddLineNumber()) {
            return;
        }
        if (bStart) {
            this.m_elementStartLineNum = this.m_lineLocator.getLineNumber();
            n.setUserData(START_LINE, this.m_elementStartLineNum, null);
        } else if (bHasEndTag) {
            n.setUserData(END_LINE, this.m_lineLocator.getLineNumber(), null);
        } else {
            n.setUserData(END_LINE, this.m_elementStartLineNum, null);
        }
    }

    protected void writeAttributes(DElement element) throws XmlStreamException {
        if (element == null) {
            return;
        }
        if (element.getDsfNamespace() != null) {
            this.writeNSAttr(element);
        }
        if (!element.hasAttributes()) {
            return;
        }
        IAttributeMap attrs = element.getDsfAttributes();
        for (DAttr attr : attrs) {
            this.m_writer.writeAttribute(attr.getNodeName(), attr.getValue());
        }
    }

    protected void writeNSAttr(DElement element) {
        if (this.m_writerCtx == null || !this.m_writerCtx.isRenderNS()) {
            return;
        }
        this.localtmpDoc = (DDocument)element.getOwnerDocument();
        if (this.localtmpDoc != null && this.localtmpDoc.getDsfNamespaceDeclarations().contains(element.getDsfNamespace())) {
            return;
        }
        String prefix = element.getPrefix();
        if (this.m_writerCtx.isOptimization() && (this.localtmpDoc == null || this.localtmpDoc != null && this.localtmpDoc.getDocumentElement() != element)) {
            DNamespace ns = element.dsfLookupNamespaceURI(prefix);
            if (prefix != null && element.isDsfDefaultNamespace(ns)) {
                return;
            }
            if (ns != null && ns == element.getDsfBaseURI() && element.getParentNode() != null) {
                return;
            }
        }
        if (HtmlNSHelper.isPrefixOnly(element.getDsfNamespace())) {
            return;
        }
        this.writeNSAttr(prefix, element.getNamespaceURI());
    }

    protected void writeNSAttr(String prefix, String uri) {
        if (prefix == null || prefix.equals("xmlns")) {
            this.m_writer.writeAttribute("xmlns", uri);
        } else if (prefix.equals("xml")) {
            this.m_writer.writeAttribute("xml", uri);
        } else {
            this.m_writer.writeAttribute("xmlns:" + prefix, uri);
        }
    }
}

