/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.console.ui.internal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.dltk.mod.console.IScriptExecResult;
import org.eclipse.dltk.mod.console.ScriptConsoleHistory;
import org.eclipse.dltk.mod.console.ScriptConsolePrompt;
import org.eclipse.dltk.mod.console.ui.AnsiColorHelper;
import org.eclipse.dltk.mod.console.ui.IScriptConsoleViewer;
import org.eclipse.dltk.mod.console.ui.ScriptConsole;
import org.eclipse.dltk.mod.console.ui.ScriptConsolePartitioner;
import org.eclipse.dltk.mod.console.ui.internal.ICommandHandler;
import org.eclipse.dltk.mod.console.ui.internal.IScriptConsoleContentHandler;
import org.eclipse.dltk.mod.console.ui.internal.Messages;
import org.eclipse.dltk.mod.core.DLTKCore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.hyperlink.HyperlinkManager;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.console.TextConsole;
import org.eclipse.ui.console.TextConsoleViewer;

public class ScriptConsoleViewer
extends TextConsoleViewer
implements IScriptConsoleViewer {
    private ScriptConsoleHistory history;
    private ScriptConsole console;

    public int getCaretPosition() {
        return this.getTextWidget().getCaretOffset();
    }

    public void enableProcessing() {
        ConsoleDocumentListener listener = this.console.getDocumentListener();
        listener.bEnabled = true;
    }

    public void disableProcessing() {
        ConsoleDocumentListener listener = this.console.getDocumentListener();
        listener.bEnabled = false;
    }

    public void setCaretPosition(final int offset) {
        if (this.getTextWidget() != null) {
            this.getTextWidget().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (ScriptConsoleViewer.this.getTextWidget() != null) {
                        ScriptConsoleViewer.this.getTextWidget().setCaretOffset(offset);
                    }
                }
            });
        }
    }

    public int beginLineOffset() throws BadLocationException {
        IDocument doc = this.getDocument();
        int offset = this.getCaretPosition();
        int line = doc.getLineOfOffset(offset);
        return offset - doc.getLineOffset(line);
    }

    protected boolean isCaretOnLastLine() {
        try {
            IDocument doc = this.getDocument();
            int line = doc.getLineOfOffset(this.getCaretPosition());
            return line == doc.getNumberOfLines() - 1;
        }
        catch (BadLocationException e) {
            e.printStackTrace();
            return false;
        }
    }

    protected StyledText createTextWidget(Composite parent, int styles) {
        return new ScriptConsoleStyledText(parent, styles);
    }

    public ScriptConsoleViewer(Composite parent, final ScriptConsole console, final IScriptConsoleContentHandler contentHandler) {
        super(parent, (TextConsole)console);
        this.console = console;
        this.history = console.getHistory();
        console.getDocumentListener().addViewer(this);
        final StyledText styledText = this.getTextWidget();
        styledText.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                ScriptConsoleViewer.this.setCaretPosition(ScriptConsoleViewer.this.getDocument().getLength());
                styledText.removeFocusListener((FocusListener)this);
            }

            public void focusLost(FocusEvent e) {
            }
        });
        styledText.addVerifyKeyListener(new VerifyKeyListener(){

            public void verifyKey(VerifyEvent event) {
                try {
                    if (event.character != '\u0000') {
                        ConsoleDocumentListener listener = console.getDocumentListener();
                        int selStart = ScriptConsoleViewer.this.getSelectedRange().x;
                        int selEnd = ScriptConsoleViewer.this.getSelectedRange().x + ScriptConsoleViewer.this.getSelectedRange().y;
                        int clOffset = listener.getCommandLineOffset();
                        int clLength = listener.getCommandLineLength();
                        if (selStart < clOffset) {
                            int selLength;
                            if (selEnd < clOffset) {
                                selStart = clOffset + clLength;
                                selLength = 0;
                            } else {
                                selStart = clOffset;
                                selLength = selEnd - selStart;
                            }
                            ScriptConsoleViewer.this.setSelectedRange(selStart, selLength);
                        }
                        if (ScriptConsoleViewer.this.beginLineOffset() < console.getDocumentListener().getLastLineReadOnlySize()) {
                            event.doit = false;
                            return;
                        }
                        if (event.character == '\r') {
                            ScriptConsoleViewer.this.getTextWidget().setCaretOffset(ScriptConsoleViewer.this.getDocument().getLength());
                            return;
                        }
                        if (event.keyCode == 32 && (event.stateMask & 0x40000) > 0) {
                            event.doit = false;
                            return;
                        }
                        if (event.keyCode == 9) {
                            event.doit = false;
                            return;
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        styledText.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 9) {
                    contentHandler.contentAssistRequired();
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        if (console.getDocumentListener().viewerList.size() == 1) {
            this.clear();
        }
    }

    @Override
    public String getCommandLine() {
        try {
            return this.console.getDocumentListener().getCommandLine();
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    @Override
    public int getCommandLineOffset() {
        try {
            return this.console.getDocumentListener().getCommandLineOffset();
        }
        catch (BadLocationException badLocationException) {
            return -1;
        }
    }

    public void clear() {
        this.console.getDocumentListener().clear();
    }

    public void insertText(String text) {
        this.getTextWidget().append(text);
    }

    public boolean canDoOperation(int operation) {
        boolean canDoOperation = super.canDoOperation(operation);
        if (canDoOperation) {
            switch (operation) {
                case 3: 
                case 5: 
                case 6: 
                case 8: 
                case 9: 
                case 11: 
                case 12: {
                    canDoOperation = this.isCaretOnLastLine();
                }
            }
        }
        return canDoOperation;
    }

    public void activatePlugins() {
        this.fHyperlinkManager = new HyperlinkManager(HyperlinkManager.LONGEST_REGION_FIRST);
        this.fHyperlinkManager.install((ITextViewer)this, this.fHyperlinkPresenter, this.fHyperlinkDetectors, this.fHyperlinkStateMask);
        super.activatePlugins();
    }

    public void dispose() {
        this.console.getDocumentListener().removeViewer(this);
    }

    public static class ConsoleDocumentListener
    implements IDocumentListener {
        private boolean bEnabled = true;
        private ICommandHandler handler;
        private ScriptConsolePrompt prompt;
        private ScriptConsoleHistory history;
        private int offset;
        private IDocument doc;
        private AnsiColorHelper ansiHelper = new AnsiColorHelper();
        private List viewerList = new ArrayList();

        private void addViewer(ScriptConsoleViewer viewer) {
            this.viewerList.add(viewer);
        }

        private void removeViewer(ScriptConsoleViewer viewer) {
            this.viewerList.remove(viewer);
        }

        protected void connectListener() {
            this.doc.addDocumentListener((IDocumentListener)this);
        }

        protected void disconnectListener() {
            this.doc.removeDocumentListener((IDocumentListener)this);
        }

        public void clear() {
            try {
                this.disconnectListener();
                this.doc.set("");
                for (ScriptConsoleViewer viewer : this.viewerList) {
                    IDocumentPartitioner partitioner = viewer.getDocument().getDocumentPartitioner();
                    if (!(partitioner instanceof ScriptConsolePartitioner)) continue;
                    ScriptConsolePartitioner scriptConsolePartitioner = (ScriptConsolePartitioner)partitioner;
                    scriptConsolePartitioner.clearRanges();
                }
                this.appendInvitation();
                Iterator iter = this.viewerList.iterator();
                while (iter.hasNext()) {
                    ((ScriptConsoleViewer)iter.next()).setCaretPosition(this.doc.getLength());
                }
                this.connectListener();
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
        }

        public ConsoleDocumentListener(ICommandHandler handler, ScriptConsolePrompt prompt, ScriptConsoleHistory history) {
            this.prompt = prompt;
            this.handler = handler;
            this.history = history;
            this.offset = 0;
            this.doc = null;
        }

        public void setDocument(IDocument doc) {
            if (this.doc != null) {
                this.disconnectListener();
            }
            this.doc = doc;
            if (this.doc != null) {
                this.connectListener();
            }
        }

        public void documentAboutToBeChanged(DocumentEvent event) {
        }

        protected void handleCommandLine() throws BadLocationException, IOException {
            final String command = this.getCommandLine();
            this.ansiHelper.reset();
            this.appendDelimeter();
            Thread handlerThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        final IScriptExecResult result = ConsoleDocumentListener.this.handler.handleCommand(command);
                        if (((ScriptConsole)ConsoleDocumentListener.this.handler).getState() != 2) {
                            ((ScriptConsole)ConsoleDocumentListener.this.handler).getPage().getSite().getShell().getDisplay().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    try {
                                        ConsoleDocumentListener.this.disconnectListener();
                                        ConsoleDocumentListener.this.processResult(result);
                                        ConsoleDocumentListener.this.connectListener();
                                    }
                                    catch (BadLocationException bxcn) {
                                        bxcn.printStackTrace();
                                    }
                                }
                            });
                        }
                    }
                    catch (IOException ixcn) {
                        ixcn.printStackTrace();
                    }
                }
            }, Messages.ScriptConsoleViewer_scriptConsoleCommandHandler);
            handlerThread.setDaemon(true);
            handlerThread.setPriority(1);
            handlerThread.start();
        }

        protected void appendText(String text) throws BadLocationException {
            this.doc.replace(this.doc.getLength(), 0, text);
        }

        protected void processText(int originalOffset, String content, boolean isInput, boolean isError, final boolean shouldReveal, final boolean shouldRedraw) throws BadLocationException {
            if (originalOffset == -1) {
                originalOffset = this.doc.getLength();
            }
            this.ansiHelper.processText(originalOffset, content, isInput, isError, new AnsiColorHelper.IAnsiColorHandler(){

                @Override
                public void handleText(int start, String content, boolean isInput, boolean isError) throws BadLocationException {
                    ConsoleDocumentListener.this.appendText(content);
                    ConsoleDocumentListener.this.addToPartitioner(start, content, isInput, isError);
                }

                @Override
                public void processingComplete(int start, int length) {
                    for (ScriptConsoleViewer viewer : ConsoleDocumentListener.this.viewerList) {
                        if (shouldReveal) {
                            viewer.setCaretPosition(ConsoleDocumentListener.this.doc.getLength());
                            viewer.revealEndOfDocument();
                        }
                        if (!shouldRedraw || viewer.getTextWidget() == null) continue;
                        viewer.getTextWidget().redrawRange(start, length, true);
                    }
                }
            });
        }

        protected void processResult(IScriptExecResult result) throws BadLocationException {
            if (result != null) {
                this.processText(-1, result.getOutput(), false, result.isError(), false, true);
                this.history.commit();
            }
            this.offset = this.getLastLineLength();
            this.appendInvitation();
        }

        private void addToPartitioner(ScriptConsoleViewer viewer, StyleRange style) {
            IDocumentPartitioner partitioner = viewer.getDocument().getDocumentPartitioner();
            if (partitioner instanceof ScriptConsolePartitioner) {
                ScriptConsolePartitioner scriptConsolePartitioner = (ScriptConsolePartitioner)partitioner;
                scriptConsolePartitioner.addRange(style);
                viewer.getTextWidget().redraw();
            }
        }

        protected void addToPartitioner(int start, String content, boolean isInput, boolean isError) {
            StringTokenizer tokenizer = new StringTokenizer(content, " \t\n\r\f@#=|,()[]{}<>'\"", true);
            int tokenStart = start;
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                for (ScriptConsoleViewer viewer : this.viewerList) {
                    if (isInput) {
                        this.addToPartitioner(viewer, new StyleRange(tokenStart, token.length(), AnsiColorHelper.COLOR_BLACK, null, 1));
                        continue;
                    }
                    this.addToPartitioner(viewer, this.ansiHelper.resolveStyleRange(tokenStart, token.length(), isError));
                }
                tokenStart += token.length();
            }
        }

        protected void processAddition(int offset, String text) {
            block6: {
                if (!this.bEnabled) {
                    return;
                }
                try {
                    String delim = TextUtilities.getDefaultLineDelimiter((IDocument)this.doc);
                    text = this.doc.get(offset, this.doc.getLength() - offset);
                    this.doc.replace(offset, text.length(), "");
                    text = text.replaceAll("\r\n|\n|\r", delim);
                    int start = 0;
                    int index = -1;
                    while ((index = text.indexOf(delim, start)) != -1) {
                        String cmd = text.substring(start, index);
                        this.processText(this.getCommandLineOffset(), cmd, true, false, false, true);
                        this.history.update(this.getCommandLine());
                        start = index + delim.length();
                        this.handleCommandLine();
                    }
                    this.processText(-1, text.substring(start, text.length()), true, false, false, true);
                }
                catch (BadLocationException e) {
                    if (DLTKCore.DEBUG) {
                        e.printStackTrace();
                    }
                }
                catch (IOException e) {
                    if (!DLTKCore.DEBUG) break block6;
                    e.printStackTrace();
                }
            }
        }

        public void documentChanged(final DocumentEvent event) {
            this.ansiHelper.disableWhile(new Runnable(){

                @Override
                public void run() {
                    ConsoleDocumentListener.this.disconnectListener();
                    ConsoleDocumentListener.this.processAddition(event.getOffset(), event.getText());
                    ConsoleDocumentListener.this.connectListener();
                }
            });
        }

        public void appendInvitation() throws BadLocationException {
            this.processText(-1, this.prompt.toString(), true, false, true, true);
        }

        public void appendDelimeter() throws BadLocationException {
            this.processText(-1, TextUtilities.getDefaultLineDelimiter((IDocument)this.doc), false, false, false, true);
        }

        protected int getLastLineLength() throws BadLocationException {
            int lastLine = this.doc.getNumberOfLines() - 1;
            return this.doc.getLineLength(lastLine);
        }

        public int getLastLineReadOnlySize() {
            return (((ScriptConsole)this.handler).getState() == 2 ? 0 : this.prompt.toString().length()) + this.offset;
        }

        public int getCommandLineOffset() throws BadLocationException {
            int lastLine = this.doc.getNumberOfLines() - 1;
            return this.doc.getLineOffset(lastLine) + this.getLastLineReadOnlySize();
        }

        public int getCommandLineLength() throws BadLocationException {
            int lastLine = this.doc.getNumberOfLines() - 1;
            return this.doc.getLineLength(lastLine) - this.getLastLineReadOnlySize();
        }

        public String getCommandLine() throws BadLocationException {
            return this.doc.get(this.getCommandLineOffset(), this.getCommandLineLength());
        }

        public void setCommandLine(final String command) {
            this.ansiHelper.disableWhile(new Runnable(){

                @Override
                public void run() {
                    try {
                        ConsoleDocumentListener.this.doc.replace(ConsoleDocumentListener.this.getCommandLineOffset(), ConsoleDocumentListener.this.getCommandLineLength(), command);
                    }
                    catch (BadLocationException bxcn) {
                        bxcn.printStackTrace();
                    }
                }
            });
        }
    }

    private class ScriptConsoleStyledText
    extends StyledText {
        public ScriptConsoleStyledText(Composite parent, int style) {
            super(parent, style | 0x40);
        }

        public void invokeAction(int action) {
            if (ScriptConsoleViewer.this.isCaretOnLastLine()) {
                switch (action) {
                    case 0x1000001: {
                        ScriptConsoleViewer.this.history.prev();
                        ScriptConsoleViewer.this.console.getDocumentListener().setCommandLine(ScriptConsoleViewer.this.history.get());
                        this.setCaretOffset(ScriptConsoleViewer.this.getDocument().getLength());
                        return;
                    }
                    case 0x1000002: {
                        ScriptConsoleViewer.this.history.next();
                        ScriptConsoleViewer.this.console.getDocumentListener().setCommandLine(ScriptConsoleViewer.this.history.get());
                        this.setCaretOffset(ScriptConsoleViewer.this.getDocument().getLength());
                        return;
                    }
                    case 8: {
                        if (this.getCaretOffset() > ScriptConsoleViewer.this.getCommandLineOffset()) break;
                        return;
                    }
                    case 127: {
                        if (this.getCaretOffset() >= ScriptConsoleViewer.this.getCommandLineOffset()) break;
                        return;
                    }
                    case 262152: {
                        return;
                    }
                }
                super.invokeAction(action);
                if (ScriptConsoleViewer.this.isCaretOnLastLine() && this.getCaretOffset() <= ScriptConsoleViewer.this.getCommandLineOffset()) {
                    this.setCaretOffset(ScriptConsoleViewer.this.getCommandLineOffset());
                }
            } else {
                super.invokeAction(action);
            }
        }

        public void superPaste() {
            super.paste();
        }

        public void paste() {
            if (ScriptConsoleViewer.this.isCaretOnLastLine()) {
                ScriptConsoleViewer.this.console.getDocumentListener().ansiHelper.disableWhile(new Runnable(){

                    @Override
                    public void run() {
                        ScriptConsoleStyledText.this.superPaste();
                    }
                });
            }
        }
    }
}

