/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.dbgp.internal.commands;

import java.net.URI;
import java.util.ArrayList;
import org.eclipse.dltk.mod.dbgp.breakpoints.DbgpBreakpointConfig;
import org.eclipse.dltk.mod.dbgp.breakpoints.IDbgpBreakpoint;
import org.eclipse.dltk.mod.dbgp.commands.IDbgpBreakpointCommands;
import org.eclipse.dltk.mod.dbgp.exceptions.DbgpException;
import org.eclipse.dltk.mod.dbgp.internal.DbgpRequest;
import org.eclipse.dltk.mod.dbgp.internal.commands.DbgpBaseCommands;
import org.eclipse.dltk.mod.dbgp.internal.commands.IDbgpCommunicator;
import org.eclipse.dltk.mod.dbgp.internal.utils.DbgpXmlEntityParser;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class DbgpBreakpointCommands
extends DbgpBaseCommands
implements IDbgpBreakpointCommands {
    private static final String BREAKPOINT_SET_COMMAND = "breakpoint_set";
    private static final String BREAKPOINT_GET_COMMAND = "breakpoint_get";
    private static final String BREAKPOINT_UPDATE_COMMAND = "breakpoint_update";
    private static final String BREAKPOINT_REMOVE_COMMAND = "breakpoint_remove";
    private static final String BREAKPOINT_LIST_COMMAND = "breakpoint_list";
    private static final String BREAKPOINT_TAG = "breakpoint";
    final String LINE_BREAKPOINT = "line";
    final String CALL_BREAKPOINT = "call";
    final String RETURN_BREAKPOINT = "return";
    final String EXCEPTION_BREAKPOINT = "exception";
    final String CONDITIONAL_BREAKPOINT = "conditional";
    final String WATCH_BREAKPOINT = "watch";

    protected IDbgpBreakpoint[] parseBreakpointsResponse(Element response) {
        ArrayList<IDbgpBreakpoint> list = new ArrayList<IDbgpBreakpoint>();
        NodeList breakpoints = response.getElementsByTagName(BREAKPOINT_TAG);
        int i = 0;
        while (i < breakpoints.getLength()) {
            list.add(DbgpXmlEntityParser.parseBreakpoint((Element)breakpoints.item(i)));
            ++i;
        }
        return list.toArray(new IDbgpBreakpoint[list.size()]);
    }

    protected String parseSetBreakpointResponse(Element response) throws DbgpException {
        return response.getAttribute("id");
    }

    protected String setBreakpoint(String type, URI uri, Integer lineNumber, String function, String exception, DbgpBreakpointConfig info) throws DbgpException {
        DbgpRequest request = this.createRequest(BREAKPOINT_SET_COMMAND);
        request.addOption("-t", type);
        if (uri != null) {
            request.addOption("-f", uri.toASCIIString());
        }
        if (lineNumber != null) {
            request.addOption("-n", lineNumber.toString());
        }
        if (function != null) {
            request.addOption("-m", function);
        }
        if (exception != null) {
            request.addOption("-x", exception);
        }
        if (info != null) {
            String expression;
            request.addOption("-s", info.getStateString());
            request.addOption("-r", info.getTemporaryString());
            if (info.getHitValue() != -1 && info.getHitCondition() != -1) {
                request.addOption("-h", info.getHitValue());
                request.addOption("-o", info.getHitConditionString());
            }
            if ((expression = info.getExpression()) != null) {
                request.setData(expression);
            }
        }
        return this.parseSetBreakpointResponse(this.communicate(request));
    }

    public DbgpBreakpointCommands(IDbgpCommunicator communicator) {
        super(communicator);
    }

    @Override
    public String setLineBreakpoint(URI uri, int lineNumber, DbgpBreakpointConfig info) throws DbgpException {
        return this.setBreakpoint("line", uri, new Integer(lineNumber), null, null, info);
    }

    @Override
    public String setCallBreakpoint(URI uri, String function, DbgpBreakpointConfig info) throws DbgpException {
        return this.setBreakpoint("call", uri, null, function, null, info);
    }

    @Override
    public String setReturnBreakpoint(URI uri, String function, DbgpBreakpointConfig info) throws DbgpException {
        return this.setBreakpoint("return", uri, null, function, null, info);
    }

    @Override
    public String setExceptionBreakpoint(String exception, DbgpBreakpointConfig info) throws DbgpException {
        return this.setBreakpoint("exception", null, null, null, exception, info);
    }

    @Override
    public String setConditionalBreakpoint(URI uri, DbgpBreakpointConfig info) throws DbgpException {
        return this.setBreakpoint("conditional", uri, null, null, null, info);
    }

    @Override
    public String setConditionalBreakpoint(URI uri, int lineNumber, DbgpBreakpointConfig info) throws DbgpException {
        return this.setBreakpoint("conditional", uri, new Integer(lineNumber), null, null, info);
    }

    @Override
    public String setWatchBreakpoint(URI uri, int line, DbgpBreakpointConfig info) throws DbgpException {
        return this.setBreakpoint("watch", uri, new Integer(line), null, null, info);
    }

    @Override
    public IDbgpBreakpoint getBreakpoint(String id) throws DbgpException {
        DbgpRequest request = this.createRequest(BREAKPOINT_GET_COMMAND);
        request.addOption("-d", id);
        IDbgpBreakpoint[] breakpoints = this.parseBreakpointsResponse(this.communicate(request));
        if (breakpoints.length > 0) {
            return breakpoints[0];
        }
        return null;
    }

    @Override
    public void removeBreakpoint(String id) throws DbgpException {
        if (id == null) {
            return;
        }
        DbgpRequest request = this.createRequest(BREAKPOINT_REMOVE_COMMAND);
        request.addOption("-d", id);
        this.communicate(request);
    }

    @Override
    public void updateBreakpoint(String id, DbgpBreakpointConfig config) throws DbgpException {
        DbgpRequest request = this.createRequest(BREAKPOINT_UPDATE_COMMAND);
        request.addOption("-d", id);
        request.addOption("-s", config.getStateString());
        if (config.getLineNo() > 0) {
            request.addOption("-n", config.getLineNo());
        }
        if (config.getHitValue() != -1) {
            request.addOption("-h", config.getHitValue());
        }
        if (config.getHitCondition() != -1) {
            request.addOption("-o", config.getHitConditionString());
        }
        this.communicate(request);
    }

    @Override
    public IDbgpBreakpoint[] getBreakpoints() throws DbgpException {
        return this.parseBreakpointsResponse(this.communicate(this.createRequest(BREAKPOINT_LIST_COMMAND)));
    }
}

