/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.internal.corext.refactoring.changes;

import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dltk.mod.core.DLTKCore;
import org.eclipse.dltk.mod.core.IProjectFragment;
import org.eclipse.dltk.mod.core.IScriptFolder;
import org.eclipse.dltk.mod.core.ModelException;
import org.eclipse.dltk.mod.internal.corext.refactoring.base.DLTKChange;
import org.eclipse.dltk.mod.internal.corext.refactoring.reorg.INewNameQuery;
import org.eclipse.dltk.mod.internal.ui.model.DLTKElementResourceMapping;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.ReorgExecutionLog;

abstract class ScriptFolderReorgChange
extends DLTKChange {
    private String fPackageHandle;
    private String fDestinationHandle;
    private INewNameQuery fNameQuery;

    ScriptFolderReorgChange(IScriptFolder pack, IProjectFragment dest, INewNameQuery nameQuery) {
        this.fPackageHandle = pack.getHandleIdentifier();
        this.fDestinationHandle = dest.getHandleIdentifier();
        this.fNameQuery = nameQuery;
    }

    abstract Change doPerformReorg(IProgressMonitor var1) throws ModelException;

    public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException {
        return this.isValid(pm, 0);
    }

    public final Change perform(IProgressMonitor pm) throws CoreException {
        pm.beginTask(this.getName(), 1);
        try {
            IScriptFolder pack = this.getPackage();
            ResourceMapping mapping = DLTKElementResourceMapping.create(pack);
            Change result = this.doPerformReorg(pm);
            this.markAsExecuted(pack, mapping);
            Change change = result;
            return change;
        }
        finally {
            pm.done();
        }
    }

    public Object getModifiedElement() {
        return this.getPackage();
    }

    IProjectFragment getDestination() {
        return (IProjectFragment)DLTKCore.create((String)this.fDestinationHandle);
    }

    IScriptFolder getPackage() {
        return (IScriptFolder)DLTKCore.create((String)this.fPackageHandle);
    }

    String getNewName() {
        if (this.fNameQuery == null) {
            return null;
        }
        return this.fNameQuery.getNewName();
    }

    private void markAsExecuted(IScriptFolder pack, ResourceMapping mapping) {
        ReorgExecutionLog log = (ReorgExecutionLog)this.getAdapter(ReorgExecutionLog.class);
        if (log != null) {
            log.markAsProcessed((Object)pack);
            log.markAsProcessed((Object)mapping);
        }
    }
}

