/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.internal.ui.navigator;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.mod.core.DLTKCore;
import org.eclipse.dltk.mod.core.ElementChangedEvent;
import org.eclipse.dltk.mod.core.IModelElement;
import org.eclipse.dltk.mod.core.IModelElementDelta;
import org.eclipse.dltk.mod.core.IProjectFragment;
import org.eclipse.dltk.mod.core.IScriptFolder;
import org.eclipse.dltk.mod.core.IScriptProject;
import org.eclipse.dltk.mod.core.ModelException;
import org.eclipse.dltk.mod.ui.DLTKUIPlugin;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public class ProjectFragmentProvider
implements IPropertyChangeListener {
    private TreeViewer fViewer;
    private boolean fFoldPackages;
    private IPreferenceStore fStore;

    public ProjectFragmentProvider(IPreferenceStore store) {
        this.fStore = store;
        this.fFoldPackages = this.arePackagesFoldedInHierarchicalLayout();
        this.fStore.addPropertyChangeListener((IPropertyChangeListener)this);
    }

    public Object[] getChildren(Object parentElement) {
        block11: {
            try {
                if (parentElement instanceof IFolder) {
                    IResource[] resources = ((IFolder)parentElement).members();
                    return this.filter(this.getFolders(resources)).toArray();
                }
                if (!(parentElement instanceof IModelElement)) break block11;
                IModelElement iModelElement = (IModelElement)parentElement;
                int type = iModelElement.getElementType();
                switch (type) {
                    case 2: {
                        IScriptProject project = (IScriptProject)iModelElement;
                        IProjectFragment root = project.findProjectFragment(project.getPath());
                        if (root != null) {
                            List children = ProjectFragmentProvider.getTopLevelChildren(root);
                            return this.filter(children).toArray();
                        }
                        break;
                    }
                    case 3: {
                        IProjectFragment root = (IProjectFragment)parentElement;
                        if (root.exists()) {
                            return this.filter(ProjectFragmentProvider.getTopLevelChildren(root)).toArray();
                        }
                        break;
                    }
                    case 4: {
                        IScriptFolder scriptFolder = (IScriptFolder)parentElement;
                        if (!scriptFolder.isRootFolder()) {
                            IProjectFragment root = (IProjectFragment)scriptFolder.getParent();
                            List children = ProjectFragmentProvider.getPackageChildren(root, scriptFolder);
                            return this.filter(children).toArray();
                        }
                        break;
                    }
                    default: {
                        break;
                    }
                }
            }
            catch (CoreException e) {
                DLTKUIPlugin.log(e);
            }
        }
        return new Object[0];
    }

    private List filter(List children) throws ModelException {
        if (this.fFoldPackages) {
            int size = children.size();
            int i = 0;
            while (i < size) {
                IScriptFolder collapsed;
                IScriptFolder fragment;
                Object curr = children.get(i);
                if (curr instanceof IScriptFolder && !(fragment = (IScriptFolder)curr).isRootFolder() && this.isEmpty(fragment) && (collapsed = this.getCollapsed(fragment)) != null) {
                    children.set(i, collapsed);
                }
                ++i;
            }
        }
        return children;
    }

    private IScriptFolder getCollapsed(IScriptFolder pack) throws ModelException {
        IModelElement[] children = ((IProjectFragment)pack.getParent()).getChildren();
        IScriptFolder child = ProjectFragmentProvider.getSinglePackageChild(pack, children);
        while (child != null && this.isEmpty(child)) {
            IScriptFolder collapsed = ProjectFragmentProvider.getSinglePackageChild(child, children);
            if (collapsed == null) {
                return child;
            }
            child = collapsed;
        }
        return child;
    }

    private boolean isEmpty(IScriptFolder fragment) throws ModelException {
        return !fragment.containsScriptResources() && fragment.getForeignResources().length == 0;
    }

    private static IScriptFolder getSinglePackageChild(IScriptFolder fragment, IModelElement[] children) {
        String prefix = String.valueOf(fragment.getElementName()) + '.';
        int prefixLen = prefix.length();
        IScriptFolder found = null;
        int i = 0;
        while (i < children.length) {
            IModelElement element = children[i];
            String name = element.getElementName();
            if (name.startsWith(prefix) && name.length() > prefixLen && name.indexOf(46, prefixLen) == -1) {
                if (found == null) {
                    found = (IScriptFolder)element;
                } else {
                    return null;
                }
            }
            ++i;
        }
        return found;
    }

    private static List getPackageChildren(IProjectFragment parent, IScriptFolder fragment) throws ModelException {
        IModelElement[] children = parent.getChildren();
        ArrayList<IModelElement> list = new ArrayList<IModelElement>(children.length);
        String prefix = String.valueOf(fragment.getElementName()) + '.';
        int prefixLen = prefix.length();
        int i = 0;
        while (i < children.length) {
            String name;
            IModelElement element = children[i];
            if (element instanceof IScriptFolder && (name = element.getElementName()).startsWith(prefix) && name.length() > prefixLen && name.indexOf(".", prefixLen) == -1) {
                list.add(element);
            }
            ++i;
        }
        return list;
    }

    private static List getTopLevelChildren(IProjectFragment root) throws ModelException {
        IModelElement[] elements = root.getChildren();
        ArrayList<IModelElement> topLevelElements = new ArrayList<IModelElement>(elements.length);
        int i = 0;
        while (i < elements.length) {
            IModelElement iModelElement = elements[i];
            if (iModelElement instanceof IScriptFolder && iModelElement.getElementName().indexOf(46) == -1) {
                IScriptFolder folder = (IScriptFolder)iModelElement;
                if (!folder.isRootFolder()) {
                    topLevelElements.add(iModelElement);
                } else {
                    IModelElement[] children = folder.getChildren();
                    int j = 0;
                    while (j < children.length) {
                        topLevelElements.add(children[j]);
                        ++j;
                    }
                }
            }
            ++i;
        }
        return topLevelElements;
    }

    private List getFolders(IResource[] resources) throws ModelException {
        ArrayList<IFolder> list = new ArrayList<IFolder>(resources.length);
        int i = 0;
        while (i < resources.length) {
            IFolder folder;
            IProject project;
            IScriptProject scriptProject;
            IResource resource = resources[i];
            if (resource instanceof IFolder && (scriptProject = DLTKCore.create((IProject)(project = (folder = (IFolder)resource).getProject()))) != null && scriptProject.isOnBuildpath((IResource)folder)) {
                list.add(folder);
            }
            ++i;
        }
        return list;
    }

    public Object getParent(Object element) {
        if (element instanceof IScriptFolder) {
            IScriptFolder frag = (IScriptFolder)element;
            return this.filterParent(this.getActualParent(frag));
        }
        return null;
    }

    private Object getActualParent(IScriptFolder fragment) {
        try {
            IModelElement parent;
            if (fragment.exists() && (parent = fragment.getParent()) instanceof IProjectFragment && parent.exists()) {
                IProjectFragment root = (IProjectFragment)parent;
                if (root.isArchive()) {
                    return this.findNextLevelParentByElementName(fragment);
                }
                IResource resource = fragment.getUnderlyingResource();
                if (resource != null && resource instanceof IFolder) {
                    IFolder folder = (IFolder)resource;
                    IContainer res = folder.getParent();
                    IModelElement el = DLTKCore.create((IResource)res);
                    if (el != null) {
                        return el;
                    }
                    return res;
                }
                return parent;
            }
        }
        catch (ModelException e) {
            DLTKUIPlugin.log(e);
        }
        return null;
    }

    private Object filterParent(Object parent) {
        if (this.fFoldPackages && parent != null) {
            try {
                IScriptFolder fragment;
                if (parent instanceof IScriptFolder && this.isEmpty(fragment = (IScriptFolder)parent) && this.hasSingleChild(fragment)) {
                    return this.filterParent(this.getActualParent(fragment));
                }
            }
            catch (ModelException e) {
                DLTKUIPlugin.log(e);
            }
        }
        return parent;
    }

    private boolean hasSingleChild(IScriptFolder fragment) {
        return this.getChildren(fragment).length == 1;
    }

    private Object findNextLevelParentByElementName(IScriptFolder child) {
        String name = child.getElementName();
        int index = name.lastIndexOf(46);
        if (index != -1) {
            String realParentName = name.substring(0, index);
            IScriptFolder element = ((IProjectFragment)child.getParent()).getScriptFolder(realParentName);
            if (element.exists()) {
                return element;
            }
        }
        return child.getParent();
    }

    public boolean hasChildren(Object element) {
        IScriptFolder fragment;
        if (element instanceof IScriptFolder && (fragment = (IScriptFolder)element).isRootFolder()) {
            return false;
        }
        return this.getChildren(element).length > 0;
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public void dispose() {
        this.fStore.removePropertyChangeListener((IPropertyChangeListener)this);
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.fViewer = (TreeViewer)viewer;
    }

    public void elementChanged(ElementChangedEvent event) {
        this.processDelta(event.getDelta());
    }

    public void processDelta(IModelElementDelta delta) {
        int kind = delta.getKind();
        final IModelElement element = delta.getElement();
        if (element instanceof IScriptFolder) {
            if (kind == 2) {
                this.postRunnable(new Runnable(){

                    @Override
                    public void run() {
                        Control ctrl = ProjectFragmentProvider.this.fViewer.getControl();
                        if (ctrl != null && !ctrl.isDisposed()) {
                            if (!ProjectFragmentProvider.this.fFoldPackages) {
                                ProjectFragmentProvider.this.fViewer.remove((Object)element);
                            } else {
                                ProjectFragmentProvider.this.refreshGrandParent(element);
                            }
                        }
                    }
                });
                return;
            }
            if (kind == 1) {
                final Object parent = this.getParent(element);
                if (parent != null) {
                    this.postRunnable(new Runnable(){

                        @Override
                        public void run() {
                            Control ctrl = ProjectFragmentProvider.this.fViewer.getControl();
                            if (ctrl != null && !ctrl.isDisposed()) {
                                if (!ProjectFragmentProvider.this.fFoldPackages) {
                                    ProjectFragmentProvider.this.fViewer.add(parent, (Object)element);
                                } else {
                                    ProjectFragmentProvider.this.refreshGrandParent(element);
                                }
                            }
                        }
                    });
                }
                return;
            }
        }
    }

    private void refreshGrandParent(IModelElement element) {
        if (element instanceof IScriptFolder) {
            IFolder folder;
            Object gp = this.getGrandParent((IScriptFolder)element);
            if (gp instanceof IModelElement) {
                IModelElement el = (IModelElement)gp;
                if (el.exists()) {
                    this.fViewer.refresh(gp);
                }
            } else if (gp instanceof IFolder && (folder = (IFolder)gp).exists()) {
                this.fViewer.refresh((Object)folder);
            }
        }
    }

    private Object getGrandParent(IScriptFolder element) {
        Object parent = this.findNextLevelParentByElementName(element);
        if (parent instanceof IProjectFragment) {
            IProjectFragment root = (IProjectFragment)parent;
            if (this.isRootProject(root)) {
                return root.getScriptProject();
            }
            return root;
        }
        Object grandParent = this.getParent(parent);
        if (grandParent == null) {
            return parent;
        }
        return grandParent;
    }

    private boolean isRootProject(IProjectFragment root) {
        return "".equals(root.getElementName());
    }

    private void postRunnable(Runnable r) {
        Control ctrl = this.fViewer.getControl();
        if (ctrl != null && !ctrl.isDisposed()) {
            Display currentDisplay = Display.getCurrent();
            if (currentDisplay != null && currentDisplay.equals(ctrl.getDisplay())) {
                ctrl.getDisplay().syncExec(r);
            } else {
                ctrl.getDisplay().asyncExec(r);
            }
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (this.arePackagesFoldedInHierarchicalLayout() != this.fFoldPackages) {
            this.fFoldPackages = this.arePackagesFoldedInHierarchicalLayout();
            if (this.fViewer != null && !this.fViewer.getControl().isDisposed()) {
                this.fViewer.getControl().setRedraw(false);
                Object[] expandedObjects = this.fViewer.getExpandedElements();
                this.fViewer.refresh();
                this.fViewer.setExpandedElements(expandedObjects);
                this.fViewer.getControl().setRedraw(true);
            }
        }
    }

    private boolean arePackagesFoldedInHierarchicalLayout() {
        return this.fStore.getBoolean("org.eclipse.dltk.mod.ui.flatPackagesInPackageExplorer");
    }
}

