/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.ui.infoviews;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.mod.core.IModelElement;
import org.eclipse.dltk.mod.ui.ScriptElementLabels;
import org.eclipse.dltk.mod.ui.infoviews.InfoViewMessages;
import org.eclipse.dltk.mod.utils.TextUtils;
import org.eclipse.osgi.util.NLS;

public class ModelElementArray {
    private final IModelElement[] elements;
    private static final long NAME_FLAGS = 786432L;
    private static final long TOOLTIP_FLAGS = -9223372034704375725L;

    public ModelElementArray(IModelElement[] elements) {
        Assert.isLegal((elements != null && elements.length > 1 ? 1 : 0) != 0);
        this.elements = elements;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ModelElementArray) {
            ModelElementArray other = (ModelElementArray)obj;
            return Arrays.equals(this.elements, other.elements);
        }
        return false;
    }

    public IModelElement[] getElements() {
        return this.elements;
    }

    private boolean isSingleMethodName() {
        IModelElement element0 = this.elements[0];
        if (element0.getElementType() == 9) {
            String methodName = element0.getElementName();
            int i = 1;
            while (i < this.elements.length) {
                IModelElement element = this.elements[i];
                if (element.getElementType() != 9 || !methodName.equals(element.getElementName())) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public String getContentDescription() {
        if (this.isSingleMethodName()) {
            return NLS.bind((String)InfoViewMessages.ContentDescription_multipleMethodsWithSameName, (Object)this.elements[0].getElementName());
        }
        ScriptElementLabels labels = ScriptElementLabels.getDefault();
        HashSet<String> names = new HashSet<String>();
        int i = 0;
        while (i < this.elements.length) {
            names.add(labels.getElementLabel(this.elements[i], 786432L));
            ++i;
        }
        return this.sortAndJoin(names, ", ");
    }

    private String sortAndJoin(Set names, String separator) {
        ArrayList nameList = new ArrayList(names);
        Collections.sort(nameList);
        return ModelElementArray.join(nameList, separator);
    }

    public String getTitleTooltip() {
        ScriptElementLabels labels = ScriptElementLabels.getDefault();
        HashSet<String> names = new HashSet<String>();
        int i = 0;
        while (i < this.elements.length) {
            names.add(labels.getElementLabel(this.elements[i], -9223372034704375725L));
            ++i;
        }
        return this.sortAndJoin(names, "\n");
    }

    private static String join(Collection collection, String separator) {
        return TextUtils.join((Collection)collection, (String)separator);
    }
}

