/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.validators.internal.ui;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.dltk.mod.core.DLTKCore;
import org.eclipse.dltk.mod.internal.ui.dialogs.StatusInfo;
import org.eclipse.dltk.mod.internal.ui.wizards.dialogfields.ComboDialogField;
import org.eclipse.dltk.mod.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.dltk.mod.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.dltk.mod.internal.ui.wizards.dialogfields.StringDialogField;
import org.eclipse.dltk.mod.validators.core.IValidator;
import org.eclipse.dltk.mod.validators.core.IValidatorType;
import org.eclipse.dltk.mod.validators.internal.ui.IAddValidatorDialogRequestor;
import org.eclipse.dltk.mod.validators.internal.ui.ValidatorConfigurationPageManager;
import org.eclipse.dltk.mod.validators.internal.ui.ValidatorMessages;
import org.eclipse.dltk.mod.validators.ui.ValidatorConfigurationPage;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class AddValidatorDialog
extends StatusDialog
implements ValidatorConfigurationPage.IStatusHandler {
    private IAddValidatorDialogRequestor fRequestor;
    private IValidatorType[] fValidatorTypes;
    private IValidatorType fSelectedValidatorType;
    private ComboDialogField fValidatorTypeCombo;
    private IValidator fEditedValidator;
    private StringDialogField fValidatorName;
    private IStatus[] fStati;
    private int fPrevIndex = -1;
    private Map createValidatorMap = new HashMap();
    private ValidatorConfigurationPage fConfigurationPage = null;
    private Composite configPage = null;

    public AddValidatorDialog(IAddValidatorDialogRequestor requestor, Shell shell, IValidatorType[] validatorTypes, IValidator editedValidator) {
        super(shell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.fRequestor = requestor;
        this.fStati = new IStatus[6];
        int i = 0;
        while (i < this.fStati.length) {
            this.fStati[i] = new StatusInfo();
            ++i;
        }
        this.fValidatorTypes = validatorTypes;
        this.fSelectedValidatorType = editedValidator != null ? editedValidator.getValidatorType() : validatorTypes[0];
        this.fEditedValidator = editedValidator;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
    }

    protected void createDialogFields() {
        this.fValidatorTypeCombo = new ComboDialogField(8);
        this.fValidatorTypeCombo.setLabelText(ValidatorMessages.addValidatorDialog_ValidatorEnvironmentType);
        this.fValidatorTypeCombo.setItems(this.getValidatorTypeNames());
        this.fValidatorName = new StringDialogField();
        this.fValidatorName.setLabelText(ValidatorMessages.addValidatorDialog_ValidatorEnvironmentName);
    }

    protected void createFieldListeners() {
        this.fValidatorTypeCombo.setDialogFieldListener(new IDialogFieldListener(){

            public void dialogFieldChanged(DialogField field) {
                AddValidatorDialog.this.updateValidatorType();
            }
        });
        this.fValidatorName.setDialogFieldListener(new IDialogFieldListener(){

            public void dialogFieldChanged(DialogField field) {
                AddValidatorDialog.this.setValidatorNameStatus(AddValidatorDialog.this.validateValidatorName());
                AddValidatorDialog.this.updateStatusLine();
            }
        });
    }

    protected String getValidatorName() {
        return this.fValidatorName.getText();
    }

    protected Control createDialogArea(Composite ancestor) {
        this.createDialogFields();
        Composite parent = (Composite)super.createDialogArea(ancestor);
        ((GridLayout)parent.getLayout()).numColumns = 3;
        this.fValidatorTypeCombo.doFillIntoGrid(parent, 3);
        ((GridData)this.fValidatorTypeCombo.getComboControl(null).getLayoutData()).widthHint = this.convertWidthInCharsToPixels(50);
        ((GridData)this.fValidatorTypeCombo.getComboControl(null).getLayoutData()).grabExcessHorizontalSpace = true;
        this.fValidatorName.doFillIntoGrid(parent, 3);
        if (this.fEditedValidator != null) {
            this.fValidatorName.setEnabled(!this.fEditedValidator.getValidatorType().isBuiltin());
            this.fEditedValidator.getName().equals(this.fEditedValidator.getValidatorType().getName());
            this.recreateConfigPage(parent);
        } else {
            this.configPage = new Composite(parent, 4);
            GridData data = new GridData(4, 4, true, true);
            data.horizontalSpan = 3;
            this.configPage.setLayoutData((Object)data);
            GridLayout layout = new GridLayout();
            layout.numColumns = 3;
            layout.marginLeft = -5;
            layout.marginRight = -5;
            layout.marginTop = -5;
            this.configPage.setLayout((Layout)layout);
            AddValidatorDialog.applyDialogFont((Control)this.configPage);
        }
        this.initializeFields();
        this.createFieldListeners();
        AddValidatorDialog.applyDialogFont((Control)parent);
        return parent;
    }

    private void recreateConfigPage(Composite parent) {
        block5: {
            if (this.fConfigurationPage != null) {
                this.fConfigurationPage.dispose();
            }
            try {
                String id = null;
                id = this.fEditedValidator != null ? this.fEditedValidator.getValidatorType().getID() : this.getValidatorType().getID();
                this.fConfigurationPage = ValidatorConfigurationPageManager.getConfigurationPage(id);
                if (this.fConfigurationPage != null) {
                    this.fConfigurationPage.setStatusHandler(this);
                }
            }
            catch (CoreException e) {
                if (!DLTKCore.DEBUG) break block5;
                e.printStackTrace();
            }
        }
        if (this.fConfigurationPage != null) {
            this.fConfigurationPage.setValidator(this.getCreateValidator());
            this.fConfigurationPage.createControl(parent, 3);
        }
    }

    private IValidator getCreateValidator() {
        if (this.configPage == null) {
            return this.fEditedValidator;
        }
        if (this.createValidatorMap.containsKey(this.fSelectedValidatorType)) {
            return (IValidator)this.createValidatorMap.get(this.fSelectedValidatorType);
        }
        IValidator validator = this.fSelectedValidatorType.createValidator(this.createUniqueId(this.fSelectedValidatorType));
        this.createValidatorMap.put(this.fSelectedValidatorType, validator);
        return validator;
    }

    private void updateValidatorType() {
        int selIndex = this.fValidatorTypeCombo.getSelectionIndex();
        if (selIndex == this.fPrevIndex) {
            return;
        }
        this.fPrevIndex = selIndex;
        if (selIndex >= 0 && selIndex < this.fValidatorTypes.length) {
            this.fSelectedValidatorType = this.fValidatorTypes[selIndex];
        }
        if (this.configPage != null) {
            this.fEditedValidator = null;
            Control[] children = this.configPage.getChildren();
            int i = 0;
            while (i < children.length) {
                children[i].dispose();
                ++i;
            }
            this.recreateConfigPage(this.configPage);
            this.configPage.redraw();
            this.configPage.layout(true, true);
            Shell shell = this.getShell();
            shell.setSize(shell.computeSize(-1, -1));
            shell.layout(true, true);
        }
        this.updateStatusLine();
    }

    public void create() {
        super.create();
        this.fValidatorName.setFocus();
        this.selectValidatorType();
    }

    private String[] getValidatorTypeNames() {
        String[] names = new String[this.fValidatorTypes.length];
        int i = 0;
        while (i < this.fValidatorTypes.length) {
            names[i] = this.fValidatorTypes[i].getName();
            ++i;
        }
        return names;
    }

    private void selectValidatorType() {
        int i = 0;
        while (i < this.fValidatorTypes.length) {
            if (this.fSelectedValidatorType == this.fValidatorTypes[i]) {
                this.fValidatorTypeCombo.selectItem(i);
                return;
            }
            ++i;
        }
    }

    private void initializeFields() {
        this.fValidatorTypeCombo.setItems(this.getValidatorTypeNames());
        if (this.fEditedValidator == null) {
            this.fValidatorName.setText("");
        } else {
            this.fValidatorTypeCombo.setEnabled(false);
            this.fValidatorName.setText(this.fEditedValidator.getName());
        }
        this.setValidatorNameStatus(this.validateValidatorName());
        this.updateStatusLine();
    }

    private IValidatorType getValidatorType() {
        return this.fSelectedValidatorType;
    }

    private IStatus validateValidatorName() {
        StatusInfo status = new StatusInfo();
        String name = this.fValidatorName.getText();
        if (name == null || name.trim().length() == 0) {
            status.setInfo(ValidatorMessages.addValidatorDialog_enterName);
        } else if (this.fRequestor.isDuplicateName(name) && (this.fEditedValidator == null || !name.equals(this.fEditedValidator.getName()))) {
            status.setError(ValidatorMessages.addValidatorDialog_duplicateName);
        }
        return status;
    }

    public void updateStatusLine() {
        IStatus max = null;
        int i = 0;
        while (i < this.fStati.length) {
            IStatus curr = this.fStati[i];
            if (curr.matches(4)) {
                this.updateStatus(curr);
                return;
            }
            if (max == null || curr.getSeverity() > max.getSeverity()) {
                max = curr;
            }
            ++i;
        }
        this.updateStatus(max);
    }

    protected void okPressed() {
        this.doOkPressed();
        super.okPressed();
    }

    protected void cancelPressed() {
        super.cancelPressed();
    }

    private void doOkPressed() {
        if (this.fConfigurationPage != null) {
            this.fConfigurationPage.applyChanges();
        }
        if (this.fEditedValidator == null) {
            IValidator validator = this.getCreateValidator();
            this.setFieldValuesToValidator(validator);
            this.fRequestor.validatorAdded(validator);
        } else {
            this.setFieldValuesToValidator(this.fEditedValidator);
        }
    }

    public void removeValidators(boolean removeAll) {
        for (Object next : this.createValidatorMap.keySet()) {
            IValidatorType type = (IValidatorType)next;
            if (!removeAll && type.equals(this.fSelectedValidatorType)) continue;
            IValidator v = (IValidator)this.createValidatorMap.get(type);
            type.disposeValidator(v.getID());
        }
        this.createValidatorMap.clear();
    }

    private String createUniqueId(IValidatorType ValidatorType) {
        String id = null;
        while (ValidatorType.findValidator(id = String.valueOf(System.currentTimeMillis())) != null) {
        }
        return id;
    }

    protected void setFieldValuesToValidator(IValidator validator) {
        validator.setName(this.fValidatorName.getText());
        if (this.fConfigurationPage != null) {
            this.fConfigurationPage.applyChanges();
        }
    }

    protected File getAbsoluteFileOrEmpty(String path) {
        if (path == null || path.length() == 0) {
            return new File("");
        }
        return new File(path).getAbsoluteFile();
    }

    private void setValidatorNameStatus(IStatus status) {
        this.fStati[0] = status;
    }

    protected IStatus getSystemLibraryStatus() {
        return this.fStati[3];
    }

    public void setSystemLibraryStatus(IStatus status) {
        this.fStati[3] = status;
    }

    protected IStatus getPreferenceStatus() {
        return this.fStati[5];
    }

    public void setPreferenceStatus(IStatus status) {
        this.fStati[5] = status;
    }

    protected void updateButtonsEnableState(IStatus status) {
        Button ok = this.getButton(0);
        if (ok != null && !ok.isDisposed()) {
            ok.setEnabled(status.getSeverity() == 0);
        }
    }

    public void setButtonLayoutData(Button button) {
        super.setButtonLayoutData(button);
    }

    protected String getDialogSettingsSectionName() {
        return "ADD_Validator_DIALOG_SECTION";
    }

    @Override
    public void updateStatus() {
        IStatus status;
        if (this.fConfigurationPage != null && (status = this.fConfigurationPage.getStatus()) != null) {
            this.setPreferenceStatus(status);
        }
        this.updateStatusLine();
    }
}

