/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.af.common.error;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.TreeSet;
import org.eclipse.vjet.af.common.error.ErrorArgsInterface;
import org.eclipse.vjet.af.common.error.ErrorFilter;
import org.eclipse.vjet.af.common.error.ErrorId;
import org.eclipse.vjet.af.common.error.ErrorObject;
import org.eclipse.vjet.af.common.error.ErrorSeverity;
import org.eclipse.vjet.dsf.common.exceptions.BaseRuntimeException;

public class ErrorList
implements Serializable {
    public static final ErrorList EMPTY_LIST = new EmptyErrorList();
    private static final int INITIAL_CAPACITY = 3;
    private transient DedupErrorList m_errors;
    static final long serialVersionUID = 1282003L;

    public ErrorList() {
        this(3);
    }

    public ErrorList(int initialSize) {
        if (initialSize < 0) {
            throw new BaseRuntimeException("Initial size must be > 0.");
        }
        this.m_errors = new DedupErrorList(initialSize);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        int size = this.m_errors.size();
        BitSet bitSet = new BitSet(size);
        out.writeInt(size);
        int i = 0;
        while (i < size) {
            MarkableErrorObject markable = (MarkableErrorObject)this.m_errors.get(i);
            out.writeObject(markable.errorObject);
            if (markable.isMarked) {
                bitSet.set(i);
            } else {
                bitSet.clear(i);
            }
            ++i;
        }
        out.writeObject(bitSet);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        MarkableErrorObject markable;
        int size = in.readInt();
        this.m_errors = new DedupErrorList(size);
        int i = 0;
        while (i < size) {
            ErrorObject error_object = (ErrorObject)in.readObject();
            markable = new MarkableErrorObject(error_object);
            this.m_errors.add(markable);
            ++i;
        }
        BitSet bitSet = (BitSet)in.readObject();
        int i2 = 0;
        while (i2 < size) {
            markable = (MarkableErrorObject)this.m_errors.get(i2);
            markable.isMarked = bitSet.get(i2);
            ++i2;
        }
    }

    public boolean hasAnyErrors() {
        return !this.isEmpty();
    }

    public boolean hasAnyErrors(ErrorFilter errorFilter) {
        int size = this.m_errors.size();
        int i = 0;
        while (i < size) {
            ErrorObject eo = ((MarkableErrorObject)this.m_errors.get((int)i)).errorObject;
            if (errorFilter.matches(eo)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public ErrorList getAllErrors() {
        return this;
    }

    public ErrorList getAllErrors(ErrorFilter errorFilter) {
        int size = this.m_errors.size();
        ErrorList result = new ErrorList(size / 2);
        int i = 0;
        while (i < size) {
            ErrorObject eo = ((MarkableErrorObject)this.m_errors.get((int)i)).errorObject;
            if (errorFilter.matches(eo)) {
                result.add(eo);
            }
            ++i;
        }
        return result;
    }

    public void clearAllErrors() {
        if (this.m_errors == null) {
            return;
        }
        this.m_errors.clear();
        this.m_errors = new DedupErrorList(3);
    }

    public void clearAllErrors(ErrorFilter errorFilter) {
        if (errorFilter == null || this.isEmpty()) {
            return;
        }
        int size = this.m_errors.size();
        List findList = (List)this.m_errors.clone();
        DedupErrorList newList = new DedupErrorList();
        int i = 0;
        while (i < size) {
            ErrorObject eo = ((MarkableErrorObject)findList.get((int)i)).errorObject;
            if (!errorFilter.matches(eo)) {
                newList.add(this.m_errors.get(i));
            }
            ++i;
        }
        this.m_errors.clear();
        this.m_errors = newList;
    }

    public ErrorList semiDeepClone() {
        ErrorList clone = new ErrorList();
        int size = this.m_errors.size();
        int i = 0;
        while (i < size) {
            MarkableErrorObject markable = (MarkableErrorObject)this.m_errors.get(i);
            MarkableErrorObject markableClone = new MarkableErrorObject(markable.errorObject);
            markableClone.isMarked = markable.isMarked;
            clone.m_errors.add(markableClone);
            ++i;
        }
        return clone;
    }

    public void add(ErrorObject errorObject) {
        if (errorObject == null) {
            throw new NullPointerException("Error object must be non-null");
        }
        this.m_errors.add(new MarkableErrorObject(errorObject));
    }

    public void add(ErrorObject[] errorObjects) {
        int i = 0;
        while (i < errorObjects.length) {
            this.add(errorObjects[i]);
            ++i;
        }
    }

    public void add(ErrorList errorList) {
        int size = errorList.size();
        int i = 0;
        while (i < size) {
            this.add(errorList.get(i));
            ++i;
        }
    }

    public int size() {
        return this.m_errors.size();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public ListIterator listIterator() {
        ArrayList<ErrorObject> list = new ArrayList<ErrorObject>(this.m_errors.size());
        int i = 0;
        while (i < this.m_errors.size()) {
            ErrorObject eo = ((MarkableErrorObject)this.m_errors.get((int)i)).errorObject;
            list.add(eo);
            ++i;
        }
        return list.listIterator();
    }

    public ErrorObject get(int index) {
        return ((MarkableErrorObject)this.m_errors.get((int)index)).errorObject;
    }

    public ErrorList findById(ErrorId id) {
        ErrorList result = null;
        int size = this.m_errors.size();
        int i = 0;
        while (i < size) {
            ErrorObject eo = ((MarkableErrorObject)this.m_errors.get((int)i)).errorObject;
            if (eo.m_id.equals(id)) {
                if (result == null) {
                    result = new ErrorList();
                }
                result.add(eo);
            }
            ++i;
        }
        return result;
    }

    public ErrorList findBySeverity(ErrorSeverity severity) {
        ErrorList result = null;
        int size = this.m_errors.size();
        int i = 0;
        while (i < size) {
            ErrorObject eo = ((MarkableErrorObject)this.m_errors.get((int)i)).errorObject;
            if (eo.m_severity.equals((Object)severity)) {
                if (result == null) {
                    result = new ErrorList();
                }
                result.add(eo);
            }
            ++i;
        }
        return result;
    }

    public ErrorList findByParameters(ErrorArgsInterface parameters) {
        ErrorList result = null;
        int size = this.m_errors.size();
        int i = 0;
        while (i < size) {
            ErrorObject eo = ((MarkableErrorObject)this.m_errors.get((int)i)).errorObject;
            ErrorArgsInterface currentParameters = eo.m_parameters;
            if (currentParameters != null && currentParameters.equals(parameters) || currentParameters == null && parameters == null) {
                if (result == null) {
                    result = new ErrorList();
                }
                result.add(eo);
            }
            ++i;
        }
        return result;
    }

    public ErrorList findByCorrelations(ErrorArgsInterface correlations) {
        ErrorList result = null;
        int size = this.m_errors.size();
        int i = 0;
        while (i < size) {
            ErrorObject eo = ((MarkableErrorObject)this.m_errors.get((int)i)).errorObject;
            ErrorArgsInterface currentCorrelations = eo.m_correlations;
            if (currentCorrelations != null && currentCorrelations.equals(correlations) || currentCorrelations == null && correlations == null) {
                if (result == null) {
                    result = new ErrorList();
                }
                result.add(eo);
            }
            ++i;
        }
        return result;
    }

    public void sortBySeverity() {
        TreeSet treeSet = new TreeSet();
        int size = this.m_errors.size();
        int i = 0;
        i = 0;
        while (i < size) {
            treeSet.add(this.m_errors.get(i));
            ++i;
        }
        Iterator treeItr = treeSet.iterator();
        while (treeItr.hasNext()) {
            this.m_errors.set(--i, treeItr.next());
        }
    }

    public void mark(int index) {
        ((MarkableErrorObject)this.m_errors.get((int)index)).isMarked = true;
    }

    public void mark(ErrorObject thatErrorObject) {
        int index = this.findObject(thatErrorObject);
        if (index == -1) {
            return;
        }
        this.mark(index);
    }

    public void markAll() {
        int i = this.m_errors.size() - 1;
        while (i >= 0) {
            this.mark(i);
            --i;
        }
    }

    public void unmark(int index) {
        ((MarkableErrorObject)this.m_errors.get((int)index)).isMarked = false;
    }

    public void unmark(ErrorObject thatErrorObject) {
        int index = this.findObject(thatErrorObject);
        if (index == -1) {
            return;
        }
        this.unmark(index);
    }

    public void unmarkAll() {
        int i = this.m_errors.size() - 1;
        while (i >= 0) {
            this.unmark(i);
            --i;
        }
    }

    public boolean isMarked(int index) {
        return ((MarkableErrorObject)this.m_errors.get((int)index)).isMarked;
    }

    public boolean isMarked(ErrorObject errorObject) {
        int index = this.findObject(errorObject);
        if (index == -1) {
            return false;
        }
        return this.isMarked(index);
    }

    private int findObject(ErrorObject errorObject) {
        if (errorObject == null) {
            throw new NullPointerException("The error object must be non-null");
        }
        int size = this.m_errors.size();
        int i = 0;
        while (i < size) {
            ErrorObject element = ((MarkableErrorObject)this.m_errors.get((int)i)).errorObject;
            if (element.equals(errorObject)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{ ");
        int size = this.size();
        int i = 0;
        while (i < size) {
            if (i != 0) {
                sb.append(", ");
            }
            sb.append(this.get(i).toString());
            ++i;
        }
        sb.append(" }");
        return sb.toString();
    }

    private static class DedupErrorList
    extends ArrayList {
        HashMap m_dedupMap;

        private DedupErrorList() {
            this.m_dedupMap = new HashMap(3);
        }

        private DedupErrorList(int initSize) {
            super(initSize);
            this.m_dedupMap = new HashMap(initSize);
        }

        @Override
        public boolean add(MarkableErrorObject obj) {
            ErrorObject key = obj.errorObject;
            if (this.m_dedupMap.get(key) != null) {
                return true;
            }
            this.m_dedupMap.put(key, obj);
            return super.add(obj);
        }

        @Override
        public void clear() {
            this.m_dedupMap.clear();
            super.clear();
        }
    }

    private static class EmptyErrorList
    extends ErrorList {
        private static final long serialVersionUID = 3721746678364120215L;

        private EmptyErrorList() {
        }

        public boolean hasErrors() {
            return false;
        }

        public boolean hasErrors(ErrorFilter errorFilter) {
            return false;
        }

        public ErrorList getErrors() {
            return this;
        }

        public ErrorList getErrors(ErrorFilter errorFilter) {
            return this;
        }

        public void clearErrors() {
        }

        public void clearErrors(ErrorFilter errorFilter) {
        }

        @Override
        public ErrorList semiDeepClone() {
            return this;
        }

        @Override
        public void add(ErrorObject errorObject) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(ErrorObject[] errorObjects) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(ErrorList errorList) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public ListIterator listIterator() {
            return Collections.EMPTY_LIST.listIterator();
        }

        @Override
        public ErrorObject get(int index) {
            return null;
        }

        @Override
        public ErrorList findById(ErrorId id) {
            return this;
        }

        @Override
        public ErrorList findBySeverity(ErrorSeverity severity) {
            return this;
        }

        @Override
        public ErrorList findByParameters(ErrorArgsInterface parameters) {
            return this;
        }

        @Override
        public ErrorList findByCorrelations(ErrorArgsInterface correlations) {
            return this;
        }

        @Override
        public void sortBySeverity() {
        }

        @Override
        public void mark(int index) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void mark(ErrorObject thatErrorObject) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void markAll() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void unmark(int index) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void unmark(ErrorObject thatErrorObject) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void unmarkAll() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isMarked(int index) {
            return false;
        }

        @Override
        public boolean isMarked(ErrorObject errorObject) {
            return false;
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("{ ");
            int size = this.size();
            int i = 0;
            while (i < size) {
                if (i != 0) {
                    sb.append(", ");
                }
                sb.append(this.get(i).toString());
                ++i;
            }
            sb.append(" }");
            return sb.toString();
        }
    }

    private class MarkableErrorObject
    implements Comparable {
        ErrorObject errorObject;
        boolean isMarked;

        MarkableErrorObject(ErrorObject wrappedErrorObject) {
            this.errorObject = wrappedErrorObject;
            this.isMarked = false;
        }

        public int compareTo(Object thatMarkable) {
            return this.errorObject.m_severity.compareTo(((MarkableErrorObject)thatMarkable).errorObject.m_severity);
        }
    }
}

