/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.kernel.stage;

import java.util.HashSet;
import org.eclipse.vjet.af.common.error.ErrorFilter;
import org.eclipse.vjet.af.common.error.ErrorList;
import org.eclipse.vjet.af.common.error.ErrorObject;
import org.eclipse.vjet.kernel.stage.IStage;
import org.eclipse.vjet.kernel.stage.IStageManager;
import org.eclipse.vjet.kernel.stage.IStageProvider;
import org.eclipse.vjet.kernel.stage.IStageTransition;
import org.eclipse.vjet.kernel.stage.StageGraph;
import org.eclipse.vjet.kernel.stage.StageId;

public class DefaultStageManager<T>
implements IStageManager<T> {
    private static final long serialVersionUID = 1L;
    private StageGraph<T> m_graph = null;
    private IStageProvider<T> m_provider;
    private boolean m_started = false;
    private ErrorList m_directErrors;
    private IStage<T> m_current;

    public DefaultStageManager() {
        this(new StageGraph());
    }

    public DefaultStageManager(StageGraph<T> graph) {
        if (graph == null) {
            throw new RuntimeException("stage graph cannot be null");
        }
        this.m_graph = graph;
    }

    @Override
    public IStage<T> start() {
        if (this.m_started) {
            throw new RuntimeException("Driver already started.");
        }
        if (this.m_graph == null) {
            throw new RuntimeException("stage graph is null");
        }
        return this.start(this.m_graph.getFirst());
    }

    @Override
    public IStage<T> start(T id) {
        if (this.m_started) {
            throw new RuntimeException("Driver already started.");
        }
        if (id == null) {
            throw new RuntimeException("id cannot be null");
        }
        IStage<T> stage = this.getStage(id);
        if (stage == null) {
            throw new RuntimeException("Stage is not found for:" + id);
        }
        this.m_started = true;
        this.m_current = this.processEntryTransition(stage);
        return this.m_current;
    }

    @Override
    public IStage<T> next(IStage<T> currentStage) {
        if (currentStage == null) {
            throw new RuntimeException("currentStage is null");
        }
        T nextId = null;
        IStageTransition<T> tz = currentStage.getExitTransition();
        nextId = tz != null && tz.getNext() != null ? (T)tz.getNext() : (T)this.m_graph.getNext(currentStage.getId());
        return this.next(nextId);
    }

    @Override
    public IStage<T> getCurrent() {
        return this.m_current;
    }

    public DefaultStageManager<T> add(T stageId) {
        this.getGraph().add(stageId);
        return this;
    }

    public DefaultStageManager<T> add(IStage<T> stage) {
        this.getGraph().add(stage);
        return this;
    }

    public StageGraph<T> getGraph() {
        return this.m_graph;
    }

    @Override
    public IStage<T> getStage(T id) {
        if (id == null) {
            return null;
        }
        IStage<T> stage = null;
        if (this.m_graph != null) {
            stage = this.m_graph.get(id);
        }
        if (stage == null && this.m_provider != null) {
            stage = this.m_provider.get(id);
        }
        return stage;
    }

    public void setProvider(IStageProvider<T> provider) {
        this.m_provider = provider;
    }

    public IStageProvider<T> getProvider() {
        return this.m_provider;
    }

    public void addError(ErrorObject error) {
        if (error == null) {
            return;
        }
        if (this.m_directErrors == null) {
            this.m_directErrors = new ErrorList();
        }
        this.m_directErrors.add(error);
    }

    public void addErrors(ErrorList errors) {
        if (errors == null || errors.isEmpty()) {
            return;
        }
        if (this.m_directErrors == null) {
            this.m_directErrors = new ErrorList();
        }
        this.m_directErrors.add(errors);
    }

    @Override
    public boolean hasDirectErrors() {
        if (this.m_directErrors == null || this.m_directErrors.isEmpty()) {
            return false;
        }
        return this.m_directErrors.hasAnyErrors();
    }

    @Override
    public boolean hasDirectErrors(ErrorFilter errorFilter) {
        if (this.m_directErrors == null || this.m_directErrors.isEmpty()) {
            return false;
        }
        return this.m_directErrors.hasAnyErrors(errorFilter);
    }

    @Override
    public ErrorList getDirectErrors() {
        if (this.m_directErrors == null) {
            this.m_directErrors = new ErrorList(0);
        }
        return this.m_directErrors;
    }

    @Override
    public ErrorList getDirectErrors(ErrorFilter errorFilter) {
        if (this.m_directErrors == null) {
            this.m_directErrors = new ErrorList(0);
        }
        return this.m_directErrors.getAllErrors(errorFilter);
    }

    @Override
    public void clearDirectErrors() {
        if (this.m_directErrors != null) {
            this.m_directErrors.clearAllErrors();
        }
    }

    @Override
    public void clearDirectErrors(ErrorFilter errorFilter) {
        if (this.m_directErrors != null) {
            this.m_directErrors.clearAllErrors(errorFilter);
        }
    }

    @Override
    public boolean hasAnyErrors() {
        return this.hasAnyErrors(new AllErrorFilter());
    }

    @Override
    public boolean hasAnyErrors(ErrorFilter errorFilter) {
        if (this.hasDirectErrors(errorFilter)) {
            return true;
        }
        if (this.m_provider != null) {
            for (IStage<T> stage : this.m_provider.getAll().values()) {
                if (!stage.hasDirectErrors(errorFilter)) continue;
                return true;
            }
        }
        for (IStage<T> stage : this.m_graph.getAll().values()) {
            if (!stage.hasDirectErrors(errorFilter)) continue;
            return true;
        }
        return false;
    }

    @Override
    public ErrorList getAllErrors() {
        return this.getAllErrors(new AllErrorFilter());
    }

    @Override
    public ErrorList getAllErrors(ErrorFilter errorFilter) {
        ErrorList answer = new ErrorList();
        answer.add(this.getDirectErrors(errorFilter));
        if (this.m_provider != null) {
            for (IStage<T> stage : this.m_provider.getAll().values()) {
                answer.add(stage.getDirectErrors(errorFilter));
            }
        }
        for (IStage<T> stage : this.m_graph.getAll().values()) {
            answer.add(stage.getDirectErrors(errorFilter));
        }
        return answer;
    }

    protected IStage<T> next(T nextId) {
        if (this.isTerminal(nextId)) {
            return null;
        }
        IStage<T> next = this.getStage(nextId);
        this.m_current = this.processEntryTransition(next);
        return this.m_current;
    }

    protected boolean isTerminal(T stageId) {
        return stageId == StageId.TERMINAL;
    }

    private IStage<T> processEntryTransition(IStage<T> stage) {
        if (stage == null) {
            return null;
        }
        IStage<T> next = stage;
        HashSet<T> visitedStages = new HashSet<T>(2);
        while (next != null) {
            T nextId;
            IStageTransition<T> entryTz = next.getEntryTransition();
            if (entryTz == null || (nextId = entryTz.getNext()) == null) break;
            if (visitedStages.contains(nextId)) {
                throw new RuntimeException("Cycle detected:" + nextId);
            }
            visitedStages.add(nextId);
            next = this.getStage(nextId);
        }
        return next;
    }

    static class AllErrorFilter
    implements ErrorFilter {
        AllErrorFilter() {
        }

        @Override
        public boolean matches(ErrorObject errorObject) {
            return true;
        }
    }
}

