/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.javatojs.trace;

import java.util.List;
import org.eclipse.vjet.dsf.common.trace.ITraceData;
import org.eclipse.vjet.dsf.common.trace.TraceAttr;
import org.eclipse.vjet.dsf.common.trace.event.TraceEvent;
import org.eclipse.vjet.dsf.common.trace.event.TraceId;
import org.eclipse.vjet.dsf.common.trace.event.TraceType;
import org.eclipse.vjet.dsf.common.trace.listener.ITraceEventListener;
import org.eclipse.vjet.dsf.common.trace.listener.ListenerId;
import org.eclipse.vjet.dsf.javatojs.trace.TraceErrors;
import org.eclipse.vjet.dsf.javatojs.trace.TranslateError;
import org.eclipse.vjet.dsf.javatojs.trace.TranslateTraceType;

public class TranslateConsoleListener
implements ITraceEventListener {
    private static final ListenerId ID = new ListenerId(TranslateConsoleListener.class.getSimpleName());
    private static final String TAB = "    ";
    private static final String NEWLINE = "\n";
    private static final String START = "start";
    private static final String END = "end";
    private static final String DURATION = "duration";
    private static final String ERR_SEVERITY = "severity";
    private static final String ERR_TYPE = "type";
    private static final String SRC_NAME = "srcName";
    private static final String SRC_LINE_NO = "srcLineNo";
    private static final String MSG = "msg";

    public ListenerId getId() {
        return ID;
    }

    public boolean isApplicable(TraceEvent event) {
        return true;
    }

    public void beforeTrace(TraceEvent event) {
    }

    public void trace(TraceEvent event) {
        if (event == null) {
            return;
        }
        TraceType type = event.getType();
        if (type == TranslateTraceType.START_GROUP) {
            this.startGroup(event);
        } else if (type == TranslateTraceType.END_GROUP) {
            this.endGroup(event);
        } else if (type == TranslateTraceType.ERRORS) {
            this.traceError(event);
        } else if (type == TranslateTraceType.TIME) {
            this.traceTime(event);
        }
    }

    public void afterTrace(TraceEvent event) {
    }

    public void close() {
    }

    private void startGroup(TraceEvent event) {
        ITraceData d;
        TraceId id = event.getId();
        if ("DependencyPhase".equals(id.getName()) || "DeclarationPhase".equals(id.getName()) || "ImplementationPhase".equals(id.getName())) {
            this.out("***** " + id.getName() + " *****");
        } else if ("Task".equals(id.getName()) && (d = event.getData()[0]) instanceof TraceAttr) {
            TraceAttr attr = (TraceAttr)d;
            this.out("Task: " + attr.getValue());
        }
    }

    private void endGroup(TraceEvent event) {
    }

    private void traceError(TraceEvent event) {
        this.writeData(event.getData());
    }

    private void traceTime(TraceEvent event) {
    }

    private void writeData(ITraceData[] data) {
        if (data == null || data.length == 0) {
            return;
        }
        ITraceData[] iTraceDataArray = data;
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            TraceErrors t;
            List<TranslateError> errors;
            ITraceData d = iTraceDataArray[n2];
            if (d instanceof TraceAttr) {
                TraceAttr attr = (TraceAttr)d;
                this.out(String.valueOf(attr.getName()) + "=" + attr.getValue() + ";");
            } else if (d instanceof TraceErrors && (errors = (t = (TraceErrors)d).getErrors()) != null && !errors.isEmpty()) {
                for (TranslateError e : errors) {
                    StringBuffer sb = new StringBuffer();
                    sb.append(TAB + e.getLevel().name() + ": ");
                    if (e.getMsgId() != null) {
                        sb.append(String.valueOf(e.getMsgId()) + "; ");
                    }
                    if (e.getMsg() != null) {
                        sb.append(String.valueOf(e.getMsg()) + "; ");
                    }
                    if (e.getSrcName() != null) {
                        sb.append(String.valueOf(e.getSrcName()) + "; ");
                    }
                    if (e.getSrcLineNo() > 0L) {
                        sb.append(String.valueOf(String.valueOf(e.getSrcLineNo())) + ";");
                    }
                    this.out(sb.toString());
                }
            }
            ++n2;
        }
    }

    private void out(String s) {
        System.out.println("Trace==> " + s);
    }
}

