/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.javatojs.translate;

import java.util.List;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.vjet.dsf.javatojs.translate.BaseTranslator;
import org.eclipse.vjet.dsf.javatojs.translate.StatementTranslator;
import org.eclipse.vjet.dsf.jst.BaseJstNode;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.declaration.JstAnnotation;
import org.eclipse.vjet.dsf.jst.declaration.JstBlock;
import org.eclipse.vjet.dsf.jst.declaration.JstType;
import org.eclipse.vjet.dsf.jst.declaration.JstVar;
import org.eclipse.vjet.dsf.jst.expr.AssignExpr;
import org.eclipse.vjet.dsf.jst.term.JstIdentifier;
import org.eclipse.vjet.dsf.jst.token.IExpr;
import org.eclipse.vjet.dsf.jst.token.ILHS;
import org.eclipse.vjet.dsf.jst.token.IStmt;

public class OtherTranslator
extends BaseTranslator {
    public void processBlock(Block astBlock, JstBlock block) {
        StatementTranslator stmtTranslator = this.getStmtTranslator();
        for (Object o : astBlock.statements()) {
            if (o instanceof Statement) {
                IStmt s = stmtTranslator.processStatement((Statement)o, (BaseJstNode)block);
                if (s == null) continue;
                block.addStmt(s);
                continue;
            }
            this.getLogger().logUnhandledNode(this, (ASTNode)o, (BaseJstNode)block);
        }
    }

    public void processAnnotation(Annotation astAnnot, BaseJstNode jstNode) {
        JstAnnotation jstAnnotation = new JstAnnotation();
        jstAnnotation.setName(astAnnot.getTypeName().toString());
        jstNode.addAnnotation(jstAnnotation);
        if (astAnnot.isSingleMemberAnnotation()) {
            SingleMemberAnnotation sma = (SingleMemberAnnotation)astAnnot;
            IExpr expr = this.getExprTranslator().processExpression(sma.getValue(), (BaseJstNode)jstAnnotation);
            if (expr != null) {
                jstAnnotation.addExpr(expr);
            }
        } else if (astAnnot.isNormalAnnotation()) {
            NormalAnnotation na = (NormalAnnotation)astAnnot;
            List values = na.values();
            for (MemberValuePair mvp : values) {
                IExpr expr = this.getExprTranslator().processExpression(mvp.getValue(), (BaseJstNode)jstAnnotation);
                if (expr == null) continue;
                AssignExpr ae = new AssignExpr((ILHS)new JstIdentifier(mvp.getName().toString()), expr);
                jstAnnotation.addExpr((IExpr)ae);
            }
        }
    }

    JstVar toJstVar(SingleVariableDeclaration var, JstType jstType) {
        IJstType type = this.getDataTypeTranslator().processType(var.getType(), (BaseJstNode)jstType);
        return new JstVar(type, var.getName().toString());
    }

    JstVar toJstVar(SingleVariableDeclaration var, JstType jstType, String name) {
        IJstType type = this.getDataTypeTranslator().processType(var.getType(), (BaseJstNode)jstType);
        return new JstVar(type, name);
    }
}

