/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.javatojs.translate;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.vjet.dsf.javatojs.report.DefaultErrorReporter;
import org.eclipse.vjet.dsf.javatojs.report.ErrorReporter;
import org.eclipse.vjet.dsf.javatojs.trace.TranslateTraceMgr;
import org.eclipse.vjet.dsf.javatojs.translate.TranslateInfo;
import org.eclipse.vjet.dsf.javatojs.translate.TranslateLogger;
import org.eclipse.vjet.dsf.javatojs.translate.TranslatorProvider;
import org.eclipse.vjet.dsf.javatojs.translate.config.TranslateConfig;
import org.eclipse.vjet.dsf.javatojs.translate.custom.CustomAttr;
import org.eclipse.vjet.dsf.javatojs.translate.custom.CustomInfo;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.declaration.JstCache;
import org.eclipse.vjet.dsf.jst.declaration.JstType;

public class TranslateCtx {
    private static ThreadLocalContext s_context = new ThreadLocalContext();
    private TranslateConfig m_config;
    private boolean m_enableParallel = false;
    private boolean m_enableTrace = false;
    private Map<JstType, TranslateInfo> m_translateInfo = new HashMap<JstType, TranslateInfo>();
    private Map<IJstType, CustomInfo> m_customInfos = new HashMap<IJstType, CustomInfo>();
    private Map<String, IJstType> m_jsTypes = new HashMap<String, IJstType>();
    private TranslateLogger m_logger;
    private TranslateTraceMgr m_traceMgr;
    private ErrorReporter m_errorReporter = new DefaultErrorReporter();

    private TranslateCtx() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TranslateCtx ctx() {
        TranslateCtx ctx = (TranslateCtx)s_context.get();
        if (ctx != null) return ctx;
        Class<TranslateCtx> clazz = TranslateCtx.class;
        synchronized (TranslateCtx.class) {
            if (ctx != null) return ctx;
            return TranslateCtx.createCtx();
        }
    }

    public static void setCtx(TranslateCtx context) {
        s_context.set(context);
    }

    public static TranslateCtx createCtx() {
        TranslateCtx context = new TranslateCtx();
        s_context.set(context);
        return context;
    }

    public static TranslateCtx createChildCtx(TranslateCtx parentCtx) {
        TranslateCtx childCtx = TranslateCtx.createCtx();
        childCtx.m_config = parentCtx.m_config;
        childCtx.m_translateInfo = parentCtx.m_translateInfo;
        childCtx.m_customInfos = parentCtx.m_customInfos;
        childCtx.m_jsTypes = parentCtx.m_jsTypes;
        childCtx.m_errorReporter = parentCtx.m_errorReporter;
        childCtx.m_enableParallel = parentCtx.m_enableParallel;
        childCtx.m_enableTrace = parentCtx.m_enableTrace;
        return childCtx;
    }

    public TranslateCtx reset() {
        this.m_config = null;
        this.m_translateInfo.clear();
        this.m_customInfos.clear();
        this.m_jsTypes.clear();
        this.m_enableParallel = false;
        this.m_enableTrace = false;
        this.m_logger = null;
        this.m_traceMgr = null;
        this.m_errorReporter = null;
        return this;
    }

    public void setConfig(TranslateConfig config) {
        this.m_config = config;
    }

    public TranslateConfig getConfig() {
        if (this.m_config == null) {
            this.m_config = new TranslateConfig();
        }
        return this.m_config;
    }

    public TranslatorProvider getProvider() {
        return this.getConfig().getProvider();
    }

    public void setTranslateInfo(Map<JstType, TranslateInfo> translateInfo) {
        this.m_translateInfo = translateInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TranslateInfo getTranslateInfo(JstType type) {
        if (type == null) {
            return null;
        }
        Class<TranslateInfo> clazz = TranslateInfo.class;
        synchronized (TranslateInfo.class) {
            TranslateInfo info = this.m_translateInfo.get(type);
            if (info == null) {
                info = new TranslateInfo(type);
                this.m_translateInfo.put(type, info);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return info;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<TranslateInfo> getAllTranslateInfos() {
        Class<TranslateInfo> clazz = TranslateInfo.class;
        synchronized (TranslateInfo.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return Collections.unmodifiableCollection(this.m_translateInfo.values());
        }
    }

    public boolean isExcludedType(String fullName) {
        if (fullName == null) {
            return false;
        }
        String mappedName = this.getConfig().getPackageMapping().mapTo(fullName);
        JstType jstType = JstCache.getInstance().getType(mappedName);
        if (jstType != null) {
            return this.isExcluded((IJstType)jstType);
        }
        return this.getConfig().getPolicy().isClassExcluded(mappedName);
    }

    public boolean isExcluded(IJstType jstType) {
        if (jstType == null || jstType.getName() == null) {
            return false;
        }
        if (!(jstType instanceof JstType)) {
            return false;
        }
        if (jstType.getName().startsWith("org.eclipse.vjet.vjo.java")) {
            return false;
        }
        CustomInfo cInfo = this.getCustomInfo(jstType, false);
        if (cInfo.isExcluded()) {
            return true;
        }
        if (this.getConfig().getPolicy().isClassExcluded(this.getConfig().getPackageMapping().mapFrom(jstType.getName()))) {
            return true;
        }
        if (cInfo.isNone() && this.getCustomInfo(jstType.getRootType(), false).isNone()) {
            IJstType baseType2;
            for (IJstType baseType2 : jstType.getExtends()) {
                if (!this.isExcluded(baseType2)) continue;
                return true;
            }
            baseType2 = this.getTranslateInfo((JstType)jstType).getBaseType();
            if (this.isExcluded(baseType2)) {
                return true;
            }
        }
        return this.isExcluded(jstType.getOuterType());
    }

    public void setCustomAttr(IJstType jstType, CustomAttr attr) {
        this.getCustomInfo(jstType, true).setAttr(attr);
    }

    public boolean isJavaOnly(IJstType jstType) {
        return this.getCustomInfo(jstType, false).isJavaOnly();
    }

    public boolean isJSProxy(IJstType jstType) {
        return this.getCustomInfo(jstType, false).isJSProxy();
    }

    public boolean isMappedToJS(IJstType jstType) {
        return this.getCustomInfo(jstType, false).isMappedToJS();
    }

    public boolean isMappedToVJO(IJstType jstType) {
        return this.getCustomInfo(jstType, false).isMappedToVJO();
    }

    public void setNewName(IJstType jstType, String newName) {
        this.getCustomInfo(jstType, true).setName(newName);
    }

    public String getNewName(IJstType jstType) {
        CustomInfo cInfo = this.getCustomInfo(jstType, false);
        return cInfo == null ? null : cInfo.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateCustomInfo(IJstType jstType, CustomInfo cInfo) {
        if (jstType == null || cInfo == null) {
            return;
        }
        CustomInfo old = this.getCustomInfo(jstType, false);
        CustomInfo newInfo = cInfo;
        if (old != null) {
            newInfo = CustomInfo.update(old, newInfo);
        }
        Class<CustomInfo> clazz = CustomInfo.class;
        synchronized (CustomInfo.class) {
            if (cInfo == CustomInfo.NONE) {
                this.m_customInfos.remove(jstType);
            } else {
                this.m_customInfos.put(jstType, newInfo);
            }
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addJsType(String name, IJstType type) {
        if (name == null || type == null) {
            return;
        }
        Class<TranslateCtx> clazz = TranslateCtx.class;
        synchronized (TranslateCtx.class) {
            this.m_jsTypes.put(name, type);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isJsType(String name) {
        Class<TranslateCtx> clazz = TranslateCtx.class;
        synchronized (TranslateCtx.class) {
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return this.m_jsTypes.containsKey(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isJsType(IJstType type) {
        Class<TranslateCtx> clazz = TranslateCtx.class;
        synchronized (TranslateCtx.class) {
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return this.m_jsTypes.containsValue(type);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IJstType getJsType(String name) {
        Class<TranslateCtx> clazz = TranslateCtx.class;
        synchronized (TranslateCtx.class) {
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return this.m_jsTypes.get(name);
        }
    }

    public TranslateCtx enableParallel(boolean enable) {
        this.m_enableParallel = enable;
        return this;
    }

    public boolean isParallelEnabled() {
        return this.m_enableParallel;
    }

    public TranslateCtx enableTrace(boolean enable) {
        this.m_enableTrace = enable;
        return this;
    }

    public boolean isTraceEnabled() {
        return this.m_enableTrace;
    }

    public void setLogger(TranslateLogger logger) {
        this.m_logger = logger;
    }

    public TranslateLogger getLogger() {
        if (this.m_logger == null) {
            this.m_logger = new TranslateLogger(this.getConfig().getErrorPolicy());
            return this.m_logger;
        }
        return this.m_logger;
    }

    public TranslateTraceMgr getTraceManager() {
        if (this.m_traceMgr == null) {
            this.m_traceMgr = new TranslateTraceMgr(this);
        }
        return this.m_traceMgr;
    }

    public ErrorReporter getErrorReporter() {
        if (this.m_errorReporter == null) {
            this.m_errorReporter = new DefaultErrorReporter();
        }
        return this.m_errorReporter;
    }

    public void setErrorReporter(ErrorReporter reporter) {
        this.m_errorReporter = reporter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CustomInfo getCustomInfo(IJstType type, boolean create) {
        if (type == null) {
            return CustomInfo.NONE;
        }
        Class<CustomInfo> clazz = CustomInfo.class;
        synchronized (CustomInfo.class) {
            CustomInfo cInfo = this.m_customInfos.get(type);
            if (cInfo != null) {
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return cInfo;
            }
            if (create) {
                cInfo = new CustomInfo();
                this.m_customInfos.put(type, cInfo);
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return cInfo;
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return CustomInfo.NONE;
        }
    }

    /* synthetic */ TranslateCtx(TranslateCtx translateCtx) {
        this();
    }

    private static class ThreadLocalContext
    extends InheritableThreadLocal<TranslateCtx> {
        private ThreadLocalContext() {
        }

        @Override
        protected TranslateCtx initialValue() {
            return new TranslateCtx(null);
        }

        @Override
        protected TranslateCtx childValue(TranslateCtx parentContext) {
            TranslateCtx childContext = new TranslateCtx(null);
            return childContext;
        }
    }
}

