/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.javatojs.translate;

public final class TranslationMode {
    private static final int DEPENDENCY = 1;
    private static final int DECLARATION = 2;
    private static final int IMPLEMENTATION = 4;
    private int m_mode = 0;

    public TranslationMode setDependency() {
        this.m_mode = 1;
        return this;
    }

    public TranslationMode addDependency() {
        this.m_mode |= 1;
        return this;
    }

    public TranslationMode setDeclaration() {
        this.m_mode = 2;
        return this;
    }

    public TranslationMode addDeclaration() {
        this.m_mode |= 2;
        return this;
    }

    public TranslationMode setImplementation() {
        this.m_mode = 4;
        return this;
    }

    public TranslationMode addImplementation() {
        this.m_mode |= 4;
        return this;
    }

    public boolean hasDependency() {
        return (this.m_mode & 1) == 1;
    }

    public boolean hasDeclaration() {
        return (this.m_mode & 2) == 2;
    }

    public boolean hasImplementation() {
        return (this.m_mode & 4) == 4;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        boolean isEmpty = true;
        if (this.hasDependency()) {
            sb.append("Dependency");
            isEmpty = false;
        }
        if (this.hasDeclaration()) {
            if (!isEmpty) {
                sb.append(",");
            }
            sb.append("Declaration");
        }
        if (this.hasImplementation()) {
            if (!isEmpty) {
                sb.append(",");
            }
            sb.append("Impl");
        }
        return sb.toString();
    }

    void setMode(int mode) {
        this.m_mode = mode;
    }

    int getMode() {
        return this.m_mode;
    }
}

