/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.javatojs.translate.config;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.vjet.dsf.javatojs.translate.TranslateCtx;
import org.eclipse.vjet.dsf.javatojs.translate.TranslateHelper;
import org.eclipse.vjet.dsf.javatojs.translate.custom.CustomAttr;
import org.eclipse.vjet.dsf.jsnative.global.ObjLiteral;
import org.eclipse.vjet.dsf.jst.IJstLib;
import org.eclipse.vjet.dsf.jst.IJstMethod;
import org.eclipse.vjet.dsf.jst.IJstProperty;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.JstLib;
import org.eclipse.vjet.dsf.jst.declaration.JstArg;
import org.eclipse.vjet.dsf.jst.declaration.JstCache;
import org.eclipse.vjet.dsf.jst.declaration.JstMethod;
import org.eclipse.vjet.dsf.jst.declaration.JstModifiers;
import org.eclipse.vjet.dsf.jst.declaration.JstPackage;
import org.eclipse.vjet.dsf.jst.declaration.JstType;
import org.eclipse.vjet.dsf.jst.lib.IJstLibProvider;
import org.eclipse.vjet.vjo.VjoTypes;
import org.eclipse.vjet.vjo.lib.LibManager;

public class DefaultJstLibProvider
implements IJstLibProvider {
    private Map<String, IJstLib> m_jstLibMap = new HashMap<String, IJstLib>();
    private static final String ObjLiteralType = ObjLiteral.class.getName();

    public DefaultJstLibProvider() {
        LibManager libMgr = LibManager.getInstance();
        this.add(libMgr.getJavaPrimitiveLib());
        IJstLib jsnativeLib = libMgr.getJsNativeGlobalLib();
        IJstLib browserLib = libMgr.getBrowserTypesLib();
        IJstLib vjoLib = libMgr.getVjoSelfDescLib();
        IJstLib vjoJavaLib = libMgr.getVjoJavaLib();
        this.add(jsnativeLib);
        this.add(browserLib);
        this.add(vjoLib);
        this.add(vjoJavaLib);
        JstCache.getInstance().addType(VjoTypes.VJO_JAVA_LANG_UTIL);
    }

    public DefaultJstLibProvider add(IJstLib jstLib) {
        if (jstLib == null) {
            return this;
        }
        this.processLibrary(jstLib);
        this.m_jstLibMap.put(jstLib.getName(), jstLib);
        JstCache.getInstance().addLib(jstLib);
        return this;
    }

    public void clearAll() {
        this.m_jstLibMap.clear();
    }

    public List<IJstLib> getAll() {
        return new ArrayList<IJstLib>(this.m_jstLibMap.values());
    }

    public IJstLib remove(String libName) {
        return this.m_jstLibMap.remove(libName);
    }

    private void replace(IJstLib jstLib) {
        this.m_jstLibMap.put(jstLib.getName(), jstLib);
    }

    private void processLibrary(IJstLib lib) {
        TranslateCtx ctx = TranslateCtx.ctx();
        if (lib != null) {
            JstLib jstLib = (JstLib)lib;
            if ("JsNativeLib".equals(lib.getName()) || "JsNativeGlobal".equals(lib.getName())) {
                jstLib = new JstLib(lib.getName());
                for (JstType jstType : lib.getAllTypes(true)) {
                    String fullName = jstType.getAlias();
                    if (fullName != null && fullName.lastIndexOf(46) > 0) {
                        if (jstType.getName().equals("String")) {
                            this.modifyStringType(jstType);
                        } else {
                            jstType.setPackage(new JstPackage(fullName.substring(0, fullName.lastIndexOf(46))));
                        }
                    } else {
                        return;
                    }
                    for (IJstProperty pty : jstType.getProperties()) {
                        JstMethod getter = this.getterMethod(pty);
                        jstType.addMethod((IJstMethod)getter);
                        JstMethod setter = this.setterMethod(pty);
                        jstType.addMethod((IJstMethod)setter);
                    }
                    if (!jstType.getAlias().equals(jstType.getName())) {
                        jstType.setSimpleName(TranslateHelper.getShortName(jstType.getAlias()));
                    }
                    jstLib.addType(jstType);
                    if (ObjLiteralType.equals(jstType.getName())) {
                        ctx.setCustomAttr((IJstType)jstType, CustomAttr.JAVA_ONLY);
                        continue;
                    }
                    ctx.setCustomAttr((IJstType)jstType, CustomAttr.MAPPED_TO_JS);
                }
            }
        }
    }

    private void modifyStringType(JstType jstType) {
    }

    private JstMethod getterMethod(IJstProperty pty) {
        JstMethod mtd = new JstMethod("get" + this.CapitalizeFirstLetter(pty.getName().toString()), new JstModifiers().setPublic(), new JstArg[0]);
        mtd.setRtnType(pty.getType());
        return mtd;
    }

    private JstMethod setterMethod(IJstProperty pty) {
        JstMethod mtd = new JstMethod("set" + this.CapitalizeFirstLetter(pty.getName().toString()), new JstModifiers().setPublic(), new JstArg[]{new JstArg(pty.getType(), "arg1", false)});
        return mtd;
    }

    private String CapitalizeFirstLetter(String name) {
        if (TranslateHelper.isNameAllCapitalized(name)) {
            return name;
        }
        String n = String.valueOf(name.substring(0, 1).toUpperCase()) + name.substring(1);
        return n;
    }
}

