/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.javatojs.translate.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.vjet.dsf.javatojs.translate.TranslateCtx;
import org.eclipse.vjet.dsf.javatojs.translate.TranslateHelper;
import org.eclipse.vjet.dsf.javatojs.translate.TranslateInfo;
import org.eclipse.vjet.dsf.jst.IJstMethod;
import org.eclipse.vjet.dsf.jst.IJstNode;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.declaration.JstArg;
import org.eclipse.vjet.dsf.jst.declaration.JstArray;
import org.eclipse.vjet.dsf.jst.declaration.JstCache;
import org.eclipse.vjet.dsf.jst.declaration.JstMethod;
import org.eclipse.vjet.dsf.jst.declaration.JstParamType;
import org.eclipse.vjet.dsf.jst.declaration.JstProperty;
import org.eclipse.vjet.dsf.jst.declaration.JstType;
import org.eclipse.vjet.dsf.jst.expr.ArithExpr;
import org.eclipse.vjet.dsf.jst.expr.AssignExpr;
import org.eclipse.vjet.dsf.jst.expr.CastExpr;
import org.eclipse.vjet.dsf.jst.expr.InfixExpr;
import org.eclipse.vjet.dsf.jst.expr.JstArrayInitializer;
import org.eclipse.vjet.dsf.jst.expr.MtdInvocationExpr;
import org.eclipse.vjet.dsf.jst.expr.ObjCreationExpr;
import org.eclipse.vjet.dsf.jst.expr.ParenthesizedExpr;
import org.eclipse.vjet.dsf.jst.expr.PostfixExpr;
import org.eclipse.vjet.dsf.jst.expr.PrefixExpr;
import org.eclipse.vjet.dsf.jst.term.JstIdentifier;
import org.eclipse.vjet.dsf.jst.term.SimpleLiteral;
import org.eclipse.vjet.dsf.jst.token.IExpr;
import org.eclipse.vjet.dsf.jst.token.ILHS;
import org.eclipse.vjet.dsf.jst.util.DataTypeHelper;

public class AutoUnboxer {
    private static AutoUnboxer s_instance = new AutoUnboxer();
    private static Map<String, String> s_mtdNames = new HashMap<String, String>();
    private static List<InfixExpr.Operator> s_arithInfixOperators;
    private static List<PrefixExpr.Operator> s_arithPrefixOperators;
    private static List<PostfixExpr.Operator> s_arithPostfixOperators;
    private static List<InfixExpr.Operator> s_boolInfixOperators;
    private static List<PrefixExpr.Operator> s_boolPrefixOperators;

    static {
        s_mtdNames.put("boolean", "booleanValue");
        s_mtdNames.put("byte", "byteValue");
        s_mtdNames.put("short", "shortValue");
        s_mtdNames.put("int", "intValue");
        s_mtdNames.put("float", "floatValue");
        s_mtdNames.put("long", "longValue");
        s_mtdNames.put("double", "doubleValue");
        s_mtdNames.put("char", "charValue");
        s_arithInfixOperators = new ArrayList<InfixExpr.Operator>();
        s_arithInfixOperators.add(InfixExpr.Operator.PLUS);
        s_arithInfixOperators.add(InfixExpr.Operator.MINUS);
        s_arithInfixOperators.add(InfixExpr.Operator.TIMES);
        s_arithInfixOperators.add(InfixExpr.Operator.DIVIDE);
        s_arithInfixOperators.add(InfixExpr.Operator.AND);
        s_arithInfixOperators.add(InfixExpr.Operator.OR);
        s_arithInfixOperators.add(InfixExpr.Operator.XOR);
        s_arithPrefixOperators = new ArrayList<PrefixExpr.Operator>();
        s_arithPrefixOperators.add(PrefixExpr.Operator.PLUS);
        s_arithPrefixOperators.add(PrefixExpr.Operator.MINUS);
        s_arithPrefixOperators.add(PrefixExpr.Operator.INCREMENT);
        s_arithPrefixOperators.add(PrefixExpr.Operator.DECREMENT);
        s_arithPrefixOperators.add(PrefixExpr.Operator.COMPLEMENT);
        s_arithPostfixOperators = new ArrayList<PostfixExpr.Operator>();
        s_arithPostfixOperators.add(PostfixExpr.Operator.INCREMENT);
        s_arithPostfixOperators.add(PostfixExpr.Operator.DECREMENT);
        s_boolInfixOperators = new ArrayList<InfixExpr.Operator>();
        s_boolInfixOperators.add(InfixExpr.Operator.CONDITIONAL_AND);
        s_boolInfixOperators.add(InfixExpr.Operator.CONDITIONAL_OR);
        s_boolPrefixOperators = new ArrayList<PrefixExpr.Operator>();
        s_boolPrefixOperators.add(PrefixExpr.Operator.NOT);
    }

    private AutoUnboxer() {
    }

    public static AutoUnboxer getInstance() {
        return s_instance;
    }

    public boolean needAutoUnboxing(IExpr expr, IJstType expectedType) {
        IJstType toType;
        IJstNode binding;
        MtdInvocationExpr mtdExpr;
        IExpr mtdIdentifier;
        if (expr == null) {
            return false;
        }
        if (expr instanceof AssignExpr) {
            AssignExpr assignExpr = (AssignExpr)expr;
            return this.needAutoUnboxing(assignExpr.getExpr(), assignExpr.getResultType());
        }
        if (expr instanceof MtdInvocationExpr && (mtdIdentifier = (mtdExpr = (MtdInvocationExpr)expr).getMethodIdentifier()) != null && mtdIdentifier instanceof JstIdentifier && (binding = ((JstIdentifier)mtdIdentifier).getJstBinding()) instanceof IJstMethod) {
            IJstMethod jstMtd = (IJstMethod)binding;
            JstArg expectedArg = null;
            int i = 0;
            while (i < mtdExpr.getArgs().size()) {
                IExpr actualArg = (IExpr)mtdExpr.getArgs().get(i);
                if (i < jstMtd.getArgs().size()) {
                    expectedArg = (JstArg)jstMtd.getArgs().get(i);
                }
                if (expectedArg != null && this.needAutoUnboxing(actualArg, expectedArg.getType())) {
                    return true;
                }
                ++i;
            }
        }
        if (this.forceUnboxing(expr, toType = this.getExpectedType(expectedType))) {
            return true;
        }
        return this.needAutoUnboxing(expr.getResultType(), toType);
    }

    public boolean needAutoUnboxing(IJstType actualType, IJstType expectedType) {
        if (actualType == null || actualType.getSimpleName() == null || expectedType == null || expectedType.getSimpleName() == null) {
            return false;
        }
        if ((DataTypeHelper.isNumericPrimitiveType((IJstType)expectedType) || DataTypeHelper.isCharPrimitiveType((IJstType)expectedType)) && (actualType instanceof JstParamType || DataTypeHelper.isNumericWrapperType((IJstType)actualType))) {
            return true;
        }
        if (DataTypeHelper.isBooleanPrimitiveType((IJstType)expectedType) && (actualType instanceof JstParamType || DataTypeHelper.isBooleanWrapperType((IJstType)actualType))) {
            return true;
        }
        return !(!DataTypeHelper.isNumericPrimitiveType((IJstType)expectedType) && !DataTypeHelper.isCharPrimitiveType((IJstType)expectedType) || !(actualType instanceof JstParamType) && !DataTypeHelper.isCharWrapperType((IJstType)actualType));
    }

    public IExpr autoUnboxing(IExpr expr, IJstType expectedType) {
        if (!this.needAutoUnboxing(expr, expectedType)) {
            return expr;
        }
        return this.unbox(expr, expectedType);
    }

    private boolean forceUnboxing(IExpr expr, IJstType expectedType) {
        if (expr == null || expectedType == null) {
            return false;
        }
        if (expr instanceof JstArrayInitializer) {
            return true;
        }
        if (expr instanceof InfixExpr) {
            InfixExpr infix = (InfixExpr)expr;
            IExpr l = infix.getLeft();
            IExpr r = infix.getRight();
            return (l == null || !this.isStringType(l.getResultType())) && (r == null || !this.isStringType(r.getResultType()));
        }
        if (expr instanceof PrefixExpr) {
            PrefixExpr prefix = (PrefixExpr)expr;
            return prefix.getIdentifier() != null;
        }
        if (expr instanceof PostfixExpr) {
            PostfixExpr postfix = (PostfixExpr)expr;
            return postfix.getIdentifier() != null;
        }
        if (expr instanceof ParenthesizedExpr) {
            return this.forceUnboxing(((ParenthesizedExpr)expr).getExpression(), expectedType);
        }
        return false;
    }

    private IExpr unbox(IExpr expr, IJstType expectedType) {
        if (expr == null || expectedType == null) {
            return expr;
        }
        IJstType toType = this.getExpectedType(expectedType);
        if (expr instanceof SimpleLiteral) {
            return expr;
        }
        if (expr instanceof InfixExpr) {
            return this.unbox((InfixExpr)expr, toType);
        }
        if (expr instanceof PrefixExpr) {
            return this.unbox((PrefixExpr)expr, toType);
        }
        if (expr instanceof PostfixExpr) {
            return this.unbox((PostfixExpr)expr, toType);
        }
        if (expr instanceof ParenthesizedExpr) {
            return this.unbox((ParenthesizedExpr)expr, toType);
        }
        if (expr instanceof JstArrayInitializer) {
            return this.unbox((JstArrayInitializer)expr, toType);
        }
        if (expr instanceof AssignExpr) {
            IExpr newExpr;
            AssignExpr assignExpr = (AssignExpr)expr;
            toType = this.getExpectedType(assignExpr.getResultType());
            IExpr e = assignExpr.getExpr();
            if (this.needAutoUnboxing(e, toType) && (newExpr = this.unbox(e, toType)) != e) {
                assignExpr.setExpr(newExpr);
            }
            return expr;
        }
        if (expr instanceof MtdInvocationExpr) {
            IJstNode binding;
            MtdInvocationExpr mtdExpr = (MtdInvocationExpr)expr;
            if (mtdExpr.getMethodIdentifier() instanceof JstIdentifier && (binding = ((JstIdentifier)mtdExpr.getMethodIdentifier()).getJstBinding()) instanceof JstMethod) {
                JstMethod jstMtd = (JstMethod)binding;
                JstArg expectedArg = null;
                int i = 0;
                while (i < mtdExpr.getArgs().size()) {
                    IExpr newExpr;
                    IExpr actualArg = (IExpr)mtdExpr.getArgs().get(i);
                    if (i < jstMtd.getArgs().size()) {
                        expectedArg = (JstArg)jstMtd.getArgs().get(i);
                    }
                    if (expectedArg != null && this.needAutoUnboxing(actualArg, expectedArg.getType()) && (newExpr = this.unbox(actualArg, expectedArg.getType())) != actualArg) {
                        mtdExpr.setArg(i, newExpr);
                    }
                    ++i;
                }
            }
            if (this.needAutoUnboxing(expr.getResultType(), expectedType)) {
                return this.doIt(expr, expectedType);
            }
            return expr;
        }
        if (expr instanceof JstProperty) {
            IExpr newExpr;
            JstProperty pty = (JstProperty)expr;
            toType = this.getExpectedType(pty.getType());
            IExpr e = pty.getInitializer();
            if (this.needAutoUnboxing(e, toType) && (newExpr = this.unbox(e, toType)) != e) {
                pty.setInitializer(newExpr);
            }
            return expr;
        }
        if (expr instanceof JstIdentifier || expr instanceof ObjCreationExpr || expr instanceof MtdInvocationExpr) {
            return this.doIt(expr, toType);
        }
        if (expr instanceof CastExpr) {
            return this.doIt((IExpr)((CastExpr)expr), toType);
        }
        return expr;
    }

    private JstArrayInitializer unbox(JstArrayInitializer arrayInitializer, IJstType expectedType) {
        if (arrayInitializer == null) {
            return null;
        }
        List exprs = arrayInitializer.getExprs();
        if (exprs != null) {
            int i = 0;
            while (i < exprs.size()) {
                IExpr newExpr;
                IExpr expr = (IExpr)exprs.get(i);
                if (this.needAutoUnboxing(expr, expectedType) && (newExpr = this.unbox(expr, expectedType)) != expr) {
                    exprs.set(i, newExpr);
                }
                ++i;
            }
        }
        return arrayInitializer;
    }

    private InfixExpr unbox(InfixExpr infix, IJstType expectedType) {
        IExpr newExpr;
        IExpr newExpr2;
        IJstType t;
        ILHS lhs;
        AssignExpr assignExpr;
        ParenthesizedExpr pExpr;
        IExpr left = infix.getLeft();
        IExpr right = infix.getRight();
        if (left != null && this.isStringType(left.getResultType()) || right != null && this.isStringType(right.getResultType())) {
            return infix;
        }
        if (left != null) {
            if (left instanceof ArithExpr) {
                if (left instanceof ParenthesizedExpr && ((ParenthesizedExpr)left).getExpression() instanceof AssignExpr) {
                    pExpr = (ParenthesizedExpr)left;
                    assignExpr = (AssignExpr)pExpr.getExpression();
                    lhs = assignExpr.getLHS();
                    if (lhs != null && (DataTypeHelper.isBooleanWrapperType((IJstType)(t = lhs.getType())) || DataTypeHelper.isNumericWrapperType((IJstType)t) || DataTypeHelper.isCharWrapperType((IJstType)t)) && (newExpr2 = this.doIt((IExpr)pExpr, (IJstType)DataTypeHelper.getPrimitivetype((IJstType)t))) != left) {
                        infix.setLeft(newExpr2);
                    }
                } else {
                    this.unbox(left, expectedType);
                }
            } else if (this.needUnbox((ArithExpr)infix, left) && (newExpr = this.unbox(left, expectedType)) != left) {
                infix.setLeft(newExpr);
            }
        }
        if (right != null) {
            if (right instanceof ArithExpr) {
                if (right instanceof ParenthesizedExpr && ((ParenthesizedExpr)right).getExpression() instanceof AssignExpr) {
                    pExpr = (ParenthesizedExpr)right;
                    assignExpr = (AssignExpr)pExpr.getExpression();
                    lhs = assignExpr.getLHS();
                    if (lhs != null && (DataTypeHelper.isBooleanWrapperType((IJstType)(t = lhs.getType())) || DataTypeHelper.isNumericWrapperType((IJstType)t) || DataTypeHelper.isCharWrapperType((IJstType)t)) && (newExpr2 = this.doIt((IExpr)pExpr, (IJstType)DataTypeHelper.getPrimitivetype((IJstType)t))) != right) {
                        infix.setRight(newExpr2);
                    }
                } else {
                    this.unbox(right, expectedType);
                }
            } else if (this.needUnbox((ArithExpr)infix, right) && (newExpr = this.unbox(right, expectedType)) != right) {
                infix.setRight(newExpr);
            }
        }
        return infix;
    }

    private PrefixExpr unbox(PrefixExpr prefix, IJstType expectedType) {
        IExpr expr = prefix.getIdentifier();
        if (expr != null) {
            IExpr newExpr;
            if (expr instanceof ArithExpr) {
                this.unbox(expr, expectedType);
            } else if (this.needUnbox((ArithExpr)prefix, expr) && (newExpr = this.unbox(expr, expectedType)) != expr) {
                prefix.setOperand(newExpr);
            }
        }
        return prefix;
    }

    private PostfixExpr unbox(PostfixExpr postfix, IJstType expectedType) {
        IExpr expr = postfix.getIdentifier();
        if (expr != null) {
            IExpr newExpr;
            if (expr instanceof ArithExpr) {
                this.unbox(expr, expectedType);
            } else if (this.needUnbox((ArithExpr)postfix, expr) && (newExpr = this.unbox(expr, expectedType)) != expr) {
                postfix.setOperand(newExpr);
            }
        }
        return postfix;
    }

    private ParenthesizedExpr unbox(ParenthesizedExpr parenthesized, IJstType expectedType) {
        IExpr expr = parenthesized.getExpression();
        if (expr != null) {
            IExpr newExpr;
            if (expr instanceof ArithExpr) {
                this.unbox(expr, expectedType);
            } else if (this.needAutoUnboxing(expr, expectedType) && (newExpr = this.unbox(expr, expectedType)) != expr) {
                parenthesized.setExpression(newExpr);
            }
        }
        return parenthesized;
    }

    private boolean needUnbox(ArithExpr arithExpr, IExpr operand) {
        IJstType actualType = operand.getResultType();
        if (actualType == null) {
            return false;
        }
        if (AutoUnboxer.isArithOperation(arithExpr)) {
            return !DataTypeHelper.isCharPrimitiveType((IJstType)actualType) && !DataTypeHelper.isNumericPrimitiveType((IJstType)actualType);
        }
        if (AutoUnboxer.isBoolOperation(arithExpr)) {
            return !DataTypeHelper.isBooleanPrimitiveType((IJstType)actualType);
        }
        return false;
    }

    private IExpr doIt(IExpr expr, IJstType toType) {
        String mtdName;
        IJstType primitiveType = expr.getResultType();
        if (primitiveType == null || primitiveType instanceof JstParamType || TranslateHelper.isObjectType(primitiveType)) {
            primitiveType = toType;
        }
        if (!DataTypeHelper.isPrimitiveType((IJstType)primitiveType)) {
            primitiveType = DataTypeHelper.getPrimitivetype((IJstType)primitiveType);
        }
        if ((mtdName = AutoUnboxer.getMtdName(primitiveType)) == null) {
            return expr;
        }
        IJstNode parentNode = expr.getParentNode();
        MtdInvocationExpr mtdExpr = null;
        if (mtdName.equals("booleanValue")) {
            JstIdentifier identifier = new JstIdentifier("org.eclipse.vjet.vjo.java.lang.BooleanUtil.booleanValue");
            mtdExpr = new MtdInvocationExpr(identifier, new IExpr[0]);
            mtdExpr.setResultType(primitiveType);
            ArrayList<IExpr> args = new ArrayList<IExpr>();
            args.add(expr);
            mtdExpr.setArgs(args);
            mtdExpr.setParent(parentNode);
            if (parentNode.getRootType() instanceof JstType) {
                JstType ownerType = (JstType)parentNode.getRootType();
                JstType type = JstCache.getInstance().getType("org.eclipse.vjet.vjo.java.lang.BooleanUtil");
                ownerType.addImport((IJstType)type);
                TranslateInfo tInfo = TranslateCtx.ctx().getTranslateInfo(ownerType);
                tInfo.addActiveImport((IJstType)type);
            }
        } else {
            JstIdentifier identifier = new JstIdentifier(mtdName);
            mtdExpr = new MtdInvocationExpr(identifier, new IExpr[0]);
            mtdExpr.setQualifyExpr(expr);
            mtdExpr.setResultType(primitiveType);
            mtdExpr.setParent(parentNode);
        }
        return mtdExpr;
    }

    private IJstType getExpectedType(IJstType expectedType) {
        if (expectedType == null) {
            return null;
        }
        if (expectedType instanceof JstArray) {
            return ((JstArray)expectedType).getComponentType();
        }
        return expectedType;
    }

    private boolean isStringType(IJstType jstType) {
        return DataTypeHelper.isString((IJstType)jstType);
    }

    private static String getMtdName(IJstType primitiveType) {
        if (primitiveType == null) {
            return null;
        }
        return s_mtdNames.get(primitiveType.getSimpleName());
    }

    private static boolean isArithOperation(ArithExpr expr) {
        if (expr == null) {
            return false;
        }
        if (expr instanceof InfixExpr) {
            return s_arithInfixOperators.contains(((InfixExpr)expr).getOperator());
        }
        if (expr instanceof PrefixExpr) {
            return s_arithPrefixOperators.contains(((PrefixExpr)expr).getOperator());
        }
        if (expr instanceof PostfixExpr) {
            return s_arithPostfixOperators.contains(((PostfixExpr)expr).getOperator());
        }
        return false;
    }

    private static boolean isBoolOperation(ArithExpr expr) {
        if (expr == null) {
            return false;
        }
        if (expr instanceof InfixExpr) {
            return s_boolInfixOperators.contains(((InfixExpr)expr).getOperator());
        }
        if (expr instanceof PrefixExpr) {
            return s_boolPrefixOperators.contains(((PrefixExpr)expr).getOperator());
        }
        return false;
    }
}

