/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.javatojs.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.JarURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.vjet.dsf.javatojs.control.IBuildResourceFilter;
import org.eclipse.vjet.dsf.javatojs.translate.TranslateCtx;
import org.eclipse.vjet.dsf.javatojs.translate.UnitTranslator;
import org.eclipse.vjet.dsf.javatojs.util.AstParserHelper;
import org.eclipse.vjet.dsf.jsgen.shared.generate.CodeStyle;
import org.eclipse.vjet.dsf.jsgen.shared.vjo.GeneratorCtx;
import org.eclipse.vjet.dsf.jsgen.shared.vjo.VjoGenerator;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.declaration.JstType;
import org.eclipse.vjet.dsf.util.JavaSourceLocator;

public class JavaToJsHelper {
    private static final String JAR_FILE_SEPARATOR = "!";

    public static void getDirectFiles(URL dir, List<URL> list, IBuildResourceFilter fileFilter) throws IOException, URISyntaxException {
        JavaToJsHelper.getFiles(dir, list, fileFilter, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void getFiles(URL dir, List<URL> list, IBuildResourceFilter fileFilter, boolean isRecursive) throws IOException, URISyntaxException {
        if (dir == null) {
            return;
        }
        URLConnection conn = null;
        if (dir.getProtocol().equalsIgnoreCase("jar")) {
            String[] splitOutput = dir.toExternalForm().split(JAR_FILE_SEPARATOR);
            try {
                conn = (JarURLConnection)new URL(String.valueOf(splitOutput[0]) + JAR_FILE_SEPARATOR + "/").openConnection();
                JarFile jarFile = ((JarURLConnection)conn).getJarFile();
                String jarFileUrlPrefix = String.valueOf(splitOutput[0]) + JAR_FILE_SEPARATOR;
                if (splitOutput == null || splitOutput.length <= 0) return;
                String relativeDirPath = splitOutput[1];
                if (!relativeDirPath.endsWith("/")) {
                    relativeDirPath = String.valueOf(relativeDirPath) + "/";
                }
                if (relativeDirPath.length() > 1 && relativeDirPath.startsWith("/")) {
                    relativeDirPath = relativeDirPath.substring(1);
                }
                int count = JavaToJsHelper.count(relativeDirPath, '/');
                Enumeration<JarEntry> jarEntries = jarFile.entries();
                while (jarEntries.hasMoreElements()) {
                    JarEntry currentEntry = jarEntries.nextElement();
                    if (!currentEntry.getName().startsWith(relativeDirPath) || currentEntry.isDirectory() || relativeDirPath.equals(currentEntry.getName())) continue;
                    if (isRecursive) {
                        list.add(new URL(String.valueOf(jarFileUrlPrefix) + "/" + currentEntry.getName()));
                        continue;
                    }
                    if (count != JavaToJsHelper.count(currentEntry.getName(), '/')) continue;
                    list.add(new URL(String.valueOf(jarFileUrlPrefix) + "/" + currentEntry.getName()));
                }
                return;
            }
            finally {
                if (conn != null) {
                    conn.getOutputStream().close();
                }
            }
        } else {
            File rootFile;
            File[] files;
            if (!dir.getProtocol().equalsIgnoreCase("file") || (files = (rootFile = new File(dir.toURI())).listFiles()) == null) return;
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File currentFile = fileArray[n2];
                URL url = currentFile.toURI().toURL();
                if (currentFile.isDirectory()) {
                    if (isRecursive) {
                        JavaToJsHelper.getFiles(url, list, fileFilter, isRecursive);
                    }
                } else if (fileFilter.accept(url)) {
                    list.add(url);
                }
                ++n2;
            }
        }
    }

    private static int count(String sourceString, char lookFor) {
        if (sourceString == null) {
            return -1;
        }
        int count = 0;
        int i = 0;
        while (i < sourceString.length()) {
            char c = sourceString.charAt(i);
            if (c == lookFor) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    public static String genVjo(Class<?> clz) throws IOException {
        return JavaToJsHelper.genVjo(clz, null, null);
    }

    public static String genVjo(Class<?> clz, TranslateCtx tCtx, GeneratorCtx gCtx) throws IOException {
        if (tCtx == null) {
            tCtx = TranslateCtx.ctx();
        }
        if (gCtx == null) {
            gCtx = new GeneratorCtx(CodeStyle.PRETTY);
        }
        JstType jst = JavaToJsHelper.translate(clz, tCtx);
        return JavaToJsHelper.toVjo(jst, gCtx);
    }

    public static JstType translate(Class<?> clz, TranslateCtx ctx) throws IOException {
        CompilationUnit cu = JavaToJsHelper.parse(clz);
        UnitTranslator translator = new UnitTranslator();
        JstType type = translator.processUnit(cu);
        ctx.getErrorReporter().reportAll();
        return type;
    }

    public static String toVjo(JstType jst, GeneratorCtx ctx) {
        VjoGenerator writer = ctx.getProvider().getTypeGenerator();
        writer.writeVjo((IJstType)jst);
        return writer.getGeneratedText();
    }

    public static CompilationUnit parse(String clzName) throws IOException {
        String inSource = JavaToJsHelper.readFromInputReader(new InputStreamReader(JavaSourceLocator.getInstance().getSourceUrl(clzName).openStream()));
        if (inSource == null) {
            return null;
        }
        ASTParser astParser = AstParserHelper.newParser();
        astParser.setSource(inSource.toCharArray());
        CompilationUnit cu = (CompilationUnit)astParser.createAST(null);
        return cu;
    }

    public static CompilationUnit toAst(String source) {
        ASTParser astParser = AstParserHelper.newParser();
        astParser.setSource(source.toCharArray());
        CompilationUnit cu = (CompilationUnit)astParser.createAST(null);
        return cu;
    }

    private static CompilationUnit parse(char[] source) {
        ASTParser astParser = AstParserHelper.newParser();
        astParser.setSource(source);
        return (CompilationUnit)astParser.createAST(null);
    }

    public static CompilationUnit parse(Class<?> cls) throws IOException {
        String inSource = JavaToJsHelper.readFromInputReader(new InputStreamReader(JavaSourceLocator.getInstance().getSourceUrl(cls).openStream()));
        ASTParser astParser = AstParserHelper.newParser();
        astParser.setSource(inSource.toCharArray());
        CompilationUnit cu = (CompilationUnit)astParser.createAST(null);
        return cu;
    }

    /*
     * Loose catch block
     */
    public static String readFromFile(String fileName) {
        String string;
        InputStreamReader isr;
        FileInputStream fis;
        block20: {
            String code;
            fis = null;
            isr = null;
            String characterEncoding = "utf-8";
            fis = new FileInputStream(fileName);
            isr = new InputStreamReader((InputStream)fis, characterEncoding);
            string = code = JavaToJsHelper.readFromInputReader(isr);
            if (fis == null) break block20;
            try {
                fis.close();
            }
            catch (IOException iOException) {}
        }
        if (isr != null) {
            try {
                isr.close();
            }
            catch (IOException iOException) {}
        }
        return string;
        catch (Exception exception) {
            block21: {
                try {
                    if (fis == null) break block21;
                }
                catch (Throwable throwable) {
                    if (fis != null) {
                        try {
                            fis.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (isr != null) {
                        try {
                            isr.close();
                        }
                        catch (IOException iOException) {}
                    }
                    throw throwable;
                }
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
            }
            if (isr != null) {
                try {
                    isr.close();
                }
                catch (IOException iOException) {}
            }
            return null;
        }
    }

    public static String getClassName(String pkgPath) {
        String clzNameWithExtension = JavaToJsHelper.getPackageName(pkgPath);
        return clzNameWithExtension.substring(0, clzNameWithExtension.lastIndexOf("."));
    }

    public static String getPkgNameFromSrc(String src) {
        if (src == null || src.length() == 0) {
            return null;
        }
        ASTParser astParser = AstParserHelper.newParser(false);
        astParser.setSource(src.toCharArray());
        CompilationUnit cu = (CompilationUnit)astParser.createAST(null);
        if (cu == null || cu.getPackage() == null) {
            return null;
        }
        String pkgName = cu.getPackage().getName().getFullyQualifiedName();
        return pkgName;
    }

    private static String getPackageName(String pkgPath) {
        int index = pkgPath.indexOf("src");
        if (index < 0) {
            return null;
        }
        String pkgName = pkgPath.substring(index + 4);
        pkgName = pkgName.replace("\\", ".");
        pkgName = pkgName.replace("/", ".");
        return pkgName;
    }

    public static String readFromInputReader(InputStreamReader reader) {
        StringBuffer sb;
        block12: {
            sb = new StringBuffer();
            char[] buf = new char[4096];
            try {
                try {
                    int numRead;
                    do {
                        if ((numRead = reader.read(buf, 0, buf.length)) <= 0) continue;
                        sb.append(buf, 0, numRead);
                    } while (numRead >= 0);
                }
                catch (Exception exception) {
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {}
                    break block12;
                }
            }
            catch (Throwable throwable) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                reader.close();
            }
            catch (IOException iOException) {}
        }
        return sb.toString();
    }
}

