/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jst;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.vjet.dsf.jst.IJstAnnotation;
import org.eclipse.vjet.dsf.jst.IJstNode;
import org.eclipse.vjet.dsf.jst.JstCommentLocation;
import org.eclipse.vjet.dsf.jst.JstSource;
import org.eclipse.vjet.dsf.jst.declaration.JstAnnotation;
import org.eclipse.vjet.dsf.jst.declaration.JstType;
import org.eclipse.vjet.dsf.jst.traversal.IJstNodeVisitor;

public class BaseJstNode
implements IJstNode {
    private static final long serialVersionUID = 1L;
    private BaseJstNode m_parent;
    private List<BaseJstNode> m_children;
    private JstSource m_source;
    private List<IJstAnnotation> m_annotations;
    private List<String> m_comments;
    private List<JstCommentLocation> m_commentLocations;

    public BaseJstNode() {
        this(null);
    }

    public BaseJstNode(BaseJstNode parent) {
        this.setParent(parent);
    }

    @Override
    public BaseJstNode getRootNode() {
        if (this.m_parent == null) {
            return this;
        }
        BaseJstNode root = this.m_parent;
        while (root.getParentNode() != null) {
            root = root.getParentNode();
        }
        return root;
    }

    @Override
    public BaseJstNode getParentNode() {
        return this.m_parent;
    }

    @Override
    public JstType getOwnerType() {
        if (this instanceof JstType) {
            return (JstType)this;
        }
        if (this.m_parent != null) {
            return this.m_parent.getOwnerType();
        }
        return null;
    }

    @Override
    public JstType getRootType() {
        JstType parentType;
        JstType rootType = parentType = this.getOwnerType();
        while (parentType != null && parentType.getParentNode() != null) {
            rootType = parentType.getParentNode().getOwnerType();
            parentType = parentType.getParentNode().getOwnerType();
        }
        return rootType;
    }

    public List<BaseJstNode> getChildren() {
        return this.getChildren(true);
    }

    @Override
    public JstSource getSource() {
        return this.m_source;
    }

    public void setParent(IJstNode parent) {
        this.setParent(parent, true);
    }

    public void setParent(IJstNode parent, boolean includeAsChild) {
        if (this.m_parent == parent) {
            return;
        }
        if (this.m_parent != null) {
            this.m_parent.removeChild(this);
        }
        if (parent instanceof BaseJstNode) {
            if (parent != null) {
                if (parent instanceof BaseJstNode && ((BaseJstNode)parent).isAncestor(this)) {
                    return;
                }
                if (includeAsChild) {
                    ((BaseJstNode)parent).addChild(this);
                }
            }
            this.m_parent = (BaseJstNode)parent;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChild(IJstNode child) {
        if (child == null || this.getChildren(true).contains(child)) {
            return;
        }
        if (this.isAncestor(child)) {
            return;
        }
        if (child instanceof BaseJstNode) {
            BaseJstNode baseJstNode = this;
            synchronized (baseJstNode) {
                this.initChildren();
                this.m_children.add((BaseJstNode)child);
            }
            ((BaseJstNode)child).setParent(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChild(IJstNode child) {
        if (child == null || !this.getChildren(true).contains(child)) {
            return;
        }
        BaseJstNode baseJstNode = this;
        synchronized (baseJstNode) {
            this.initChildren();
            this.m_children.remove(child);
        }
        if (child instanceof BaseJstNode) {
            ((BaseJstNode)child).setParent(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChildren(Collection<? extends IJstNode> c) {
        BaseJstNode baseJstNode = this;
        synchronized (baseJstNode) {
            this.initChildren();
            for (IJstNode iJstNode : c) {
                this.m_children.remove(iJstNode);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearChildren() {
        BaseJstNode baseJstNode = this;
        synchronized (baseJstNode) {
            this.m_children = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAnnotation(JstAnnotation annot) {
        if (annot == null) {
            return;
        }
        BaseJstNode baseJstNode = this;
        synchronized (baseJstNode) {
            if (this.m_annotations == null) {
                this.m_annotations = new ArrayList<IJstAnnotation>();
            }
            if (!this.m_annotations.contains(annot)) {
                this.m_annotations.add(annot);
                this.addChild(annot);
            }
        }
    }

    @Override
    public List<IJstAnnotation> getAnnotations() {
        if (this.m_annotations == null || this.m_annotations.isEmpty()) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.m_annotations);
    }

    public void setAnnotations(List<IJstAnnotation> annotations) {
        this.m_annotations = annotations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IJstAnnotation getAnnotation(String name) {
        if (this.m_annotations == null || this.m_annotations.isEmpty()) {
            return null;
        }
        BaseJstNode baseJstNode = this;
        synchronized (baseJstNode) {
            for (IJstAnnotation anno : this.m_annotations) {
                if (!anno.getName().toString().equals(name)) continue;
                return anno;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAnnotations() {
        BaseJstNode baseJstNode = this;
        synchronized (baseJstNode) {
            if (this.m_annotations == null) {
                return;
            }
            for (IJstAnnotation annot : this.m_annotations) {
                this.removeChild((JstAnnotation)annot);
            }
            this.m_annotations = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCommentLocations() {
        BaseJstNode baseJstNode = this;
        synchronized (baseJstNode) {
            if (this.m_commentLocations == null) {
                return;
            }
            this.m_commentLocations = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearComments() {
        BaseJstNode baseJstNode = this;
        synchronized (baseJstNode) {
            if (this.m_comments == null) {
                return;
            }
            this.m_comments = null;
        }
    }

    public void setSource(JstSource source) {
        this.m_source = source;
    }

    @Override
    public List<String> getComments() {
        return this.m_comments;
    }

    @Override
    public List<JstCommentLocation> getCommentLocations() {
        if (this.m_commentLocations == null) {
            return Collections.EMPTY_LIST;
        }
        return this.m_commentLocations;
    }

    public void setComments(List<String> comments) {
        this.m_comments = comments;
    }

    public void addCommentLocation(int startOffset, int endOffset) {
        this.addCommentLocation(new JstCommentLocation(startOffset, endOffset));
    }

    public void addCommentLocation(int startOffset, int endOffset, boolean isVjetComment) {
        this.addCommentLocation(new JstCommentLocation(startOffset, endOffset, isVjetComment));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCommentLocation(JstCommentLocation location) {
        if (location == null) {
            return;
        }
        BaseJstNode baseJstNode = this;
        synchronized (baseJstNode) {
            if (this.m_commentLocations == null) {
                this.m_commentLocations = new ArrayList<JstCommentLocation>();
            }
            this.m_commentLocations.add(location);
        }
    }

    public void setCommentLocations(List<JstCommentLocation> commentLocations) {
        this.m_commentLocations = commentLocations;
    }

    private synchronized List<BaseJstNode> getChildren(boolean readOnly) {
        this.initChildren();
        if (readOnly) {
            return Collections.unmodifiableList(this.m_children);
        }
        return this.m_children;
    }

    private synchronized void initChildren() {
        if (this.m_children == null) {
            this.m_children = new ArrayList<BaseJstNode>();
        }
    }

    private boolean isAncestor(IJstNode node) {
        IJstNode parent = this.getParentNode();
        while (parent != null && parent != parent.getParentNode()) {
            if (parent == node) {
                return true;
            }
            parent = parent.getParentNode();
        }
        return false;
    }

    public static String prettyPrintNode(IJstNode n) {
        if (n == null) {
            return "[null]";
        }
        String p = n.getParentNode() != null ? BaseJstNode.prettyPrintNode(n.getParentNode()) : "";
        return String.valueOf(p) + "/[" + n.getClass().getSimpleName() + ":" + n.toString().replaceAll("\\s+", " ") + "]";
    }

    @Override
    public void accept(IJstNodeVisitor visitor) {
        visitor.visit(this);
    }
}

