/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jst.declaration;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.vjet.dsf.common.Z;
import org.eclipse.vjet.dsf.jst.BaseJstNode;
import org.eclipse.vjet.dsf.jst.IJstAnnotation;
import org.eclipse.vjet.dsf.jst.declaration.JstName;
import org.eclipse.vjet.dsf.jst.token.IExpr;
import org.eclipse.vjet.dsf.jst.traversal.IJstNodeVisitor;

public class JstAnnotation
extends BaseJstNode
implements IJstAnnotation {
    private static final long serialVersionUID = 1L;
    private JstName m_name;
    private List<IExpr> m_values;

    public JstAnnotation() {
    }

    public JstAnnotation(String name) {
        this.m_name = new JstName(name);
    }

    public JstAnnotation(String name, IExpr ... values) {
        this.m_name = new JstName(name);
        IExpr[] iExprArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            IExpr iExpr = iExprArray[n2];
            this.m_values.add(iExpr);
            ++n2;
        }
    }

    public JstAnnotation(JstName name) {
        this.m_name = name;
    }

    public JstAnnotation(JstName name, IExpr ... values) {
        this.m_name = name;
        IExpr[] iExprArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            IExpr iExpr = iExprArray[n2];
            this.m_values.add(iExpr);
            ++n2;
        }
    }

    @Override
    public JstName getName() {
        return this.m_name;
    }

    public void setName(String name) {
        this.setName(new JstName(name));
    }

    public void setName(JstName name) {
        assert (name != null) : "name cannot be null";
        this.m_name = name;
    }

    public void addExpr(IExpr expr) {
        if (this.m_values == null) {
            this.m_values = new ArrayList<IExpr>();
        }
        this.m_values.add(expr);
        this.addChild(expr);
    }

    @Override
    public List<IExpr> values() {
        if (this.m_values == null || this.m_values.size() == 0) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.m_values);
    }

    @Override
    public void accept(IJstNodeVisitor visitor) {
        visitor.visit(this);
    }

    public String toString() {
        Z z = new Z();
        z.format("m_name", this.m_name == null ? null : this.m_name.getName());
        z.format("m_values", this.m_values);
        return z.toString();
    }
}

