/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jst.declaration;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.vjet.dsf.common.Z;
import org.eclipse.vjet.dsf.jst.IJstMethod;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.declaration.JstCache;
import org.eclipse.vjet.dsf.jst.declaration.JstMixedType;
import org.eclipse.vjet.dsf.jst.declaration.JstType;
import org.eclipse.vjet.dsf.jst.traversal.IJstNodeVisitor;

public class JstArray
extends JstType {
    private static final long serialVersionUID = 1L;
    private IJstType m_componentType;

    public JstArray(IJstType componentType) {
        this.m_componentType = componentType;
        this.addExtend(JstCache.getInstance().getType("Array"));
    }

    @Override
    public String getSimpleName() {
        String name = this.getElementType().getSimpleName();
        int dimensions = this.getDimensions();
        int i = 0;
        while (i < dimensions) {
            name = String.valueOf(name) + "[]";
            ++i;
        }
        return name;
    }

    @Override
    public List<IJstMethod> getMethods(boolean isStatic, boolean recursive) {
        if (this.m_componentType instanceof JstMixedType) {
            ArrayList<IJstMethod> mtds = new ArrayList<IJstMethod>();
            JstMixedType mt = (JstMixedType)this.m_componentType;
            for (IJstType type : mt.m_types) {
                mtds.addAll(type.getMethods(isStatic, recursive));
            }
            return mtds;
        }
        return super.getMethods(isStatic, recursive);
    }

    @Override
    public IJstMethod getMethod(String name, boolean isStatic, boolean recursive) {
        boolean cfr_ignored_0 = this.m_componentType instanceof JstMixedType;
        return super.getMethod(name, isStatic, recursive);
    }

    @Override
    public String getName() {
        String name = this.getElementType().getName();
        int dimensions = this.getDimensions();
        int i = 0;
        while (i < dimensions) {
            name = String.valueOf(name) + "[]";
            ++i;
        }
        return name;
    }

    public int getDimensions() {
        IJstType type = this.getComponentType();
        int dimensions = 1;
        while (type != null && type instanceof JstArray) {
            ++dimensions;
            type = ((JstArray)type).getComponentType();
        }
        return dimensions;
    }

    public IJstType getElementType() {
        IJstType type = this.getComponentType();
        while (type != null && type instanceof JstArray) {
            type = ((JstArray)type).getComponentType();
        }
        return type;
    }

    public IJstType getComponentType() {
        return this.m_componentType;
    }

    @Override
    public void accept(IJstNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public String toString() {
        Z z = new Z();
        z.format("m_componentType", (Object)this.m_componentType);
        return z.toString();
    }
}

