/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jst.declaration;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.vjet.dsf.jst.BaseJstNode;
import org.eclipse.vjet.dsf.jst.declaration.VarTable;
import org.eclipse.vjet.dsf.jst.token.IStmt;
import org.eclipse.vjet.dsf.jst.traversal.IJstNodeVisitor;

public class JstBlock
extends BaseJstNode {
    private static final long serialVersionUID = 1L;
    private List<IStmt> m_stmts;
    protected VarTable m_varTable;

    public JstBlock addStmt(int index, IStmt stmt) {
        if (stmt == null) {
            return this;
        }
        if (this.m_stmts == null) {
            this.m_stmts = new ArrayList<IStmt>(5);
        }
        this.m_stmts.add(index, stmt);
        this.addChild((BaseJstNode)((Object)stmt));
        return this;
    }

    public JstBlock addStmt(IStmt stmt) {
        if (stmt == null) {
            return this;
        }
        if (this.m_stmts == null) {
            this.m_stmts = new ArrayList<IStmt>(5);
        }
        this.m_stmts.add(stmt);
        this.addChild((BaseJstNode)((Object)stmt));
        return this;
    }

    public List<IStmt> getStmts() {
        if (this.m_stmts == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.m_stmts);
    }

    public VarTable getVarTable() {
        if (this.m_varTable == null) {
            this.m_varTable = new VarTable();
        }
        return this.m_varTable;
    }

    public String toBlockText() {
        StringBuilder sb = new StringBuilder("{");
        for (IStmt stmt : this.getStmts()) {
            sb.append("\n").append(stmt.toStmtText());
        }
        sb.append("\n}");
        return sb.toString();
    }

    @Override
    public void accept(IJstNodeVisitor visitor) {
        visitor.visit(this);
    }

    public String toString() {
        return this.toBlockText();
    }
}

