/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jst.declaration;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.vjet.dsf.jst.IJstLib;
import org.eclipse.vjet.dsf.jst.IJstRefType;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.declaration.JstObjectLiteralType;
import org.eclipse.vjet.dsf.jst.declaration.JstPackage;
import org.eclipse.vjet.dsf.jst.declaration.JstRefType;
import org.eclipse.vjet.dsf.jst.declaration.JstType;

public class JstCache {
    private List<JstType> m_temp = new ArrayList<JstType>();
    private Map<String, JstType> m_types = new HashMap<String, JstType>();
    private Map<String, JstObjectLiteralType> m_aliasTypes = new HashMap<String, JstObjectLiteralType>();
    private Map<String, JstRefType> m_refTypes = new HashMap<String, JstRefType>();
    private Map<String, JstPackage> m_pkgs = new HashMap<String, JstPackage>();
    private Map<String, IJstLib> m_lib = new HashMap<String, IJstLib>();
    private Map<String, String> m_typeSymbolMapping = new HashMap<String, String>();
    private Map<IJstType, IJstRefType> m_typeRefTypeMap = new HashMap<IJstType, IJstRefType>();
    private Map<String, String> m_aliasTempMapping;
    private static JstCache s_instance = new JstCache();

    private JstCache() {
    }

    public static JstCache getInstance() {
        return s_instance;
    }

    public synchronized void addLib(IJstLib lib) {
        if (lib == null) {
            return;
        }
        for (JstType jst : lib.getAllTypes(true)) {
            this.addType(jst, true);
        }
    }

    public synchronized void addTypeSymbolMapping(String shortName, String longName) {
        this.m_typeSymbolMapping.put(shortName, longName);
    }

    public synchronized String getTypeSymbolMapping(String shortName) {
        return this.m_typeSymbolMapping.get(shortName);
    }

    public synchronized JstType addType(JstType type, boolean rtnExisting) {
        JstType existing;
        if (type == null) {
            return null;
        }
        if (rtnExisting && (existing = this.getType(type.getName())) != null) {
            return existing;
        }
        this.addType(type.getName(), type);
        return type;
    }

    public synchronized boolean addType(JstType type) {
        if (type.getAlias() != null && !type.getAlias().equals(type.getName())) {
            this.addType(type.getAlias(), type);
        }
        return this.addType(type.getName(), type);
    }

    public synchronized boolean addAliasType(String alias, JstObjectLiteralType type) {
        if (type == null) {
            return false;
        }
        if (alias == null) {
            return false;
        }
        if (type.isLocalType()) {
            return false;
        }
        this.m_aliasTypes.put(alias, type);
        return true;
    }

    public synchronized boolean addType(String key, JstType type) {
        if (type == null) {
            return false;
        }
        if (key == null) {
            this.m_temp.add(type);
            return true;
        }
        if (type.isLocalType()) {
            return false;
        }
        this.m_types.put(key, type);
        return true;
    }

    public synchronized boolean addOType(JstType oType) {
        if (oType == null) {
            return false;
        }
        this.m_types.put(oType.getName(), oType);
        return true;
    }

    public synchronized JstObjectLiteralType getAliasType(String alias, boolean create) {
        JstObjectLiteralType jstType = this.m_aliasTypes.get(alias);
        if (jstType != null) {
            return jstType;
        }
        if (create) {
            jstType = new JstObjectLiteralType(alias);
            this.addAliasType(alias, jstType);
            return jstType;
        }
        return null;
    }

    public synchronized JstType getType(String fullName, boolean create) {
        JstType jstType = this.getType(fullName);
        if (jstType != null) {
            return jstType;
        }
        if (create) {
            jstType = new JstType(fullName);
            this.addType(jstType);
            return jstType;
        }
        return null;
    }

    public synchronized JstType getType(String fullName) {
        if (fullName == null) {
            return null;
        }
        JstType type = this.m_refTypes.get(fullName);
        if (type != null) {
            return type;
        }
        type = this.m_types.get(fullName);
        if (type != null) {
            return type;
        }
        for (JstType t : this.m_temp) {
            if (!fullName.equals(t.getName())) continue;
            this.addType(fullName, t);
            this.m_temp.remove(t);
            return t;
        }
        for (IJstLib lib : this.m_lib.values()) {
            type = lib.getType(fullName, true);
            if (type == null) continue;
            return type;
        }
        return null;
    }

    public synchronized JstType getType(JstPackage pkg, String typeName) {
        String fullName = pkg == null ? typeName : String.valueOf(pkg.getName()) + "." + typeName;
        return this.getType(fullName);
    }

    public synchronized boolean addRefType(JstRefType type) {
        return this.addRefType(type.getName(), type);
    }

    public synchronized boolean addRefType(String key, JstRefType type) {
        if ("Void".equals(type.getSimpleName())) {
            this.m_refTypes.put("void", type);
            this.m_refTypes.put(key, type);
            return true;
        }
        if (type.isArray()) {
            String arrayKey = type.getSimpleName();
            int i = 0;
            while (i < type.getDimensions()) {
                arrayKey = String.valueOf(arrayKey) + "[]";
                ++i;
            }
            this.m_refTypes.put(arrayKey, type);
        } else {
            this.m_refTypes.put(key, type);
        }
        return true;
    }

    public synchronized JstRefType getRefType(String fullName) {
        JstRefType refType = this.m_refTypes.get(fullName);
        if (refType != null) {
            return refType;
        }
        for (IJstLib lib : this.m_lib.values()) {
            JstType jstType = lib.getType(fullName, true);
            if (jstType == null || !(jstType instanceof JstRefType)) continue;
            return (JstRefType)jstType;
        }
        return null;
    }

    public synchronized JstType getRefType(JstPackage pkg, String typeName) {
        String fullName = pkg == null ? typeName : String.valueOf(pkg.getName()) + "." + typeName;
        return this.getRefType(fullName);
    }

    public synchronized boolean addTypeRefType(IJstRefType type) {
        if (type == null) {
            return false;
        }
        this.m_typeRefTypeMap.put(type.getReferencedNode(), type);
        return true;
    }

    public IJstRefType getTypeRefType(IJstType type) {
        return this.m_typeRefTypeMap.get(type);
    }

    public synchronized boolean addPackage(JstPackage pkg) {
        if (pkg == null || this.m_pkgs.containsKey(pkg.getName())) {
            return false;
        }
        this.m_pkgs.put(pkg.getName(), pkg);
        return true;
    }

    public synchronized JstPackage getPackage(String fullName) {
        return this.m_pkgs.get(fullName);
    }

    /*
     * WARNING - void declaration
     */
    public synchronized boolean removeJstType(JstType type) {
        String key = null;
        if (this.m_types.containsValue(type)) {
            for (Map.Entry<String, JstType> entry : this.m_types.entrySet()) {
                if (entry.getValue() != type) continue;
                key = entry.getKey();
                break;
            }
            if (key != null) {
                return this.m_types.remove(key) != null;
            }
        }
        if (this.m_refTypes.containsValue(type)) {
            for (Map.Entry<String, JstType> entry : this.m_refTypes.entrySet()) {
                if (entry.getValue() != type) continue;
                key = entry.getKey();
                break;
            }
            if (key != null) {
                return this.m_refTypes.remove(key) != null;
            }
        }
        if (this.m_typeRefTypeMap.containsKey(type)) {
            void var3_9;
            Object var3_7 = null;
            for (Map.Entry<IJstType, IJstRefType> entry : this.m_typeRefTypeMap.entrySet()) {
                if (entry.getKey() != type) continue;
                IJstType iJstType = entry.getKey();
                break;
            }
            if (var3_9 != null) {
                return this.m_typeRefTypeMap.remove(var3_9) != null;
            }
        }
        return false;
    }

    public void printTypes(PrintStream p) {
        p.println("ref types in cache");
        for (IJstType iJstType : this.m_refTypes.values()) {
            p.println(iJstType.getName());
        }
        p.println("types in cache");
        for (IJstType iJstType : this.m_types.values()) {
            p.println(iJstType.getName());
        }
        p.println("types in temp");
        for (IJstType iJstType : this.m_temp) {
            p.println(iJstType.getName());
        }
        p.println("types with aliases");
        for (String string : this.m_aliasTypes.keySet()) {
            p.print("alias:" + string + this.m_aliasTypes.get(string).getName());
        }
        p.println("type in lib");
        for (IJstLib iJstLib : this.m_lib.values()) {
            for (JstType t : iJstLib.getAllTypes(true)) {
                p.println(t.getName());
            }
        }
    }

    public synchronized void clear() {
        this.m_types.clear();
        this.m_refTypes.clear();
        this.m_temp.clear();
        this.m_lib.clear();
        this.m_pkgs.clear();
        this.m_typeSymbolMapping.clear();
        this.m_typeRefTypeMap.clear();
        this.m_aliasTypes.clear();
        this.m_aliasTempMapping = null;
    }

    public boolean createAliasPlaceHolder(String alias, String typeName) {
        if (this.m_aliasTempMapping == null) {
            this.m_aliasTempMapping = new HashMap<String, String>();
        }
        this.m_aliasTempMapping.put(alias, typeName);
        return true;
    }
}

