/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jst.declaration;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.vjet.dsf.common.Z;
import org.eclipse.vjet.dsf.jst.IJstAnnotation;
import org.eclipse.vjet.dsf.jst.IJstDoc;
import org.eclipse.vjet.dsf.jst.IJstGlobalVar;
import org.eclipse.vjet.dsf.jst.IJstMethod;
import org.eclipse.vjet.dsf.jst.IJstNode;
import org.eclipse.vjet.dsf.jst.IJstOType;
import org.eclipse.vjet.dsf.jst.IJstProperty;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.IJstTypeReference;
import org.eclipse.vjet.dsf.jst.IScriptProblem;
import org.eclipse.vjet.dsf.jst.JstCommentLocation;
import org.eclipse.vjet.dsf.jst.JstSource;
import org.eclipse.vjet.dsf.jst.declaration.JstBlock;
import org.eclipse.vjet.dsf.jst.declaration.JstModifiers;
import org.eclipse.vjet.dsf.jst.declaration.JstPackage;
import org.eclipse.vjet.dsf.jst.declaration.JstParamType;
import org.eclipse.vjet.dsf.jst.token.IStmt;
import org.eclipse.vjet.dsf.jst.traversal.IJstNodeVisitor;

public class JstExtendedType
implements IJstType {
    private static final long serialVersionUID = 1L;
    private final IJstType m_targetType;
    private final List<IJstType> m_extendedTypes;

    public JstExtendedType(IJstType targetType, List<IJstType> extendedTypes) {
        this.m_targetType = targetType;
        this.m_extendedTypes = extendedTypes;
    }

    public IJstType getTargetType() {
        return this.m_targetType;
    }

    @Override
    public void accept(IJstNodeVisitor visitor) {
        this.m_targetType.accept(visitor);
    }

    @Override
    public void addOType(IJstOType otype) {
        this.m_targetType.addOType(otype);
    }

    @Override
    public String getAlias() {
        return this.m_targetType.getAlias();
    }

    @Override
    public String getAliasTypeName() {
        return this.m_targetType.getAliasTypeName();
    }

    @Override
    public List<IJstProperty> getAllPossibleProperties(boolean isStatic, boolean recursive) {
        List<IJstProperty> props = this.m_targetType.getAllPossibleProperties(isStatic, recursive);
        Set<String> names = this.getAllEntries();
        for (IJstType type : this.m_extendedTypes) {
            JstExtendedType.combineProps(props, type.getAllPossibleProperties(isStatic, recursive), names);
        }
        return props;
    }

    @Override
    public IJstAnnotation getAnnotation(String name) {
        return this.m_targetType.getAnnotation(name);
    }

    @Override
    public List<IJstAnnotation> getAnnotations() {
        return this.m_targetType.getAnnotations();
    }

    @Override
    public List<? extends IJstNode> getChildren() {
        return this.m_targetType.getChildren();
    }

    @Override
    public List<String> getComments() {
        return this.m_targetType.getComments();
    }

    @Override
    public List<JstCommentLocation> getCommentLocations() {
        return this.m_targetType.getCommentLocations();
    }

    @Override
    public IJstMethod getConstructor() {
        return this.m_targetType.getConstructor();
    }

    @Override
    public IJstType getContainingType() {
        return this.m_targetType.getContainingType();
    }

    @Override
    public IJstDoc getDoc() {
        return this.m_targetType.getDoc();
    }

    @Override
    public IJstType getEmbededType(String shortName) {
        return this.m_targetType.getEmbededType(shortName);
    }

    @Override
    public List<? extends IJstType> getEmbededTypes() {
        return this.m_targetType.getEmbededTypes();
    }

    @Override
    public IJstProperty getEnumValue(String name) {
        return this.m_targetType.getEnumValue(name);
    }

    @Override
    public List<IJstProperty> getEnumValues() {
        return this.m_targetType.getEnumValues();
    }

    @Override
    public List<? extends IJstType> getExpects() {
        return this.m_targetType.getExpects();
    }

    @Override
    public List<? extends IJstTypeReference> getExpectsRef() {
        return this.m_targetType.getExpectsRef();
    }

    @Override
    public IJstType getExtend() {
        return this.m_targetType.getExtend();
    }

    @Override
    public IJstTypeReference getExtendRef() {
        return this.m_targetType.getExtendRef();
    }

    @Override
    public List<? extends IJstType> getExtends() {
        return this.m_targetType.getExtends();
    }

    @Override
    public List<? extends IJstTypeReference> getExtendsRef() {
        return this.m_targetType.getExtendsRef();
    }

    @Override
    public IJstType getFullyQualifiedImport(String typeName) {
        return this.m_targetType.getFullyQualifiedImport(typeName);
    }

    @Override
    public List<? extends IJstType> getFullyQualifiedImports() {
        return this.m_targetType.getFullyQualifiedImports();
    }

    @Override
    public List<? extends IJstTypeReference> getFullyQualifiedImportsRef() {
        return this.m_targetType.getFullyQualifiedImportsRef();
    }

    @Override
    public IJstGlobalVar getGlobalVar(String name, boolean recursive) {
        return this.m_targetType.getGlobalVar(name, recursive);
    }

    @Override
    public IJstGlobalVar getGlobalVar(String name) {
        return this.m_targetType.getGlobalVar(name);
    }

    @Override
    public List<? extends IJstGlobalVar> getGlobalVars() {
        return this.m_targetType.getGlobalVars();
    }

    @Override
    public IJstType getImport(String typeName) {
        return this.m_targetType.getImport(typeName);
    }

    @Override
    public IJstTypeReference getImportRef(String typeName) {
        return this.m_targetType.getImportRef(typeName);
    }

    @Override
    public List<? extends IJstType> getImports() {
        return this.m_targetType.getImports();
    }

    @Override
    public Map<String, ? extends IJstType> getImportsMap() {
        return this.m_targetType.getImportsMap();
    }

    @Override
    public List<? extends IJstTypeReference> getImportsRef() {
        return this.m_targetType.getImportsRef();
    }

    @Override
    public IJstTypeReference getInactiveImportRef(String typeName) {
        return this.m_targetType.getInactiveImportRef(typeName);
    }

    @Override
    public IJstType getInactiveImport(String typeName) {
        return this.m_targetType.getInactiveImport(typeName);
    }

    @Override
    public List<? extends IJstType> getInactiveImports() {
        return this.m_targetType.getInactiveImports();
    }

    @Override
    public Map<String, ? extends IJstType> getInactiveImportsMap() {
        return this.m_targetType.getInactiveImportsMap();
    }

    @Override
    public List<? extends IJstTypeReference> getInactiveImportsRef() {
        return this.m_targetType.getInactiveImportsRef();
    }

    @Override
    public JstBlock getInitBlock() {
        return this.m_targetType.getInitBlock();
    }

    @Override
    public List<IStmt> getInitializers(boolean isStatic) {
        return this.m_targetType.getInitializers(isStatic);
    }

    @Override
    public List<? extends IJstType> getInstanceEmbededTypes() {
        return this.m_targetType.getInstanceEmbededTypes();
    }

    @Override
    public List<IStmt> getInstanceInitializers() {
        return this.m_targetType.getInstanceInitializers();
    }

    @Override
    public IJstMethod getInstanceMethod(String name, boolean recursive) {
        return this.getMethod(name, false, recursive);
    }

    @Override
    public IJstMethod getInstanceMethod(String name) {
        return this.getInstanceMethod(name, false);
    }

    @Override
    public List<? extends IJstMethod> getInstanceMethods() {
        return this.getMethods(false);
    }

    @Override
    public List<IJstProperty> getInstanceProperties() {
        return this.getProperties(false);
    }

    @Override
    public IJstProperty getInstanceProperty(String name, boolean recursive) {
        return this.getProperty(name, false, recursive);
    }

    @Override
    public IJstProperty getInstanceProperty(String name) {
        return this.getInstanceProperty(name, false);
    }

    @Override
    public IJstMethod getMethod(String name, boolean isStatic, boolean recursive) {
        IJstMethod method = this.m_targetType.getMethod(name, isStatic, recursive);
        if (method != null) {
            return method;
        }
        for (IJstType type : this.m_extendedTypes) {
            method = type.getMethod(name, isStatic, recursive);
            if (method == null) continue;
            return method;
        }
        return null;
    }

    @Override
    public IJstMethod getMethod(String name, boolean isStatic) {
        return this.getMethod(name, isStatic, false);
    }

    @Override
    public IJstMethod getMethod(String name) {
        IJstMethod method = this.m_targetType.getMethod(name);
        if (method != null) {
            return method;
        }
        for (IJstType type : this.m_extendedTypes) {
            method = type.getMethod(name);
            if (method == null) continue;
            return method;
        }
        return null;
    }

    @Override
    public List<? extends IJstMethod> getMethods() {
        ArrayList<IJstMethod> methods = new ArrayList<IJstMethod>(this.m_targetType.getMethods());
        Set<String> names = this.getAllEntries();
        for (IJstType type : this.m_extendedTypes) {
            JstExtendedType.combineMethods(methods, type.getMethods(), names);
        }
        return methods;
    }

    @Override
    public List<? extends IJstMethod> getMethods(boolean isStatic, boolean recursive) {
        ArrayList<IJstMethod> methods = new ArrayList<IJstMethod>(this.m_targetType.getMethods(isStatic, recursive));
        Set<String> names = this.getAllEntries();
        for (IJstType type : this.m_extendedTypes) {
            JstExtendedType.combineMethods(methods, type.getMethods(isStatic, recursive), names);
        }
        return methods;
    }

    @Override
    public List<? extends IJstMethod> getMethods(boolean isStatic) {
        return this.getMethods(isStatic, false);
    }

    @Override
    public List<? extends IJstType> getMixins() {
        return this.m_targetType.getMixins();
    }

    @Override
    public List<? extends IJstTypeReference> getMixinsRef() {
        return this.m_targetType.getMixinsRef();
    }

    @Override
    public JstModifiers getModifiers() {
        return this.m_targetType.getModifiers();
    }

    @Override
    public String getName() {
        return this.m_targetType.getName();
    }

    @Override
    public Map<String, Object> getOptions() {
        return this.m_targetType.getOptions();
    }

    @Override
    public IJstOType getOType(String name) {
        return this.m_targetType.getOType(name);
    }

    @Override
    public List<IJstOType> getOTypes() {
        return this.m_targetType.getOTypes();
    }

    @Override
    public IJstType getOuterType() {
        return this.m_targetType.getOuterType();
    }

    @Override
    public IJstType getOwnerType() {
        return this.m_targetType.getOwnerType();
    }

    @Override
    public JstPackage getPackage() {
        return this.m_targetType.getPackage();
    }

    @Override
    public List<String> getParamNames() {
        return this.m_targetType.getParamNames();
    }

    @Override
    public List<JstParamType> getParamTypes() {
        return this.m_targetType.getParamTypes();
    }

    @Override
    public IJstNode getParentNode() {
        return this.m_targetType.getParentNode();
    }

    @Override
    public List<IJstProperty> getProperties() {
        ArrayList<IJstProperty> props = new ArrayList<IJstProperty>(this.m_targetType.getProperties());
        Set<String> names = this.getAllEntries();
        for (IJstType type : this.m_extendedTypes) {
            JstExtendedType.combineProps(props, type.getProperties(), names);
        }
        return props;
    }

    @Override
    public List<IJstProperty> getProperties(boolean isStatic) {
        ArrayList<IJstProperty> props = new ArrayList<IJstProperty>(this.m_targetType.getProperties(isStatic));
        Set<String> names = this.getAllEntries();
        for (IJstType type : this.m_extendedTypes) {
            JstExtendedType.combineProps(props, type.getProperties(isStatic), names);
        }
        return props;
    }

    @Override
    public IJstProperty getProperty(String name, boolean isStatic, boolean recursive) {
        IJstProperty prop = this.m_targetType.getProperty(name, isStatic, recursive);
        if (prop != null) {
            return prop;
        }
        for (IJstType type : this.m_extendedTypes) {
            prop = type.getProperty(name, isStatic, recursive);
            if (prop == null) continue;
            return prop;
        }
        return null;
    }

    @Override
    public IJstProperty getProperty(String name, boolean isStatic) {
        return this.getProperty(name, isStatic, false);
    }

    @Override
    public IJstProperty getProperty(String name) {
        IJstProperty prop = this.m_targetType.getProperty(name);
        if (prop != null) {
            return prop;
        }
        for (IJstType type : this.m_extendedTypes) {
            prop = type.getProperty(name);
            if (prop == null) continue;
            return prop;
        }
        return null;
    }

    @Override
    public IJstNode getRootNode() {
        return this.m_targetType.getRootNode();
    }

    @Override
    public IJstType getRootType() {
        return this.m_targetType.getRootType();
    }

    @Override
    public List<? extends IJstType> getSatisfies() {
        return this.m_targetType.getSatisfies();
    }

    @Override
    public List<? extends IJstTypeReference> getSatisfiesRef() {
        return this.m_targetType.getSatisfiesRef();
    }

    @Override
    public IJstType getSiblingType(String shortName) {
        return this.m_targetType.getSiblingType(shortName);
    }

    @Override
    public List<? extends IJstType> getSiblingTypes() {
        return this.m_targetType.getSiblingTypes();
    }

    @Override
    public String getSimpleName() {
        return this.m_targetType.getSimpleName();
    }

    @Override
    public JstSource getSource() {
        return this.m_targetType.getSource();
    }

    @Override
    public List<? extends IJstType> getStaticEmbededTypes() {
        return this.m_targetType.getStaticEmbededTypes();
    }

    @Override
    public List<IStmt> getStaticInitializers() {
        return this.m_targetType.getStaticInitializers();
    }

    @Override
    public IJstMethod getStaticMethod(String name, boolean recursive) {
        return this.getMethod(name, true, recursive);
    }

    @Override
    public IJstMethod getStaticMethod(String name) {
        return this.getMethod(name, true, false);
    }

    @Override
    public List<? extends IJstMethod> getStaticMethods() {
        return this.getMethods(true);
    }

    @Override
    public List<IJstProperty> getStaticProperties() {
        return this.getProperties(true);
    }

    @Override
    public IJstProperty getStaticProperty(String name, boolean recursive) {
        return this.getProperty(name, true, recursive);
    }

    @Override
    public IJstProperty getStaticProperty(String name) {
        return this.getProperty(name, true, false);
    }

    @Override
    public boolean hasGlobalVars() {
        return this.m_targetType.hasGlobalVars();
    }

    @Override
    public boolean hasImport(String typeName) {
        return this.m_targetType.hasImport(typeName);
    }

    @Override
    public boolean hasInstanceMethod(String mtdName, boolean recursive) {
        if (this.m_targetType.hasInstanceMethod(mtdName, recursive)) {
            return true;
        }
        for (IJstType type : this.m_extendedTypes) {
            if (!type.hasInstanceMethod(mtdName, recursive)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasInstanceMethods() {
        if (this.m_targetType.hasInstanceMethods()) {
            return true;
        }
        for (IJstType type : this.m_extendedTypes) {
            if (!type.hasInstanceMethods()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasInstanceProperties() {
        if (this.m_targetType.hasInstanceProperties()) {
            return true;
        }
        for (IJstType type : this.m_extendedTypes) {
            if (!type.hasInstanceProperties()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasInstanceProperty(String name, boolean recursive) {
        if (this.m_targetType.hasInstanceProperty(name, recursive)) {
            return true;
        }
        for (IJstType type : this.m_extendedTypes) {
            if (!type.hasInstanceProperty(name, recursive)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasMixins() {
        return this.m_targetType.hasMixins();
    }

    @Override
    public boolean hasStaticMethod(String mtdName, boolean recursive) {
        if (this.m_targetType.hasStaticMethod(mtdName, recursive)) {
            return true;
        }
        for (IJstType type : this.m_extendedTypes) {
            if (!type.hasStaticMethod(mtdName, recursive)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasStaticMethods() {
        if (this.m_targetType.hasStaticMethods()) {
            return true;
        }
        for (IJstType type : this.m_extendedTypes) {
            if (!type.hasStaticMethods()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasStaticProperties() {
        if (this.m_targetType.hasStaticProperties()) {
            return true;
        }
        for (IJstType type : this.m_extendedTypes) {
            if (!type.hasStaticProperties()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasStaticProperty(String name, boolean recursive) {
        if (this.m_targetType.hasStaticProperty(name, recursive)) {
            return true;
        }
        for (IJstType type : this.m_extendedTypes) {
            if (!type.hasStaticProperty(name, recursive)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isAnonymous() {
        return this.m_targetType.isAnonymous();
    }

    @Override
    public boolean isClass() {
        return this.m_targetType.isClass();
    }

    @Override
    public boolean isEmbededType() {
        return this.m_targetType.isEmbededType();
    }

    @Override
    public boolean isEnum() {
        return this.m_targetType.isEnum();
    }

    @Override
    public boolean isFakeType() {
        return this.m_targetType.isFakeType();
    }

    @Override
    public boolean isFType() {
        return this.m_targetType.isFType();
    }

    @Override
    public boolean isImpliedImport() {
        return this.m_targetType.isImpliedImport();
    }

    @Override
    public boolean isInterface() {
        return this.m_targetType.isInterface();
    }

    @Override
    public boolean isLocalType() {
        return this.m_targetType.isLocalType();
    }

    @Override
    public boolean isMetaType() {
        return this.m_targetType.isMetaType();
    }

    @Override
    public boolean isMixin() {
        return this.m_targetType.isMixin();
    }

    @Override
    public boolean isOType() {
        return this.m_targetType.isOType();
    }

    @Override
    public boolean isParamName(String name) {
        return this.m_targetType.isParamName(name);
    }

    @Override
    public boolean isSiblingType() {
        return this.m_targetType.isSiblingType();
    }

    @Override
    public List<IJstType> getAllDerivedTypes() {
        return this.m_targetType.getAllDerivedTypes();
    }

    private static void combineProps(List<IJstProperty> props, List<IJstProperty> additions, Set<String> names) {
        for (IJstProperty prop : additions) {
            String name = prop.getName().getName();
            if (names.contains(name)) continue;
            names.add(name);
            props.add(prop);
        }
    }

    private static void combineMethods(List<IJstMethod> methods, List<? extends IJstMethod> additions, Set<String> names) {
        for (IJstMethod iJstMethod : additions) {
            String name = iJstMethod.getName().getName();
            if (names.contains(name)) continue;
            names.add(name);
            methods.add(iJstMethod);
        }
    }

    private Set<String> getAllEntries() {
        HashSet<String> names = new HashSet<String>();
        for (IJstProperty iJstProperty : this.m_targetType.getProperties()) {
            names.add(iJstProperty.getName().getName());
        }
        for (IJstMethod iJstMethod : this.m_targetType.getMethods()) {
            names.add(iJstMethod.getName().getName());
        }
        return names;
    }

    @Override
    public List<? extends IJstType> getSecondaryTypes() {
        throw new UnsupportedOperationException("secondary types not supported for extension");
    }

    @Override
    public boolean isSingleton() {
        return this.m_targetType.isSingleton();
    }

    @Override
    public List<JstBlock> getJstBlockList() {
        throw new UnsupportedOperationException("secondary types not supported for extension");
    }

    @Override
    public List<IScriptProblem> getProblems() {
        throw new UnsupportedOperationException("secondary types not supported for extension");
    }

    @Override
    public void setJstBlockList(List<JstBlock> blocks) {
        throw new UnsupportedOperationException("secondary types not supported for extension");
    }

    @Override
    public void setProblems(List<IScriptProblem> probs) {
        throw new UnsupportedOperationException("secondary types not supported for extension");
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Z.fmt((String)"target type: ", (Object)this.m_targetType));
        if (this.m_extendedTypes != null) {
            sb.append(Z.fmt((String)"extended type: ", this.m_extendedTypes));
        }
        return sb.toString();
    }
}

