/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jst.declaration;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.vjet.dsf.common.Z;
import org.eclipse.vjet.dsf.jst.BaseJstNode;
import org.eclipse.vjet.dsf.jst.IJstDoc;
import org.eclipse.vjet.dsf.jst.IJstGlobalVar;
import org.eclipse.vjet.dsf.jst.IJstMethod;
import org.eclipse.vjet.dsf.jst.IJstOType;
import org.eclipse.vjet.dsf.jst.IJstProperty;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.IJstTypeReference;
import org.eclipse.vjet.dsf.jst.IScriptProblem;
import org.eclipse.vjet.dsf.jst.ISynthesized;
import org.eclipse.vjet.dsf.jst.declaration.JstBlock;
import org.eclipse.vjet.dsf.jst.declaration.JstCache;
import org.eclipse.vjet.dsf.jst.declaration.JstMethod;
import org.eclipse.vjet.dsf.jst.declaration.JstModifiers;
import org.eclipse.vjet.dsf.jst.declaration.JstPackage;
import org.eclipse.vjet.dsf.jst.declaration.JstParamType;
import org.eclipse.vjet.dsf.jst.declaration.JstProxyMethod;
import org.eclipse.vjet.dsf.jst.declaration.JstProxyProperty;
import org.eclipse.vjet.dsf.jst.declaration.JstProxyType;
import org.eclipse.vjet.dsf.jst.declaration.JstTypeReference;
import org.eclipse.vjet.dsf.jst.declaration.JstTypeWithArgs;
import org.eclipse.vjet.dsf.jst.declaration.VarTable;
import org.eclipse.vjet.dsf.jst.token.IStmt;
import org.eclipse.vjet.dsf.jst.traversal.IJstNodeVisitor;

public class JstType
extends BaseJstNode
implements IJstType {
    private static final long serialVersionUID = 1L;
    private static final String EMPTY = "";
    private Category m_category = Category.CLASS;
    private JstPackage m_pkg;
    private String m_simpleName;
    private String m_alias;
    private String m_aliasTypeName;
    List<IJstOType> m_otypes = new ArrayList<IJstOType>();
    private Map<String, IJstTypeReference> m_imports = null;
    private Map<String, IJstTypeReference> m_inactiveImports = null;
    private Map<String, IJstTypeReference> m_fullyQualifiedImports = null;
    private List<IJstTypeReference> m_extends;
    private List<IJstTypeReference> m_satisfies;
    private List<IJstTypeReference> m_expects;
    private List<IJstTypeReference> m_mixins;
    private Map<String, Object> m_options = null;
    private JstModifiers m_modifiers = new JstModifiers();
    private List<IJstProperty> m_ptys = null;
    private List<IJstGlobalVar> m_gvars = null;
    private List<IJstMethod> m_mtds = null;
    private JstMethod m_constructor;
    private List<IStmt> m_staticInits;
    private List<IStmt> m_instanceInits;
    private List<JstType> m_innerTypes;
    private JstType m_outerType;
    private List<JstType> m_siblingTypes;
    private JstType m_containingType;
    private boolean m_isLocalType = false;
    private List<IJstProperty> m_enumValues;
    private VarTable m_varTable;
    private Map<String, JstParamType> m_paramTypes;
    private transient Info m_info = new Info();
    private IJstDoc m_doc;
    private JstBlock m_initBlock;
    private boolean m_impliedImport;
    private boolean m_isMetaType;
    private boolean m_isFakeType = false;
    private List<IJstType> m_secondaryTypes;
    private boolean m_singleton;
    private List<JstBlock> m_blockList;
    private transient List<IScriptProblem> m_probs;

    JstType() {
        this.getModifiers().setStatic(true).setPublic();
    }

    JstType(String name) {
        this();
        if (name == null) {
            return;
        }
        this.setName(name);
    }

    public void setName(String name) {
        int index = name.lastIndexOf(".");
        if (index != -1) {
            this.setPackage(new JstPackage(name.substring(0, index)));
            this.setSimpleName(name.substring(index + 1));
        } else {
            this.setPackage(new JstPackage());
            this.setSimpleName(name);
        }
    }

    JstType(JstPackage pkg, String simpleName) {
        this();
        this.m_pkg = pkg;
        this.setSimpleName(simpleName);
    }

    JstType(JstType parent) {
        this();
        this.setOuterType(parent);
    }

    @Override
    public JstPackage getPackage() {
        if (this.m_pkg != null) {
            return this.m_pkg;
        }
        if (this.m_outerType != null) {
            JstPackage pkg = this.m_outerType.getPackage();
            JstPackage pkg4Inner = new JstPackage(this.m_outerType.getName());
            if (pkg != null) {
                pkg4Inner.setGroupName(pkg.getGroupName());
            }
            return pkg4Inner;
        }
        return null;
    }

    @Override
    public String getSimpleName() {
        return this.m_simpleName;
    }

    @Override
    public String getName() {
        JstPackage pkg = this.getPackage();
        if (pkg != null && pkg.getName() != null && pkg.getName().length() > 0) {
            return String.valueOf(pkg.getName()) + "." + this.getSimpleName();
        }
        return this.getSimpleName();
    }

    @Override
    public String getAlias() {
        if (this.m_alias == null) {
            return this.getName();
        }
        return this.m_alias;
    }

    @Override
    public String getAliasTypeName() {
        return this.m_aliasTypeName;
    }

    public Category getCategory() {
        return this.m_category;
    }

    @Override
    public boolean isClass() {
        return this.m_category == Category.CLASS;
    }

    @Override
    public boolean isInterface() {
        return this.m_category == Category.INTERFACE;
    }

    @Override
    public boolean isEnum() {
        return this.m_category == Category.ENUM;
    }

    @Override
    public boolean isMixin() {
        return this.m_category == Category.MODULE;
    }

    @Override
    public boolean isOType() {
        return this.m_category == Category.OTYPE;
    }

    @Override
    public boolean isFType() {
        return this.m_category == Category.FTYPE;
    }

    @Override
    public boolean isMetaType() {
        boolean isMeta;
        boolean bl = isMeta = this.m_isMetaType || this.isOType();
        if (isMeta) {
            return isMeta;
        }
        JstType outerType = this.getOuterType();
        return outerType == null ? false : outerType.isMetaType();
    }

    public void setMetaType(boolean set) {
        this.m_isMetaType = set;
    }

    @Override
    public boolean isFakeType() {
        return this.m_isFakeType;
    }

    public void setFakeType(boolean set) {
        this.m_isFakeType = set;
    }

    @Override
    public boolean isAnonymous() {
        return this.getParentNode() != null && !(this.getParentNode() instanceof IJstType) && this.getName() == null;
    }

    @Override
    public boolean hasImport(String typeName) {
        return this.getImportRef(typeName) != null;
    }

    @Override
    public IJstType getImport(String typeName) {
        IJstTypeReference t = this.getImportRef(typeName);
        return t != null ? t.getReferencedType() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IJstTypeReference getImportRef(String typeName) {
        if (typeName == null || this.m_imports == null || this.m_imports.isEmpty()) {
            return null;
        }
        JstType jstType = this;
        synchronized (jstType) {
            IJstTypeReference t = this.m_imports.get(typeName);
            return t != null ? t : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<IJstType> getImports() {
        ArrayList<IJstType> list = new ArrayList<IJstType>();
        JstType jstType = this;
        synchronized (jstType) {
            if (this.m_imports == null || this.m_imports.size() == 0) {
                return Collections.emptyList();
            }
            for (IJstTypeReference tr : this.m_imports.values()) {
                IJstType type = tr.getReferencedType();
                boolean isDup = false;
                for (IJstType t : list) {
                    if (!type.getName().equals(t.getName())) continue;
                    isDup = true;
                    break;
                }
                if (isDup) continue;
                list.add(type);
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IJstType getInactiveImport(String typeName) {
        if (typeName == null || this.m_inactiveImports == null || this.m_inactiveImports.isEmpty()) {
            return null;
        }
        JstType jstType = this;
        synchronized (jstType) {
            IJstTypeReference t = this.m_inactiveImports.get(typeName);
            return t != null ? t.getReferencedType() : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IJstTypeReference getInactiveImportRef(String typeName) {
        if (typeName == null || this.m_inactiveImports == null || this.m_inactiveImports.isEmpty()) {
            return null;
        }
        JstType jstType = this;
        synchronized (jstType) {
            IJstTypeReference t = this.m_inactiveImports.get(typeName);
            return t != null ? t : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<? extends IJstType> getInactiveImports() {
        ArrayList<IJstType> list = new ArrayList<IJstType>();
        JstType jstType = this;
        synchronized (jstType) {
            if (this.m_inactiveImports == null || this.m_inactiveImports.isEmpty()) {
                return Collections.emptyList();
            }
            for (IJstTypeReference tr : this.m_inactiveImports.values()) {
                IJstType type = tr.getReferencedType();
                boolean isDup = false;
                for (IJstType t : list) {
                    if (!type.getName().equals(t.getName())) continue;
                    isDup = true;
                    break;
                }
                if (isDup) continue;
                list.add(type);
            }
        }
        return list;
    }

    @Override
    public void addOType(IJstOType otype) {
        assert (this.isOType());
        if (otype instanceof JstType) {
            ((JstType)((Object)otype)).setParent(this);
        }
        this.m_otypes.add(otype);
    }

    @Override
    public List<IJstOType> getOTypes() {
        return this.m_otypes;
    }

    @Override
    public IJstOType getOType(String name) {
        if (name == null) {
            return null;
        }
        for (IJstOType otype : this.m_otypes) {
            if (!otype.getSimpleName().equals(name)) continue;
            return otype;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<IJstTypeReference> getImportsRef() {
        ArrayList<IJstTypeReference> list = new ArrayList<IJstTypeReference>();
        JstType jstType = this;
        synchronized (jstType) {
            if (this.m_imports == null || this.m_imports.isEmpty()) {
                return Collections.emptyList();
            }
            for (IJstTypeReference tr : this.m_imports.values()) {
                if (list.contains(tr)) continue;
                list.add(tr);
            }
        }
        return list;
    }

    @Override
    public IJstType getExtend() {
        IJstTypeReference t = this.getExtendRef();
        return t != null ? t.getReferencedType() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IJstTypeReference getExtendRef() {
        if (this.m_extends == null) {
            return null;
        }
        JstType jstType = this;
        synchronized (jstType) {
            if (!this.m_extends.isEmpty()) {
                return this.m_extends.get(0);
            }
        }
        return null;
    }

    static List<IJstType> unwrap(List<IJstTypeReference> l) {
        if (l == null || l.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<IJstType> ret = new ArrayList<IJstType>(l.size());
        for (IJstTypeReference t : l) {
            ret.add(t.getReferencedType());
        }
        return ret;
    }

    static boolean contains(IJstType t, List<IJstTypeReference> l) {
        for (IJstTypeReference tr : l) {
            if (tr.getReferencedType() != t) continue;
            return true;
        }
        return false;
    }

    public List<IJstTypeReference> getExtendsRef() {
        if (this.m_extends == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.m_extends);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<IJstType> getExtends() {
        if (this.m_extends == null) {
            return Collections.emptyList();
        }
        JstType jstType = this;
        synchronized (jstType) {
            return JstType.unwrap(this.m_extends);
        }
    }

    public List<IJstType> getSatisfies() {
        if (this.m_satisfies == null && (this.m_mixins == null || this.getMixinsRef().size() == 0)) {
            return Collections.emptyList();
        }
        List<IJstTypeReference> list = this.m_satisfies;
        if (this.getMixinsRef().size() > 0) {
            list = this.m_satisfies == null ? new ArrayList<IJstTypeReference>() : new ArrayList<IJstTypeReference>(this.m_satisfies);
            this.getMergedMixinSatisfies(list);
        } else if (this.m_satisfies == null) {
            return Collections.emptyList();
        }
        return JstType.unwrap(list);
    }

    private void getMergedMixinSatisfies(List<IJstTypeReference> satisfies) {
        for (IJstTypeReference mixin : this.getMixinsRef()) {
            List<? extends IJstTypeReference> mixinSatisfies = mixin.getReferencedType().getSatisfiesRef();
            if (mixinSatisfies == null) continue;
            for (IJstTypeReference iJstTypeReference : mixinSatisfies) {
                satisfies.add(iJstTypeReference);
            }
        }
    }

    public List<IJstTypeReference> getSatisfiesRef() {
        if (this.m_satisfies == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.m_satisfies);
    }

    public List<IJstType> getExpects() {
        if (this.m_expects == null || this.m_expects.size() == 0) {
            return Collections.emptyList();
        }
        List<IJstTypeReference> list = this.m_expects;
        if (this.getExpectsRef().size() > 0) {
            list = this.m_expects == null ? new ArrayList<IJstTypeReference>() : new ArrayList<IJstTypeReference>(this.m_expects);
        }
        return JstType.unwrap(list);
    }

    @Override
    public JstModifiers getModifiers() {
        return this.m_modifiers;
    }

    @Override
    public IJstProperty getProperty(String name) {
        IJstProperty pty = this.getProperty(name, true);
        if (pty != null) {
            return pty;
        }
        return this.getProperty(name, false);
    }

    @Override
    public IJstProperty getProperty(String name, boolean isStatic) {
        return this.getProperty(name, isStatic, false);
    }

    @Override
    public IJstProperty getProperty(String name, boolean isStatic, boolean recursive) {
        if (name == null) {
            return null;
        }
        for (IJstProperty pty : this.getProperties()) {
            if (pty.isStatic() != isStatic || !name.equals(pty.getName().getName())) continue;
            return pty;
        }
        if (recursive && !this.getExtends().isEmpty()) {
            for (IJstType t : this.getExtends()) {
                IJstProperty pty;
                if (t == this || (pty = t.getProperty(name, isStatic, recursive)) == null) continue;
                return pty;
            }
        }
        return null;
    }

    @Override
    public List<IJstProperty> getProperties() {
        if (this.m_mixins != null && this.getMixinsRef().size() > 0) {
            return this.getMixinMergedProperties();
        }
        if (this.m_ptys == null) {
            return Collections.EMPTY_LIST;
        }
        return Collections.unmodifiableList(this.m_ptys);
    }

    public List<IJstProperty> getMixinMergedProperties() {
        if (this.m_ptys == null) {
            this.m_ptys = new ArrayList<IJstProperty>();
        }
        ArrayList<IJstProperty> list = new ArrayList<IJstProperty>(this.m_ptys);
        for (IJstTypeReference module : this.getMixinsRef()) {
            if (this.equals(module.getReferencedType())) continue;
            for (IJstProperty prop : module.getReferencedType().getProperties()) {
                if (prop instanceof ISynthesized || prop instanceof JstProxyProperty) continue;
                list.add(new JstProxyProperty(prop));
            }
        }
        return list;
    }

    @Override
    public List<IJstProperty> getProperties(boolean isStatic) {
        if (isStatic) {
            return this.getStaticProperties();
        }
        return this.getInstanceProperties();
    }

    @Override
    public List<IJstProperty> getAllPossibleProperties(boolean isStatic, boolean recursive) {
        ArrayList<IJstProperty> list = new ArrayList<IJstProperty>();
        list.addAll(this.getProperties(isStatic));
        if (recursive) {
            ArrayList<IJstType> types = new ArrayList<IJstType>();
            this.gatherExtendTypes(types, this);
            this.gatherSatisfiesTypes(types, this);
            if (!types.isEmpty()) {
                for (IJstType t : types) {
                    for (IJstProperty p : t.getProperties(isStatic)) {
                        if (list.contains(p) || p.getModifiers().isPrivate()) continue;
                        list.add(p);
                    }
                }
            }
        }
        return list;
    }

    @Override
    public List<IJstType> getAllDerivedTypes() {
        ArrayList<IJstType> types = new ArrayList<IJstType>();
        for (IJstType mixin : this.getMixins()) {
            if (mixin instanceof JstProxyType) {
                JstProxyType pt = (JstProxyType)mixin;
                types.add(pt.getType());
                continue;
            }
            if (!(mixin instanceof JstType)) continue;
            types.add(mixin);
        }
        this.gatherExtendTypes(types, this);
        this.gatherSatisfiesTypes(types, this);
        return types;
    }

    @Override
    public IJstProperty getEnumValue(String name) {
        if (name == null) {
            return null;
        }
        for (IJstProperty prop : this.getEnumValues()) {
            if (!name.equals(prop.getName().getName())) continue;
            return prop;
        }
        return null;
    }

    @Override
    public boolean hasStaticProperties() {
        return this.getStaticProperties().size() > 0;
    }

    @Override
    public boolean hasStaticProperty(String varName, boolean recursive) {
        boolean isStatic;
        if (varName == null) {
            return false;
        }
        boolean bl = isStatic = this.getStaticProperty(varName) != null;
        if (isStatic || !recursive || this.getExtends().isEmpty()) {
            return isStatic;
        }
        for (IJstType base : this.getExtends()) {
            if (!base.hasStaticProperty(varName, recursive)) continue;
            return true;
        }
        return false;
    }

    @Override
    public IJstProperty getStaticProperty(String name) {
        if (name == null) {
            return null;
        }
        for (IJstProperty pty : this.getStaticProperties()) {
            if (!name.equals(pty.getName().getName())) continue;
            return pty;
        }
        return null;
    }

    @Override
    public IJstProperty getStaticProperty(String name, boolean recursive) {
        IJstProperty pty2;
        if (name == null) {
            return null;
        }
        for (IJstProperty pty2 : this.getStaticProperties()) {
            if (!name.equals(pty2.getName().getName())) continue;
            return pty2;
        }
        pty2 = null;
        if (recursive && !this.getExtends().isEmpty()) {
            for (IJstType base : this.getExtends()) {
                pty2 = base.getStaticProperty(name, recursive);
                if (pty2 == null) continue;
                return pty2;
            }
        }
        if (recursive && !this.getSatisfies().isEmpty()) {
            for (IJstType base : this.getSatisfies()) {
                pty2 = base.getStaticProperty(name, recursive);
                if (pty2 == null) continue;
                return pty2;
            }
        }
        return null;
    }

    @Override
    public List<IJstProperty> getStaticProperties() {
        ArrayList<IJstProperty> list = new ArrayList<IJstProperty>();
        for (IJstProperty pty : this.getProperties()) {
            if (!pty.isStatic()) continue;
            list.add(pty);
        }
        return list;
    }

    @Override
    public boolean hasInstanceProperties() {
        return this.getInstanceProperties().size() > 0;
    }

    @Override
    public boolean hasInstanceProperty(String varName, boolean recursive) {
        boolean isInstance;
        if (varName == null) {
            return false;
        }
        boolean bl = isInstance = this.getInstanceProperty(varName) != null;
        if (isInstance || !recursive || this.getExtends().isEmpty()) {
            return isInstance;
        }
        for (IJstType base : this.getExtends()) {
            if (!base.hasInstanceProperty(varName, recursive)) continue;
            return true;
        }
        return false;
    }

    @Override
    public IJstProperty getInstanceProperty(String name) {
        if (name == null) {
            return null;
        }
        for (IJstProperty pty : this.getInstanceProperties()) {
            if (!name.equals(pty.getName().getName())) continue;
            return pty;
        }
        return null;
    }

    @Override
    public IJstProperty getInstanceProperty(String name, boolean recursive) {
        IJstProperty pty2;
        if (name == null) {
            return null;
        }
        for (IJstProperty pty2 : this.getInstanceProperties()) {
            if (!name.equals(pty2.getName().getName())) continue;
            return pty2;
        }
        pty2 = null;
        if (recursive && !this.getExtends().isEmpty()) {
            for (IJstType base : this.getExtends()) {
                pty2 = base.getInstanceProperty(name, recursive);
                if (pty2 == null) continue;
                return pty2;
            }
        }
        return null;
    }

    @Override
    public List<IJstProperty> getInstanceProperties() {
        ArrayList<IJstProperty> list = new ArrayList<IJstProperty>();
        for (IJstProperty pty : this.getProperties()) {
            if (pty.isStatic()) continue;
            list.add(pty);
        }
        return list;
    }

    @Override
    public JstMethod getConstructor() {
        return this.m_constructor;
    }

    @Override
    public IJstMethod getMethod(String name) {
        IJstMethod mtd = this.getMethod(name, true, false);
        if (mtd != null) {
            return mtd;
        }
        return this.getMethod(name, false, false);
    }

    @Override
    public IJstMethod getMethod(String name, boolean isStatic) {
        return this.getMethod(name, isStatic, false);
    }

    @Override
    public IJstMethod getMethod(String name, boolean isStatic, boolean recursive) {
        if (name == null) {
            return null;
        }
        for (IJstMethod mtd : this.getMethods()) {
            if (mtd.isStatic() != isStatic || !name.equals(mtd.getName().getName())) continue;
            return mtd;
        }
        if (recursive && !this.getExtends().isEmpty()) {
            for (IJstType t : this.getExtends()) {
                IJstMethod mtd;
                if (t == this || (mtd = t.getMethod(name, isStatic, recursive)) == null) continue;
                return mtd;
            }
        }
        if (!isStatic && this.getModifiers().isAbstract()) {
            return this.getMethodFromSatisfies(name, this);
        }
        return null;
    }

    private IJstMethod getMethodFromSatisfies(String name, IJstType type) {
        for (IJstType iJstType : type.getSatisfies()) {
            IJstMethod mtd = iJstType.getMethod(name, false, true);
            if (mtd == null) continue;
            return mtd;
        }
        IJstType iJstType = type.getExtend();
        if (iJstType == null) {
            return null;
        }
        if (iJstType.getModifiers().isAbstract()) {
            return this.getMethodFromSatisfies(name, iJstType);
        }
        return null;
    }

    public List<IJstMethod> getMethods() {
        if (this.m_mixins != null && this.getMixinsRef().size() > 0) {
            return this.getMixinMergedMethods();
        }
        if (this.m_mtds == null) {
            this.m_mtds = new ArrayList<IJstMethod>();
        }
        return Collections.unmodifiableList(this.m_mtds);
    }

    private List<IJstMethod> getMixinMergedMethods() {
        if (this.m_mtds == null) {
            this.m_mtds = new ArrayList<IJstMethod>();
        }
        ArrayList<IJstMethod> list = new ArrayList<IJstMethod>(this.m_mtds);
        for (IJstTypeReference module : this.getMixinsRef()) {
            if (this.equals(module.getReferencedType())) continue;
            for (IJstMethod iJstMethod : module.getReferencedType().getMethods()) {
                if (iJstMethod instanceof ISynthesized || iJstMethod instanceof JstProxyMethod) continue;
                JstProxyMethod jstProxyMethod = new JstProxyMethod(iJstMethod, this.getName());
                list.add(jstProxyMethod);
            }
        }
        return list;
    }

    public List<IJstMethod> getMethods(boolean isStatic) {
        if (isStatic) {
            return this.getStaticMethods();
        }
        return this.getInstanceMethods();
    }

    public List<IJstMethod> getMethods(boolean isStatic, boolean recursive) {
        LinkedHashMap<String, IJstMethod> mtdMap = new LinkedHashMap<String, IJstMethod>();
        for (IJstMethod mtd : this.getMethods(isStatic)) {
            String mtdName = mtd.getName().getName();
            if (mtdMap.containsKey(mtdName)) continue;
            mtdMap.put(mtdName, mtd);
        }
        if (recursive) {
            ArrayList<IJstType> types = new ArrayList<IJstType>();
            this.gatherExtendTypes(types, this);
            if (!isStatic && this.getModifiers().isAbstract()) {
                JstType.gatherSatisfiesForAbstractTypes(types, this);
            }
            if (!types.isEmpty()) {
                for (IJstType t : types) {
                    for (IJstMethod iJstMethod : t.getMethods(isStatic)) {
                        String mtdName = iJstMethod.getName().getName();
                        if (mtdMap.containsKey(mtdName)) continue;
                        mtdMap.put(mtdName, iJstMethod);
                    }
                }
            }
        }
        ArrayList<IJstMethod> mtdList = new ArrayList<IJstMethod>(mtdMap.size());
        for (IJstMethod mtd : mtdMap.values()) {
            mtdList.add(mtd);
        }
        return mtdList;
    }

    private static void gatherSatisfiesForAbstractTypes(List<IJstType> types, IJstType type) {
        for (IJstType iJstType : type.getSatisfies()) {
            if (types.contains(iJstType)) continue;
            types.add(iJstType);
        }
        IJstType iJstType = type.getExtend();
        if (iJstType == null) {
            return;
        }
        if (iJstType.getModifiers().isAbstract()) {
            JstType.gatherSatisfiesForAbstractTypes(types, iJstType);
        }
    }

    private void gatherExtendTypes(List<IJstType> types, IJstType type) {
        for (IJstType iJstType : type.getExtends()) {
            if (types.contains(iJstType) || this.getName().equals(iJstType.getName())) break;
            types.add(iJstType);
            this.gatherExtendTypes(types, iJstType);
        }
    }

    private void gatherSatisfiesTypes(List<IJstType> types, IJstType type) {
        for (IJstType iJstType : type.getSatisfies()) {
            if (types.contains(iJstType) || this.getName().equals(iJstType.getName())) break;
            types.add(iJstType);
            this.gatherSatisfiesTypes(types, iJstType);
        }
    }

    @Override
    public boolean hasStaticMethods() {
        return this.getStaticMethods().size() > 0;
    }

    @Override
    public boolean hasStaticMethod(String mtdName, boolean recursive) {
        boolean hasStatic;
        if (mtdName == null) {
            return false;
        }
        IJstMethod mtd = this.getMethod(mtdName, true);
        boolean bl = hasStatic = mtd != null;
        if (hasStatic || !recursive || this.getExtends().isEmpty()) {
            return hasStatic;
        }
        for (IJstType base : this.getExtends()) {
            if (!base.hasStaticMethod(mtdName, recursive)) continue;
            return true;
        }
        return false;
    }

    public List<IJstMethod> getStaticMethods() {
        ArrayList<IJstMethod> list = new ArrayList<IJstMethod>();
        for (IJstMethod mtd : this.getMethods()) {
            if (!mtd.isStatic()) continue;
            list.add(mtd);
        }
        return list;
    }

    @Override
    public IJstMethod getStaticMethod(String name) {
        if (name == null) {
            return null;
        }
        for (IJstMethod mtd : this.getStaticMethods()) {
            if (!name.equals(mtd.getName().getName())) continue;
            return mtd;
        }
        return null;
    }

    @Override
    public IJstMethod getStaticMethod(String name, boolean recursive) {
        IJstMethod mtd2;
        if (name == null) {
            return null;
        }
        for (IJstMethod mtd2 : this.getStaticMethods()) {
            if (!name.equals(mtd2.getName().getName())) continue;
            return mtd2;
        }
        mtd2 = null;
        if (recursive && !this.getExtends().isEmpty()) {
            for (IJstType base : this.getExtends()) {
                mtd2 = base.getStaticMethod(name, recursive);
                if (mtd2 == null) continue;
                return mtd2;
            }
        }
        return null;
    }

    @Override
    public boolean hasInstanceMethods() {
        return this.getInstanceMethods().size() > 0;
    }

    @Override
    public boolean hasInstanceMethod(String mtdName, boolean recursive) {
        boolean hasInstance;
        if (mtdName == null) {
            return false;
        }
        IJstMethod mtd = this.getMethod(mtdName, false);
        boolean bl = hasInstance = mtd != null;
        if (hasInstance || !recursive || this.getExtends().isEmpty()) {
            return hasInstance;
        }
        for (IJstType base : this.getExtends()) {
            if (!base.hasInstanceMethod(mtdName, recursive)) continue;
            return true;
        }
        return false;
    }

    public List<IJstMethod> getInstanceMethods() {
        ArrayList<IJstMethod> list = new ArrayList<IJstMethod>();
        for (IJstMethod mtd : this.getMethods()) {
            if (mtd.isStatic()) continue;
            list.add(mtd);
        }
        return list;
    }

    @Override
    public IJstMethod getInstanceMethod(String name) {
        if (name == null) {
            return null;
        }
        for (IJstMethod mtd : this.getInstanceMethods()) {
            if (!name.equals(mtd.getName().getName())) continue;
            return mtd;
        }
        return null;
    }

    @Override
    public IJstMethod getInstanceMethod(String name, boolean recursive) {
        IJstMethod mtd2;
        if (name == null) {
            return null;
        }
        for (IJstMethod mtd2 : this.getInstanceMethods()) {
            if (!name.equals(mtd2.getName().getName())) continue;
            return mtd2;
        }
        mtd2 = null;
        if (recursive && !this.getExtends().isEmpty()) {
            for (IJstType base : this.getExtends()) {
                mtd2 = base.getInstanceMethod(name, recursive);
                if (mtd2 == null) continue;
                return mtd2;
            }
        }
        return null;
    }

    @Override
    public List<IStmt> getInitializers(boolean isStatic) {
        if (this.isInterface() || isStatic) {
            return this.getStaticInitializers();
        }
        return this.getInstanceInitializers();
    }

    @Override
    public List<IStmt> getStaticInitializers() {
        if (this.m_staticInits == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.m_staticInits);
    }

    @Override
    public List<IStmt> getInstanceInitializers() {
        if (this.m_instanceInits == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.m_instanceInits);
    }

    @Override
    public boolean hasMixins() {
        return this.getMixinsRef().size() > 0;
    }

    public List<IJstType> getMixins() {
        if (this.m_mixins == null || this.m_mixins.size() == 0) {
            return Collections.emptyList();
        }
        List<IJstTypeReference> list = this.m_mixins;
        if (this.getMixinsRef().size() > 0) {
            list = this.m_mixins == null ? new ArrayList<IJstTypeReference>() : new ArrayList<IJstTypeReference>(this.m_mixins);
        } else if (this.m_mixins == null) {
            return Collections.emptyList();
        }
        return JstType.unwrap(list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<IJstTypeReference> getMixinsRef() {
        if (this.m_mixins == null) {
            return Collections.emptyList();
        }
        JstType jstType = this;
        synchronized (jstType) {
            return Collections.unmodifiableList(this.m_mixins);
        }
    }

    public synchronized List<JstType> getEmbededTypes() {
        if (this.m_innerTypes == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.m_innerTypes);
    }

    @Override
    public JstType getEmbededType(String shortName) {
        if (shortName == null) {
            return null;
        }
        for (JstType embeded : this.getEmbededTypes()) {
            if (!shortName.equals(embeded.getSimpleName())) continue;
            return embeded;
        }
        return null;
    }

    public void setEmbeddedTypes(List<JstType> embeddedTypes) {
        for (JstType iJstType : embeddedTypes) {
            this.addInnerType(iJstType);
        }
    }

    public List<JstType> getStaticEmbededTypes() {
        ArrayList<JstType> list = new ArrayList<JstType>();
        for (JstType embeded : this.getEmbededTypes()) {
            if (!embeded.getModifiers().isStatic()) continue;
            list.add(embeded);
        }
        return list;
    }

    public List<JstType> getInstanceEmbededTypes() {
        ArrayList<JstType> list = new ArrayList<JstType>();
        for (JstType embeded : this.getEmbededTypes()) {
            if (embeded.getModifiers().isStatic()) continue;
            list.add(embeded);
        }
        return list;
    }

    @Override
    public boolean isEmbededType() {
        return this.m_outerType != null;
    }

    @Override
    public JstType getOuterType() {
        return this.m_outerType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JstType getSiblingType(String shortName) {
        if (shortName == null || this.m_siblingTypes == null) {
            return null;
        }
        JstType jstType = this;
        synchronized (jstType) {
            for (JstType embeded : this.m_siblingTypes) {
                if (!embeded.getSimpleName().equals(shortName)) continue;
                return embeded;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<JstType> getSiblingTypes() {
        if (this.m_siblingTypes == null) {
            return Collections.emptyList();
        }
        JstType jstType = this;
        synchronized (jstType) {
            return Collections.unmodifiableList(this.m_siblingTypes);
        }
    }

    @Override
    public boolean isSiblingType() {
        return this.m_containingType != null;
    }

    @Override
    public JstType getContainingType() {
        return this.m_containingType;
    }

    @Override
    public boolean isParamName(String name) {
        return name != null && this.getParamNames().contains(name);
    }

    @Override
    public synchronized List<String> getParamNames() {
        if (this.m_paramTypes == null) {
            return Collections.emptyList();
        }
        ArrayList<String> list = new ArrayList<String>();
        list.addAll(this.m_paramTypes.keySet());
        return list;
    }

    @Override
    public synchronized List<JstParamType> getParamTypes() {
        if (this.m_paramTypes == null) {
            return Collections.emptyList();
        }
        ArrayList<JstParamType> list = new ArrayList<JstParamType>();
        list.addAll(this.m_paramTypes.values());
        return list;
    }

    @Override
    public IJstDoc getDoc() {
        return this.m_doc;
    }

    public void setDoc(IJstDoc jstDoc) {
        this.m_doc = jstDoc;
    }

    public JstType setCategory(Category category) {
        assert (category != null) : "category cannot be null";
        this.m_category = category;
        if (Category.FTYPE == category) {
            this.addExtend(JstCache.getInstance().getType("Function"));
        }
        return this;
    }

    public JstType setPackage(JstPackage pkg) {
        this.m_pkg = pkg;
        return this;
    }

    public JstType setSimpleName(String simpleName) {
        assert (simpleName != null) : "simpleName cannot be null";
        this.m_simpleName = simpleName;
        if (this.m_simpleName != null) {
            this.m_info.setHasName();
        }
        return this;
    }

    public JstType setAlias(String alias) {
        this.m_alias = alias;
        return this;
    }

    public JstType setAliasTypeName(String aliasTypeName) {
        this.m_aliasTypeName = aliasTypeName;
        return this;
    }

    public void addImport(IJstType importType) {
        assert (importType != null) : "importType cannot be null";
        assert (importType.getSimpleName() != null) : "importType.getSimpleName() cannot be null";
        if (importType != null) {
            this.addImport(importType.getSimpleName(), importType);
        }
    }

    public void addImport(IJstTypeReference importType) {
        assert (importType != null) : "importType cannot be null";
        assert (importType.getReferencedType().getSimpleName() != null) : "importType.getSimpleName() cannot be null";
        if (importType != null) {
            this.addImport(importType.getReferencedType().getSimpleName(), importType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addImport(String key, IJstTypeReference importType) {
        if (key == null || importType == null || this.m_outerType != null || importType.getReferencedType() == this) {
            return;
        }
        IJstType type = importType.getReferencedType();
        if (key.length() == 0) {
            key = type.getName();
        }
        if (this.getImport(type.getSimpleName()) == type || this.getImport(type.getName()) == type) {
            return;
        }
        JstType jstType = this;
        synchronized (jstType) {
            if (this.m_imports == null) {
                this.m_imports = new LinkedHashMap<String, IJstTypeReference>();
            }
            if (!this.m_imports.containsKey(key)) {
                this.m_imports.put(key, importType);
                this.addChild(importType);
            }
        }
    }

    public void addImport(String key, IJstType importType) {
        if (key == null || importType == null || this.m_outerType != null || importType == this) {
            return;
        }
        this.addImport(key, new JstTypeReference(importType));
    }

    public void addInactiveImport(IJstType importType) {
        assert (importType != null) : "importType cannot be null";
        assert (importType.getSimpleName() != null) : "importType.getSimpleName() cannot be null";
        this.addInactiveImport(importType.getSimpleName(), importType);
    }

    public void addInactiveImport(IJstTypeReference importType) {
        assert (importType != null) : "importType cannot be null";
        assert (importType.getReferencedType().getSimpleName() != null) : "importType.getSimpleName() cannot be null";
        this.addInactiveImport(importType.getReferencedType().getSimpleName(), importType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addInactiveImport(String key, IJstTypeReference importType) {
        if (key == null || importType == null || this.m_outerType != null || importType.getReferencedType() == this) {
            return;
        }
        IJstType type = importType.getReferencedType();
        if (key.length() == 0) {
            key = type.getName();
        }
        if (this.getInactiveImport(type.getSimpleName()) == type || this.getInactiveImport(type.getName()) == type) {
            return;
        }
        JstType jstType = this;
        synchronized (jstType) {
            if (this.m_inactiveImports == null) {
                this.m_inactiveImports = new LinkedHashMap<String, IJstTypeReference>();
            }
            if (!this.m_inactiveImports.containsKey(key)) {
                this.m_inactiveImports.put(key, importType);
                this.addChild(importType);
            }
        }
    }

    public void addInactiveImport(String key, IJstType importType) {
        if (key == null || importType == null || this.m_outerType != null || importType == this) {
            return;
        }
        this.addInactiveImport(key, new JstTypeReference(importType));
    }

    public void addFullyQualifiedImport(IJstType importType) {
        assert (importType != null) : "importType cannot be null";
        assert (importType.getSimpleName() != null) : "importType.getSimpleName() cannot be null";
        this.addFullyQualifiedImport(importType.getSimpleName(), importType);
    }

    public void addFullyQualifiedImport(IJstTypeReference importType) {
        assert (importType != null) : "importType cannot be null";
        assert (importType.getReferencedType().getSimpleName() != null) : "importType.getSimpleName() cannot be null";
        this.addFullyQualifiedImport(importType.getReferencedType().getSimpleName(), importType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFullyQualifiedImport(String key, IJstTypeReference importType) {
        if (key == null || importType == null || this.m_outerType != null || importType.getReferencedType() == this) {
            return;
        }
        IJstType type = importType.getReferencedType();
        if (key.length() == 0) {
            key = type.getName();
        }
        if (this.getFullyQualifiedImport(type.getSimpleName()) == type || this.getFullyQualifiedImport(type.getName()) == type) {
            return;
        }
        JstType jstType = this;
        synchronized (jstType) {
            if (this.m_fullyQualifiedImports == null) {
                this.m_fullyQualifiedImports = new LinkedHashMap<String, IJstTypeReference>();
            }
            if (!this.m_fullyQualifiedImports.containsKey(key)) {
                this.m_fullyQualifiedImports.put(key, importType);
                this.addChild(importType);
            }
        }
    }

    public void addFullyQualifiedImport(String key, IJstType importType) {
        if (key == null || importType == null || this.m_outerType != null || importType == this) {
            return;
        }
        this.addFullyQualifiedImport(key, new JstTypeReference(importType));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeImport(IJstType type) {
        if (this.m_imports == null || this.m_imports.isEmpty()) {
            return;
        }
        JstType jstType = this;
        synchronized (jstType) {
            for (Map.Entry<String, IJstTypeReference> t : this.m_imports.entrySet()) {
                if (t.getValue().getReferencedType() != type) continue;
                IJstTypeReference tr = this.m_imports.remove(t.getKey());
                this.removeChild(tr);
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeImport(IJstTypeReference type) {
        if (this.m_imports == null || this.m_imports.isEmpty()) {
            return;
        }
        JstType jstType = this;
        synchronized (jstType) {
            for (Map.Entry<String, IJstTypeReference> t : this.m_imports.entrySet()) {
                if (!t.getValue().equals(type)) continue;
                IJstTypeReference tr = this.m_imports.remove(t.getKey());
                this.removeChild(tr);
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeInactiveImport(IJstType type) {
        if (this.m_inactiveImports == null && this.m_inactiveImports.isEmpty()) {
            return;
        }
        JstType jstType = this;
        synchronized (jstType) {
            for (Map.Entry<String, IJstTypeReference> t : this.m_inactiveImports.entrySet()) {
                if (t.getValue().getReferencedType() != type) continue;
                IJstTypeReference tr = this.m_inactiveImports.remove(t.getKey());
                this.removeChild(tr);
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeInactiveImport(IJstTypeReference type) {
        if (this.m_inactiveImports == null || this.m_inactiveImports.isEmpty()) {
            return;
        }
        JstType jstType = this;
        synchronized (jstType) {
            for (Map.Entry<String, IJstTypeReference> t : this.m_inactiveImports.entrySet()) {
                if (!t.getValue().equals(type)) continue;
                IJstTypeReference tr = this.m_inactiveImports.remove(t.getKey());
                this.removeChild(tr);
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFullyQualifiedImport(IJstType type) {
        if (this.m_fullyQualifiedImports == null || this.m_fullyQualifiedImports.isEmpty()) {
            return;
        }
        JstType jstType = this;
        synchronized (jstType) {
            for (Map.Entry<String, IJstTypeReference> t : this.m_fullyQualifiedImports.entrySet()) {
                if (t.getValue().getReferencedType() != type) continue;
                IJstTypeReference tr = this.m_fullyQualifiedImports.remove(t.getKey());
                this.removeChild(tr);
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFullyQualifiedImport(IJstTypeReference type) {
        if (this.m_fullyQualifiedImports == null || this.m_fullyQualifiedImports.isEmpty()) {
            return;
        }
        JstType jstType = this;
        synchronized (jstType) {
            for (Map.Entry<String, IJstTypeReference> t : this.m_fullyQualifiedImports.entrySet()) {
                if (!t.getValue().equals(type)) continue;
                IJstTypeReference tr = this.m_fullyQualifiedImports.remove(t.getKey());
                this.removeChild(tr);
                return;
            }
        }
    }

    public void addExtend(IJstType extend) {
        if (extend == null) {
            return;
        }
        this.addExtend(new JstTypeReference(extend));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addExtend(IJstTypeReference extend) {
        if (extend == null) {
            return;
        }
        JstType jstType = this;
        synchronized (jstType) {
            if (this.m_extends != null && JstType.contains(extend.getReferencedType(), this.m_extends)) {
                return;
            }
            if (this.m_extends == null) {
                this.m_extends = new ArrayList<IJstTypeReference>(1);
            }
            if (this.m_extends.size() == 1 && "vjo.Object".equals(this.m_extends.get(0).getReferencedType().getName())) {
                this.m_extends = new ArrayList<IJstTypeReference>(1);
            }
            this.m_extends.add(extend);
            this.addChild(extend);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IJstType removeExtend(IJstType extend) {
        if (extend == null) {
            return null;
        }
        JstType jstType = this;
        synchronized (jstType) {
            for (IJstTypeReference ref : this.getExtendsRef()) {
                if (extend != ref.getReferencedType()) continue;
                this.m_extends.remove(ref);
                this.removeChild(ref);
                return extend;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IJstType removeSatisfy(IJstType satisfy) {
        if (satisfy == null) {
            return null;
        }
        JstType jstType = this;
        synchronized (jstType) {
            for (IJstTypeReference ref : this.getSatisfiesRef()) {
                if (satisfy != ref.getReferencedType()) continue;
                this.m_satisfies.remove(ref);
                this.removeChild(ref);
                return satisfy;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAlias() {
        JstType jstType = this;
        synchronized (jstType) {
            this.m_alias = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearExtends() {
        JstType jstType = this;
        synchronized (jstType) {
            if (this.m_extends != null) {
                this.removeChildren(this.m_extends);
                this.m_extends = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearSatisfies() {
        JstType jstType = this;
        synchronized (jstType) {
            if (this.m_satisfies != null) {
                this.removeChildren(this.m_satisfies);
                this.m_satisfies = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearEmbeddedTypes() {
        JstType jstType = this;
        synchronized (jstType) {
            if (this.m_innerTypes != null) {
                this.removeChildren(this.m_innerTypes);
                this.m_innerTypes = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearOuterType() {
        JstType jstType = this;
        synchronized (jstType) {
            if (this.m_outerType != null) {
                this.m_outerType = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearSecondaryTypes() {
        JstType jstType = this;
        synchronized (jstType) {
            if (this.m_secondaryTypes != null) {
                this.removeChildren(this.m_secondaryTypes);
                this.m_secondaryTypes = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearStaticInits() {
        JstType jstType = this;
        synchronized (jstType) {
            if (this.m_staticInits != null) {
                this.removeChildren(this.m_staticInits);
                this.m_staticInits = null;
            }
            if (this.m_initBlock != null) {
                this.removeChild(this.m_initBlock);
                this.m_initBlock = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearInstanceInits() {
        JstType jstType = this;
        synchronized (jstType) {
            if (this.m_instanceInits != null) {
                this.removeChildren(this.m_instanceInits);
                this.m_instanceInits = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearImports() {
        JstType jstType = this;
        synchronized (jstType) {
            if (this.m_imports != null) {
                this.removeChildren(this.m_imports.values());
                this.m_imports = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearInactiveImports() {
        JstType jstType = this;
        synchronized (jstType) {
            if (this.m_inactiveImports != null) {
                this.removeChildren(this.m_inactiveImports.values());
                this.m_inactiveImports = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearOTypes() {
        JstType jstType = this;
        synchronized (jstType) {
            this.m_otypes = new ArrayList<IJstOType>();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearName() {
        JstType jstType = this;
        synchronized (jstType) {
            this.m_simpleName = null;
            this.m_pkg = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearModifiers() {
        this.m_singleton = false;
        JstType jstType = this;
        synchronized (jstType) {
            this.m_modifiers = new JstModifiers();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearExpects() {
        JstType jstType = this;
        synchronized (jstType) {
            this.m_expects = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearOptions() {
        JstType jstType = this;
        synchronized (jstType) {
            this.m_options = null;
            this.m_isMetaType = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearMixins() {
        JstType jstType = this;
        synchronized (jstType) {
            if (this.m_mixins != null) {
                for (IJstTypeReference m : this.m_mixins) {
                    for (IJstProperty iJstProperty : m.getReferencedType().getProperties()) {
                        this.removeProperty(iJstProperty.getName().getName(), iJstProperty.isStatic());
                    }
                    for (IJstMethod iJstMethod : m.getReferencedType().getMethods()) {
                        this.removeMethod(iJstMethod.getName().getName(), iJstMethod.isStatic());
                    }
                }
                this.m_mixins = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSatisfy(IJstTypeReference satisfier) {
        if (satisfier == null) {
            return;
        }
        JstType jstType = this;
        synchronized (jstType) {
            if (this.m_satisfies != null && JstType.contains(satisfier.getReferencedType(), this.m_satisfies)) {
                return;
            }
            if (this.m_satisfies == null) {
                this.m_satisfies = new ArrayList<IJstTypeReference>(1);
            }
            this.m_satisfies.add(satisfier);
            this.addChild(satisfier);
        }
    }

    public void addSatisfy(IJstType satisfier) {
        if (satisfier == null) {
            return;
        }
        this.addSatisfy(new JstTypeReference(satisfier));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addExpects(IJstTypeReference expects) {
        if (expects == null) {
            return;
        }
        JstType jstType = this;
        synchronized (jstType) {
            if (this.m_expects != null && JstType.contains(expects.getReferencedType(), this.m_expects)) {
                return;
            }
            if (this.m_expects == null) {
                this.m_expects = new ArrayList<IJstTypeReference>(1);
            }
            this.m_expects.add(expects);
            this.addChild(expects);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addExpects(IJstType expects) {
        if (expects == null) {
            return;
        }
        JstType jstType = this;
        synchronized (jstType) {
            if (this.m_expects != null && JstType.contains(expects, this.m_expects)) {
                return;
            }
            if (this.m_expects == null) {
                this.m_expects = new ArrayList<IJstTypeReference>();
            }
            JstTypeReference ref = new JstTypeReference(expects);
            this.addChild(ref);
            this.m_expects.add(ref);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProperty(IJstProperty pty) {
        if (pty == null || this.getProperties().contains(pty)) {
            return;
        }
        JstType jstType = this;
        synchronized (jstType) {
            if (this.m_ptys == null) {
                this.m_ptys = new ArrayList<IJstProperty>();
            }
            this.m_ptys.add(pty);
            this.addChild(pty);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IJstProperty removeProperty(String ptyName, boolean isStatic) {
        if (ptyName == null || this.m_ptys == null) {
            return null;
        }
        JstType jstType = this;
        synchronized (jstType) {
            IJstProperty pty = this.getProperty(ptyName, isStatic);
            this.m_ptys.remove(pty);
            if (pty instanceof BaseJstNode) {
                this.removeChild((BaseJstNode)((Object)pty));
            }
            return pty;
        }
    }

    public JstType setConstructor(JstMethod constructor) {
        this.removeChild(this.m_constructor);
        this.addChild(constructor);
        this.m_constructor = constructor;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JstType addMethod(IJstMethod mtd) {
        if (mtd == null || this.getMethods().contains(mtd)) {
            return this;
        }
        JstType jstType = this;
        synchronized (jstType) {
            if (this.m_mtds == null) {
                this.m_mtds = new ArrayList<IJstMethod>();
            }
            this.m_mtds.add(mtd);
            this.addChild(mtd);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IJstMethod removeMethod(String mtdName, boolean isStatic) {
        if (mtdName == null || this.m_mtds == null) {
            return null;
        }
        JstType jstType = this;
        synchronized (jstType) {
            IJstMethod mtd = this.getMethod(mtdName, isStatic);
            this.m_mtds.remove(mtd);
            if (mtd instanceof BaseJstNode) {
                this.removeChild((BaseJstNode)((Object)mtd));
            }
            return mtd;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearMethods() {
        JstType jstType;
        for (IJstMethod mtd : this.getMethods()) {
            this.removeChild(mtd);
            jstType = null;
        }
        jstType = this;
        synchronized (jstType) {
            this.m_mtds = null;
            this.setConstructor(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearProperties() {
        JstType jstType = this;
        synchronized (jstType) {
            this.m_ptys = null;
        }
    }

    public void addInit(IStmt stmt, boolean isStatic) {
        if (stmt == null) {
            return;
        }
        if (isStatic) {
            if (this.m_staticInits == null) {
                this.m_staticInits = new ArrayList<IStmt>();
            }
            this.m_staticInits.add(stmt);
        } else {
            if (this.m_instanceInits == null) {
                this.m_instanceInits = new ArrayList<IStmt>();
            }
            this.m_instanceInits.add(stmt);
        }
        this.getInitBlock().addStmt(stmt);
    }

    @Override
    public JstBlock getInitBlock() {
        if (this.m_initBlock == null) {
            this.m_initBlock = new JstBlock();
            this.addChild(this.m_initBlock);
        }
        return this.m_initBlock;
    }

    public void setInitBlock(JstBlock block) {
        if (this.m_initBlock != null) {
            this.removeChild(this.m_initBlock);
        }
        this.m_initBlock = block;
        this.addChild(this.m_initBlock);
    }

    public VarTable getVarTable() {
        if (this.m_varTable == null) {
            this.m_varTable = new VarTable();
        }
        return this.m_varTable;
    }

    private void clearVarTable() {
        this.m_varTable = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMixin(IJstTypeReference module) {
        if (module == null) {
            return;
        }
        JstType jstType = this;
        synchronized (jstType) {
            if (this.m_mixins != null && this.m_mixins.contains(module)) {
                return;
            }
            if (this.m_mixins == null) {
                this.m_mixins = new ArrayList<IJstTypeReference>(1);
            }
            this.m_mixins.add(module);
            this.addChild(module);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addInnerType(JstType innerType) {
        if (innerType == null) {
            return;
        }
        JstType jstType = this;
        synchronized (jstType) {
            if (this.m_innerTypes != null && this.m_innerTypes.contains(innerType)) {
                return;
            }
            if (this.m_innerTypes == null) {
                this.m_innerTypes = new ArrayList<JstType>(1);
            }
            this.m_innerTypes.add(innerType);
            this.addChild(innerType);
        }
        innerType.m_outerType = this;
        innerType.setParent(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JstType removeInnerType(String shortName) {
        if (shortName == null) {
            return null;
        }
        JstType jstType = this;
        synchronized (jstType) {
            JstType innerType = this.getEmbededType(shortName);
            this.m_innerTypes.remove(innerType);
            this.removeChild(innerType);
            return innerType;
        }
    }

    public boolean hasInnerType(String shortName) {
        return this.getEmbededType(shortName) != null;
    }

    public void setOuterType(JstType outerType) {
        this.m_outerType = outerType;
        this.setParent(this.m_outerType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSiblingType(JstType siblingType) {
        if (siblingType == null) {
            return;
        }
        JstType jstType = this;
        synchronized (jstType) {
            if (this.m_siblingTypes != null && this.m_siblingTypes.contains(siblingType)) {
                return;
            }
            if (this.m_siblingTypes == null) {
                this.m_siblingTypes = new ArrayList<JstType>(1);
            }
            this.m_siblingTypes.add(siblingType);
            this.addChild(siblingType);
        }
        siblingType.m_containingType = this;
        siblingType.setParent(this);
    }

    public boolean hasSiblingType(String shortName) {
        return this.getSiblingType(shortName) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JstParamType addParam(String paramName) {
        if (paramName == null) {
            return null;
        }
        String trimmedParamName = paramName.trim();
        JstType jstType = this;
        synchronized (jstType) {
            JstParamType pType;
            if (this.m_paramTypes == null) {
                this.m_paramTypes = new LinkedHashMap<String, JstParamType>();
            }
            if ((pType = this.m_paramTypes.get(trimmedParamName)) != null) {
                return pType;
            }
            pType = new JstParamType(trimmedParamName);
            this.m_paramTypes.put(trimmedParamName, pType);
            return pType;
        }
    }

    public synchronized JstParamType getParamType(String name) {
        JstParamType paramType = null;
        if (this.m_paramTypes != null) {
            paramType = this.m_paramTypes.get(name);
        }
        if (paramType == null && this.isEmbededType()) {
            return this.m_outerType.getParamType(name);
        }
        return paramType;
    }

    public synchronized void clearParams() {
        if (this.m_paramTypes != null) {
            this.m_paramTypes = null;
        }
    }

    public String getParamsDecoration() {
        if (this.getParamNames().isEmpty()) {
            return EMPTY;
        }
        StringBuilder sb = new StringBuilder("<");
        int i = 0;
        for (JstParamType p : this.getParamTypes()) {
            if (i++ > 0) {
                sb.append(",");
            }
            sb.append(p.getSimpleName());
            if (p.getBounds().isEmpty()) continue;
            IJstType bType = p.getBounds().get(0);
            sb.append(" extends ").append(bType.getSimpleName());
            if (!(bType instanceof JstTypeWithArgs)) continue;
            sb.append(((JstTypeWithArgs)bType).getArgsDecoration());
        }
        sb.append(">");
        return sb.toString();
    }

    @Override
    public List<IJstProperty> getEnumValues() {
        if (this.m_enumValues == null) {
            this.m_enumValues = new ArrayList<IJstProperty>();
        }
        return this.m_enumValues;
    }

    public void setEnumValues(List<IJstProperty> enumValues) {
        for (IJstProperty enumV : enumValues) {
            this.addEnumValue(enumV);
        }
    }

    public synchronized void clearEnumValues() {
        this.m_enumValues = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEnumValue(IJstProperty enumVal) {
        JstType jstType = this;
        synchronized (jstType) {
            if (this.m_enumValues == null) {
                this.m_enumValues = new ArrayList<IJstProperty>();
            }
            this.m_enumValues.add(enumVal);
        }
    }

    public void fixMixin(IJstType mixinType) {
        if (!this.hasMixins() || this == mixinType) {
            return;
        }
        List<IJstTypeReference> mixinDependencies = this.getMixinsRef();
        boolean isMixIn = false;
        for (IJstTypeReference typeRef : mixinDependencies) {
            if (typeRef.getReferencedType() != mixinType) continue;
            isMixIn = true;
            break;
        }
        if (isMixIn) {
            ArrayList<IJstProperty> removePropList = new ArrayList<IJstProperty>();
            for (IJstProperty prop : this.getProperties()) {
                if (prop.getOwnerType() != mixinType) continue;
                removePropList.add(prop);
            }
            for (IJstProperty removeProp : removePropList) {
                this.removeProperty(removeProp.getName().getName(), removeProp.isStatic());
            }
            ArrayList<IJstMethod> removeMtdList = new ArrayList<IJstMethod>();
            for (IJstMethod iJstMethod : this.getMethods()) {
                if (iJstMethod.getOwnerType() != mixinType) continue;
                removeMtdList.add(iJstMethod);
            }
            for (IJstMethod iJstMethod : removeMtdList) {
                this.removeMethod(iJstMethod.getName().getName(), iJstMethod.isStatic());
            }
            for (IJstMethod iJstMethod : mixinType.getMethods()) {
                this.addMethod(new JstProxyMethod(iJstMethod, this.getName()));
            }
            for (IJstProperty iJstProperty : mixinType.getProperties()) {
                this.addProperty(new JstProxyProperty(iJstProperty));
            }
        }
    }

    public Info getStatus() {
        return this.m_info;
    }

    @Override
    public synchronized void accept(IJstNodeVisitor visitor) {
        visitor.visit(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Z z = new Z();
        z.format("m_name", (Object)this.m_simpleName);
        z.format("m_alias", (Object)this.m_alias);
        z.format("m_pkg", (Object)this.getPackage());
        JstType jstType = this;
        synchronized (jstType) {
            if (this.m_imports != null) {
                this.m_imports.isEmpty();
            }
            if (this.m_extends != null) {
                for (IJstTypeReference n : this.m_extends) {
                    z.format("extend", (Object)n.getReferencedType().getName());
                }
            }
            if (this.m_enumValues != null) {
                int i = 0;
                for (IJstProperty n : this.m_enumValues) {
                    z.format("m_enumValues[" + i + "]", (Object)n.getName());
                    ++i;
                }
            }
        }
        return z.toString();
    }

    public void dump() {
        Z z = new Z();
        z.format("type", (Object)this.getName());
        z.format("package", (Object)this.getPackage());
        z.format("constructor", (Object)this.getConstructor());
        if (this.m_extends != null) {
            for (IJstTypeReference n : this.m_extends) {
                z.format("extend", (Object)n.getReferencedType().getName());
            }
        }
        z.format("static props", this.getStaticProperties());
        z.format("static methods", this.getStaticMethods());
        z.format("instance props", this.getInstanceProperties());
        z.format("instance methods", this.getInstanceMethods());
        System.out.println(z);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, ? extends IJstType> getImportsMap() {
        LinkedHashMap<String, IJstType> map = new LinkedHashMap<String, IJstType>();
        JstType jstType = this;
        synchronized (jstType) {
            if (this.m_imports != null) {
                for (Map.Entry<String, IJstTypeReference> me : this.m_imports.entrySet()) {
                    map.put(me.getKey(), me.getValue().getReferencedType());
                }
            }
        }
        return Collections.unmodifiableMap(map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, ? extends IJstType> getInactiveImportsMap() {
        LinkedHashMap<String, IJstType> map = new LinkedHashMap<String, IJstType>();
        JstType jstType = this;
        synchronized (jstType) {
            if (this.m_inactiveImports != null) {
                for (Map.Entry<String, IJstTypeReference> me : this.m_inactiveImports.entrySet()) {
                    map.put(me.getKey(), me.getValue().getReferencedType());
                }
            }
        }
        return Collections.unmodifiableMap(map);
    }

    public void addInitWithoutChild(IStmt stmt, boolean isStatic) {
        if (stmt == null) {
            return;
        }
        if (isStatic) {
            if (this.m_staticInits == null) {
                this.m_staticInits = new ArrayList<IStmt>();
            }
            this.m_staticInits.add(stmt);
        } else {
            if (this.m_instanceInits == null) {
                this.m_instanceInits = new ArrayList<IStmt>();
            }
            this.m_instanceInits.add(stmt);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.m_info = new Info();
        this.m_info.setHasResolution();
        this.m_info.setHasName();
    }

    private Object readResolve() throws ObjectStreamException {
        JstType type = JstCache.getInstance().getType(this.getName());
        if (type != null) {
            return type;
        }
        return this;
    }

    @Override
    public boolean isLocalType() {
        return this.m_isLocalType;
    }

    public void setLocalType(boolean localType) {
        this.m_isLocalType = localType;
    }

    @Override
    public List<? extends IJstTypeReference> getExpectsRef() {
        if (this.m_expects == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.m_expects);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<IJstTypeReference> getInactiveImportsRef() {
        ArrayList<IJstTypeReference> list = new ArrayList<IJstTypeReference>();
        JstType jstType = this;
        synchronized (jstType) {
            if (this.m_inactiveImports == null || this.m_inactiveImports.isEmpty()) {
                return Collections.emptyList();
            }
            for (IJstTypeReference tr : this.m_inactiveImports.values()) {
                list.add(tr);
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IJstType getFullyQualifiedImport(String typeName) {
        if (typeName == null || this.m_fullyQualifiedImports == null || this.m_fullyQualifiedImports.isEmpty()) {
            return null;
        }
        JstType jstType = this;
        synchronized (jstType) {
            IJstTypeReference t = this.m_fullyQualifiedImports.get(typeName);
            return t != null ? t.getReferencedType() : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<? extends IJstType> getFullyQualifiedImports() {
        ArrayList<IJstType> list = new ArrayList<IJstType>();
        JstType jstType = this;
        synchronized (jstType) {
            if (this.m_fullyQualifiedImports == null || this.m_fullyQualifiedImports.isEmpty()) {
                return Collections.emptyList();
            }
            for (IJstTypeReference tr : this.m_fullyQualifiedImports.values()) {
                IJstType type = tr.getReferencedType();
                boolean isDup = false;
                for (IJstType t : list) {
                    if (!type.getName().equals(t.getName())) continue;
                    isDup = true;
                    break;
                }
                if (isDup) continue;
                list.add(type);
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<? extends IJstTypeReference> getFullyQualifiedImportsRef() {
        ArrayList<IJstTypeReference> list = new ArrayList<IJstTypeReference>();
        JstType jstType = this;
        synchronized (jstType) {
            if (this.m_fullyQualifiedImports == null || this.m_fullyQualifiedImports.isEmpty()) {
                return Collections.emptyList();
            }
            for (IJstTypeReference tr : this.m_fullyQualifiedImports.values()) {
                list.add(tr);
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, ? extends IJstType> getFullyQualifiedImportsMap() {
        LinkedHashMap<String, IJstType> map = new LinkedHashMap<String, IJstType>();
        JstType jstType = this;
        synchronized (jstType) {
            if (this.m_fullyQualifiedImports == null) {
                this.m_fullyQualifiedImports = new LinkedHashMap<String, IJstTypeReference>();
            }
            for (Map.Entry<String, IJstTypeReference> me : this.m_fullyQualifiedImports.entrySet()) {
                map.put(me.getKey(), me.getValue().getReferencedType());
            }
        }
        return Collections.unmodifiableMap(map);
    }

    public void clearAll() {
        this.clearChildren();
        this.clearAnnotations();
        this.clearCommentLocations();
        this.clearComments();
        this.clearModifiers();
        this.clearParams();
        this.clearName();
        this.clearAlias();
        this.clearExpects();
        this.clearMixins();
        this.clearExtends();
        this.clearImports();
        this.clearMethods();
        this.clearProperties();
        this.clearSatisfies();
        this.clearEmbeddedTypes();
        this.clearEnumValues();
        this.clearStaticInits();
        this.clearInstanceInits();
        this.clearInactiveImports();
        this.clearGlobalVars();
        this.clearOTypes();
        this.clearOptions();
        this.clearVarTable();
        this.clearSecondaryTypes();
        this.clearOuterType();
        this.clearJstBlockList();
        this.clearProblems();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearGlobalVars() {
        for (IJstGlobalVar jstType : this.getGlobalVars()) {
            if (!(jstType instanceof BaseJstNode)) continue;
            this.removeChild((BaseJstNode)((Object)jstType));
        }
        JstType jstType = this;
        synchronized (jstType) {
            this.m_gvars = null;
        }
    }

    @Override
    public boolean hasGlobalVars() {
        return this.m_gvars != null && !this.m_gvars.isEmpty();
    }

    @Override
    public IJstGlobalVar getGlobalVar(String name) {
        return this.getGlobalVar(name, false);
    }

    @Override
    public IJstGlobalVar getGlobalVar(String name, boolean recursive) {
        if (name == null) {
            return null;
        }
        for (IJstGlobalVar iJstGlobalVar : this.getGlobalVars()) {
            if (!name.equals(iJstGlobalVar.getName().getName())) continue;
            return iJstGlobalVar;
        }
        if (recursive && !this.getExtends().isEmpty()) {
            for (IJstType t : this.getExtends()) {
                IJstGlobalVar iJstGlobalVar;
                if (t == this || (iJstGlobalVar = t.getGlobalVar(name, recursive)) == null) continue;
                return iJstGlobalVar;
            }
        }
        return null;
    }

    @Override
    public List<? extends IJstGlobalVar> getGlobalVars() {
        if (this.m_gvars == null || this.m_gvars.isEmpty()) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.m_gvars);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addGlobalVar(IJstGlobalVar global) {
        if (global == null || this.getGlobalVars().contains(global)) {
            return;
        }
        JstType jstType = this;
        synchronized (jstType) {
            if (this.m_gvars == null) {
                this.m_gvars = new ArrayList<IJstGlobalVar>();
            }
            this.m_gvars.add(global);
            this.addChild(global);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IJstGlobalVar removeGlobalVar(String global) {
        if (global == null || this.m_gvars == null) {
            return null;
        }
        JstType jstType = this;
        synchronized (jstType) {
            IJstGlobalVar glb = this.getGlobalVar(global);
            this.m_gvars.remove(glb);
            if (glb instanceof BaseJstNode) {
                this.removeChild((BaseJstNode)((Object)glb));
            }
            return glb;
        }
    }

    @Override
    public boolean isImpliedImport() {
        return this.m_impliedImport;
    }

    public void setImpliedImport(boolean impliedImport) {
        this.m_impliedImport = impliedImport;
    }

    @Override
    public Map<String, Object> getOptions() {
        if (this.m_options == null) {
            return Collections.EMPTY_MAP;
        }
        return this.m_options;
    }

    public void addOption(String name, Object value) {
        if (this.m_options == null) {
            this.m_options = new LinkedHashMap<String, Object>();
        }
        this.m_options.put(name, value);
    }

    public void addSecondaryType(IJstType secondaryType) {
        if (this.m_secondaryTypes == null) {
            this.m_secondaryTypes = new ArrayList<IJstType>();
        }
        this.m_secondaryTypes.add(secondaryType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSecondaryType(JstType secondaryType) {
        if (secondaryType == null) {
            return;
        }
        JstType jstType = this;
        synchronized (jstType) {
            if (this.m_secondaryTypes != null && this.m_secondaryTypes.contains(secondaryType)) {
                return;
            }
            if (this.m_secondaryTypes == null) {
                this.m_secondaryTypes = new ArrayList<IJstType>(1);
            }
            this.m_secondaryTypes.add(secondaryType);
        }
    }

    public List<IJstType> getSecondaryTypes() {
        if (this.m_secondaryTypes == null) {
            return Collections.EMPTY_LIST;
        }
        return Collections.unmodifiableList(this.m_secondaryTypes);
    }

    public void setSingleton(boolean b) {
        this.m_singleton = b;
    }

    @Override
    public boolean isSingleton() {
        return this.m_singleton;
    }

    public void setExpects(List<IJstType> expects) {
        for (IJstType expect : expects) {
            this.addExpects(expect);
        }
    }

    public void setExtends(List<IJstType> extends1) {
        for (IJstType extend : extends1) {
            this.addExtend(extend);
        }
    }

    public void setImports(List<IJstType> imports) {
        for (IJstType iJstType : imports) {
            this.addImport(iJstType);
        }
    }

    public void setInactiveImports(List<? extends IJstType> inactiveImports) {
        for (IJstType iJstType : inactiveImports) {
            this.addInactiveImport(iJstType);
        }
    }

    public void setMethods(List<IJstMethod> methods) {
        for (IJstMethod iJstMethod : methods) {
            this.addMethod(iJstMethod);
        }
    }

    public void setProperties(List<IJstProperty> properties) {
        for (IJstProperty iJstProperty : properties) {
            this.addProperty(iJstProperty);
        }
    }

    public void setInstanceInitializers(List<IStmt> instanceInitializers) {
        for (IStmt iStmt : instanceInitializers) {
            this.addInit(iStmt, false);
        }
    }

    public void setStaticInitializers(List<IStmt> staticInitializers) {
        for (IStmt iStmt : staticInitializers) {
            this.addInit(iStmt, true);
        }
    }

    public void setGlobalVars(List<? extends IJstGlobalVar> globalVars) {
        for (IJstGlobalVar iJstGlobalVar : globalVars) {
            this.addGlobalVar(iJstGlobalVar);
        }
    }

    public void setMixins(List<IJstType> mixins) {
        for (IJstType iJstType : mixins) {
            this.addMixin(new JstTypeReference(iJstType));
        }
    }

    public void setModifers(JstModifiers modifiers) {
        this.m_modifiers = modifiers;
    }

    public void setOptions(Map<String, Object> options) {
        this.m_options = options;
    }

    public void setOTypes(List<IJstOType> oTypes) {
        for (IJstOType iJstOType : oTypes) {
            this.addOType(iJstOType);
        }
    }

    public void setParam(Map<String, JstParamType> paramTypes) {
        this.m_paramTypes = paramTypes;
    }

    public void setSatisfies(List<IJstType> satisfies) {
        for (IJstType iJstType : satisfies) {
            this.addSatisfy(iJstType);
        }
    }

    public void setSecondaryTypes(List<IJstType> secondaryTypes) {
        this.m_secondaryTypes = secondaryTypes;
    }

    public void setSiblingTypes(List<JstType> siblingTypes) {
        for (JstType jstType : siblingTypes) {
            this.addSiblingType(jstType);
        }
    }

    public void setStatus(Info status) {
        this.m_info = status;
    }

    @Override
    public List<JstBlock> getJstBlockList() {
        return this.m_blockList;
    }

    @Override
    public void setJstBlockList(List<JstBlock> blocks) {
        this.m_blockList = blocks;
    }

    public void clearJstBlockList() {
        this.m_blockList = null;
    }

    @Override
    public List<IScriptProblem> getProblems() {
        return this.m_probs;
    }

    @Override
    public void setProblems(List<IScriptProblem> probs) {
        this.m_probs = probs;
    }

    public void clearProblems() {
        this.m_probs = null;
    }

    public static enum Category {
        CLASS,
        INTERFACE,
        ENUM,
        MODULE,
        OTYPE,
        FTYPE,
        LTYPE;

    }

    public static class Info {
        private static final int HAS_NAME = 1;
        private static final int HAS_DECL = 2;
        private static final int HAS_IMPL = 4;
        private static final int HAS_RESOLUTION = 5;
        private static final int IS_PHANTOM = 8;
        private static final int IS_PROMOTED = 9;
        private static final int IS_ALIAS_PROMOTED = 10;
        private int m_status;
        private boolean m_isValid;

        public void setHasName() {
            this.m_status |= 1;
        }

        public boolean hasName() {
            return (this.m_status & 1) == 1;
        }

        public void setHasDecl() {
            this.m_status |= 2;
        }

        public boolean hasImpl() {
            return (this.m_status & 4) == 4;
        }

        public void setHasResolution() {
            this.m_status |= 5;
        }

        public boolean hasResolution() {
            return (this.m_status & 5) == 5;
        }

        public void setHasImpl() {
            this.m_status |= 4;
        }

        public boolean hasDecl() {
            return (this.m_status & 2) == 2;
        }

        public void setIsValid(boolean isValid) {
            this.m_isValid = isValid;
        }

        public boolean isValid() {
            return this.m_isValid;
        }

        public void setIsPhantom() {
            this.m_status |= 8;
        }

        public boolean isPhantom() {
            return (this.m_status & 8) == 8;
        }

        public void setGlobalsPromoted() {
            this.m_status |= 9;
        }

        public boolean areGlobalsPromoted() {
            return (this.m_status & 9) == 9;
        }

        public boolean isAliasTypeNamePromoted() {
            return (this.m_status & 0xA) == 10;
        }

        public String toString() {
            Z z = new Z();
            z.format("m_isValid", this.m_isValid);
            z.format("hasName", this.hasName());
            z.format("hasDecl", this.hasDecl());
            z.format("hasImpl", this.hasImpl());
            z.format("isPhantom", this.isPhantom());
            z.format("isPromoted", this.areGlobalsPromoted());
            z.format("isAliasTypeNamePromoted", this.isAliasTypeNamePromoted());
            return z.toString();
        }
    }
}

